/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentConstants;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestCondition
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);

    @Test
    public void testRowExist() {
        QueryCondition condition = Constants.ROW_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id != null)");
    }

    @Test
    public void testRowNotExist() {
        QueryCondition condition = Constants.ROW_NOT_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id = null)");
    }

    @Test
    public void testSimpleConditionsNonExistent() {
        QueryCondition condition = MapRDB.newCondition().notExists("nonExistantElem").build();
        this.serializeAndCompare(condition, "(nonExistantElem = null)");
    }

    @Test
    public void testSimpleConditionsExistent() {
        QueryCondition condition = MapRDB.newCondition().exists("existantElem").build();
        this.serializeAndCompare(condition, "(existantElem != null)");
    }

    @Test
    public void testSimpleConditionsNullType() {
        QueryCondition condition = MapRDB.newCondition().typeOf("nullElem", Value.Type.NULL).build();
        this.serializeAndCompare(condition, "(TYPE_OF(nullElem) = NULL)");
    }

    @Test
    public void testSimpleConditionsBool() {
        QueryCondition condition = MapRDB.newCondition().is("boolElem", QueryCondition.Op.EQUAL, false).build();
        this.serializeAndCompare(condition, "(boolElem = false)");
    }

    @Test
    public void testSimpleConditionsString() {
        QueryCondition condition = MapRDB.newCondition().is("stringElem", QueryCondition.Op.GREATER, "stupidity").build();
        this.serializeAndCompare(condition, "(stringElem > \"stupidity\")");
    }

    @Test
    public void testSimpleConditionsInt() {
        QueryCondition condition = MapRDB.newCondition().is("intElem", QueryCondition.Op.NOT_EQUAL, 5).build();
        this.serializeAndCompare(condition, "(intElem != {\"$numberLong\":5})");
    }

    @Test
    public void testSimpleConditionsLong() {
        QueryCondition condition = MapRDB.newCondition().is("longElem", QueryCondition.Op.LESS_OR_EQUAL, 527346237644235L).build();
        this.serializeAndCompare(condition, "(longElem <= {\"$numberLong\":527346237644235})");
    }

    @Test
    public void testSimpleConditionsEmptyByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate(4).putInt(300);
        QueryCondition condition = MapRDB.newCondition().is("emptyByteBuffer", QueryCondition.Op.EQUAL, bb).build();
        this.serializeAndCompare(condition, "(emptyByteBuffer = {\"$binary\":\"\"})");
    }

    @Test
    public void testSimpleConditionsFloat() {
        QueryCondition condition = MapRDB.newCondition().is("floatElem", QueryCondition.Op.LESS, 3.141592f).build();
        this.serializeAndCompare(condition, "(floatElem < 3.141592025756836)");
    }

    @Test
    public void testSimpleConditionsDouble() {
        QueryCondition condition = MapRDB.newCondition().is("doubleElem", QueryCondition.Op.GREATER_OR_EQUAL, Math.PI).build();
        this.serializeAndCompare(condition, "(doubleElem >= 3.141592653589793)");
    }

    @Test
    @Ignore(value="BigDecimal type not supported")
    public void testSimpleConditionsDecimal() {
        QueryCondition condition = MapRDB.newCondition().is("deceimalElem", QueryCondition.Op.EQUAL, new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068", new MathContext(100))).build();
        this.serializeAndCompare(condition, "(deceimalElem = {\"$decimal\":\"3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068\"})");
    }

    @Test
    public void testSimpleConditionsDate() {
        QueryCondition condition = MapRDB.newCondition().is("dateElem", QueryCondition.Op.NOT_EQUAL, ODate.parse((String)"1979-08-24")).build();
        this.serializeAndCompare(condition, "(dateElem != {\"$dateDay\":\"1979-08-24\"})");
    }

    @Test
    public void testSimpleConditionsTime() {
        QueryCondition condition = MapRDB.newCondition().is("timeElem", QueryCondition.Op.LESS_OR_EQUAL, OTime.parse((String)"16:32:00")).build();
        this.serializeAndCompare(condition, "(timeElem <= {\"$time\":\"16:32:00\"})");
    }

    @Test
    public void testSimpleConditionsTimestamp() {
        QueryCondition condition = MapRDB.newCondition().is("timestampElem", QueryCondition.Op.EQUAL, OTimestamp.parse((String)"1979-08-24T16:32:00.000+05:30")).build();
        this.serializeAndCompare(condition, "(timestampElem = {\"$date\":\"1979-08-24T11:02:00.000Z\"})");
    }

    @Test
    @Ignore(value="Interval type not supported")
    public void testSimpleConditionsInterval() {
        QueryCondition condition = MapRDB.newCondition().is("intervalElem", QueryCondition.Op.GREATER, new OInterval(1239213L)).build();
        this.serializeAndCompare(condition, "(intervalElem > {\"$interval\":1239213})");
    }

    @Test
    public void testSimpleConditionsBinary() {
        QueryCondition condition = MapRDB.newCondition().is("binaryElem", QueryCondition.Op.EQUAL, ByteBuffer.wrap(new byte[]{97, 100, 105, 116, 121, 97})).build();
        this.serializeAndCompare(condition, "(binaryElem = {\"$binary\":\"YWRpdHlh\"})");
    }

    @Test
    public void testSimpleConditionsMap() {
        QueryCondition condition = MapRDB.newCondition().equals("mapElem", (Map)ImmutableMap.of((Object)"name", (Object)"hulk", (Object)"weight", (Object)526, (Object)"id", (Object)627131273323L, (Object)"dob", (Object)OTimestamp.parse((String)"1979-10-12T05:23:00.122+07:00"))).build();
        this.serializeAndCompare(condition, "(mapElem = {\"name\":\"hulk\",\"weight\":{\"$numberLong\":526},\"id\":{\"$numberLong\":627131273323},\"dob\":{\"$date\":\"1979-10-11T22:23:00.122Z\"}})");
    }

    @Test
    public void testSimpleConditionsEmptyMap() {
        ImmutableMap emptyMap = ImmutableMap.of();
        QueryCondition condition = MapRDB.newCondition().equals("emptyMapElem", (Map)emptyMap).build();
        this.serializeAndCompare(condition, "(emptyMapElem = {})");
    }

    @Test
    public void testSimpleConditionsArray() {
        QueryCondition condition = MapRDB.newCondition().equals("listElem", (List)ImmutableList.of((Object)"January", (Object)4, (Object)OTimestamp.parse((String)"2015-03-14T20:12:21.000+00:00"), (Object)ODate.parse((String)"1969-12-31"), (Object)ODate.parse((String)"1970-01-01"), (Object)ODate.parse((String)"1950-01-26"), (Object)OTime.parse((String)"11:22:33"))).build();
        this.serializeAndCompare(condition, "(listElem = [\"January\",{\"$numberLong\":4},{\"$date\":\"2015-03-14T20:12:21.000Z\"},{\"$dateDay\":\"1969-12-31\"},{\"$dateDay\":\"1970-01-01\"},{\"$dateDay\":\"1950-01-26\"},{\"$time\":\"11:22:33\"}])");
    }

    @Test
    public void testSimpleConditionsEmptyArray() {
        QueryCondition condition = MapRDB.newCondition().equals("emptyListElem", (List)ImmutableList.of()).build();
        this.serializeAndCompare(condition, "(emptyListElem = [])");
    }

    @Test
    public void testSimpleConditionsWithLike() {
        QueryCondition condition = MapRDB.newCondition().like("likeElem", "San%").build();
        this.serializeAndCompare(condition, "(likeElem MATCHES \"^\\\\QSan\\\\E.*$\")");
    }

    @Test
    public void testSimpleConditionsWithNotLike() {
        QueryCondition condition = MapRDB.newCondition().notLike("likeElem", "%San__%").build();
        this.serializeAndCompare(condition, "(likeElem NOT_MATCHES \"^.*\\\\QSan\\\\E...*$\")");
    }

    @Test
    public void testSimpleConditionsRegexMatch() {
        QueryCondition condition = MapRDB.newCondition().matches("patternElem", ".*peace$").build();
        this.serializeAndCompare(condition, "(patternElem MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatch() {
        QueryCondition condition = MapRDB.newCondition().notMatches("antiPatternElem", ".*war.*").build();
        this.serializeAndCompare(condition, "(antiPatternElem NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsRegexMatchId() {
        QueryCondition condition = MapRDB.newCondition().matches("_id", ".*peace$").build();
        this.serializeAndCompare(condition, "(_id MATCHES \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatchId() {
        QueryCondition condition = MapRDB.newCondition().notMatches("_id", ".*war.*").build();
        this.serializeAndCompare(condition, "(_id NOT_MATCHES \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsIn() {
        QueryCondition condition = MapRDB.newCondition().in("oneInTheListElem", (List)ImmutableList.of((Object)42, (Object)"42", (Object)new ODate(42L), (Object)new OTime(42L), (Object)new OTimestamp(42L))).build();
        this.serializeAndCompare(condition, "((oneInTheListElem = {\"$numberLong\":42}) or (oneInTheListElem = \"42\") or (oneInTheListElem = {\"$dateDay\":\"1969-12-31\"}) or (oneInTheListElem = {\"$time\":\"17:00:00.042\"}) or (oneInTheListElem = {\"$date\":\"1970-01-01T00:00:00.042Z\"}))");
    }

    @Test
    public void testSimpleConditionsNotIn() {
        QueryCondition condition = MapRDB.newCondition().notIn("noneInTheListElem", (List)ImmutableList.of((Object)"gold", (Object)"silver", (Object)"bronze")).build();
        this.serializeAndCompare(condition, "((noneInTheListElem != \"gold\") and (noneInTheListElem != \"silver\") and (noneInTheListElem != \"bronze\"))");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConditionCompoundingWihoutBlock() {
        QueryCondition condition = MapRDB.newCondition().is("a", QueryCondition.Op.EQUAL, 6).matches("b", "wrong_condition_grouping").build();
    }

    @Test
    public void testConditionWithId() {
        QueryCondition condition = MapRDB.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdEqual() {
        QueryCondition condition = MapRDB.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "pqr").build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdNotEqual() {
        QueryCondition condition = MapRDB.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.NOT_EQUAL, "pqr").build();
        Assert.assertTrue((!(condition = ((ConditionImpl)condition).cloneOptimized()).isEmpty() ? 1 : 0) != 0);
        this.checkAndGetRange(condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition, "(_id != \"pqr\")");
    }

    @Test
    public void testConditionWithIdOnMatches() {
        QueryCondition condition = MapRDB.newCondition().matches(DocumentConstants.ID_FIELD, "device.*").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("device"), this.encode("devicf"));
        this.serializeAndCompare(condition, "(_id MATCHES \"device.*\")");
    }

    @Test
    public void testConditionWithIdRange() {
        QueryCondition condition = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), this.encode("uvw"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdDisjointRange() {
        QueryCondition condition = MapRDB.newCondition().or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition, "((_id < \"pqr\") or (_id > \"uvw\"))");
    }

    @Test
    public void testConditionWithIdReveseRange() {
        QueryCondition condition = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encodeStringBinary("uvw\\x00"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testMultiLevelAndConditionsOnId() {
        QueryCondition condition = MapRDB.newCondition().and().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "rst").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().build();
        this.serializeAndCompare(condition, "(((_id > \"abc\") and (_id < \"pqr\")) and (_id >= \"rst\") and (_id <= \"xyz\"))");
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encode("rst"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testOrOfAndsConditionsOnId() {
        QueryCondition condition = MapRDB.newCondition().or().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "abc").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "pqr").close().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "efg").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "xyz").close().close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encodeStringBinary("abc\\x00"), this.encodeStringBinary("xyz\\x00"));
        this.serializeAndCompare(condition, "(((_id > \"abc\") and (_id < \"pqr\")) or ((_id >= \"efg\") and (_id <= \"xyz\")))");
    }

    @Test
    public void testMultiLevelCondition() {
        QueryCondition condition = this.newComplexCondition1();
        Assert.assertEquals((Object)"((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))", (Object)condition.toString());
        this.serializeAndCompare(condition, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
    }

    @Test
    public void testAddConditionToAnotherCondition() {
        QueryCondition inner = this.newComplexCondition1();
        QueryCondition outer0 = MapRDB.newCondition().condition(inner).build();
        this.serializeAndCompare(outer0, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer0.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer0);
        QueryCondition outer1 = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "uvw").condition(inner).close().build();
        outer1 = ((ConditionImpl)outer1).cloneOptimized();
        this.serializeAndCompare(outer1, "((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer1.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer1);
        QueryCondition outer2 = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "pqr").is("some.other.field", QueryCondition.Op.EQUAL, 25.69).condition(inner).close().build();
        outer2 = ((ConditionImpl)outer2).cloneOptimized();
        this.serializeAndCompare(outer2, "((some.other.field = 25.69) and ((c.u.r != null) and (TYPE_OF(c.u.r) = ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\"))))");
        Assert.assertFalse((boolean)outer2.isEmpty());
        Assert.assertNotEquals((Object)inner, (Object)outer2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConditionToAnotherConditionFail() {
        QueryCondition inner = this.newComplexCondition1();
        MapRDB.newCondition().is("abc", QueryCondition.Op.EQUAL, "pqr").condition(inner).build();
    }

    @Test
    public void testComplexMixCondition() {
        QueryCondition condition = MapRDB.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "device001").is("price", QueryCondition.Op.GREATER_OR_EQUAL, 75).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "user999").or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "parts550").is("price", QueryCondition.Op.LESS_OR_EQUAL, 100).close().close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encodeStringBinary("device001\\x00"), this.encode("user999"));
        this.serializeAndCompare(condition, "((price >= {\"$numberLong\":75}) and ((_id > \"parts550\") or (price <= {\"$numberLong\":100})))");
    }

    private byte[] encode(String in) {
        return IdCodec.encodeAsBytes((String)in);
    }

    private byte[] encodeStringBinary(String in) {
        return IdCodec.encodeStringBinary((String)in);
    }

    private void serializeAndCompare(QueryCondition condition) {
        this.serializeAndCompare(condition, "<EMPTY>");
    }

    private void serializeAndCompare(QueryCondition condition, String infix) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        QueryCondition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)condition, (Object)newCondition);
        Assert.assertEquals((Object)infix, (Object)((ConditionImpl)condition).asInfix());
    }

    private ConditionNode.RowkeyRange checkAndGetRange(QueryCondition condition, byte[] start, byte[] stop) {
        List rowkeyRanges = ((ConditionImpl)condition).getRowkeyRanges();
        Assert.assertEquals((long)1L, (long)rowkeyRanges.size());
        ConditionNode.RowkeyRange rowkeyRange = (ConditionNode.RowkeyRange)rowkeyRanges.get(0);
        _logger.info("{}", (Object)rowkeyRange);
        Assert.assertArrayEquals((byte[])start, (byte[])rowkeyRange.getStartRow());
        Assert.assertArrayEquals((byte[])stop, (byte[])rowkeyRange.getStopRow());
        return rowkeyRange;
    }

    private QueryCondition newComplexCondition1() {
        return MapRDB.newCondition().and().exists("c.u.r").typeOf("c.u.r", Value.Type.ARRAY).is("c.u.r[0].d", QueryCondition.Op.EQUAL, 10.5).or().is("a.b[4]", QueryCondition.Op.EQUAL, 4).is("b.e.t", QueryCondition.Op.EQUAL, "35").close().close().build();
    }
}

