/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests;

import com.mapr.db.tests.aces.TestJSONAceSupportWithCluster;
import com.mapr.db.tests.audit.TestJSONAuditSupportWithCluster;
import com.mapr.db.tests.condition.TestConditionWithCluster;
import com.mapr.db.tests.ojai.TestDBDocument;
import com.mapr.db.tests.ojai.TestDBDocumentReaderMCF;
import com.mapr.db.tests.rowcol.MultiColumnFamilyEncodeDecodeTest;
import com.mapr.db.tests.rowcol.MutationTest;
import com.mapr.db.tests.tableops.MapRDBStressTest;
import com.mapr.db.tests.tableops.TTLTest;
import com.mapr.db.tests.tableops.TestCheckAndXXX_MultiFamilies;
import com.mapr.db.tests.tableops.TestCompaction;
import com.mapr.db.tests.tableops.TestKeepDeletes;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.tableops.TestMapRDBWithClusterConc;
import com.mapr.db.tests.tableops.TestMapRDBWithClusterConcAppend;
import com.mapr.db.tests.tableops.TestTableOps;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={MapRDBStressTest.class, MutationTest.class, MultiColumnFamilyEncodeDecodeTest.class, TestCheckAndXXX_MultiFamilies.class, TestCompaction.class, TestConditionWithCluster.class, TestDBDocument.class, TestDBDocumentReaderMCF.class, TestJSONAceSupportWithCluster.class, TestJSONAuditSupportWithCluster.class, TestKeepDeletes.class, TestMapRDBWithCluster.class, TestMapRDBWithClusterConc.class, TestMapRDBWithClusterConcAppend.class, TestTableOps.class, TTLTest.class})
@Category(value={StressTest.class})
public class TestClusterMockExternalReplica
extends BaseTest {
    static Runtime runTime = null;
    private static final Logger _logger = LoggerFactory.getLogger(TestClusterMockExternalReplica.class);
    static final String TED_FILE = "build_fileserver/fs/server/db/test/ted";
    static Path repoRootPath = null;
    static Path tedCmdPath = null;
    static final String SET_TED_CMD = " enable ExpandMutationArray";
    static final String RESET_TED_CMD = " disable ExpandMutationArray";

    public static int runCmd(String msg, String cmd) throws IOException, InterruptedException {
        _logger.info(msg + cmd);
        if (runTime == null) {
            runTime = Runtime.getRuntime();
        }
        Process process = runTime.exec(cmd);
        return process.waitFor();
    }

    @BeforeClass
    public static void beforeClass() throws IOException, InterruptedException {
        if (!TestClusterMockExternalReplica.isClusterTest()) {
            return;
        }
        if (tedCmdPath == null) {
            throw new IOException("Could not find ted command file.");
        }
        String cmd = tedCmdPath.toString() + SET_TED_CMD;
        int setStatus = TestClusterMockExternalReplica.runCmd("BeforeClass: ", cmd);
        if (setStatus != 0) {
            throw new IOException("BeforeClass: " + tedCmdPath.toString() + SET_TED_CMD + " failed with exitStatus: " + setStatus);
        }
    }

    @AfterClass
    public static void afterClass() throws IOException, InterruptedException {
        if (!TestClusterMockExternalReplica.isClusterTest()) {
            return;
        }
        if (tedCmdPath == null) {
            throw new IOException("Could not find ted command file.");
        }
        String cmd = tedCmdPath.toString() + RESET_TED_CMD;
        int resetStatus = TestClusterMockExternalReplica.runCmd("AfterClass: ", cmd);
        if (resetStatus != 0) {
            throw new IOException("AfterClass: " + tedCmdPath.toString() + RESET_TED_CMD + " failed with exitStatus: " + resetStatus);
        }
    }

    static {
        repoRootPath = TestClusterMockExternalReplica.getSourceRoot();
        if (repoRootPath != null && !Files.exists(tedCmdPath = repoRootPath.resolve(TED_FILE), new LinkOption[0])) {
            tedCmdPath = null;
        }
    }
}

