/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.BigDecimalSizeDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValuePair;
import com.mapr.db.rowcol.KeyValueSizeDescriptor;
import com.mapr.db.rowcol.RootTimeDescriptor;
import com.mapr.db.rowcol.RowcolType;
import com.mapr.db.rowcol.SerializationContext;
import com.mapr.db.rowcol.TimeAndUniq;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.nio.ByteBuffer;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.TypeException;

public class KeyValueDeserializeHelper {
    public static Value.Type getType(ByteBuffer input) {
        byte rowColType = input.get();
        if (rowColType == 0) {
            return null;
        }
        Value.Type type = RowcolType.valueType(rowColType & 0x1F);
        return type;
    }

    public static void deserializeWithoutKeyValue(SerializationContext context, ByteBuffer input) {
        if (context.isRoot()) {
            context.setNewRecord(false);
            RootTimeDescriptor.deserialize(input, context);
            TimeDescriptor.deserialize(null, input, context);
        }
        Value.Type type = KeyValueDeserializeHelper.getType(input);
        context.setType(type);
        if (type == null) {
            return;
        }
        int numBitsForValue = context.isArrayElement() ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
        context.setNumBitsForValue(numBitsForValue);
        context.setKeyValueSize(input);
        TimeDescriptor.deserialize(null, input, context);
        if (context.isArrayElement()) {
            ArrayIndexDescriptor.deserialize(null, input, context);
        } else {
            int[] kvOrder = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
            context.setOrderInMap(kvOrder[0]);
        }
    }

    public static KeyValuePair deserialize(boolean isArrayElement, KeyValue parentKv, SerializationContext context, ByteBuffer input) {
        KeyValue kv;
        SerializationContext.ProjectionState parentProjState;
        String key = null;
        FieldPath parentPath = context.currentPath();
        SerializationContext.ProjectionState projState = parentProjState = context.currentProjectionState();
        do {
            byte rowColType;
            if ((rowColType = input.get()) == 0) {
                return null;
            }
            Value.Type type = RowcolType.valueType(rowColType & 0x1F);
            if (type == Value.Type.MAP) {
                kv = new DBDocumentImpl();
            } else if (type == Value.Type.ARRAY) {
                kv = new DBList(InsertContext.OpType.NONE);
            } else {
                kv = context.newKeyValue();
                kv.type_ = type.getCode();
            }
            kv.setIsArrayElement(isArrayElement);
            rowColType = (byte)(rowColType >> 5 & 7);
            kv.opType = (byte)(InsertContext.OpType.values()[rowColType].ordinal() & 0xFF);
            int numBitsForValue = isArrayElement ? 8 : KeyValueSizeDescriptor.valueSizeBitsForType(type);
            int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(numBitsForValue, input);
            TimeDescriptor.deserialize(kv, input, context);
            if (isArrayElement) {
                ArrayIndexDescriptor.deserialize(kv, input, context);
            } else {
                KeyValueDeserializeHelper.deserializeOrderOfField(kv, input);
                key = Bytes.toString((ByteBuffer)input, (int)keyValueSize[0]);
            }
            if (context.shouldPrunePaths()) {
                FieldPath p = parentPath;
                projState = parentProjState;
                if (!context.isRoot() || parentPath == FieldPath.EMPTY) {
                    if (key != null) {
                        p = parentPath == FieldPath.EMPTY ? FieldPath.parseFrom((String)key) : parentPath.cloneWithNewChild(key);
                    } else if (isArrayElement) {
                        FieldPath fieldPath = p = parentPath == FieldPath.EMPTY ? FieldPath.parseFrom((String)key) : parentPath.cloneWithNewChild(kv.orderInMap);
                    }
                    if (parentProjState.isAncestor()) {
                        projState = context.getProjectionState(parentProjState, p);
                    }
                }
                context.setCurrentPath(p);
                context.setCurrentProjectionState(projState);
            }
            context.setNewRecord(false);
            KeyValueDeserializeHelper.deserializeValue(kv, input, context, keyValueSize[1]);
        } while (projState != null && projState.isUnrelated());
        return new KeyValuePair(key, kv);
    }

    private static void deserializeOrderOfField(KeyValue kv, ByteBuffer input) {
        int[] keyValueSize = KeyValueSizeDescriptor.decodeKeyValueSize(0, input);
        kv.setOrderOfField(keyValueSize[0]);
    }

    private static void deserializeValue(KeyValue kv, ByteBuffer input, SerializationContext context, int valueSize) {
        switch (kv.getType()) {
            case ARRAY: {
                KeyValueDeserializeHelper.deserializeArrayValue(kv, context, input);
                return;
            }
            case BINARY: {
                byte[] bytes = new byte[valueSize];
                input.get(bytes);
                ByteBuffer b = ByteBuffer.wrap(bytes);
                kv.objValue = b;
                return;
            }
            case NULL: {
                return;
            }
            case BOOLEAN: {
                kv.primValue = valueSize;
                return;
            }
            case BYTE: {
                kv.primValue = input.get();
                return;
            }
            case DECIMAL: {
                kv.objValue = BigDecimalSizeDescriptor.deSerialize(input);
                return;
            }
            case DOUBLE: 
            case LONG: {
                kv.primValue = input.getLong();
                return;
            }
            case FLOAT: 
            case INT: {
                kv.primValue = input.getInt();
                return;
            }
            case MAP: {
                KeyValueDeserializeHelper.deserializeMap(kv, context, input);
                return;
            }
            case SHORT: {
                kv.primValue = input.getShort();
                return;
            }
            case STRING: {
                String v = Bytes.toString((ByteBuffer)input, (int)valueSize);
                kv.objValue = v;
                return;
            }
            case INTERVAL: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                kv.primValue = KeyValueDeserializeHelper.deserializeVarLong(valueSize, input);
                return;
            }
        }
        throw new TypeException("Unknown type " + kv.getType());
    }

    public static long deserializeVarLong(int valueSize, ByteBuffer input) {
        switch (valueSize) {
            case 0: {
                return 0L;
            }
            case 1: {
                return (long)input.get() & 0xFFL;
            }
            case 2: {
                return (long)input.getShort() & 0xFFFFL;
            }
            case 4: {
                return (long)input.getInt() & 0xFFFFFFFFL;
            }
            case 8: {
                return input.getLong();
            }
        }
        throw new IllegalArgumentException("Invalid size in serialize " + valueSize);
    }

    private static void deserializeMap(KeyValue kv, SerializationContext context, ByteBuffer input) {
        KeyValuePair value;
        DBDocumentImpl rec = (DBDocumentImpl)kv;
        TimeAndUniq savedBaseTs = context.getBaseTime();
        FieldPath savedCurrentPath = null;
        SerializationContext.ProjectionState savedProjState = null;
        if (context.shouldPrunePaths()) {
            savedCurrentPath = context.currentPath();
            savedProjState = context.currentProjectionState();
        }
        while ((value = KeyValueDeserializeHelper.deserialize(false, kv, context, input)) != null) {
            rec.map.put(value.getKey(), value.getValue());
            if (savedCurrentPath == null) continue;
            context.setCurrentPath(savedCurrentPath);
            context.setCurrentProjectionState(savedProjState);
        }
        context.setBaseTime(savedBaseTs);
    }

    private static void deserializeArrayValue(KeyValue kv, SerializationContext context, ByteBuffer input) {
        KeyValuePair kvPair;
        DBList rec = (DBList)kv;
        TimeAndUniq savedBaseTs = context.getBaseTime();
        FieldPath savedCurrentPath = null;
        SerializationContext.ProjectionState savedProjState = null;
        if (context.shouldPrunePaths()) {
            savedCurrentPath = context.currentPath();
            savedProjState = context.currentProjectionState();
        }
        while ((kvPair = KeyValueDeserializeHelper.deserialize(true, kv, context, input)) != null) {
            KeyValue value = kvPair.getValue();
            if (savedProjState != null && savedProjState.isUnrelated()) {
                context.setCurrentPath(savedCurrentPath);
                context.setCurrentProjectionState(savedProjState);
                continue;
            }
            if (value.getArrayIndexType() == ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ABSOLUTE) {
                FieldPath p;
                if (savedProjState != null && context.getProjectionState(savedProjState, p = savedCurrentPath.cloneWithNewChild(value.getOrderOfField())).isUnrelated()) {
                    context.setCurrentPath(savedCurrentPath);
                    context.setCurrentProjectionState(savedProjState);
                    continue;
                }
                int index = value.getOrderOfField();
                while (rec.list.size() < index) {
                    rec.list.add(null);
                }
                context.setHasArrayProjection();
                value.setArrayIndexType(ArrayIndexDescriptor.ArrayIndexType.ARRAY_INDEX_TYPE_ASSOCIATIVE);
            }
            rec.list.add(value);
            if (savedProjState == null) continue;
            context.setCurrentPath(savedCurrentPath);
            context.setCurrentProjectionState(savedProjState);
        }
        context.setBaseTime(savedBaseTs);
    }
}

