/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.proto.Dbserver;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRDBWithClusterEfficientReads
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithClusterEfficientReads.class);
    private static final String T_1CF_CFACE = "testtable-TMWCER-1CF-CFACE";
    private static final String T_1CF_COLACE = "testtable-TMWCER-1CF-COLACE";
    private static final String T_1CF_NOACE = "testtable-TMWCER-1CF-NOACE";
    private static final String T_MCF_CFACE = "testtable-TMWCER-MCF-CFACE";
    private static final String T_MCF_COLACE = "testtable-TMWCER-MCF-COLACE";
    private static final String T_MCF_NOACE = "testtable-TMWCER-MCF-NOACE";
    private static String PATH_PERSONAL = "personal";
    private static String PATH_PER_ADDR = "personal.address";
    private static String PATH_PER_NAME = "personal.name";
    private static String PATH_PROFESSIONAL = "professional";
    private static String PATH_PROF_SAL = "professional.salary";
    private static String PATH_PROF_POS = "professional.position";
    private static String PATH_PROF_LARGE_ARRAY = "professional.largeArray";
    private static String PATH_DEF_HELLO = "default.hello";
    private static String PATH_DEF_LARGE_ARRAY = "default.largeArray";

    @BeforeClass
    public static void startupBeforeClass() throws IOException, Exception {
        String user = System.getProperty("user.name");
        HashMap<String, String> cfPaths = new HashMap<String, String>();
        cfPaths.put("cf1", PATH_PERSONAL);
        cfPaths.put("cf2", PATH_PROFESSIONAL);
        DBTests.createOrReplaceTable(T_1CF_CFACE);
        DBTests.setCFAce(DBTests.getTablePath(T_1CF_CFACE), "default", Dbserver.DBAccessType.FamilyReadData, "!u:" + user);
        Table t1cfcface = DBTests.getTable(T_1CF_CFACE);
        DBTests.createOrReplaceTable(T_1CF_COLACE);
        DBTests.setFieldAce(DBTests.getTablePath(T_1CF_COLACE), "default", PATH_PER_ADDR, Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        Table t1cfcolace = DBTests.getTable(T_1CF_COLACE);
        DBTests.createOrReplaceTable(T_1CF_NOACE);
        Table t1cfnoace = DBTests.getTable(T_1CF_NOACE);
        DBTests.createOrReplaceTable(T_MCF_CFACE, cfPaths);
        DBTests.setCFAce(DBTests.getTablePath(T_MCF_CFACE), "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:" + user);
        Table tmcfcface = DBTests.getTable(T_MCF_CFACE);
        DBTests.createOrReplaceTable(T_MCF_COLACE, cfPaths);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_COLACE), "cf1", "address", Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_COLACE), "cf2", "salary", Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        Table tmcfcolace = DBTests.getTable(T_MCF_COLACE);
        DBTests.createOrReplaceTable(T_MCF_NOACE, cfPaths);
        Table tmcfnoace = DBTests.getTable(T_MCF_NOACE);
        byte[] largeArray = new byte[45536];
        for (int i = 0; i < 5; ++i) {
            Document d = MapRDB.newDocument().set("_id", "id" + i).set(PATH_DEF_HELLO, "hello" + i).set(PATH_PER_NAME, "name" + i).set(PATH_PER_ADDR, "addr" + i).set(PATH_PROF_POS, "pos" + i).set(PATH_PROF_SAL, "sal" + i);
            if (i % 2 == 0) {
                d.set(PATH_DEF_LARGE_ARRAY + "1", largeArray).set(PATH_DEF_LARGE_ARRAY + "2", largeArray).set(PATH_DEF_LARGE_ARRAY + "3", largeArray);
            }
            if (i % 4 == 0) {
                d.set(PATH_PROF_LARGE_ARRAY + "1", largeArray).set(PATH_PROF_LARGE_ARRAY + "2", largeArray).set(PATH_PROF_LARGE_ARRAY + "3", largeArray).set(PATH_PROF_LARGE_ARRAY + "4", largeArray).set(PATH_PROF_LARGE_ARRAY + "5", largeArray).set(PATH_PROF_LARGE_ARRAY + "6", largeArray);
            }
            t1cfcface.insertOrReplace(d);
            t1cfcolace.insertOrReplace(d);
            t1cfnoace.insertOrReplace(d);
            tmcfcface.insertOrReplace(d);
            tmcfcolace.insertOrReplace(d);
            tmcfnoace.insertOrReplace(d);
        }
        Thread.sleep(15000L);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables(T_1CF_CFACE);
        DBTests.deleteTables(T_1CF_COLACE);
        DBTests.deleteTables(T_1CF_NOACE);
        DBTests.deleteTables(T_MCF_CFACE);
        DBTests.deleteTables(T_MCF_COLACE);
        DBTests.deleteTables(T_MCF_NOACE);
    }

    private void checkFields(Document d, boolean dhE, boolean pnE, boolean paE, boolean ppE, boolean psE, boolean dl1E, boolean dl2E, boolean dl3E, boolean pl1E, boolean pl2E, boolean pl3E, boolean pl4E, boolean pl5E, boolean pl6E) {
        Assert.assertNotNull((Object)d);
        Assert.assertNotNull((Object)d.getString("_id"));
        if (dhE) {
            Assert.assertNotNull((Object)d.getString(PATH_DEF_HELLO));
        } else {
            Assert.assertNull((Object)d.getString(PATH_DEF_HELLO));
        }
        if (pnE) {
            Assert.assertNotNull((Object)d.getString(PATH_PER_NAME));
        } else {
            Assert.assertNull((Object)d.getString(PATH_PER_NAME));
        }
        if (paE) {
            Assert.assertNotNull((Object)d.getString(PATH_PER_ADDR));
        } else {
            Assert.assertNull((Object)d.getString(PATH_PER_ADDR));
        }
        if (ppE) {
            Assert.assertNotNull((Object)d.getString(PATH_PROF_POS));
        } else {
            Assert.assertNull((Object)d.getString(PATH_PROF_POS));
        }
        if (psE) {
            Assert.assertNotNull((Object)d.getString(PATH_PROF_SAL));
        } else {
            Assert.assertNull((Object)d.getString(PATH_PROF_SAL));
        }
        if (dl1E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "1"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "1"));
        }
        if (dl2E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "2"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "2"));
        }
        if (dl3E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "3"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_DEF_LARGE_ARRAY + "3"));
        }
        if (pl1E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "1"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "1"));
        }
        if (pl2E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "2"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "2"));
        }
        if (pl3E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "3"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "3"));
        }
        if (pl4E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "4"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "4"));
        }
        if (pl5E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "5"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "5"));
        }
        if (pl6E) {
            Assert.assertNotNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "6"));
        } else {
            Assert.assertNull((Object)d.getBinary(PATH_PROF_LARGE_ARRAY + "6"));
        }
    }

    private void checkFields(List<Document> docs, boolean dhE, boolean pnE, boolean paE, boolean ppE, boolean psE, boolean dl1E, boolean dl2E, boolean dl3E, boolean pl1E, boolean pl2E, boolean pl3E, boolean pl4E, boolean pl5E, boolean pl6E) {
        int i = 0;
        for (Document d : docs) {
            this.checkFields(d, dhE, pnE, paE, ppE, psE, i % 2 == 0 ? dl1E : false, i % 2 == 0 ? dl2E : false, i % 2 == 0 ? dl3E : false, i % 4 == 0 ? pl1E : false, i % 4 == 0 ? pl2E : false, i % 4 == 0 ? pl3E : false, i % 4 == 0 ? pl4E : false, i % 4 == 0 ? pl5E : false, i % 4 == 0 ? pl6E : false);
            ++i;
        }
    }

    private void verifyIdOnlyProjection(Table t) {
        DocumentStream rs = t.find(new String[]{"_id"});
        Iterator itrs = rs.iterator();
        ArrayList docs = new ArrayList();
        while (itrs.hasNext()) {
            this.checkFields((Document)itrs.next(), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        }
    }

    private void verifyIdOnlyProjection(Table t, String id) {
        this.checkFields(t.findById(id, new String[]{"_id"}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void test1CFCFAce() throws IOException {
        Table t = DBTests.getTable(T_1CF_CFACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id1"), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_PROF_LARGE_ARRAY + "4"}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void test1CFColAce() throws IOException {
        Table t = DBTests.getTable(T_1CF_COLACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, false, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, false, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, false, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, false, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS}), true, true, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_PROF_LARGE_ARRAY + "4"}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    @Test
    public void test1CFNoAce() throws IOException {
        Table t = DBTests.getTable(T_1CF_NOACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, true, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, true, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS, PATH_PROF_LARGE_ARRAY + "4"}), true, true, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, true, false, false, false, false, false, false, false);
    }

    @Test
    public void testMCFCFAce() throws IOException {
        Table t = DBTests.getTable(T_MCF_CFACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, false, false, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, false, false, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, false, false, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, false, false, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, true, false, false, false, false, false, false, false);
    }

    @Test
    public void testMCFColAce() throws IOException {
        Table t = DBTests.getTable(T_MCF_COLACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, false, true, false, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, false, true, false, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, false, true, false, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_PROF_SAL}), true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_SAL, PATH_PROF_LARGE_ARRAY + "4"}), true, true, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, true, false, false, false, false, false, false, false);
    }

    @Test
    public void testMCFNoAce() throws IOException {
        Table t = DBTests.getTable(T_MCF_NOACE);
        this.verifyIdOnlyProjection(t);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, true, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, true, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_PROF_SAL}), true, false, true, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_SAL, PATH_PROF_LARGE_ARRAY + "4"}), true, true, false, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, true, false, false, false, true, false, false, false, false, false, false, false);
    }

    @Test
    public void testMCFFlipPerm() throws IOException, Exception {
        String T_MCF_FLIP_PERM = "testtable-TMWCER-MCF-CP";
        String user = System.getProperty("user.name");
        HashMap<String, String> cfPaths = new HashMap<String, String>();
        cfPaths.put("cf1", PATH_PERSONAL);
        cfPaths.put("cf2", PATH_PROFESSIONAL);
        DBTests.createOrReplaceTable(T_MCF_FLIP_PERM, cfPaths);
        Table t = DBTests.getTable(T_MCF_FLIP_PERM);
        byte[] largeArray = new byte[45536];
        for (int i = 0; i < 3; ++i) {
            Document d = MapRDB.newDocument().set("_id", "id" + i).set(PATH_DEF_HELLO, "hello" + i).set(PATH_PER_NAME, "name" + i).set(PATH_PER_ADDR, "addr" + i).set(PATH_PROF_POS, "pos" + i).set(PATH_PROF_SAL, "sal" + i);
            if (i % 2 == 0) {
                d.set(PATH_DEF_LARGE_ARRAY + "1", largeArray).set(PATH_DEF_LARGE_ARRAY + "2", largeArray).set(PATH_DEF_LARGE_ARRAY + "3", largeArray);
            }
            if (i % 4 == 0) {
                d.set(PATH_PROF_LARGE_ARRAY + "1", largeArray).set(PATH_PROF_LARGE_ARRAY + "2", largeArray).set(PATH_PROF_LARGE_ARRAY + "3", largeArray).set(PATH_PROF_LARGE_ARRAY + "4", largeArray).set(PATH_PROF_LARGE_ARRAY + "5", largeArray).set(PATH_PROF_LARGE_ARRAY + "6", largeArray);
            }
            t.insertOrReplace(d);
        }
        t.flush();
        Thread.sleep(15000L);
        Iterator itrs = t.find().iterator();
        ArrayList<Document> docs = new ArrayList<Document>();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, true, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, true, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_PROF_SAL}), true, false, true, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_SAL, PATH_PROF_LARGE_ARRAY + "4"}), true, true, false, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, true, false, false, false, true, false, false, false, false, false, false, false);
        DBTests.setCFAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:" + user);
        itrs = t.find().iterator();
        docs.clear();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, false, false, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id0"), true, false, false, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, false, false, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, false, false, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), true, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, true, false, false, false, false, false, false, false);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "default", "default.hello", Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "cf2", "salary", Dbserver.DBAccessType.ColumnReadData, "!u:" + user);
        itrs = t.find().iterator();
        docs.clear();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, false, false, false, true, false, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id0"), false, false, false, true, false, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), false, false, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), false, false, false, true, false, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO}), false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), false, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_POS, PATH_PROF_LARGE_ARRAY + "4"}), false, false, false, true, false, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), false, false, false, false, false, false, true, false, false, false, false, false, false, false);
        DBTests.setCFAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "cf1", Dbserver.DBAccessType.FamilyReadData, "u:" + user);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "default", "default.hello", Dbserver.DBAccessType.ColumnReadData, "u:" + user);
        DBTests.setFieldAce(DBTests.getTablePath(T_MCF_FLIP_PERM), "cf2", "salary", Dbserver.DBAccessType.ColumnReadData, "u:" + user);
        itrs = t.find().iterator();
        docs.clear();
        while (itrs.hasNext()) {
            docs.add((Document)itrs.next());
        }
        this.checkFields(docs, true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.verifyIdOnlyProjection(t, "id0");
        this.verifyIdOnlyProjection(t, "id1");
        this.verifyIdOnlyProjection(t, "id2");
        this.checkFields(t.findById("id0"), true, true, true, true, true, true, true, true, true, true, true, true, true, true);
        this.checkFields(t.findById("id1"), true, true, true, true, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2"), true, true, true, true, true, true, true, true, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_PROF_SAL}), true, false, true, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id0", new String[]{PATH_DEF_HELLO, PATH_PROF_LARGE_ARRAY + "4"}), true, false, false, false, false, false, false, false, false, false, false, true, false, false);
        this.checkFields(t.findById("id1", new String[]{PATH_DEF_HELLO, PATH_PER_NAME, PATH_PROF_SAL, PATH_PROF_LARGE_ARRAY + "4"}), true, true, false, false, true, false, false, false, false, false, false, false, false, false);
        this.checkFields(t.findById("id2", new String[]{PATH_DEF_HELLO, PATH_PER_ADDR, PATH_DEF_LARGE_ARRAY + "2", PATH_PROF_LARGE_ARRAY + "4"}), true, false, true, false, false, false, true, false, false, false, false, false, false, false);
    }
}

