/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.store.DocumentMutation;

@Category(value={ClusterTest.class})
public class TestDBDocumentReaderMCF
extends BaseTest {
    private void validateSimple(DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)false, (Object)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"aaa", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testSimple() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader reader : tab.find().documentReaders()) {
            this.validateSimple(reader);
        }
    }

    @Test
    public void testNestedCFStructure() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.a1.a2");
        cfPath.put("cf2", "b");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("a.a1.a2.a3", "xyz").set("a.a1.a2.a4", "pqr").setArray("a.a1.a5.a7", new int[]{1, 2, 3}).set("a.a1.a6", true).set("b.b1", 256).set("b.b2", 11.22).set("c", "abracadabra");
        tab.insertOrReplace("r1", d);
        tab.flush();
        Iterator iter = tab.find().documentReaders().iterator();
        DocumentReader r = (DocumentReader)iter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a5", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"a7", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)1L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)2L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"a7", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)true, (Object)r.getBoolean());
        Assert.assertEquals((Object)"a6", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"a3", (Object)r.getFieldName());
        Assert.assertEquals((Object)"xyz", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"a4", (Object)r.getFieldName());
        Assert.assertEquals((Object)"pqr", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"c", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abracadabra", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"b", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    private void validateReaderWithMissingCF(DocumentReader r) {
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertEquals((Object)false, (Object)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"aaa", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testMissingCFData() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        String[] paths = new String[]{"a", "n"};
        for (DocumentReader reader : tab.find(paths).documentReaders()) {
            this.validateReaderWithMissingCF(reader);
        }
    }

    @Test
    public void testWithEmptyDefaultCF() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf2", "k");
        cfPath.put("cf3", "n");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("a.d", false).set("a.e", 111.222).set("k.x2", "abcd").set("n.x1.y1", 1.23).set("n.x2.y2", "aaa");
        tab.insertOrReplace("r1", d);
        tab.flush();
        String[] paths = new String[]{"k", "n"};
        Iterator docIter = tab.find(paths).iterator();
        Iterator iter = tab.find(paths).documentReaders().iterator();
        DocumentReader r = (DocumentReader)iter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abcd", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)"y1", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"x2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"y2", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"n", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testMutatedDocumentReader() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("cf1", "a.b");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("X", "abcd").set("p.q", "lala");
        tab.insertOrReplace("r1", d);
        DocumentMutation m = MapRDB.newMutation();
        m.setOrReplace("a.b.k.c", "tablet");
        tab.update("r1", m);
        tab.flush();
        Iterator iter = tab.find().iterator();
        Iterator docIter = tab.find().documentReaders().iterator();
        DocumentReader r = (DocumentReader)docIter.next();
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"X", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abcd", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"p", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"q", (Object)r.getFieldName());
        Assert.assertEquals((Object)"lala", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"a", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"b", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"k", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"c", (Object)r.getFieldName());
        Assert.assertEquals((Object)"tablet", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
    }

    @Test
    public void testSimple2() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("first_name", "Jane").set("last_name", "Dane");
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiMCFScalarDataWithDefaultCFEmpty() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("age", "age");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("first_name", "Jane").set("last_name", "Dane").set("zip", 92026);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name", "zip"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Jane", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiCFWithMapAndEmptyDefault() throws IOException {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("age", "age");
        cfPath.put("address.zip", "address.zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("first_name", "Jane").set("last_name", "Dane").set("age", 22).set("address.name", "Bond St").set("address.zip", 92026);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"first_name", "address"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)"address", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Bond St", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((long)92026L, (long)r.getInt());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"first_name", (Object)r.getFieldName());
            Assert.assertEquals((Object)"Jane", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultiCFWithArrayInNonDefaultCFProj() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("dept", "Sales").set("first_name", "Greg").setArray("phone", new String[]{"111111", "222222"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"phone"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"111111", (Object)r.getString());
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testEmptyDefaultWithArrayProjInCF() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("first_name", "first_name");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("dept", "Sales").set("first_name", "Greg").setArray("phone", new String[]{"111111", "222222", "333333"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"phone[1]", "phone[2]", "zip"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((Object)"zip", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"333333", (Object)r.getString());
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
            Assert.assertNull((Object)r.next());
        }
    }

    @Test
    public void testMultipleArrayOnMultipleCF() throws Exception {
        HashMap<String, String> cfPath = new HashMap<String, String>();
        cfPath.put("k", "k");
        cfPath.put("phone", "phone");
        cfPath.put("zip", "zip");
        Table tab = DBTests.createOrReplaceTable("mytab", cfPath);
        Document d = MapRDB.newDocument().set("dept", "Sales").setArray("k", new int[]{123, 7777}).setArray("phone", new String[]{"111111", "222222", "333333"}).set("zip", 92025);
        tab.insertOrReplace("r1", d);
        tab.flush();
        for (DocumentReader r : tab.find(new String[]{"k", "phone[1]", "phone[2]"}).documentReaders()) {
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"222222", (Object)r.getString());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
            Assert.assertEquals((Object)"333333", (Object)r.getString());
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"phone", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((long)123L, (long)r.getInt());
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
            Assert.assertEquals((long)7777L, (long)r.getInt());
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
            Assert.assertEquals((Object)"k", (Object)r.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        }
    }
}

