/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.MapRDB;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.util.Values;

@Category(value={SimpleTest.class})
public class TestDBDOMDocumentReader
extends BaseTest {
    DBDocumentImpl record = new DBDocumentImpl();
    private static final KeyValue _ID = DBValueBuilderImpl.KeyValueBuilder.initFrom("id1");

    @Before
    public void setUp() {
        this.record.set("map.num1", (byte)127);
        this.record.set("map.name.first", "John");
        this.record.set("map.name.last", "Doe");
        this.record.set("map.address.street.no", 350);
        this.record.set("map.address.street.name", "Front St");
        this.record.set("map.address.zip", 95134L);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Short(500));
        values.add(new Double(5555.5555));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("key1", 100);
        m.put("key2", "xyz");
        values.add(m);
        ArrayList<Constable> l = new ArrayList<Constable>();
        l.add(Double.valueOf(123.4567));
        l.add(Boolean.valueOf(true));
        values.add(l);
        this.record.set("map.list", values);
    }

    @Test
    public void testDOMRecordReader() throws IOException {
        DocumentReader.EventType et;
        boolean isArray = false;
        DocumentReader r = this.record.asReader();
        String fieldName = null;
        while ((et = r.next()) != null) {
            if (r.inMap() && r.getFieldName() != null) {
                fieldName = r.getFieldName();
                if (et == DocumentReader.EventType.BYTE) {
                    Assert.assertEquals((Object)"num1", (Object)fieldName);
                    Assert.assertEquals((long)127L, (long)r.getByte());
                }
                if (et == DocumentReader.EventType.INT && !isArray) {
                    Assert.assertEquals((Object)"no", (Object)fieldName);
                    Assert.assertEquals((long)350L, (long)r.getInt());
                }
                if (et == DocumentReader.EventType.LONG && !isArray) {
                    Assert.assertEquals((Object)"zip", (Object)fieldName);
                    Assert.assertEquals((long)95134L, (long)r.getLong());
                }
            }
            if (isArray && et == DocumentReader.EventType.SHORT) {
                Assert.assertEquals((Object)"list", (Object)fieldName);
                Assert.assertEquals((long)500L, (long)r.getShort());
            }
            if (et == DocumentReader.EventType.START_ARRAY) {
                isArray = true;
            }
            if (et != DocumentReader.EventType.END_ARRAY) continue;
            isArray = false;
        }
    }

    @Test
    public void testDOMReader() {
        DocumentReader.EventType et;
        DocumentReader reader = this.record.asReader("map.list");
        while ((et = reader.next()) != null) {
            if (et != DocumentReader.EventType.BOOLEAN) continue;
            Assert.assertEquals((Object)true, (Object)reader.getBoolean());
        }
    }

    @Test
    public void testScalarTypeReader() {
        DocumentReader.EventType et;
        DocumentReader reader = this.record.asReader("map.num1");
        while ((et = reader.next()) != null) {
            Assert.assertEquals((Object)DocumentReader.EventType.BYTE, (Object)et);
            Assert.assertEquals((long)127L, (long)reader.getByte());
        }
    }

    public void iterateOverBaseReader(DBDocumentReaderBase reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        while ((et = reader.next()) != null) {
            if (reader.inMap() && reader.getFieldName() != null) {
                fieldName = reader.getFieldName();
                if (et == DocumentReader.EventType.LONG) {
                    Assert.assertEquals((Object)fieldName, (Object)"zip");
                    Assert.assertEquals((long)95134L, (long)reader.getLong());
                } else if (et == DocumentReader.EventType.INT && fieldName.equals("key1")) {
                    Assert.assertEquals((long)100L, (long)reader.getInt());
                }
            }
            if (et == DocumentReader.EventType.END_MAP || et == DocumentReader.EventType.END_ARRAY) continue;
            ControlInfo ctlInfo = reader.getControlInfo();
        }
    }

    @Test
    public void testDOMReaderWithBaseInterface() {
        DBDocumentReaderBase reader = (DBDocumentReaderBase)this.record.asReader();
        this.iterateOverBaseReader(reader);
    }

    @Test
    public void testDOMReaderFull() throws Exception {
        try (InputStream testJson = this.getResourceStream("com/mapr/db/tests/json/test2.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            DocumentReader r = RowcolCodec.getDBDocument((Document)((Document)stream.iterator().next())).setId((Value)_ID).asReader();
            DocumentReader.EventType et = null;
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"_id", (Object)r.getFieldName());
            Assert.assertEquals((Object)"id1", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((Object)"map", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)et);
            Assert.assertEquals((Object)"null", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)et);
            Assert.assertEquals((Object)"boolean", (Object)r.getFieldName());
            Assert.assertEquals((Object)true, (Object)r.getBoolean());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"string", (Object)r.getFieldName());
            Assert.assertEquals((Object)"eureka", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"byte", (Object)r.getFieldName());
            Assert.assertEquals((long)127L, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"short", (Object)r.getFieldName());
            Assert.assertEquals((long)32767L, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"int", (Object)r.getFieldName());
            Assert.assertEquals((long)Integer.MAX_VALUE, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)et);
            Assert.assertEquals((Object)"long", (Object)r.getFieldName());
            Assert.assertEquals((long)Long.MAX_VALUE, (long)r.getLong());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"float", (Object)r.getFieldName());
            Assert.assertEquals((double)3.4028235, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"double", (Object)r.getFieldName());
            Assert.assertEquals((double)Double.MAX_VALUE, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((Object)"decimal", (Object)r.getFieldName());
            Assert.assertEquals((Object)"123456789012345678901234567890123456789012345678901.23456789", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)et);
            Assert.assertEquals((Object)"date", (Object)r.getFieldName());
            Assert.assertEquals((Object)"2012-10-20", (Object)r.getDate().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.TIME, (Object)et);
            Assert.assertEquals((Object)"time", (Object)r.getFieldName());
            Assert.assertEquals((Object)"07:42:46.123", (Object)r.getTime().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.TIMESTAMP, (Object)et);
            Assert.assertEquals((Object)"timestamp", (Object)r.getFieldName());
            Assert.assertEquals((Object)"2012-10-20T14:42:46.123Z", (Object)r.getTimestamp().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((Object)"interval", (Object)r.getFieldName());
            Assert.assertEquals((double)1.728E8, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.BINARY, (Object)et);
            Assert.assertEquals((Object)"binary", (Object)r.getFieldName());
            Assert.assertEquals((Object)Values.parseBinary((String)"YWJjZA=="), (Object)r.getBinary());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"array", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            Assert.assertEquals((double)42.0, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"open sesame", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((double)3.14, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)et);
            Assert.assertEquals((long)3L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"2015-01-21", (Object)r.getDate().toString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((long)4L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((Object)"nested", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((long)0L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((long)1L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)et);
            Assert.assertEquals((long)2L, (long)r.getArrayIndex());
            Assert.assertEquals((double)0.0, (double)r.getDouble(), (double)0.0);
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
            Assert.assertEquals((long)3L, (long)r.getArrayIndex());
            Assert.assertEquals((Object)"", (Object)r.getString());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((Object)"nested", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((long)4L, (long)r.getArrayIndex());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)et);
            Assert.assertEquals((Object)"array", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertEquals((Object)"map", (Object)r.getFieldName());
            et = r.next();
            Assert.assertNotNull((Object)et);
            Assert.assertTrue((boolean)r.inMap());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)et);
            Assert.assertNull((Object)r.getFieldName());
            et = r.next();
            Assert.assertNull((Object)et);
        }
    }

    @Test
    public void testDOMReaderWithArrayIndex() {
        Document doc = MapRDB.newDocument();
        doc.set("map.m", "abcd");
        doc.setArray("map.array[2]", new int[]{1111, 2222, 3333, 4444});
        DocumentReader r = doc.asReader();
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"m", (Object)r.getFieldName());
        Assert.assertEquals((Object)"abcd", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"array", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)0L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)1L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)2L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.INT, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getArrayIndex());
        Assert.assertEquals((long)4444L, (long)r.getInt());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testRepeatedMapWithNulls() {
        String s = "{\n  \"values\": [\n  null,\n  {\n    \"typeName\": {}\n  },\n  null,\n  {\n    \"typeValue\": {}\n  },\n  null]\n}";
        Document doc = MapRDB.newDocument((String)s);
        DocumentReader r = doc.asReader();
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)et);
        Assert.assertEquals((Object)"values", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertEquals((long)0L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((long)1L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"typeName", (Object)r.getFieldName());
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"typeName", (Object)r.getFieldName());
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((long)1L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertEquals((long)2L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"typeValue", (Object)r.getFieldName());
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)"typeValue", (Object)r.getFieldName());
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((long)3L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertEquals((long)4L, (long)r.getArrayIndex());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }
}

