/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.tests.aces.TestJSONAceSupportWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.DocumentConstants;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TabletInfoTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONAceSupportWithCluster.class);
    private static final String EMPTY = "";
    private static final String AAAA = "aaaaa";
    private static final String BBBB = "bbbbb";
    private static final String CCCC = "ccccc";
    private static final String DDDD = "ddddd";
    private static final String EEEE = "eeeee";
    private static final String[] ALL_IDS = new String[]{"aaaaa", "", "ddddd", "eeeee", "bbbbb", "ccccc"};
    private static final String TABLE_NAME = "testtable-" + TabletInfoTest.class.getSimpleName();
    private static Table table;

    @BeforeClass
    public static void setupTestJSONAceSupportWithCluster() throws Exception {
        table = DBTests.createOrReplaceTable(TABLE_NAME, new String[]{AAAA, BBBB, CCCC, DDDD, EEEE});
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.setOption(Table.TableOption.EXCLUDEID, true);
    }

    @AfterClass
    public static void cleanupTestJSONAceSupportWithCluster() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testGetTabletInfoForARow() throws IOException {
        TabletInfo tabletInfoCCCC = table.getTabletInfo(CCCC);
        List range = ((ConditionImpl)tabletInfoCCCC.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        TabletInfo tabletInfo1111 = table.getTabletInfo("1111");
        range = ((ConditionImpl)tabletInfo1111.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        TabletInfo tabletInfoZZZZ = table.getTabletInfo("zzzz");
        range = ((ConditionImpl)tabletInfoZZZZ.getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetAllTabletInfos() throws IOException {
        TabletInfo[] tabletInfos = table.getTabletInfos();
        Assert.assertEquals((long)6L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
        List range = ((ConditionImpl)tabletInfos[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[1].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[2].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[3].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[4].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[5].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EMPTY, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetSelectedTabletInfos() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "aaaab").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "eeeec").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)4L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
        List range = ((ConditionImpl)tabletInfos[0].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)AAAA, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[1].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)BBBB, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[2].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)CCCC, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
        range = ((ConditionImpl)tabletInfos[3].getCondition()).getRowkeyRanges();
        Assert.assertEquals((Object)DDDD, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStartRow()));
        Assert.assertEquals((Object)EEEE, (Object)IdCodec.decodeString((byte[])((ConditionNode.RowkeyRange)range.get(0)).getStopRow()));
    }

    @Test
    public void testGetSelectedTabletInfosWithNoLastKey() throws IOException {
        ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "aaaxy").build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)5L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
    }

    @Test
    public void testGetSelectedTabletInfosWithNoFirstKey() throws IOException {
        ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "dddaa").build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)4L, (long)tabletInfos.length);
        for (TabletInfo tabletInfo : tabletInfos) {
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
        }
    }

    @Test
    public void testGetSelectedTabletInfosOnTabletStartKeys() throws IOException {
        for (String id : ALL_IDS) {
            ConditionImpl c = new ConditionImpl().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, id).build();
            TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
            Assert.assertEquals((long)1L, (long)tabletInfos.length);
            TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
            _logger.info("TabletInfo: {}.", (Object)tabletInfo);
            if (id == EMPTY) {
                Assert.assertArrayEquals((byte[])EMPTY.getBytes(), (byte[])tabletInfo.getStartRow());
                continue;
            }
            Assert.assertTrue((boolean)tabletInfo.containsRow(IdCodec.encodeAsBytes((String)id)));
            Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)id), (byte[])tabletInfo.getStartRow());
        }
    }

    @Test
    public void testGetSelectedTabletInfosForRangeWithinTablet() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "AAAA").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "BBBB").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
        Assert.assertArrayEquals((byte[])EMPTY.getBytes(), (byte[])tabletInfo.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tabletInfo.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tabletInfo);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeOnTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, AAAA).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, BBBB).close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)1L, (long)tabletInfos.length);
        TabletInfoImpl tabletInfo = (TabletInfoImpl)tabletInfos[0];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tabletInfo.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tabletInfo.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tabletInfo);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeOnTwoTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, AAAA).is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, CCCC).close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        TabletInfoImpl tablet0Info = (TabletInfoImpl)tabletInfos[0];
        TabletInfoImpl tablet1Info = (TabletInfoImpl)tabletInfos[1];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tablet0Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tablet1Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)CCCC), (byte[])tablet1Info.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tablet0Info);
    }

    @Test
    public void testGetSelectedTabletInfosForRangeAcrossTabletBoundaries() throws IOException {
        ConditionImpl c = new ConditionImpl().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "abbbb").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "bcccc").close().build();
        TabletInfo[] tabletInfos = table.getTabletInfos((QueryCondition)c);
        Assert.assertEquals((long)2L, (long)tabletInfos.length);
        TabletInfoImpl tablet0Info = (TabletInfoImpl)tabletInfos[0];
        TabletInfoImpl tablet1Info = (TabletInfoImpl)tabletInfos[1];
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)AAAA), (byte[])tablet0Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)BBBB), (byte[])tablet1Info.getStartRow());
        Assert.assertArrayEquals((byte[])IdCodec.encodeAsBytes((String)CCCC), (byte[])tablet1Info.getStopRow());
        _logger.info("TabletInfo: {}.", (Object)tablet0Info);
    }
}

