/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.openjdk.jol.info.GraphLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ObjectFootprintTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ObjectFootprintTest.class);
    private int intnum = 1234567;
    private long longnum = 123456789L;
    private String stringVal = "aaaaaaaaaa";
    private double doublenum = 123456.789;
    private byte bnum = (byte)119;
    private int[] arrayint = new int[]{100, 200, 300, 400, 500, 600, 700, 800, 900, 1000};
    private byte[] arraybyte = new byte[]{1, 10, 2, 20, 3, 30, 4, 40, 5, 50, 6, 60, 7, 70, 8, 80, 9, 90, 11, 110, 12, 120};
    private short[] arrayshort = new short[]{1, 10, 2, 20, 3, 30, 4, 40, 5, 50, 6, 60, 7, 70, 8, 80, 9, 90, 11, 110, 12, 120};
    private static Table table = null;
    private static String TABLE_NAME = "test-memfootprint-table";

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanUp() {
        if (table != null) {
            table.close();
        }
    }

    @Test
    public void testFlatDocumentWithManyBranches() throws Exception {
        Document d = this.createFlatDoc(100);
        table.insertOrReplace("1", d);
        table.flush();
        Document doc = table.findById("1");
        doc.set("val", "xyz");
        long totalDOMSize = GraphLayout.parseInstance((Object)doc).totalSize();
        _logger.info("testFlatDocumentWithManyBranches:totalDOMSize = {}", (Object)totalDOMSize);
        Assert.assertTrue((totalDOMSize <= 430000L ? 1 : 0) != 0);
    }

    @Test
    public void testDeepDocument() throws Exception {
        Document d = this.createDeepDocument(10, 100);
        table.insertOrReplace("2", d);
        table.flush();
        Document doc = table.findById("2");
        doc.set("val", "xyz");
        long totalDOMSize = GraphLayout.parseInstance((Object)doc).totalSize();
        _logger.info("testDeepDocument:totalDOMSize = {}", (Object)totalDOMSize);
        Assert.assertTrue((totalDOMSize <= 420000L ? 1 : 0) != 0);
    }

    private Document createFlatDoc(int level) {
        Document d = MapRDB.newDocument();
        String s = "map";
        for (int i = 0; i < level; ++i) {
            String k = s + "." + "l" + Integer.toString(i);
            d.set(k + ".int", this.intnum);
            d.set(k + ".str", this.stringVal);
            d.set(k + ".long", this.longnum);
            d.set(k + ".double", this.doublenum);
            d.set(k + ".byte", this.bnum);
            d.set(k + ".short", s);
            d.setArray(k + ".array", this.arrayint);
            d.setArray(k + ".arraybyte", this.arraybyte);
            d.setArray(k + ".arrayshort", this.arrayshort);
        }
        return d;
    }

    private Document createDeepDocument(int branches, int level) {
        Document d = MapRDB.newDocument();
        String s = "map";
        for (int i = 0; i < branches; ++i) {
            String k = s;
            for (int j = 1; j < level; ++j) {
                k = k + ".l" + Integer.toString(i) + Integer.toString(j);
            }
            d.set(k + ".int", this.intnum);
            d.set(k + ".str", this.stringVal);
            d.set(k + ".long", this.longnum);
            d.set(k + ".double", this.doublenum);
            d.set(k + ".byte", this.bnum);
            d.set(k + ".short", s);
            d.setArray(k + ".array", this.arrayint);
            d.setArray(k + ".arraybyte", this.arraybyte);
            d.setArray(k + ".arrayshort", this.arrayshort);
        }
        return d;
    }
}

