/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.store.DocumentMutation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class TestMapRDBWithClusterConcAppend
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestMapRDBWithClusterConcAppend";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentWriteTest() throws Exception {
        int i;
        int nthreads = 10;
        for (int i2 = 0; i2 < nthreads; ++i2) {
            Document record = MapRDB.newDocument();
            record.set("F1", Arrays.asList("a", "b", "c"));
            table.insertOrReplace("record" + i2, record);
            table.flush();
        }
        ExecutorService executor = Executors.newFixedThreadPool(nthreads);
        Future[] futures = new Future[nthreads];
        Callable[] workers = new Callable[nthreads];
        int nops = 100;
        for (i = 0; i < nthreads; ++i) {
            DocumentMutation[] mutations = new DocumentMutation[nops];
            for (int j = 0; j < nops; ++j) {
                mutations[j] = MapRDB.newMutation().append("F1", Arrays.asList("a", "b", "c", j));
                Thread.sleep(100L);
            }
            workers[i] = new MutationCallableList(TABLE_NAME, "record" + i, mutations, i);
        }
        for (i = 0; i < nthreads; ++i) {
            futures[i] = executor.submit(workers[i]);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        for (i = 0; i < nthreads; ++i) {
            futures[i].get();
            _logger.info("validating record" + i);
            _logger.info("REC " + table.findById("record" + i));
        }
    }

    public class MutationCallableList
    implements Callable {
        String tableName;
        DocumentMutation[] mutations;
        String record;
        int tid;

        public MutationCallableList(String tableName, String record, DocumentMutation[] mutation, int i) {
            this.tableName = tableName;
            this.mutations = mutation;
            this.record = record;
            this.tid = i;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            try (Table table = null;){
                for (DocumentMutation mutation : this.mutations) {
                    table = DBTests.getTable(this.tableName);
                    table.update(this.record, mutation);
                    table.flush();
                }
                System.out.println("Thread " + this.tid + " done.");
            }
            return null;
        }
    }
}

