/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.collect.ImmutableList;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class MapRDBStressTest
extends BaseTest
implements Datasets {
    private static final Logger _logger;
    private static final String TABLE_NAME = "testtable-MapRDBStressTest";
    private static final char[] mychars;
    private final Random random = new Random();
    private static Table table;
    QueryCondition condition;
    List<Object> values;
    int numRecords = 2048;
    int maxRecDepth = 128;
    int maxRecBreadth = 32;
    int minkeySize = 128;
    int numDel = 256;
    String keyPrefix = "KEY";
    String[] keys = new String[this.numRecords];
    String[][] perLevel = new String[this.maxRecDepth][this.maxRecBreadth];
    String colPrefix = "hkey";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        table.close();
        DBTests.deleteTables(TABLE_NAME);
    }

    public String getRandKey(int numChar) {
        char[] buf = new char[numChar];
        for (int idx = 0; idx < buf.length; ++idx) {
            buf[idx] = mychars[this.random.nextInt(mychars.length)];
        }
        return new String(buf);
    }

    private void setKeys() {
        String randString = this.getRandKey(this.minkeySize);
        String uuid = UUID.randomUUID().toString();
        for (int i = 0; i < this.numRecords; ++i) {
            this.keys[i] = this.keyPrefix + randString + uuid + i;
        }
    }

    private void setHierKeys() {
        String hierKey = null;
        for (int iter = 0; iter < this.maxRecDepth; ++iter) {
            int i;
            if (iter == 0) {
                for (i = 0; i < this.maxRecBreadth; ++i) {
                    this.perLevel[iter][i] = this.colPrefix + iter;
                }
                continue;
            }
            for (i = 0; i < this.maxRecBreadth; ++i) {
                for (int intIter = 0; intIter < iter; ++intIter) {
                    int suffix = intIter + 1;
                    hierKey = this.perLevel[intIter][i] + "." + this.colPrefix + suffix + i;
                }
                this.perLevel[iter][i] = hierKey;
            }
        }
        this.setKeys();
    }

    private void setCondition(int idx) {
        int i = idx == this.maxRecBreadth ? (int)(Math.random() * (double)this.maxRecBreadth) : idx;
        String hierKey = this.perLevel[this.maxRecDepth - 1][i];
        this.condition = MapRDB.newCondition().and().exists("map.LIST").typeOf("map.LIST", Value.Type.ARRAY).is("map.int", QueryCondition.Op.EQUAL, 50000).close().build();
    }

    private void putRecords() throws IOException {
        Document putRec = null;
        for (int i = 0; i < this.numRecords; ++i) {
            putRec = this.getRecord();
            if (i == this.numRecords - 1) {
                putRec.set("office", "abc comp");
            }
            table.insertOrReplace(this.keys[i], putRec);
        }
        _logger.info("Inserted " + this.numRecords + " records.");
    }

    void testGets() throws IOException {
        Document readRecord;
        int i;
        for (i = 0; i < this.numRecords; ++i) {
            readRecord = table.findById(this.keys[i]);
            Assert.assertNotNull((Object)readRecord);
        }
        _logger.info("Get test completed");
        for (i = 0; i < this.numRecords; ++i) {
            readRecord = table.findById(this.keys[i], this.condition);
            Assert.assertNotNull((Object)readRecord);
        }
        _logger.info("Get condition test completed ");
        int count = 0;
        this.setCondition(this.maxRecBreadth - 1);
        for (int i2 = 0; i2 < this.numRecords; ++i2) {
            readRecord = table.findById(this.keys[i2], this.condition, new String[]{"office"});
            if (readRecord == null) continue;
            ++count;
        }
        _logger.info("Get condition+proj test completed " + count);
    }

    void testScans() throws IOException {
        DocumentStream rs = table.find();
        Iterator itrs = rs.iterator();
        int count = 0;
        while (itrs.hasNext()) {
            Document readRecord = (Document)itrs.next();
            Assert.assertEquals((Object)readRecord.getValue("map").getType(), (Object)Value.Type.MAP);
            Assert.assertEquals((double)readRecord.getDouble("map.double"), (double)10.1234567891, (double)0.0);
            ++count;
        }
        _logger.info("Scan completed - got " + count + " records.");
        Assert.assertEquals((long)count, (long)this.numRecords);
        for (int i = 0; i < this.numDel; ++i) {
            table.delete(this.keys[i]);
        }
        table.flush();
        rs = table.find();
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        _logger.info("Scan completed after " + this.numDel + " records delete. Got " + count + " records.");
        Assert.assertEquals((long)count, (long)(this.numRecords - this.numDel));
        rs = table.find(this.condition, new String[]{"office"});
        itrs = rs.iterator();
        count = 0;
        while (itrs.hasNext()) {
            itrs.next();
            ++count;
        }
        _logger.info("Scan with condition count " + count);
    }

    Document getRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setArray("Scores", new int[]{10, 20, 30, 40, 50, 60, 70}).setArray("Friends", new Object[]{"A", "B", "M", "Z", new Integer(10)}).set("map.boolean", false).set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).setNull("NULL").set("map.a1.a2.a3", 10000);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i = 0; i < bbuf.capacity(); ++i) {
            bbuf.put((byte)i);
        }
        bbuf.rewind();
        rec.set("binary3", bbuf).set("Time", new OTime(10000000L)).set("Date", new ODate(432000000L)).set("boolean", false).set("string", "string").set("byte", (byte)100);
        this.values = new ArrayList<Object>();
        this.values.add("Field1");
        this.values.add(new Integer(500));
        this.values.add(new Double(5555.5555));
        rec.set("map.LIST", this.values);
        ArrayList<Object> values2 = new ArrayList<Object>();
        values2.add("Field1");
        values2.add(new Integer(500));
        values2.add(new Double(5555.5555));
        values2.add(new int[]{500, 1000, 1500, 2000});
        rec.set("map.LIST2", values2);
        for (int i = 0; i < this.maxRecBreadth; ++i) {
            rec.set(this.perLevel[this.maxRecDepth - 1][i], i * 1000);
        }
        return rec;
    }

    void testCondition() throws IOException {
        QueryCondition inner = MapRDB.newCondition().exists("address").build();
        QueryCondition c = MapRDB.newCondition().or().and().equals("NAME", NAMES[1]).typeOf("address.phones", Value.Type.ARRAY).exists("address.phones[1]").is("address.phones[1]", QueryCondition.Op.EQUAL, 5556667777L).matches("address.street", ".*Pennsylvania Avenue.*").or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER, "parts550").is("price", QueryCondition.Op.LESS_OR_EQUAL, 100).close().in("age", (List)ImmutableList.of((Object)1001.82, (Object)Float.valueOf(17.5f), (Object)23, (Object)25.56, (Object)95)).notIn("age", (List)ImmutableList.of((Object)23, (Object)71L, (Object)91, (Object)54.7)).close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, "dev4").is("age", QueryCondition.Op.GREATER, 100).condition(inner).close().build();
        boolean conditionSuccess = table.checkAndDelete("CheckAndReplaceKey", c);
        Assert.assertEquals((Object)true, (Object)conditionSuccess);
    }

    void testCheckAndMutateReplace() throws IOException {
        Document rr;
        boolean conditionSuccess;
        QueryCondition c;
        int i;
        int numLoops = 1234;
        Document r = this.getRecord();
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.insertOrReplace("CheckAndReplaceKey", r);
        for (i = 0; i < numLoops; ++i) {
            c = MapRDB.newCondition().is("map.short", QueryCondition.Op.EQUAL, (short)(10000 + i)).build();
            r.set("map.short", (short)(10000 + i + 1));
            conditionSuccess = table.checkAndReplace("CheckAndReplaceKey", c, r);
            Assert.assertEquals((Object)true, (Object)conditionSuccess);
            rr = table.findById("CheckAndReplaceKey");
            Assert.assertEquals((long)rr.getInt("Scores[1]"), (long)20L);
            Assert.assertEquals((Object)rr.getString("Friends[0]"), (Object)"A");
            Assert.assertEquals((long)rr.getByte("map.byte"), (long)100L);
            Assert.assertEquals((long)rr.getShort("map.short"), (long)((short)(10000 + i + 1)));
            Assert.assertEquals((long)rr.getLong("map.long"), (long)12345678999L);
            Assert.assertEquals((long)rr.getInt("map.LIST2[3][2]"), (long)1500L);
        }
        for (i = 0; i < numLoops; ++i) {
            rr = table.findById("CheckAndReplaceKey");
            c = MapRDB.newCondition().is("map.short", QueryCondition.Op.EQUAL, (short)(10000 + numLoops + i)).build();
            DocumentMutation m = MapRDB.newMutation().increment("map.short", 1);
            conditionSuccess = table.checkAndMutate("CheckAndReplaceKey", c, m);
            Assert.assertEquals((Object)true, (Object)conditionSuccess);
            rr = table.findById("CheckAndReplaceKey");
            Assert.assertEquals((long)rr.getInt("Scores[1]"), (long)20L);
            Assert.assertEquals((Object)rr.getString("Friends[0]"), (Object)"A");
            Assert.assertEquals((long)rr.getByte("map.byte"), (long)100L);
            Assert.assertEquals((long)rr.getShort("map.short"), (long)((short)(10000 + numLoops + i + 1)));
            Assert.assertEquals((long)rr.getLong("map.long"), (long)12345678999L);
            Assert.assertEquals((long)rr.getInt("map.LIST2[3][2]"), (long)1500L);
        }
        _logger.info("checkAndMutate/Replace test completed.");
    }

    @Test
    public void stressTestMapRDB() throws IOException, InterruptedException {
        this.setHierKeys();
        this.setCondition(this.maxRecBreadth);
        this.putRecords();
        this.testGets();
        this.testScans();
        this.testCheckAndMutateReplace();
        this.testCondition();
    }

    public static void main(String[] args) throws Exception {
        MapRDBStressTest t = new MapRDBStressTest();
        t.stressTestMapRDB();
    }

    static {
        char ch;
        _logger = LoggerFactory.getLogger(MapRDBStressTest.class);
        StringBuilder sb = new StringBuilder();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            sb.append(ch);
        }
        for (ch = 'a'; ch <= 'z'; ch = (char)(ch + '\u0001')) {
            sb.append(ch);
        }
        mychars = sb.toString().toCharArray();
    }
}

