/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.MapRDB;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestDBDocument
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestDBDocument.class);
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testAllTypes() {
        int i;
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("map.field1", (byte)100);
        rec.set("map.field2", (short)10000);
        rec.set("map.longfield2verylongverylong", 12.345678);
        rec.set("FIELD2", "VERY LONG STRING IS THIS YOU KNOW");
        rec.set("map2.field1", (byte)100);
        rec.set("map2.field2", (short)10000);
        rec.set("map2.longfield2verylongverylong", 12.345678);
        rec.set("FIELD3", "VERY LONG STRING IS THIS YOU KNOW");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        rec.set("newmap.map", map);
        StringBuilder buf = new StringBuilder();
        rec.toString(buf);
        _logger.info("Record is {}", (Object)buf);
        rec.set("map.boolean", false);
        rec.set("map.string", "string");
        rec.set("map.byte", (byte)100);
        rec.set("map.short", (short)10000);
        rec.set("map.int", 50000);
        rec.set("map.long", 12345678999L);
        rec.set("map.float", 10.1234f);
        rec.set("map.double", 10.1234567891);
        byte[] bytes = new byte[5];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)i2;
        }
        rec.set("map.binary1", bytes);
        rec.set("map.binary2", bytes, 1, 3);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i3 = 0; i3 < bbuf.capacity(); ++i3) {
            bbuf.put((byte)i3);
        }
        rec.set("map.binary3", bbuf);
        map = new HashMap();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add(100);
        scores.add(200);
        scores.add(300);
        scores.add(400);
        rec.set("map.map", map);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Integer(500));
        values.add(new Double(5555.5555));
        rec.set("map.list", values);
        Assert.assertEquals((Object)rec.getValue("map").getType(), (Object)Value.Type.MAP);
        Assert.assertEquals((Object)rec.getBoolean("map.boolean"), (Object)false);
        Assert.assertEquals((Object)rec.getString("map.string"), (Object)"string");
        Assert.assertEquals((long)rec.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)rec.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)rec.getInt("map.int"), (long)50000L);
        Assert.assertEquals((long)rec.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((double)rec.getFloat("map.float"), (double)10.1234f, (double)0.0);
        Assert.assertEquals((double)rec.getDouble("map.double"), (double)10.1234567891, (double)0.0);
        ByteBuffer readBuf = rec.getBinary("map.binary1");
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bytes[i]);
        }
        readBuf = rec.getBinary("map.binary2");
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)readBuf.get(), (long)bytes[1 + i]);
        }
        readBuf = rec.getBinary("map.binary3");
        for (i = 0; i < bbuf.capacity(); ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bbuf.get(i));
        }
        Map m = rec.getValue("map.map").getMap();
        Assert.assertEquals(map, (Object)m);
        List l = rec.getValue("map.list").getList();
        Assert.assertEquals(values, (Object)l);
    }

    @Test
    public void testBug18764() {
        Document r1 = MapRDB.newDocument().set("age", 50).set("name", "joeseph").set("address.zip", 94086).set("address.street", "Washington Ave");
        Assert.assertEquals((Object)true, (Object)r1.equals(r1));
    }

    @Test
    public void testBooleanArray() {
        Document r1 = MapRDB.newDocument();
        r1.set("map.int", 111);
        boolean[] boolArray = new boolean[]{true, false, true};
        r1.setArray("map.boolarray", boolArray);
        Assert.assertEquals((Object)false, (Object)r1.getBoolean("map.boolarray[1]"));
        Assert.assertEquals((Object)true, (Object)r1.getBoolean("map.boolarray[2]"));
    }

    @Test
    public void arrayTest() throws Exception {
        Document r = MapRDB.newDocument();
        r.setArray("Double_array", new double[]{10.1, 20.2, 30.3});
        Assert.assertEquals((double)10.1, (double)r.getDouble("Double_array[0]"), (double)0.0);
    }

    @Test
    public void testEquals() {
        Document rec = MapRDB.newDocument();
        rec.set("map.field1", (byte)100);
        rec.set("map.field2", (short)10000);
        rec.set("map.string", "eureka");
        rec.set("map.boolean", false);
        rec.set("map.date", ODate.parse((String)"2013-02-12"));
        OTime time = OTime.parse((String)"07:42:46");
        rec.set("map.time", time);
        OTimestamp timeStamp = OTimestamp.parse((String)"2012-10-20T07:42:46");
        rec.set("map.timestamp", timeStamp);
        rec.set("map.int", 12345678);
        byte[] byteArray = "abracadabra".getBytes();
        rec.set("map.bytearray", byteArray);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("a", 500);
        m.put("b", "abcd");
        ArrayList<Object> newlist = new ArrayList<Object>();
        newlist.add("aaaaa");
        newlist.add(1234567.89);
        m.put("c", newlist);
        rec.set("map2", m);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(12345.678901);
        l.add("abracadabra");
        HashMap<String, Constable> m2 = new HashMap<String, Constable>();
        m2.put("a1", Integer.valueOf(111));
        m2.put("b1", Boolean.valueOf(false));
        l.add(m2);
        rec.set("list1", l);
        Document rec2 = rec;
        Assert.assertEquals((Object)true, (Object)rec2.equals(rec));
        Value stringValue = rec.getValue("map.string");
        Assert.assertEquals((Object)true, (Object)stringValue.equals("eureka"));
        byte b = rec.getByte("map.field1");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field1").equals(b));
        Byte bite = new Byte(b);
        Assert.assertEquals((Object)true, (Object)bite.equals(rec.getByte("map.field1")));
        short s = rec.getShort("map.field2");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field2").equals(s));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field2").equals(KeyValueBuilder.initFrom((short)s)));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.boolean").equals(false));
        Assert.assertEquals((Object)ODate.parse((String)"2013-02-12"), (Object)rec.getDate("map.date"));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map2").equals(m));
        int x = rec.getInt("map.int");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.int").equals(x));
        Assert.assertEquals((Object)true, (Object)rec.getList("list1").equals(l));
        Assert.assertEquals((Object)time, (Object)rec.getTime("map.time"));
        Assert.assertEquals((Object)timeStamp, (Object)rec.getTimestamp("map.timestamp"));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.bytearray").equals(ByteBuffer.wrap(byteArray)));
        Value myValue = rec.getValue("map.date");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.date").equals(myValue));
        myValue = rec.getValue("map.time");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.time").equals(myValue));
        myValue = rec.getValue("map.timestamp");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.timestamp").equals(myValue));
        myValue = rec.getValue("list1");
        Assert.assertEquals((Object)true, (Object)rec.getValue("list1").equals(myValue));
        myValue = rec.getValue("map2");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map2").equals(myValue));
    }

    @Test
    public void testSelfEquals() {
        Document doc = MapRDB.newDocument().set("emptymap", new HashMap());
        _logger.info(doc.toString());
        Assert.assertTrue((boolean)doc.equals(doc));
    }

    @Test
    public void testDocumentEqualsWithJson() throws IOException {
        String fieldPath = "`a|b`.`c,''-\\\"d`.` a!\\`#$%&'()*+,-/:;<=>?@`.`[]^_{|}~`";
        FieldPath fp = FieldPath.parseFrom((String)fieldPath);
        Document d1 = MapRDB.newDocument();
        d1.set(fp, 10);
        d1.set("list", (List)ImmutableList.of((Object)1, (Object)"abc", (Object)99.0));
        d1.set("map", (Map)ImmutableMap.of((Object)"k1", (Object)"abc", (Object)"k2", (Object)99.0));
        Document d2 = Json.newDocument();
        d2.set(fp, 10);
        d2.set("list", (List)ImmutableList.of((Object)1, (Object)"abc", (Object)99.0));
        d2.set("map", (Map)ImmutableMap.of((Object)"k1", (Object)"abc", (Object)"k2", (Object)99.0));
        Assert.assertEquals((Object)d1, (Object)d2);
    }

    @Test
    public void testBug18884() {
        Document r1 = MapRDB.newDocument().set("string", "asdasd").set("ts", new OTimestamp(100000L));
        Document r2 = MapRDB.newDocument().set("string", "asdasd").set("ts", new OTimestamp(100000L));
        Assert.assertEquals((Object)true, (Object)r1.getValue("ts").equals(r2.getValue("ts")));
        Document doc1 = Json.newDocument();
        doc1.set("abcd", "efg");
        Document doc2 = MapRDB.newDocument();
        doc2.set("abcd", "efg");
        Assert.assertEquals((Object)doc1, (Object)doc2);
        Assert.assertEquals((Object)doc2, (Object)doc1);
        doc1.set("arr[0]", "a");
        doc1.set("arr[1]", "b");
        doc2.set("arr[0]", "a");
        doc2.set("arr[1]", "b");
        Assert.assertEquals((Object)true, (Object)doc1.equals(doc2));
        Assert.assertEquals((Object)true, (Object)doc2.equals(doc1));
    }

    @Test
    public void testNull() {
        Document r1 = MapRDB.newDocument().setNull("a");
        Document r2 = MapRDB.newDocument().setNull("a");
        Assert.assertEquals((Object)true, (Object)r1.equals(r2));
    }

    @Test
    public void testBigDecimalIntervalDisabled() {
        Document doc = MapRDB.newDocument();
        doc.set("val1", "xyz");
        this.exception.expect(UnsupportedOperationException.class);
        doc.set("val2", new BigDecimal(1.223344));
        doc.set("val3", false);
        doc.set("val4", new OInterval(10000L));
    }
}

