/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.aces;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.exceptions.AccessDeniedException;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.proto.Dbserver;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestJSONAceSupportWithCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONAceSupportWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestJSONAceSupport";
    private static Table table;
    private static Path tablePath;

    @Before
    public void setupTestJSONAceSupportWithCluster() throws Exception {
        try {
            table = DBTests.createOrReplaceTable(TABLE_NAME);
            table.setOption(Table.TableOption.BUFFERWRITE, false);
            table.setOption(Table.TableOption.EXCLUDEID, true);
        }
        catch (Exception e) {
            _logger.info("Failed to create a new table '{}'.", (Object)tablePath);
            throw e;
        }
    }

    @After
    public void cleanupTestJSONAceSupportWithCluster() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testJSONAceArraySupport() throws Exception {
        assert (table != null);
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "restaurant.menu[][].price", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "restaurant.menu[][].dish", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address[]", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "mapr.projects", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "mapr.projects[][].FirstName", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "mapr.projects[][].LastName", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        HashMap<String, String> s1 = new HashMap<String, String>();
        HashMap<String, String> s2 = new HashMap<String, String>();
        HashMap<String, String> s3 = new HashMap<String, String>();
        HashMap<String, String> s4 = new HashMap<String, String>();
        s1.put("street", "Maude Ave");
        s2.put("street", "Capitol Ave");
        s3.put("Street", "Holger Way");
        s4.put("streets", "Zanker road");
        putRec.setArray("person.address", new Object[]{s1, s2, s3, s4});
        try {
            table.insertOrReplace("r1", (Document)putRec);
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Put person.address[].street failed with exception: " + e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> a1 = new HashMap<String, Object>();
        HashMap<String, Object> a2 = new HashMap<String, Object>();
        HashMap<String, Object> a3 = new HashMap<String, Object>();
        a1.put("dish", "Ice-Cream");
        a1.put("price", 4.99);
        a2.put("dish", "Cake");
        a2.put("price", 6.99);
        a3.put("dish", "Pudding");
        a3.put("price", 3.99);
        Object[] dessert = new Object[]{a1, a2, a3};
        HashMap<String, Object> d1 = new HashMap<String, Object>();
        HashMap<String, Object> d2 = new HashMap<String, Object>();
        HashMap<String, Object> d3 = new HashMap<String, Object>();
        HashMap<String, Object> d4 = new HashMap<String, Object>();
        d1.put("dish", "Paneer Tikka");
        d1.put("price", 5.99);
        d2.put("dish", "Samosa");
        d2.put("price", 4.99);
        d3.put("dish", "Chaat");
        d3.put("price", 5.99);
        d4.put("dish", "Pakoda");
        d4.put("price", 3.99);
        Object[] appetizers = new Object[]{d1, d2, d3, d4};
        Object[] menu = new Object[]{appetizers, dessert};
        putRec = new DBDocumentImpl();
        putRec.set("restaurant.name", "Ojai Cafe").setArray("restaurant.menu", menu);
        try {
            table.insertOrReplace("r1", (Document)putRec);
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Put person.restaurant[][].dish failed with exception: " + e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> e1 = new HashMap<String, String>();
        HashMap<String, String> e2 = new HashMap<String, String>();
        HashMap<String, String> e3 = new HashMap<String, String>();
        HashMap<String, String> e4 = new HashMap<String, String>();
        HashMap<String, String> e5 = new HashMap<String, String>();
        e1.put("FirstName", "Anurag");
        e1.put("LastName", "Choudhary");
        e2.put("FirstName", "Santanu");
        e2.put("LastName", "Chatterjee");
        e3.put("FirstName", "Bharat");
        e3.put("LastName", "Baddepudi");
        e4.put("FirstName", "Aditya");
        e4.put("LastName", "Kishore");
        e5.put("FirstName", "Jimit");
        e5.put("LastName", "Shah");
        Object[] ojai = new Object[]{e1, e2, e3, e4, e5};
        HashMap<String, String> e6 = new HashMap<String, String>();
        HashMap<String, String> e7 = new HashMap<String, String>();
        HashMap<String, String> e8 = new HashMap<String, String>();
        HashMap<String, String> e9 = new HashMap<String, String>();
        e6.put("FirstName", "Andrew");
        e6.put("LastName", "Gliga");
        e7.put("FirstName", "Todd");
        e7.put("LastName", "Richmond");
        e8.put("FirstName", "Anbang");
        e8.put("LastName", "Xu");
        e9.put("FirstName", "Naveen");
        e9.put("LastName", "Tirupattur");
        Object[] mcs = new Object[]{e6, e7, e8, e9};
        putRec = new DBDocumentImpl();
        putRec.setArray("mapr.projects", new Object[]{ojai, mcs});
        try {
            table.insertOrReplace("r1", (Document)putRec);
            table.insertOrReplace("r2", (Document)putRec);
            table.insertOrReplace("r3", (Document)putRec);
            table.insertOrReplace("r4", (Document)putRec);
        }
        catch (Exception e) {
            _logger.error("Put mapr.projects[] block failed with an exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        Document readRecord = null;
        readRecord = table.findById("r1");
        Assert.assertEquals((Object)"Choudhary", (Object)readRecord.getString("mapr.projects[0][0].LastName"));
        Assert.assertEquals((Object)"Chatterjee", (Object)readRecord.getString("mapr.projects[0][1].LastName"));
        Assert.assertEquals((Object)"Baddepudi", (Object)readRecord.getString("mapr.projects[0][2].LastName"));
        Assert.assertEquals((Object)"Kishore", (Object)readRecord.getString("mapr.projects[0][3].LastName"));
        Assert.assertEquals((Object)"Shah", (Object)readRecord.getString("mapr.projects[0][4].LastName"));
        Assert.assertEquals((Object)"Gliga", (Object)readRecord.getString("mapr.projects[1][0].LastName"));
        Assert.assertEquals((Object)"Richmond", (Object)readRecord.getString("mapr.projects[1][1].LastName"));
        Assert.assertEquals((Object)"Xu", (Object)readRecord.getString("mapr.projects[1][2].LastName"));
        Assert.assertEquals((Object)"Tirupattur", (Object)readRecord.getString("mapr.projects[1][3].LastName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[0][0].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[0][1].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[0][2].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[0][3].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[0][4].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[1][0].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[1][1].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[1][2].FirstName"));
        Assert.assertNull((Object)readRecord.getString("mapr.projects[1][3].FirstName"));
    }

    @Test
    public void testJSONPutAceValidation() throws Exception {
        DBDocumentImpl putRec;
        assert (table != null);
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.name", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address", Dbserver.DBAccessType.ColumnTraverseData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address.office.city", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.office", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address.office.street", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address.home", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.home", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.cell", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.ssn", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        String new_lName = "vora";
        String new_fName = "jimmy";
        try {
            this.putSingleKV("r1", "person.name.last", new_lName);
            _logger.info("Put person.name.last succeeded.");
        }
        catch (Exception e) {
            _logger.error("Put person.name.last failed with an exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            this.putSingleKV("r1", "person.name.first", new_fName);
            _logger.info("Put person.name.first succeeded.");
        }
        catch (Exception e) {
            _logger.error("Pu person.name.first failed with an exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            this.putSingleKV("r1", "person.address.office.city", "mountain view");
            _logger.info("Put person.address.office.city succeeded.");
        }
        catch (Exception e) {
            _logger.error("Put person.adress.office.city failed with an exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            this.putSingleKV("r1", "person.phone.office", "234-567-8901");
            _logger.info("Put person.phone.office succeeded.");
        }
        catch (AccessDeniedException e) {
            _logger.info("Put for person.phone.office failed with an exception" + e.getMessage(), (Throwable)e);
        }
        try {
            this.putSingleKV("r1", "person.address.office.street", "Castro St.");
            _logger.info("Put person.address.office.street succeeded.");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put person.adress.office.city failed with an exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.putSingleKV("r1", "person.phone.cell", "234-567-8901");
            _logger.info("Put person.phone.cell succeeded.");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put for person.phone.cell failed with an exception" + e.getMessage(), (Throwable)e);
        }
        try {
            this.putSingleKV("r1", "person.address.home.zip", "95134");
            _logger.info("Put person.adress.home.zip succeeded.");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put for person.address.home.zip failed with an exception" + e.getMessage(), (Throwable)e);
        }
        try {
            putRec = new DBDocumentImpl();
            putRec.set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", "95134");
            table.insertOrReplace("r1", (Document)putRec);
            _logger.info("Put block for person.address succeeded");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put block for person.address failed with an exception" + e.getMessage(), (Throwable)e);
        }
        try {
            putRec = new DBDocumentImpl();
            putRec.set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012");
            table.insertOrReplace("r1", (Document)putRec);
            _logger.info("Put block for person.phone succeeded");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put block for person.phone failed with an exception" + e.getMessage(), (Throwable)e);
        }
        try {
            putRec = new DBDocumentImpl();
            putRec.set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
            table.insertOrReplace("r1", (Document)putRec);
            _logger.info("Put block for person.ssn succeeded");
            Assert.fail();
        }
        catch (AccessDeniedException e) {
            _logger.debug("Put block for person.ssn failed with an exception" + e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testJSONGetAceValidationWithProjection() throws Exception {
        assert (table != null);
        DBTests.setFieldAce(tablePath, "default", "person.address.home.street", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.ssn", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", "95134").set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        System.out.println("Put block succeeded.");
        Document readRecord = null;
        readRecord = table.findById("r1", new String[]{"person.address.home.city", "person.address.home.street", "person.phone.home", "person.phone.office"});
        Assert.assertEquals((Object)readRecord.getString("person.address.home.city"), (Object)"Sunnyvale");
        Assert.assertNull((Object)readRecord.getString("person.address.home.street"));
        Assert.assertEquals((Object)readRecord.getString("person.phone.office"), (Object)"123-456-7890");
        Assert.assertNull((Object)readRecord.getString("person.phone.home"));
        Assert.assertNull((Object)readRecord.getString("person.phone.cell"));
        Assert.assertNull((Object)readRecord.getString("person.address.office.zip"));
    }

    @Test
    public void testJSONGetAceValidationNoProjection() throws Exception {
        assert (table != null);
        DBTests.setFieldAce(tablePath, "default", "person.address.home.street", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.ssn", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", 95134).set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        System.out.println("Put block succeeded.");
        table.flush();
        Document readRecord = null;
        readRecord = table.findById("r1");
        Assert.assertEquals((Object)readRecord.getString("person.name.first"), (Object)"jimit");
        Assert.assertEquals((Object)readRecord.getString("person.name.last"), (Object)"shah");
        Assert.assertEquals((Object)readRecord.getString("person.address.home.city"), (Object)"Sunnyvale");
        Assert.assertEquals((Object)readRecord.getString("person.address.office.street"), (Object)"San Jose");
        Assert.assertEquals((long)readRecord.getInt("person.address.office.zip"), (long)95134L);
        Assert.assertEquals((Object)readRecord.getString("person.phone.office"), (Object)"123-456-7890");
        Assert.assertEquals((Object)readRecord.getString("person.phone.cell"), (Object)"345-678-9012");
        Assert.assertNull((Object)readRecord.getString("person.address.home.street"));
        Assert.assertNull((Object)readRecord.getString("person.phone.home"));
        Assert.assertNull((Object)readRecord.getString("person.ssn"));
        QueryCondition cond = MapRDB.newCondition().and().exists("person.address.office.zip").typeOf("person.address.office.zip", Value.Type.INT).is("person.address.office.zip", QueryCondition.Op.EQUAL, 95134).close().build();
        readRecord = table.findById("r1", cond);
        Assert.assertNotNull((Object)readRecord);
        Assert.assertEquals((long)readRecord.getInt("person.address.office.zip"), (long)95134L);
        cond = MapRDB.newCondition().and().exists("person.address.office.zip").typeOf("person.address.office.zip", Value.Type.INT).is("person.address.office.zip", QueryCondition.Op.EQUAL, 95131).close().build();
        readRecord = table.findById("r1", cond);
        Assert.assertNull((Object)readRecord);
    }

    @Test
    public void testJSONScanAceValidationWithProjection() throws Exception {
        assert (table != null);
        DBTests.setFieldAce(tablePath, "default", "person.address.home.street", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", "95134").set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        table.insertOrReplace("r2", (Document)putRec);
        table.insertOrReplace("r3", (Document)putRec);
        table.insertOrReplace("r4", (Document)putRec);
        System.out.println("Put block succeeded.");
        DocumentStream rs = table.find(new String[]{"person.address.home.city", "person.address.home.street"});
        for (Document readRecord : rs) {
            Assert.assertEquals((Object)"Sunnyvale", (Object)readRecord.getString("person.address.home.city"));
            Assert.assertNull((Object)readRecord.getValue("person.address.home.street"));
        }
    }

    @Test
    public void testJSONScanAceValidationNoProjection() throws Exception {
        assert (table != null);
        DBTests.setFieldAce(tablePath, "default", "person.address.home.street", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.phone.home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person.ssn", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", 95134).set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        table.insertOrReplace("r2", (Document)putRec);
        table.insertOrReplace("r3", (Document)putRec);
        table.insertOrReplace("r4", (Document)putRec);
        System.out.println("Put block succeeded.");
        DocumentStream rs = table.find();
        for (Document readRecord : rs) {
            Assert.assertEquals((Object)readRecord.getString("person.name.first"), (Object)"jimit");
            Assert.assertEquals((Object)readRecord.getString("person.name.last"), (Object)"shah");
            Assert.assertEquals((Object)readRecord.getString("person.address.home.city"), (Object)"Sunnyvale");
            Assert.assertEquals((Object)readRecord.getString("person.address.office.street"), (Object)"San Jose");
            Assert.assertEquals((long)readRecord.getInt("person.address.office.zip"), (long)95134L);
            Assert.assertEquals((Object)readRecord.getString("person.phone.office"), (Object)"123-456-7890");
            Assert.assertEquals((Object)readRecord.getString("person.phone.cell"), (Object)"345-678-9012");
            Assert.assertNull((Object)readRecord.getString("person.address.home.street"));
            Assert.assertNull((Object)readRecord.getString("person.phone.home"));
            Assert.assertNull((Object)readRecord.getString("person.ssn"));
        }
        QueryCondition cond = MapRDB.newCondition().and().exists("person.address.office.zip").typeOf("person.address.office.zip", Value.Type.INT).is("person.address.office.zip", QueryCondition.Op.EQUAL, 95134).close().build();
        rs = table.find(cond);
        for (Document readRecord : rs) {
            Assert.assertEquals((long)readRecord.getInt("person.address.office.zip"), (long)95134L);
        }
        cond = MapRDB.newCondition().and().exists("person.address.office.zip").typeOf("person.address.office.zip", Value.Type.INT).is("person.address.office.zip", QueryCondition.Op.EQUAL, 95131).close().build();
        rs = table.find(cond);
        Iterator itrs = rs.iterator();
        Assert.assertFalse((boolean)itrs.hasNext());
    }

    @Test
    public void testJSONCFAceValidation() throws Exception {
        assert (table != null);
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.name", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address.home", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", 95134).set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        System.out.println("Put block succeeded.");
        table.flush();
        Document readRecord = null;
        readRecord = table.findById("r1");
        Assert.assertEquals((Object)"jimit", (Object)readRecord.getString("person.name.first"));
        Assert.assertEquals((Object)"shah", (Object)readRecord.getString("person.name.last"));
        Assert.assertEquals((Object)"Sunnyvale", (Object)readRecord.getString("person.address.home.city"));
        Assert.assertEquals((Object)"525 E Maude Ave", (Object)readRecord.getString("person.address.home.street"));
        Assert.assertNull((Object)readRecord.getString("person.address.office.street"));
        Assert.assertNull((Object)readRecord.getString("person.address.office.zip"));
        Assert.assertNull((Object)readRecord.getString("person.ssn.area"));
    }

    @Test
    public void testJSONCFAceExclusionValidation() throws Exception {
        assert (table != null);
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "person", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "person.address.home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", 95134).set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", "123").set("person.ssn.group", "45").set("person.ssn.serial", "6789");
        table.insertOrReplace("r1", (Document)putRec);
        System.out.println("Put block succeeded.");
        table.flush();
        Document readRecord = null;
        readRecord = table.findById("r1");
        Assert.assertEquals((Object)"jimit", (Object)readRecord.getString("person.name.first"));
        Assert.assertEquals((Object)"shah", (Object)readRecord.getString("person.name.last"));
        Assert.assertEquals((Object)"San Jose", (Object)readRecord.getString("person.address.office.street"));
        Assert.assertEquals((long)95134L, (long)readRecord.getInt("person.address.office.zip"));
        Assert.assertEquals((Object)"123", (Object)readRecord.getString("person.ssn.area"));
        Assert.assertNull((Object)readRecord.getString("person.address.home.street"));
        Assert.assertNull((Object)readRecord.getString("person.address.home.city"));
    }

    @Test
    public void testJSONAceUpdateAndGet() throws Exception {
        assert (table != null);
        HashMap<String, String[]> categories = new HashMap<String, String[]>();
        categories.put("food", new String[]{"Food", "Donuts", "Coffee & Tea"});
        categories.put("entertainment", new String[]{"Theater", "Cinema", "Improv"});
        Document putRec = MapRDB.newDocument();
        FieldPath fpWifi = FieldPath.parseFrom((String)"`Wi-Fi`");
        FieldPath fpPrice = FieldPath.parseFrom((String)"`Price Range`");
        putRec.set("business_id", "A12345").set("full_address", "6935 N Durango Dr\nSte 150\nCentennial\nLas Vegas, NV").set("open", true).set("categories", categories).set("city", "Las Vegas").set("review_count", 15).set("latitude", 36.287822723389).set(fpWifi, "free").set(fpPrice, 1);
        table.insertOrReplace("r1", putRec);
        table.insertOrReplace("r2", putRec);
        table.insertOrReplace("r3", putRec);
        table.insertOrReplace("r4", putRec);
        System.out.println("Put block succeeded.");
        table.flush();
        HashMap<String, String[]> newCategories = new HashMap<String, String[]>();
        newCategories.put("food", new String[]{"Bagels"});
        DocumentMutation rm = MapRDB.newMutation();
        rm.setOrReplace("open", false).append("full_address", " 89149").increment("review_count", 1).merge("categories", newCategories).delete(fpWifi);
        table.update("r1", rm);
        table.flush();
        Document readRecord = table.findById("r1");
        Assert.assertEquals((Object)"A12345", (Object)readRecord.getString("business_id"));
        Assert.assertEquals((Object)"6935 N Durango Dr\nSte 150\nCentennial\nLas Vegas, NV 89149", (Object)readRecord.getString("full_address"));
        Assert.assertEquals((Object)false, (Object)readRecord.getBoolean("open"));
        Assert.assertEquals((long)16L, (long)readRecord.getInt("review_count"));
        List foodList = readRecord.getValue("categories.food").getList();
        List entertainment = readRecord.getValue("categories.entertainment").getList();
        Assert.assertEquals((Object)"Food", foodList.get(0));
        Assert.assertEquals((Object)"Bagels", foodList.get(3));
        Assert.assertEquals((Object)"Theater", entertainment.get(0));
        Assert.assertNull((Object)readRecord.getString(fpWifi));
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "open", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "open", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "full_address", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(tablePath, "default", "review_count", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DocumentMutation rm1 = MapRDB.newMutation();
        rm1.setOrReplace("open", true);
        try {
            table.update("r1", rm1);
            table.flush();
            readRecord = table.findById("r1");
            Assert.assertEquals((Object)true, (Object)readRecord.getBoolean("open"));
        }
        catch (Exception e) {
            _logger.info("Failed to update table 'open' field");
            throw e;
        }
        rm1 = MapRDB.newMutation();
        rm1.append("full_address", " USA");
        try {
            table.update("r1", rm1);
            table.flush();
            readRecord = table.findById("r1");
            _logger.error("full_address after update = " + readRecord.getString("full_address"));
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Update to 'full_address' failed with exception: " + e.getMessage(), (Throwable)e);
        }
        rm1 = MapRDB.newMutation();
        rm1.increment("review_count", 1);
        try {
            table.update("r1", rm1);
            table.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Updating 'review_count' failed with exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testJSONAceUpdateAndGetMultiCF() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "Value1").set("a.b.d", 15).set("c.d", "Value2").set("x.y.z.a", "Value3").set("x.y.w", 20).set("x.y.a", true);
        mcfTable.insertOrReplace("r1", putRec);
        System.out.println("Put r1 succeeded");
        mcfTable.flush();
        DocumentMutation rm = MapRDB.newMutation();
        rm.append("a.b.c", "Append").increment("a.b.d", 5).append("x.y.z.a", "Append").increment("x.y.w", 5);
        mcfTable.update("r1", rm);
        mcfTable.flush();
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "d", Dbserver.DBAccessType.ColumnWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        Document readRecord = null;
        rm = MapRDB.newMutation();
        rm.delete("c.d");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to delete 'c.d': " + e.getMessage(), (Throwable)e);
        }
        try {
            mcfTable.delete("r1");
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to delete entire Document: " + e.getMessage(), (Throwable)e);
        }
        rm = MapRDB.newMutation();
        rm.append("a.b.c", "Value1");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.error("Failed to append 'a.b.c': " + e.getMessage());
            throw e;
        }
        readRecord = mcfTable.findById("r1");
        Assert.assertEquals((Object)"Value1AppendValue1", (Object)readRecord.getString("a.b.c"));
        rm = MapRDB.newMutation();
        rm.increment("a.b.d", 20);
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to increment 'a.b.d': " + e.getMessage(), (Throwable)e);
        }
        rm = MapRDB.newMutation();
        rm.delete("x.y.a");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to delete 'x.y.a': " + e.getMessage(), (Throwable)e);
        }
        readRecord = mcfTable.findById("r1");
        Assert.assertEquals((long)20L, (long)readRecord.getInt("a.b.d"));
        rm = MapRDB.newMutation();
        rm.append("x.y.z.a", "Append");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to append 'x.y.z.a': " + e.getMessage(), (Throwable)e);
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertNull((Object)readRecord.getString("x.y.z.a"));
        }
        catch (Exception e) {
            _logger.error("Failed to read 'x.y.z.a': " + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation();
        rm.setOrReplace("a.b.c", true).increment("x.y.w", 5);
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to update multi-CF record with a.b.c and x.y.w: " + e.getMessage(), (Throwable)e);
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((Object)"Value1AppendValue1", (Object)readRecord.getString("a.b.c"));
            Assert.assertEquals((long)25L, (long)readRecord.getInt("x.y.w"));
        }
        catch (Exception e) {
            _logger.error("Failed to write 'x.y.w': " + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation();
        rm.setOrReplace("a.b.c", true).setOrReplace("x.y.z.a", 20000);
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            _logger.info("Multi CF 2 update succeeded");
        }
        catch (Exception e) {
            _logger.error("Failed to update multi-CF record - a.b.c to true and x.y.z.a to 20000: " + e.getMessage());
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((Object)true, (Object)readRecord.getBoolean("a.b.c"));
            Assert.assertNull((Object)readRecord.getValue("x.y.z.a"));
        }
        catch (Exception e) {
            _logger.error("Failed to read record: " + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation().setOrReplace("a.b.c", "FALSE");
        QueryCondition cond = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, true).is("x.y.z.a", QueryCondition.Op.EQUAL, 20000).close().build();
        try {
            Assert.assertEquals((Object)false, (Object)mcfTable.checkAndMutate("r1", cond, rm));
            _logger.error("Failed to checkAndMutate record as condition failed.");
        }
        catch (Exception e) {
            _logger.debug("Failed to checkAndMutate record: " + e.getMessage(), (Throwable)e);
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((Object)true, (Object)readRecord.getBoolean("a.b.c"));
        }
        catch (Exception e) {
            _logger.error("Failed to read fieldpath a.b.c for r1:" + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation().increment("x.y.w", 5);
        cond = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, true).notExists("x.y.z.a").close().build();
        try {
            Assert.assertEquals((Object)true, (Object)mcfTable.checkAndMutate("r1", cond, rm));
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to checkAndMutate record, put failed: " + e.getMessage(), (Throwable)e);
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((long)25L, (long)readRecord.getInt("x.y.w"));
        }
        catch (Exception e) {
            _logger.error("Failed to read 'x.y.w': " + e.getMessage());
            throw e;
        }
        Document doc = MapRDB.newDocument().set("a.b.c", 15000);
        cond = MapRDB.newCondition().and().is("a.b.c", QueryCondition.Op.EQUAL, true).is("x.y.a", QueryCondition.Op.EQUAL, true).close().build();
        try {
            Assert.assertEquals((Object)true, (Object)mcfTable.checkAndReplace("r1", cond, doc));
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Failed to checkAndReplace document, put failed: " + e.getMessage());
        }
        try {
            Assert.assertNotNull((Object)mcfTable.findById("r1"));
        }
        catch (Exception e) {
            _logger.error("Failed to read 'a.b': " + e.getMessage());
            throw e;
        }
        if (mcfTable != null) {
            mcfTable.close();
            DBTests.deleteTables(mcfTableName);
        }
    }

    @Test
    @Ignore(value="To be fixed by Jimit")
    public void testJSONAceUpdateAndGetMultiCF2() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf2", "a.b");
        cfMap.put("cf3", "x.z");
        cfMap.put("cf4", "x.z.p");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        Document putRec = MapRDB.newDocument();
        putRec.set("a.b.c", "abc").set("a.b.d", 10000).set("a.e", "ae").setArray("a.f", new Object[]{"default1", "default2", "default3"}).set("x.y", "xy").setArray("x.z.p.r", new Object[]{1000, "arr1", false, "arr3"}).setArray("x.z.p.s", new Object[]{2000, "arr1", true, "arr3"}).setArray("x.z.q", new Object[]{"string1", "string2", "string3"});
        mcfTable.insertOrReplace("r1", putRec);
        System.out.println("Put r1 succeeded");
        mcfTable.flush();
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "default", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "default", "a", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf2", "c", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf3", "q", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf4", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf4", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf4", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf4", "r", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf4", "r", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DocumentMutation rm = null;
        Document readRecord = null;
        rm = MapRDB.newMutation();
        rm.append("a.e", "ae").append("a.f[0]", "default1");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("Failed to update 'a.e' and 'a.f[0]': " + e.getMessage(), (Throwable)e);
        }
        rm = MapRDB.newMutation();
        rm.append("a.b.c", "abc");
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.error("Failed to update a.b.c: " + e.getMessage());
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1", new String[]{"a.b.c"});
            Assert.assertEquals((Object)"abcabc", (Object)readRecord.getString("a.b.c"));
        }
        catch (Exception e) {
            _logger.error("Failed to read a.b.c: " + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation();
        rm.setOrReplace("a.b.c.d", 12345);
        try {
            mcfTable.update("r2", rm);
            mcfTable.flush();
        }
        catch (Exception e) {
            _logger.error("Failed to update a.b.c.d: " + e.getMessage());
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1", new String[]{"a.b.c.d"});
            Assert.assertEquals((long)12345L, (long)readRecord.getInt("a.b.c.d"));
        }
        catch (Exception e) {
            _logger.error("Failed to read a.b.c: " + e.getMessage());
            throw e;
        }
        rm = MapRDB.newMutation();
        rm.increment("a.b.d", 5000);
        try {
            mcfTable.update("r1", rm);
            mcfTable.flush();
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("Failed to increment a.b.d: " + e.getMessage(), (Throwable)e);
        }
        rm = MapRDB.newMutation();
        rm.increment("x.z.p.r[0]", 5000).append("x.z.p.r[1]", "arr1");
        try {
            mcfTable.update("r1", rm);
            Assert.fail();
        }
        catch (Exception e) {
            _logger.info("Updating x.z.p.r failed :" + e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testJSONAceMultiCF() throws Exception {
        Document readRecord;
        DocumentMutation rm;
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath);
            throw e;
        }
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyWriteData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyWriteData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf3", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "c.d", Dbserver.DBAccessType.ColumnWriteData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "c.d", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf2", "w", Dbserver.DBAccessType.ColumnReadData, "u:root");
        try {
            rm = MapRDB.newMutation();
            rm.setOrReplace("a.b.c.d", 10000);
            mcfTable.update("r1", rm);
            mcfTable.flush();
            _logger.info("Update a.b.c.d succeeded");
        }
        catch (Exception e) {
            _logger.error("Put a.b.c.d failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((long)10000L, (long)readRecord.getInt("a.b.c.d"));
        }
        catch (Exception e) {
            _logger.error("Read a.b.c.d failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            mcfTable.increment("r1", "a.b.c.d", 1);
            _logger.info("Increment a.b.c.d succeeded");
        }
        catch (Exception e) {
            _logger.error("Increment a.b.c.d failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((long)10001L, (long)readRecord.getInt("a.b.c.d"));
        }
        catch (Exception e) {
            _logger.error("Read a.b.c.d failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            rm = MapRDB.newMutation();
            rm.setOrReplace("a.b.c.e", 20000);
            mcfTable.update("r1", rm);
            mcfTable.flush();
            _logger.info("Update a.b.c.e succeeded.");
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Update a.b.c.e failed with exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            mcfTable.increment("r1", "a.b.c.e", 1);
            _logger.info("Increment a.b.c.e succeeded.");
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Increment a.b.c.e failed with exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            readRecord = mcfTable.findById("r1");
            Assert.assertEquals((long)10001L, (long)readRecord.getInt("a.b.c.e"));
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Read a.b.c.e failed with exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            rm = MapRDB.newMutation();
            rm.setOrReplace("x.y.z", true);
            mcfTable.update("r1", rm);
            mcfTable.flush();
            _logger.info("Update x.y.z succeded");
        }
        catch (Exception e) {
            _logger.error("Update x.y.z failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            readRecord = mcfTable.findById("r1");
            readRecord.getBoolean("x.y.z");
            Assert.fail();
        }
        catch (Exception e) {
            _logger.debug("Read x.y.z failed with exception: " + e.getMessage(), (Throwable)e);
        }
        try {
            rm = MapRDB.newMutation();
            rm.setOrReplace("x.y.w", "MapR");
            mcfTable.update("r1", rm);
            mcfTable.flush();
            _logger.info("Update x.y.w succeeded");
        }
        catch (Exception e) {
            _logger.error("Update x.y.w failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            Document readRec = mcfTable.findById("r1");
            Assert.assertEquals((Object)"MapR", (Object)readRec.getString("x.y.w"));
        }
        catch (Exception e) {
            _logger.error("Read x.y.w failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Test
    public void testJSONAceWithProjection() throws Exception {
        tablePath = DBTests.getTablePath(TABLE_NAME);
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("person", "person");
        cfMap.put("name", "person.name");
        cfMap.put("address", "person.address");
        cfMap.put("phone", "person.phone");
        cfMap.put("ssn", "person.ssn");
        try {
            table = DBTests.createOrReplaceTable(TABLE_NAME, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + tablePath);
            throw e;
        }
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setCFAce(tablePath, "default", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "default", "id", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setFieldAce(tablePath, "name", "first", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "address", "home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "phone", "cell", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "phone", "home", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "ssn", "area", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setFieldAce(tablePath, "ssn", "serial", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set("person.name.first", "jimit").set("person.name.last", "shah").set("person.address.home.street", "525 E Maude Ave").set("person.address.home.city", "Sunnyvale").set("person.address.office.street", "San Jose").set("person.address.office.zip", 95134).set("person.phone.office", "123-456-7890").set("person.phone.home", "234-567-8901").set("person.phone.cell", "345-678-9012").set("person.ssn.area", 123).set("person.ssn.group", 45).set("person.ssn.serial", 6789).set("person.gender", "male").set("id", 123456);
        table.insertOrReplace("r1", (Document)putRec);
        table.insertOrReplace("r2", (Document)putRec);
        table.flush();
        System.out.println("Put block succeeded.");
        Document readRecord2 = null;
        DocumentStream ds = null;
        Iterator itrs = null;
        _logger.info("CASE 0: DEFAULT CF");
        readRecord2 = table.findById("r1", new String[]{"id"});
        Assert.assertNotNull((Object)readRecord2);
        ds = table.find(new String[]{"id"});
        itrs = ds.iterator();
        assert (itrs.hasNext());
        readRecord2 = (Document)itrs.next();
        Assert.assertEquals((long)123456L, (long)readRecord2.getInt("id"));
        _logger.info("CASE 1: NO VALID FAMILY");
        readRecord2 = table.findById("r1", new String[]{"person.name.first"});
        Assert.assertNull((Object)readRecord2);
        ds = table.find(new String[]{"person.name.first"});
        itrs = ds.iterator();
        Assert.assertFalse((boolean)itrs.hasNext());
        ds.close();
        _logger.info("SUCCESS\n");
        _logger.info("CASE 2: 1 VALID FAMILY");
        readRecord2 = table.findById("r1", new String[]{"person.name", "person.address.home"});
        Assert.assertNull((Object)readRecord2.getString("person.name.first"));
        Assert.assertNull((Object)readRecord2.getValue("person.address.home"));
        Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
        ds = table.find(new String[]{"person.name"});
        for (Document readRecord2 : ds) {
            Assert.assertNull((Object)readRecord2.getString("person.name.first"));
            Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
        }
        ds.close();
        _logger.info("SUCCESS\n");
        _logger.info("CASE 3: ALTERNATE VALID FAMILIES");
        readRecord2 = table.findById("r2", new String[]{"person.name", "person.address"});
        Assert.assertNull((Object)readRecord2.getString("person.name.first"));
        Assert.assertNull((Object)readRecord2.getValue("person.address.home"));
        Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
        Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
        Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
        ds = table.find(new String[]{"person.name", "person.address"});
        itrs = ds.iterator();
        boolean hasNext = itrs.hasNext();
        Assert.assertEquals((Object)true, (Object)hasNext);
        while (hasNext) {
            readRecord2 = (Document)itrs.next();
            Assert.assertNull((Object)readRecord2.getString("person.name.first"));
            Assert.assertNull((Object)readRecord2.getValue("person.address.home"));
            Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
            Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
            Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
            hasNext = itrs.hasNext();
        }
        _logger.info("SUCCESS\n");
        _logger.info("CASE 4: ALLOCATED(> 4) TO INLINE(4)");
        readRecord2 = table.findById("r1", new String[]{"person.address.home", "person.address.office", "person.name.first", "person.name.last", "person.phone.home", "person.ssn.area", "person.gender"});
        Assert.assertNull((Object)readRecord2.getString("person.name.first"));
        Assert.assertNull((Object)readRecord2.getValue("person.address.home"));
        Assert.assertNull((Object)readRecord2.getString("person.phone.home"));
        Assert.assertNull((Object)readRecord2.getString("person.ssn.area"));
        Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
        Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
        Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
        Assert.assertEquals((Object)"male", (Object)readRecord2.getString("person.gender"));
        ds = table.find(new String[]{"person.address.home", "person.address.office", "person.name.first", "person.name.last", "person.phone.home", "person.ssn.area", "person.gender"});
        itrs = ds.iterator();
        hasNext = itrs.hasNext();
        Assert.assertEquals((Object)true, (Object)hasNext);
        while (hasNext) {
            readRecord2 = (Document)itrs.next();
            Assert.assertNull((Object)readRecord2.getString("person.name.first"));
            Assert.assertNull((Object)readRecord2.getValue("person.address.home"));
            Assert.assertNull((Object)readRecord2.getString("person.phone.home"));
            Assert.assertNull((Object)readRecord2.getString("person.ssn.area"));
            Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
            Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
            Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
            Assert.assertEquals((Object)"male", (Object)readRecord2.getString("person.gender"));
            hasNext = itrs.hasNext();
        }
        _logger.info("SUCCESS\n");
        _logger.info("CASE 5: ALLOCATED TO ALLOCATED");
        readRecord2 = table.findById("r1", new String[]{"person.name.last", "person.address.office.street", "person.address.office.zip", "person.phone", "person.ssn.group", "person.gender"});
        Assert.assertNull((Object)readRecord2.getString("person.phone.home"));
        Assert.assertNull((Object)readRecord2.getString("person.phone.cell"));
        Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
        Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
        Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
        Assert.assertEquals((Object)"123-456-7890", (Object)readRecord2.getString("person.phone.office"));
        Assert.assertEquals((long)45L, (long)readRecord2.getInt("person.ssn.group"));
        Assert.assertEquals((Object)"male", (Object)readRecord2.getString("person.gender"));
        ds = table.find(new String[]{"person.name.last", "person.address.office.street", "person.address.office.zip", "person.phone", "person.ssn.group", "person.gender"});
        itrs = ds.iterator();
        hasNext = itrs.hasNext();
        Assert.assertEquals((Object)true, (Object)hasNext);
        while (hasNext) {
            readRecord2 = (Document)itrs.next();
            Assert.assertNull((Object)readRecord2.getString("person.phone.home"));
            Assert.assertNull((Object)readRecord2.getString("person.phone.cell"));
            Assert.assertEquals((Object)"shah", (Object)readRecord2.getString("person.name.last"));
            Assert.assertEquals((Object)"San Jose", (Object)readRecord2.getString("person.address.office.street"));
            Assert.assertEquals((long)95134L, (long)readRecord2.getInt("person.address.office.zip"));
            Assert.assertEquals((Object)"123-456-7890", (Object)readRecord2.getString("person.phone.office"));
            Assert.assertEquals((long)45L, (long)readRecord2.getInt("person.ssn.group"));
            Assert.assertEquals((Object)"male", (Object)readRecord2.getString("person.gender"));
            hasNext = itrs.hasNext();
        }
        _logger.info("SUCCESS\n");
    }

    @Test
    public void testJSONAceWithProjection2() throws Exception {
        int cfNum;
        tablePath = DBTests.getTablePath(TABLE_NAME);
        HashMap<String, String> cfMap = new HashMap<String, String>();
        int NUM_CFS = 63;
        for (cfNum = 1; cfNum < NUM_CFS; ++cfNum) {
            String cf = "cf" + Integer.toString(cfNum);
            cfMap.put(cf, cf);
        }
        boolean[] CFReadPerm = new boolean[NUM_CFS];
        _logger.info("Table Column Families: cf1-cf" + cfNum);
        try {
            table = DBTests.createOrReplaceTable(TABLE_NAME, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + tablePath);
            throw e;
        }
        cfNum = 1;
        while (cfNum < NUM_CFS - 3) {
            String cf = "cf" + Integer.toString(cfNum);
            DBTests.setFieldAce(tablePath, cf, "c1", Dbserver.DBAccessType.ColumnReadData, "!u:root");
            CFReadPerm[cfNum++] = false;
            CFReadPerm[cfNum++] = true;
            CFReadPerm[cfNum++] = true;
        }
        DBDocumentImpl putRec = new DBDocumentImpl();
        for (cfNum = 1; cfNum < NUM_CFS; ++cfNum) {
            String cf = "cf" + Integer.toString(cfNum);
            putRec.set(cf + ".c1", "value" + Integer.toString(cfNum));
        }
        _logger.info("Set " + cfNum + " fields.");
        table.insertOrReplace("r1", (Document)putRec);
        table.insertOrReplace("r2", (Document)putRec);
        table.flush();
        _logger.info("Put block succeeded");
        ArrayList<String> projList = new ArrayList<String>();
        for (cfNum = 1; cfNum < 10; ++cfNum) {
            projList.add("cf" + Integer.toString(cfNum) + ".c1");
            _logger.info("Added cf" + Integer.toString(cfNum) + ".c1");
        }
        Document readRecord = null;
        DocumentStream ds = null;
        Iterator itrs = null;
        readRecord = table.findById("r1", projList.toArray(new String[projList.size()]));
        _logger.info("Read record");
        Assert.assertNotNull((Object)readRecord);
        for (cfNum = 1; cfNum < 10; ++cfNum) {
            String cf = "cf" + Integer.toString(cfNum);
            if (CFReadPerm[cfNum]) {
                Assert.assertEquals((Object)("value" + Integer.toString(cfNum)), (Object)readRecord.getString(cf + ".c1"));
                continue;
            }
            Assert.assertNull((Object)readRecord.getString(cf + ".c1"));
        }
        ds = table.find(projList.toArray(new String[projList.size()]));
        _logger.info("Scan records");
        itrs = ds.iterator();
        boolean hasNext = itrs.hasNext();
        Assert.assertEquals((Object)true, (Object)hasNext);
        while (hasNext) {
            readRecord = (Document)itrs.next();
            for (cfNum = 1; cfNum < 10; ++cfNum) {
                String cf = "cf" + Integer.toString(cfNum);
                if (CFReadPerm[cfNum]) {
                    Assert.assertEquals((Object)("value" + Integer.toString(cfNum)), (Object)readRecord.getString(cf + ".c1"));
                    continue;
                }
                Assert.assertNull((Object)readRecord.getString(cf + ".c1"));
            }
            hasNext = itrs.hasNext();
        }
    }

    @Test
    public void testJSONAceGetEmptyPathProjection() throws Exception {
        String mcfTableName = "test_json_multicf";
        Path mcfTablePath = DBTests.getTablePath(mcfTableName);
        Table mcfTable = null;
        HashMap<String, String> cfMap = new HashMap<String, String>();
        cfMap.put("cf1", "a.b");
        cfMap.put("cf2", "x.y");
        cfMap.put("cf3", "x.y.z");
        try {
            mcfTable = DBTests.createOrReplaceTable(mcfTableName, cfMap);
        }
        catch (Exception e) {
            _logger.error("Failed to create table " + mcfTablePath, (Throwable)e);
            throw e;
        }
        DBTests.setFieldAce(mcfTablePath, "default", "\"\"", Dbserver.DBAccessType.ColumnReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf1", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf1", "\"\"", Dbserver.DBAccessType.ColumnReadData, "u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyReadData, "!u:root");
        DBTests.setCFAce(mcfTablePath, "cf2", Dbserver.DBAccessType.FamilyTraverseData, "u:root");
        DBTests.setFieldAce(mcfTablePath, "cf2", "a.\"\"", Dbserver.DBAccessType.ColumnReadData, "u:root");
        Document doc = MapRDB.newDocument();
        doc.set("\"\"", "emptystring").set("a.b.\"\"", "cf1emptystring").set("x.y.a.\"\"", "cf2emptystring");
        try {
            mcfTable.insertOrReplace("key1", doc);
        }
        catch (Exception e) {
            _logger.error("Insert failed with exception: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            Document doc1 = mcfTable.findById("key1", new String[]{"a.b.c.\"\""});
            Assert.assertNull((Object)doc1.getString("\"\""));
            Assert.assertEquals((Object)"cf1emptystring", (Object)doc1.getString("\"\""));
            Assert.assertEquals((Object)"cf2emptystring", (Object)doc1.getString("a.\"\""));
        }
        catch (Exception e) {
            _logger.info("FindById failed with exception: " + e.getMessage());
        }
    }

    void putSingleKV(String row, String col, String value) throws AccessDeniedException, IOException {
        _logger.info("PutSingelKV: col : " + col + " val: " + value);
        DBDocumentImpl putRec = new DBDocumentImpl();
        putRec.set(col, value);
        table.insertOrReplace(row, (Document)putRec);
        table.flush();
    }

    public static void executeRawCmd(String cmd) throws IOException {
        String line;
        _logger.info("CLI: " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = stdInput.readLine()) != null) {
            _logger.info(line);
        }
        BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        while ((line = stdErr.readLine()) != null) {
            _logger.info(line);
        }
    }

    static {
        tablePath = DBTests.getTablePath(TABLE_NAME);
    }
}

