/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.google.common.collect.BiMap;
import com.mapr.db.DBDocument;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;

public class SequenceFileRowColCodec {
    public static int SEQUENCEFILE_CODEC_VERSION = 1;

    public static ByteBuffer encode(Document document) {
        if (document instanceof DBDocumentImpl) {
            return SequenceFileRowColCodec.getMCFEncoded((DBDocumentImpl)document);
        }
        return RowcolCodec.encode(document);
    }

    private static ByteBuffer getMCFEncoded(DBDocumentImpl document) {
        if (!document.getNeedDOMStruct()) {
            ByteBuffer buf = RowcolCodec.encode(document);
            HashMap<FieldPath, Integer> pathMap = new HashMap<FieldPath, Integer>();
            HashMap<Integer, ByteBuffer> buffersToCache = new HashMap<Integer, ByteBuffer>();
            HashMap<Integer, String> cfIdMap = new HashMap<Integer, String>();
            pathMap.put(FieldPath.parseFrom((String)""), 1);
            buffersToCache.put(1, buf);
            cfIdMap.put(1, "default");
            document.setSerializedJson(buffersToCache, pathMap, cfIdMap, document.getId(), false, false, false);
        }
        Map<FieldPath, Integer> jsonPathMap = document.getJsonPathMap();
        Map<Integer, ByteBuffer> cachedBuffer = document.getCachedBuffers();
        Dbserver.MCFRowColOutputFormat.Builder header = Dbserver.MCFRowColOutputFormat.newBuilder();
        header.setVersion(SEQUENCEFILE_CODEC_VERSION);
        ByteBuffer encodedId = IdCodec.encode(document.getId());
        int rowKeyLength = encodedId.remaining();
        header.setRowkeysize(rowKeyLength);
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            Dbserver.MCFRowColOutputFormat.CFmetadata.Builder cfMeta = Dbserver.MCFRowColOutputFormat.CFmetadata.newBuilder();
            cfMeta.setJsonPath(kv.getKey().asPathString());
            cfMeta.setCfId(kv.getValue().intValue());
            ByteBuffer bBuf = cachedBuffer.get(kv.getValue());
            if (bBuf == null) {
                cfMeta.setBufferLength(0);
            } else {
                cfMeta.setBufferLength(bBuf.remaining());
            }
            cfMeta.build();
            header.addCfDescriptor(cfMeta);
        }
        Dbserver.MCFRowColOutputFormat mcfHeader = header.build();
        int mcfEncodingSize = 0;
        for (Map.Entry<Integer, ByteBuffer> kv : cachedBuffer.entrySet()) {
            mcfEncodingSize += kv.getValue().remaining();
        }
        byte[] mcfHeaderArray = mcfHeader.toByteArray();
        mcfEncodingSize += 4 + mcfHeaderArray.length;
        ByteBuffer encodedBuffer = ByteBuffer.allocate(mcfEncodingSize += rowKeyLength);
        encodedBuffer.order(ByteOrder.LITTLE_ENDIAN);
        encodedBuffer.putInt(mcfHeaderArray.length);
        encodedBuffer.put(mcfHeaderArray);
        encodedBuffer.put(encodedId);
        for (Map.Entry<FieldPath, Integer> kv : jsonPathMap.entrySet()) {
            ByteBuffer buff = cachedBuffer.get(kv.getValue());
            if (buff == null) continue;
            ByteBuffer newBuffer = buff.duplicate();
            newBuffer.position(buff.position());
            newBuffer.limit(buff.limit());
            encodedBuffer.put(newBuffer);
        }
        encodedBuffer.rewind();
        return encodedBuffer;
    }

    public static DBDocument decode(ByteBuffer buffer) throws IOException {
        return SequenceFileRowColCodec.decode(buffer, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBDocument decode(ByteBuffer buffer, BiMap<FieldPath, Integer> destMap) throws IOException {
        DBDocumentImpl document = new DBDocumentImpl();
        HashMap<Integer, ByteBuffer> cachedBuffer = new HashMap<Integer, ByteBuffer>();
        HashMap<FieldPath, Integer> jsonPathMap = new HashMap<FieldPath, Integer>();
        HashMap<Integer, String> cfIdToName = new HashMap<Integer, String>();
        int headerSize = buffer.getInt();
        byte[] header = new byte[headerSize];
        buffer.get(header);
        Dbserver.MCFRowColOutputFormat mcfMetadata = Dbserver.MCFRowColOutputFormat.parseFrom((byte[])header);
        int numCFs = mcfMetadata.getCfDescriptorCount();
        int bufferPosition = buffer.position();
        int rowkeyLength = mcfMetadata.getRowkeysize();
        ByteBuffer rowkey = buffer.duplicate();
        rowkey.position(bufferPosition);
        rowkey.limit(bufferPosition += rowkeyLength);
        for (int i = 0; i < numCFs; ++i) {
            Integer cfId;
            Dbserver.MCFRowColOutputFormat.CFmetadata metaData = mcfMetadata.getCfDescriptor(i);
            String jsonPath = metaData.getJsonPath();
            FieldPath fPath = FieldPath.parseFrom((String)jsonPath);
            if (destMap != null) {
                if (!destMap.containsKey((Object)fPath)) throw new IOException("CF Mapping not found for path " + fPath.toString() + " in destination table");
                cfId = (Integer)destMap.get((Object)fPath);
            } else {
                cfId = metaData.getCfId();
            }
            int bufferLength = metaData.getBufferLength();
            String cfName = jsonPath.length() == 0 ? "default" : "CF" + i;
            jsonPathMap.put(fPath, cfId);
            cfIdToName.put(cfId, cfName);
            ByteBuffer thisCFData = buffer.duplicate();
            thisCFData.order(ByteOrder.LITTLE_ENDIAN);
            thisCFData.position(bufferPosition);
            thisCFData.limit(bufferPosition += bufferLength);
            cachedBuffer.put(cfId, thisCFData);
        }
        document.setSerializedJson(cachedBuffer, jsonPathMap, cfIdToName, IdCodec.decode(rowkey), false, false, false);
        return document;
    }
}

