/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.DBDocument;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.ojai.DBDocumentReaderIterable;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.fs.MapRResultScanner;
import com.mapr.fs.jni.MapRResult;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.exceptions.StreamInUseException;

public class DBDocumentStream
implements DocumentStream<DBDocument> {
    MapRResultScanner scanner_;
    boolean excludeId_;
    MapRDBTableImpl table_;
    private volatile boolean iteratorOpened;
    Set<FieldPath> conditionPaths_;

    public DBDocumentStream(MapRResultScanner scanner, boolean excludeId, MapRDBTableImpl table, Set<FieldPath> condPaths) {
        this.scanner_ = scanner;
        this.excludeId_ = excludeId;
        this.table_ = table;
        this.iteratorOpened = false;
        this.conditionPaths_ = condPaths;
    }

    public void streamTo(DocumentListener l) {
        try {
            Iterator<DBDocument> i$ = this.iterator();
            while (i$.hasNext()) {
                DBDocument record = i$.next();
                l.documentArrived((Document)record);
            }
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            l.failed(e);
        }
    }

    public void close() throws Exception {
        this.scanner_.close();
    }

    private DBDocument next() throws IOException {
        MapRResult res = null;
        try {
            res = this.scanner_.nextRow();
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "findAll.next()");
        }
        ByteBuffer keyBuf = res.getKey();
        if (keyBuf == null) {
            return null;
        }
        Map cfbufs = res.getJsonByteBufs();
        if (cfbufs == null) {
            return null;
        }
        DBDocumentImpl record = RowcolCodec.decode(cfbufs, this.table_.sortedByPath(), this.table_.idToCFNameMap(), keyBuf, this.excludeId_, true, this.table_.isKeepInsertionOrder(), this.table_.decodeTimestamp());
        if (this.conditionPaths_ != null) {
            for (FieldPath fp : this.conditionPaths_) {
                record.delete(fp);
            }
        }
        return record;
    }

    public Iterator<DBDocument> iterator() {
        return new Iterator<DBDocument>(){
            DBDocument next = null;
            boolean done = false;

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                if (this.next == null) {
                    try {
                        this.next = DBDocumentStream.this.next();
                        if (this.next == null) {
                            this.done = true;
                        }
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw ExceptionHandler.handle(e, "findNext()");
                    }
                }
                return true;
            }

            @Override
            public DBDocument next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called after hasNext() returned false.");
                }
                DBDocument temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterable<DocumentReader> documentReaders() {
        this.checkStateForIteration();
        this.iteratorOpened = true;
        return new DBDocumentReaderIterable(this);
    }

    private void checkStateForIteration() {
        if (this.iteratorOpened) {
            throw new StreamInUseException("An iterator has already been opened on this record stream.");
        }
    }
}

