/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.ControlInfo;
import com.mapr.db.DBDocument;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.ControlInfoImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.exceptions.TypeException;
import org.ojai.types.Interval;
import org.ojai.util.Types;

@API.Internal
public class DBDOMDocumentReader
implements DBDocumentReaderBase {
    private Stack<IteratorWithType> stateStack = new Stack();
    private DocumentReader.EventType event = null;
    private DocumentReader.EventType nextEvent = null;
    private DocumentReader.EventType currentEvent = null;
    private KeyValue jsonValue;
    private Value rootKeyValue = null;

    public DBDOMDocumentReader(Value value) {
        Value.Type t = value.getType();
        if (t == Value.Type.MAP) {
            Iterator iter = ((DBDocument)value).iterator();
            this.stateStack.push(new IteratorWithType(iter, t));
            this.event = DocumentReader.EventType.START_MAP;
        } else if (t == Value.Type.ARRAY) {
            Iterator<Object> iter = ((DBList)value).iterator();
            this.stateStack.push(new IteratorWithType(iter, t));
            this.event = DocumentReader.EventType.START_ARRAY;
        } else {
            this.jsonValue = (KeyValue)value;
            this.event = Types.getEventTypeForType((Value.Type)value.getType());
        }
        this.rootKeyValue = value;
    }

    public ByteBuffer getBinary() {
        this.checkEventType(DocumentReader.EventType.BINARY);
        return this.jsonValue.getBinary();
    }

    public byte getByte() {
        this.checkEventType(DocumentReader.EventType.BYTE);
        return this.jsonValue.getByte();
    }

    public short getShort() {
        this.checkEventType(DocumentReader.EventType.SHORT);
        return this.jsonValue.getShort();
    }

    public int getInt() {
        this.checkEventType(DocumentReader.EventType.INT);
        return this.jsonValue.getInt();
    }

    public long getLong() {
        this.checkEventType(DocumentReader.EventType.LONG);
        return this.jsonValue.getLong();
    }

    public float getFloat() {
        this.checkEventType(DocumentReader.EventType.FLOAT);
        return this.jsonValue.getFloat();
    }

    public double getDouble() {
        this.checkEventType(DocumentReader.EventType.DOUBLE);
        return this.jsonValue.getDouble();
    }

    public BigDecimal getDecimal() {
        this.checkEventType(DocumentReader.EventType.DECIMAL);
        return this.jsonValue.getDecimal();
    }

    public int getDecimalPrecision() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.precision();
        }
        return 0;
    }

    public int getDecimalScale() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.scale();
        }
        return 0;
    }

    public int getDecimalValueAsInt() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.intValueExact();
        }
        return 0;
    }

    public long getDecimalValueAsLong() {
        BigDecimal d = this.getDecimal();
        if (d != null) {
            return d.longValueExact();
        }
        return 0L;
    }

    public ByteBuffer getDecimalValueAsBytes() {
        BigDecimal decimal = this.getDecimal();
        if (decimal != null) {
            BigInteger decimalInteger = decimal.unscaledValue();
            byte[] bytearray = decimalInteger.toByteArray();
            return ByteBuffer.wrap(bytearray);
        }
        return null;
    }

    public boolean getBoolean() {
        this.checkEventType(DocumentReader.EventType.BOOLEAN);
        return this.jsonValue.getBoolean();
    }

    public String getString() {
        this.checkEventType(DocumentReader.EventType.STRING);
        return this.jsonValue.getString();
    }

    public long getTimestampLong() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.jsonValue.getTimestampAsLong();
    }

    public Date getDate() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.jsonValue.getDate();
    }

    public int getDateInt() {
        this.checkEventType(DocumentReader.EventType.DATE);
        return this.jsonValue.getDateAsInt();
    }

    private void checkEventType(DocumentReader.EventType event) throws TypeException {
        if (this.currentEvent != event) {
            throw new TypeException("Event type mismatch.");
        }
    }

    public String getFieldName() {
        this.checkEventType(DocumentReader.EventType.FIELD_NAME);
        return this.jsonValue.getKey();
    }

    public Interval getInterval() {
        this.checkEventType(DocumentReader.EventType.INTERVAL);
        return this.jsonValue.getInterval();
    }

    public int getIntervalDays() {
        return this.getInterval().getDays();
    }

    public long getIntervalMillis() {
        return this.getInterval().getTimeInMillis();
    }

    public Time getTime() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.jsonValue.getTime();
    }

    public int getTimeInt() {
        this.checkEventType(DocumentReader.EventType.TIME);
        return this.jsonValue.getTimeAsInt();
    }

    public Timestamp getTimestamp() {
        this.checkEventType(DocumentReader.EventType.TIMESTAMP);
        return this.jsonValue.getTimestamp();
    }

    public DocumentReader.EventType next() {
        this.currentEvent = null;
        if (this.event != null) {
            this.currentEvent = this.event;
            this.event = null;
        } else if (this.nextEvent != null) {
            this.currentEvent = this.nextEvent;
            this.nextEvent = null;
        } else {
            this.ProcessNextNode();
            this.currentEvent = this.event;
            this.event = null;
        }
        return this.currentEvent;
    }

    private void ProcessNextNode() {
        if (this.stateStack.empty()) {
            this.event = null;
            return;
        }
        IteratorWithType iterElem = this.stateStack.peek();
        Iterator<KeyValue> iter = iterElem.iter;
        if (iter.hasNext()) {
            KeyValue o = iter.next();
            if (o instanceof Map.Entry) {
                Map.Entry kvpair = (Map.Entry)((Object)o);
                this.jsonValue = (KeyValue)kvpair.getValue();
                this.jsonValue.setKey((String)kvpair.getKey());
                Value.Type kvpairType = this.jsonValue.getType();
                if (kvpairType == Value.Type.MAP) {
                    this.event = DocumentReader.EventType.FIELD_NAME;
                    this.nextEvent = DocumentReader.EventType.START_MAP;
                    this.stateStack.push(new IteratorWithType(((DBDocument)((Object)this.jsonValue)).iterator(), kvpairType));
                } else if (kvpairType == Value.Type.ARRAY) {
                    this.event = DocumentReader.EventType.FIELD_NAME;
                    this.nextEvent = DocumentReader.EventType.START_ARRAY;
                    this.stateStack.push(new IteratorWithType(((DBList)this.jsonValue).iterator(), kvpairType));
                } else {
                    this.event = DocumentReader.EventType.FIELD_NAME;
                    this.nextEvent = Types.getEventTypeForType((Value.Type)this.jsonValue.getType());
                }
            } else {
                this.jsonValue = KeyValueBuilder.initFromObject(o);
                Value.Type t = this.jsonValue.getType();
                if (t == Value.Type.ARRAY) {
                    this.event = DocumentReader.EventType.START_ARRAY;
                    this.stateStack.push(new IteratorWithType(((DBList)this.jsonValue).iterator(), t));
                } else if (t == Value.Type.MAP) {
                    this.event = DocumentReader.EventType.START_MAP;
                    this.stateStack.push(new IteratorWithType(((DBDocument)((Object)this.jsonValue)).iterator(), t));
                } else {
                    this.event = Types.getEventTypeForType((Value.Type)t);
                }
            }
        } else {
            iterElem = this.stateStack.pop();
            this.event = iterElem.iterType == Value.Type.MAP ? DocumentReader.EventType.END_MAP : DocumentReader.EventType.END_ARRAY;
            return;
        }
    }

    @Override
    public ControlInfo getControlInfo() {
        if (this.currentEvent == DocumentReader.EventType.END_MAP || this.currentEvent == DocumentReader.EventType.END_ARRAY) {
            throw new UnsupportedOperationException("Can not return timeDescriptor for eventType END_MAP or END_ARRAY");
        }
        byte timeDesc = this.jsonValue != null ? this.jsonValue.getTimeDescriptor() : ((KeyValue)this.rootKeyValue).getTimeDescriptor();
        return new ControlInfoImpl(timeDesc);
    }

    class IteratorWithType {
        Iterator<KeyValue> iter;
        Value.Type iterType;

        IteratorWithType(Iterator<?> i, Value.Type t) {
            this.iter = i;
            this.iterType = t;
        }
    }
}

