/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Marlincommon;
import com.mapr.fs.tables.TableProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;

public class TableDescriptorImpl
implements TableDescriptor {
    private Path path_;
    private final Dbserver.TableAttr.Builder tableAttr_;
    private final Dbserver.TableAces.Builder tableAces_;
    private List<FamilyDescriptor> families_;

    public TableDescriptorImpl() {
        this(null, null, new TableProperties(Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false), true);
    }

    public TableDescriptorImpl(boolean insertionOrder) {
        this(null, null, new TableProperties(Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false), insertionOrder);
    }

    public TableDescriptorImpl(Path tablePath) {
        this(tablePath, null, new TableProperties(Dbserver.TableAttr.getDefaultInstance(), Dbserver.TableAces.getDefaultInstance(), null, false), true);
    }

    TableDescriptorImpl(TableDescriptorImpl other) {
        this.path_ = other.path_;
        this.tableAttr_ = other.tableAttr_.clone();
        this.tableAces_ = other.tableAces_.clone();
        this.families_ = other.getFamilies();
    }

    TableDescriptorImpl(Path tablePath, List<Dbserver.ColumnFamilyAttr> cfList, TableProperties tableProps, boolean insertionOrder) {
        this.path_ = tablePath;
        this.tableAttr_ = tableProps.getAttr().toBuilder();
        this.tableAces_ = tableProps.getAces().toBuilder();
        this.families_ = Lists.newArrayList();
        if (cfList != null) {
            for (Dbserver.ColumnFamilyAttr cfAttr : cfList) {
                this.families_.add(new FamilyDescriptorImpl(cfAttr));
            }
        }
        this.tableAttr_.setJson(true);
        this.setInsertionOrder(insertionOrder);
    }

    @Override
    public Path getPath() {
        return this.path_;
    }

    @Override
    public TableDescriptorImpl setPath(String tablePath) {
        return this.setPath(new Path(tablePath));
    }

    @Override
    public TableDescriptorImpl setPath(Path tablePath) {
        this.path_ = tablePath;
        return this;
    }

    @Override
    public boolean isInsertionOrder() {
        return this.tableAttr_.hasInsertionOrder() && this.tableAttr_.getInsertionOrder();
    }

    @Override
    public TableDescriptorImpl setInsertionOrder(boolean insertionOrder) {
        this.tableAttr_.setInsertionOrder(insertionOrder);
        return this;
    }

    @Override
    public boolean isBulkLoad() {
        return this.tableAttr_.hasBulkLoad() && this.tableAttr_.getBulkLoad();
    }

    @Override
    public TableDescriptorImpl setBulkLoad(boolean bulkLoad) {
        this.tableAttr_.setBulkLoad(bulkLoad);
        return this;
    }

    @Override
    public boolean isAutoSplit() {
        return this.tableAttr_.hasAutoSplit() && this.tableAttr_.getAutoSplit();
    }

    @Override
    public TableDescriptorImpl setAutoSplit(boolean autoSplit) {
        this.tableAttr_.setAutoSplit(autoSplit);
        return this;
    }

    @Override
    public long getSplitSize() {
        return this.tableAttr_.getRegionSizeMB();
    }

    @Override
    public TableDescriptorImpl setSplitSize(long splitSizeMB) {
        this.tableAttr_.setRegionSizeMB(splitSizeMB);
        return this;
    }

    @Override
    public FamilyDescriptor getFamily(String familyName) {
        for (FamilyDescriptor family : this.families_) {
            if (!family.getName().equals(familyName)) continue;
            return family.clone();
        }
        return null;
    }

    @Override
    public List<FamilyDescriptor> getFamilies() {
        ArrayList families = Lists.newArrayList();
        for (FamilyDescriptor family : this.families_) {
            families.add(family.clone());
        }
        return families;
    }

    @Override
    public TableDescriptorImpl setFamilies(List<FamilyDescriptor> families) {
        Preconditions.checkNotNull(families, (Object)"families can not be null");
        this.families_ = Lists.newArrayList(families);
        return this;
    }

    @Override
    public TableDescriptorImpl addFamily(FamilyDescriptor family) {
        if (this.families_ == null) {
            this.families_ = Lists.newArrayList();
        }
        for (FamilyDescriptor familyDescriptor : this.families_) {
            if (!family.getName().equals(familyDescriptor.getName()) && !family.getJsonFieldPath().equals((Object)familyDescriptor.getJsonFieldPath())) continue;
            throw new IllegalArgumentException("A family with same name or json path already exist.\n" + familyDescriptor);
        }
        this.families_.add(family);
        return this;
    }

    public long getDeleteTTL() {
        return this.tableAttr_.getDeleteTTL();
    }

    public TableDescriptor setDeleteTTL(long ttlSec) {
        this.tableAttr_.setDeleteTTL(ttlSec);
        return this;
    }

    public int getMaxValueSizeInMemIndex() {
        return this.tableAttr_.getMaxValueSzInMemIndex();
    }

    public TableDescriptorImpl setMaxValueSizeInMemIndex(int valueSz) {
        this.tableAttr_.setMaxValueSzInMemIndex(valueSz);
        return this;
    }

    public boolean isStream() {
        return this.tableAttr_.hasIsMarlinTable() && this.tableAttr_.getIsMarlinTable();
    }

    public TableDescriptorImpl setStream() {
        this.tableAttr_.setIsMarlinTable(true);
        return this;
    }

    public boolean isStreamAutoCreate() {
        if (this.tableAttr_.hasMarlinAttr()) {
            return this.tableAttr_.getMarlinAttr().getAutoCreateTopics();
        }
        return false;
    }

    public TableDescriptorImpl setStreamAutoCreate(boolean autoCreate) {
        Marlincommon.MarlinTableAttr mattr = Marlincommon.MarlinTableAttr.newBuilder((Marlincommon.MarlinTableAttr)this.tableAttr_.getMarlinAttr()).setAutoCreateTopics(autoCreate).build();
        this.tableAttr_.setMarlinAttr(mattr);
        return this;
    }

    public int getStreamDefaultPartitions() {
        if (this.tableAttr_.hasMarlinAttr()) {
            return this.tableAttr_.getMarlinAttr().getDefaultNumFeedsPerTopic();
        }
        return 0;
    }

    public TableDescriptorImpl setStreamDefaultPartitions(int numPartitions) {
        Marlincommon.MarlinTableAttr mattr = Marlincommon.MarlinTableAttr.newBuilder((Marlincommon.MarlinTableAttr)this.tableAttr_.getMarlinAttr()).setDefaultNumFeedsPerTopic(numPartitions).build();
        this.tableAttr_.setMarlinAttr(mattr);
        return this;
    }

    public Dbserver.TableAttr.Builder getTableAttr() {
        return this.tableAttr_.clone();
    }

    public Dbserver.TableAces.Builder getTableAces() {
        return this.tableAces_.clone();
    }

    public String toString() {
        return "{\"Path\": \"" + this.getPath() + "\", \"InsertionOrder\": " + this.isInsertionOrder() + ", \"BulkLoad\": " + this.isBulkLoad() + ", \"AutoSplit\": " + this.isAutoSplit() + ", \"SplitSize\": " + this.getSplitSize() + ", \"Families\": " + this.getFamilies() + "}";
    }

    @Override
    public TableDescriptorImpl clone() {
        return new TableDescriptorImpl(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.families_ == null ? 0 : this.families_.hashCode());
        result = 31 * result + (this.path_ == null ? 0 : this.path_.hashCode());
        result = 31 * result + (this.isAutoSplit() ? 1 : 0);
        result = 31 * result + (this.isBulkLoad() ? 1 : 0);
        result = 31 * result + this.getMaxValueSizeInMemIndex();
        result = 31 * result + (this.isInsertionOrder() ? 1 : 0);
        result = 31 * result + (int)this.getSplitSize();
        result = 31 * result + (int)this.getDeleteTTL();
        result = 31 * result + (this.isStream() ? 1 : 0);
        if (this.isStream()) {
            result = 31 * result + (this.isStreamAutoCreate() ? 1 : 0);
            result = 31 * result + this.getStreamDefaultPartitions();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableDescriptorImpl other = (TableDescriptorImpl)obj;
        if (this.families_ == null ? other.families_ != null : !this.families_.equals(other.families_)) {
            return false;
        }
        if (this.path_ == null ? other.path_ != null : !this.path_.equals((Object)other.path_)) {
            return false;
        }
        if (this.isAutoSplit() != other.isAutoSplit()) {
            return false;
        }
        if (this.isBulkLoad() != other.isBulkLoad()) {
            return false;
        }
        if (this.getMaxValueSizeInMemIndex() != other.getMaxValueSizeInMemIndex()) {
            return false;
        }
        if (this.isInsertionOrder() != other.isInsertionOrder()) {
            return false;
        }
        if (this.getDeleteTTL() != other.getDeleteTTL()) {
            return false;
        }
        if (this.getSplitSize() != other.getSplitSize()) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        if (this.isStream()) {
            if (this.isStreamAutoCreate() != other.isStreamAutoCreate()) {
                return false;
            }
            if (this.getStreamDefaultPartitions() != other.getStreamDefaultPartitions()) {
                return false;
            }
        }
        return true;
    }
}

