/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.EncodedBufFamIdInfo;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import com.mapr.fs.jni.MapRScan;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.ojai.FieldPath;
import org.ojai.annotation.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
public class MapRDBTableImplHelper {
    private static Logger logger = LoggerFactory.getLogger(MapRDBTableImplHelper.class);
    private static Configuration config = new Configuration();

    public static Dbserver.SchemaFamily getDefaultSchemaFamily(String cfName, Integer ttl) {
        Dbserver.SchemaFamily.Builder builder = Dbserver.SchemaFamily.newBuilder().setName(cfName).setInMemory(false).setMinVersions(0).setMaxVersions(1).setTtl((long)ttl.intValue()).setCompression(Common.FileCompressionType.FCT_LZ4);
        return builder.build();
    }

    public static Dbserver.ColumnFamilyAttr getColumnFamilyAttr(String cfName, String cfPath, Integer ttl) {
        if (cfName.equals("default")) {
            return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(MapRDBTableImplHelper.getDefaultSchemaFamily(cfName, ttl)).build();
        }
        return Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(MapRDBTableImplHelper.getDefaultSchemaFamily(cfName, ttl)).setJsonFamilyPath(cfPath).build();
    }

    public static int getDefaultFamilyId(MapRHTable maprTable) throws DBException {
        try {
            return maprTable.getFamilyId("default");
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "getDefaultFamilyId()");
        }
    }

    private static String getPathUnderCF(String path, String cfPath) {
        if (path == null || cfPath == null) {
            return null;
        }
        int ios = path.indexOf(cfPath);
        String rem = null;
        if (ios >= 0) {
            rem = path.substring(ios + cfPath.length(), path.length());
            rem = rem.equals("") ? "v" : (rem.charAt(0) == '.' ? "v" + rem : "v." + rem);
        }
        return rem;
    }

    private static Map<Integer, List<String>> getPerFamPaths(Map<FieldPath, Integer> pathCFidMap, boolean excludeEmbeddedFamilies, String ... paths) {
        TreeMap<Integer, List<String>> pathsPerFam = new TreeMap<Integer, List<String>>();
        int defCFId = 0;
        for (String path : paths) {
            boolean foundCF = false;
            String addedToCFPath = null;
            Integer addedToCFid = 0;
            boolean foundFinal = false;
            for (Map.Entry<FieldPath, Integer> entry : pathCFidMap.entrySet()) {
                List addTo;
                String remPath;
                String cfPath = entry.getKey().asPathString();
                Integer cfId = entry.getValue();
                if (cfPath.equals("") || (remPath = MapRDBTableImplHelper.getPathUnderCF(path, cfPath)) == null) continue;
                if (foundCF) {
                    assert (addedToCFid != 0);
                    assert (addedToCFPath != null);
                    int ios = cfPath.indexOf(addedToCFPath);
                    if (ios == -1) continue;
                    List addedToOld = (List)pathsPerFam.get(addedToCFid);
                    String oldRemPath = MapRDBTableImplHelper.getPathUnderCF(path, addedToCFPath);
                    addedToOld.remove(oldRemPath);
                    if (addedToOld.size() == 0) {
                        pathsPerFam.remove(addedToCFid);
                    }
                }
                if ((addTo = (List)pathsPerFam.get(cfId)) == null) {
                    pathsPerFam.put(cfId, new ArrayList());
                    addTo = (List)pathsPerFam.get(cfId);
                }
                if (remPath.equals("v")) {
                    foundFinal = true;
                } else {
                    addTo.add(remPath);
                    addedToCFPath = cfPath;
                    addedToCFid = cfId;
                }
                foundCF = true;
                if (!excludeEmbeddedFamilies) {
                    for (FieldPath cfPathUpfp : pathCFidMap.keySet()) {
                        Integer cfIdUp;
                        List addToUp;
                        String cfPathUp = cfPathUpfp.asPathString();
                        if (cfPathUp.equals(cfPath) || cfPathUp.equals("")) continue;
                        int ios = cfPathUp.indexOf(path);
                        if (!cfPathUp.startsWith(cfPath) || ios == -1 || (addToUp = (List)pathsPerFam.get(cfIdUp = pathCFidMap.get(cfPathUpfp))) != null) continue;
                        pathsPerFam.put(cfIdUp, new ArrayList());
                    }
                }
                if (!foundFinal) continue;
                break;
            }
            if (foundCF) continue;
            if (!path.equals("")) {
                if (defCFId == 0) {
                    defCFId = pathCFidMap.get(FieldPath.parseFrom((String)""));
                    assert (defCFId != 0);
                    pathsPerFam.put(defCFId, new ArrayList());
                }
                List addTo = (List)pathsPerFam.get(defCFId);
                addTo.add(path);
                continue;
            }
            if (!excludeEmbeddedFamilies) {
                for (FieldPath cfPathUpfp : pathCFidMap.keySet()) {
                    Integer cfIdUp = pathCFidMap.get(cfPathUpfp);
                    pathsPerFam.put(cfIdUp, new ArrayList());
                }
                continue;
            }
            defCFId = pathCFidMap.get(FieldPath.parseFrom((String)""));
            pathsPerFam.put(defCFId, new ArrayList());
        }
        return pathsPerFam;
    }

    public static MapRRowConstraint toRowConstraint(MapRDBTableImpl table, String ... paths) throws DBException {
        MapRRowConstraint rc = new MapRRowConstraint();
        BiMap<FieldPath, Integer> pathCFidMap = table.idPathMap();
        rc.maxVersions = 1;
        rc.minStamp = -9223372036854775807L;
        rc.maxStamp = Long.MAX_VALUE;
        if (table.getDeletes()) {
            rc.getDeletes = true;
        }
        if (paths != null) {
            Map<Integer, List<String>> pathsPerFam = MapRDBTableImplHelper.getPerFamPaths(pathCFidMap, table.excludeEmbeddedFamily(), paths);
            if (logger.isTraceEnabled()) {
                logger.trace(" proj map : '{}'", pathsPerFam);
            }
            rc.numFamilies = pathsPerFam.size();
            rc.numColumns = paths.length;
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
            rc.columns = new byte[rc.numColumns][];
            int famIter = 0;
            int rccount = 0;
            for (Map.Entry<Integer, List<String>> entry : pathsPerFam.entrySet()) {
                Integer cfId = entry.getKey();
                List<String> cfPath = entry.getValue();
                rc.families[famIter] = cfId;
                rc.columnsPerFamily[famIter] = cfPath.size();
                ++famIter;
                for (int j = 0; j < cfPath.size(); ++j) {
                    rc.columns[rccount] = Bytes.toBytes((String)cfPath.get(j));
                    ++rccount;
                }
            }
        } else {
            rc.numFamilies = pathCFidMap.size();
            rc.families = new int[rc.numFamilies];
            rc.columnsPerFamily = new int[rc.numFamilies];
            rc.numColumns = 0;
            int i = 0;
            List<Map.Entry<FieldPath, Integer>> sbid = table.sortedById();
            for (Map.Entry<FieldPath, Integer> entry : sbid) {
                rc.families[i] = entry.getValue();
                rc.columnsPerFamily[i] = 0;
                ++i;
            }
        }
        return rc;
    }

    public static DBDocument doGet(MapRDBTableImpl table, ByteBuffer id, boolean excludeId) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, null, excludeId, (String[])null);
    }

    public static DBDocument doGet(MapRDBTableImpl table, ByteBuffer id, boolean excludeId, String ... paths) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, null, excludeId, paths);
    }

    public static DBDocument doGet(MapRDBTableImpl table, ByteBuffer id, Condition c, boolean excludeId) throws DBException {
        return MapRDBTableImplHelper.doGet(table, id, c, excludeId, (String[])null);
    }

    private static boolean containsSuper(List<String> projPaths, String aCondPath) {
        return projPaths.contains(aCondPath);
    }

    public static CondAndProjPaths setPaths(Condition c, String[] projPaths, CondAndProjPaths ret) {
        Set<FieldPath> condPaths;
        Set<FieldPath> set = condPaths = c != null ? ((ConditionImpl)c).getProjections() : null;
        if (condPaths == null || condPaths.size() == 0) {
            ret.allPaths = projPaths;
            return ret;
        }
        if (projPaths == null || projPaths.length == 0) {
            ret.allPaths = projPaths;
            return ret;
        }
        ArrayList<String> addList = new ArrayList<String>();
        int numAdded = 0;
        List<String> paths = Arrays.asList(projPaths);
        for (FieldPath cfp : condPaths) {
            String cp = cfp.asPathString();
            if (MapRDBTableImplHelper.containsSuper(paths, cp)) {
                condPaths.remove(cfp);
                continue;
            }
            addList.add(cp);
            ++numAdded;
        }
        assert (addList.size() == numAdded);
        String[] addArray = addList.toArray(new String[addList.size()]);
        ret.allPaths = new String[addArray.length + projPaths.length];
        System.arraycopy(addArray, 0, ret.allPaths, 0, numAdded);
        System.arraycopy(projPaths, 0, ret.allPaths, numAdded, projPaths.length);
        ret.condPaths = condPaths;
        return ret;
    }

    public static DBDocument doGet(MapRDBTableImpl table, ByteBuffer id, Condition c, boolean excludeId, String ... paths) throws DBException {
        byte[] serFilt;
        MapRGet mrget = new MapRGet();
        mrget.result = new MapRResult();
        CondAndProjPaths bothpaths = new CondAndProjPaths();
        MapRDBTableImplHelper.setPaths(c, paths, bothpaths);
        mrget.rowConstraint = MapRDBTableImplHelper.toRowConstraint(table, bothpaths.allPaths);
        if (c != null && !c.isEmpty()) {
            ByteBuffer serCond = ((ConditionImpl)c).cloneOptimized().getDescriptor(table.idPathMap()).getSerialized();
            serFilt = new byte[serCond.capacity()];
            serCond.get(serFilt);
        } else {
            serFilt = null;
        }
        mrget.setFilter(serFilt);
        mrget.setEncodedResult(true);
        mrget.key = new byte[id.remaining()];
        int currentPosition = id.position();
        id.get(mrget.key);
        id.position(currentPosition);
        ByteBuffer keyBuf = ByteBuffer.wrap(mrget.key);
        try {
            table.maprTable().getJson(mrget);
            Map cfbufs = mrget.getResult().getJsonByteBufs();
            if (cfbufs == null) {
                DBDocument dBDocument = null;
                return dBDocument;
            }
            DBDocumentImpl record = RowcolCodec.decode(cfbufs, table.sortedByPath(), table.idToCFNameMap(), keyBuf, excludeId, true, table.isKeepInsertionOrder(), table.decodeTimestamp());
            if (paths != null && bothpaths.condPaths != null) {
                for (FieldPath fp : bothpaths.condPaths) {
                    record.delete(fp);
                }
            }
            DBDocumentImpl dBDocumentImpl = record;
            return dBDocumentImpl;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "doGet()");
        }
        finally {
            if (mrget.getArena() != 0L) {
                table.maprTable().freeArena(mrget.getArena());
            }
        }
    }

    public static List<Map.Entry<FieldPath, Integer>> sortByValueToList(Map<FieldPath, Integer> map) {
        LinkedList<Map.Entry<FieldPath, Integer>> list = new LinkedList<Map.Entry<FieldPath, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<FieldPath, Integer>>(){

            @Override
            public int compare(Map.Entry<FieldPath, Integer> o1, Map.Entry<FieldPath, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return list;
    }

    public static BiMap<FieldPath, Integer> sortByPath(Map<FieldPath, Integer> map) {
        TreeMap<FieldPath, Integer> result = new TreeMap<FieldPath, Integer>(map);
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Map.Entry entry : result.entrySet()) {
            mapBuilder.put(entry.getKey(), entry.getValue());
        }
        return mapBuilder.build();
    }

    public static BiMap<FieldPath, Integer> sortByValue(BiMap<FieldPath, Integer> map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<FieldPath, Integer>>(){

            @Override
            public int compare(Map.Entry<FieldPath, Integer> o1, Map.Entry<FieldPath, Integer> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Map.Entry entry : list) {
            mapBuilder.put(entry.getKey(), entry.getValue());
        }
        return mapBuilder.build();
    }

    public static MapRPut toMapRPut(ByteBuffer id, int[] famIds, ByteBuffer[] bbuf, byte type) {
        MapRPut mrput = new MapRPut();
        int bufLen = 0;
        mrput.numCells = mrput.numFamilies = famIds.length;
        mrput.type = type;
        mrput.rowTimeStamp = 0L;
        mrput.key = new byte[id.remaining()];
        id.get(mrput.key);
        mrput.families = new int[mrput.numFamilies];
        mrput.keyvals = null;
        mrput.cellsPerFamily = new int[mrput.numFamilies];
        mrput.encBuffers = new ByteBuffer[mrput.numFamilies];
        mrput.encPositions = new int[mrput.numFamilies];
        mrput.encLimits = new int[mrput.numFamilies];
        int i = 0;
        int prevCfId = 0;
        int[] arr$ = famIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int entry;
            mrput.families[i] = entry = arr$[i$];
            if (i != 0) {
                assert (mrput.families[i] > prevCfId);
                prevCfId = mrput.families[i];
            } else {
                prevCfId = mrput.families[i];
            }
            mrput.cellsPerFamily[i] = 1;
            if (bbuf == null || bbuf[i] == null) {
                mrput.encBuffers[i] = null;
                mrput.encLimits[i] = 0;
                mrput.encPositions[i] = 0;
            } else {
                mrput.encBuffers[i] = bbuf[i];
                mrput.encPositions[i] = bbuf[i].position();
                mrput.encLimits[i] = bbuf[i].limit();
                bufLen += mrput.encLimits[i] - mrput.encPositions[i];
                mrput.encBuffers[i].rewind();
            }
            ++i;
        }
        mrput.rowTotalBytes = mrput.key.length + 8 + bufLen;
        mrput.setIsEncoded(true);
        return mrput;
    }

    public static void getMaps(List<Dbserver.ColumnFamilyAttr> cfAttrs, ComboMap cm) throws TableNotFoundException {
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder cfNameBuilder = ImmutableBiMap.builder();
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttrs) {
            logger.trace("CF#{}, name: '{}', path: '{}'", new Object[]{cfAttr.getSchFamily().getId(), cfAttr.getSchFamily().getName(), cfAttr.getJsonFamilyPath()});
            mapBuilder.put((Object)FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()), (Object)cfAttr.getSchFamily().getId());
            cfNameBuilder.put((Object)cfAttr.getSchFamily().getId(), (Object)cfAttr.getSchFamily().getName());
        }
        cm.idToName = cfNameBuilder.build();
        cm.pathToId = mapBuilder.build();
    }

    public static BiMap<FieldPath, Integer> getCFIdPathMap(List<Dbserver.ColumnFamilyAttr> cfAttrs) throws TableNotFoundException {
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Dbserver.ColumnFamilyAttr cfAttr : cfAttrs) {
            logger.trace("CF#{}, name: '{}', path: '{}'", new Object[]{cfAttr.getSchFamily().getId(), cfAttr.getSchFamily().getName(), cfAttr.getJsonFamilyPath()});
            mapBuilder.put((Object)FieldPath.parseFrom((String)cfAttr.getJsonFamilyPath()), (Object)cfAttr.getSchFamily().getId());
        }
        return mapBuilder.build();
    }

    public static EncodedBufFamIdInfo getEncBufsAndFamilyIds(SerializedFamilyInfo[] info) {
        int numFams = 0;
        for (int i = 0; i < info.length; ++i) {
            if (info[i].getAction() == SerializationAction.NO_ACTION) continue;
            ++numFams;
        }
        ByteBuffer[] encVals = new ByteBuffer[numFams];
        int[] famIds = new int[numFams];
        int idx = 0;
        block6: for (int i = 0; i < info.length; ++i) {
            if (info[i].getAction() != SerializationAction.NO_ACTION) {
                famIds[idx] = info[i].getFamilyId();
            }
            switch (info[i].getAction()) {
                case NO_ACTION: {
                    continue block6;
                }
                case SET: {
                    encVals[idx] = info[i].getByteBuffer();
                    ++idx;
                    continue block6;
                }
                case DELETE_FAMILY: {
                    encVals[idx] = null;
                    ++idx;
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        return new EncodedBufFamIdInfo(encVals, famIds);
    }

    public static void insertOrReplace(MapRDBTableImpl table, ByteBuffer id, SerializedFamilyInfo[] info) throws DBException {
        EncodedBufFamIdInfo ebf = MapRDBTableImplHelper.getEncBufsAndFamilyIds(info);
        MapRPut mput = MapRDBTableImplHelper.toMapRPut(id, ebf.familyIds, ebf.encBuffers, (byte)0);
        try {
            if (table.getOption(Table.TableOption.BUFFERWRITE).getBoolean()) {
                table.maprTable().put(mput);
            } else {
                table.maprTable().syncPut(mput, true);
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "insertOrReplace()");
        }
    }

    public static MapRScan toMapRScan(MapRDBTableImpl table) throws DBException {
        return MapRDBTableImplHelper.toMapRScan(table, null, (String[])null);
    }

    public static MapRScan toMapRScan(MapRDBTableImpl table, String ... paths) throws DBException {
        return MapRDBTableImplHelper.toMapRScan(table, null, paths);
    }

    public static MapRScan toMapRScan(MapRDBTableImpl table, Condition c, String ... paths) throws DBException {
        MapRScan maprscan = new MapRScan();
        maprscan.batch = 0;
        maprscan.caching = 0;
        maprscan.startRow = MapRConstants.EMPTY_START_ROW;
        maprscan.stopRow = MapRConstants.EMPTY_END_ROW;
        maprscan.filter = null;
        maprscan.rowConstraint = MapRDBTableImplHelper.toRowConstraint(table, paths);
        byte[] serFilt = null;
        if (c != null) {
            ConditionImpl cImpl = ((ConditionImpl)c).cloneOptimized();
            ConditionNode.RowkeyRange keyRange = cImpl.getRowkeyRanges().get(0);
            maprscan.startRow = keyRange.getStartRow();
            maprscan.stopRow = keyRange.getStopRow();
            if (!cImpl.isEmpty()) {
                serFilt = Bytes.getBytes((ByteBuffer)cImpl.getDescriptor(table.idPathMap()).getSerialized());
            }
            logger.trace("Condition: '{}', startRow: '{}', stopRow: '{}'", new Object[]{cImpl, Bytes.toStringBinary((byte[])maprscan.startRow), Bytes.toStringBinary((byte[])maprscan.stopRow)});
        }
        maprscan.setFilter(serFilt);
        return maprscan;
    }

    public static MapRFileSystem getMapRFileSystem() {
        return MapRDBTableImplHelper.getMapRFileSystem(config);
    }

    public static MapRFileSystem getMapRFileSystem(Configuration config) {
        try {
            return (MapRFileSystem)FileSystem.get((URI)new URI("maprfs:///"), (Configuration)config);
        }
        catch (IOException | URISyntaxException e) {
            throw new DBException("Could not get filesystem", e);
        }
    }

    public static List<String> getColumnFamiliesList(String columnSpec) {
        ArrayList<String> cfList = new ArrayList<String>();
        if (columnSpec != null) {
            String[] cols = columnSpec.split(",");
            String column = null;
            for (String col : cols) {
                if (col.contains(":")) {
                    String[] names = col.split(":");
                    column = names[0];
                } else {
                    column = col;
                }
                if (cfList.contains(column)) continue;
                cfList.add(column);
            }
        }
        return cfList;
    }

    static class ComboMap {
        BiMap<FieldPath, Integer> pathToId;
        BiMap<Integer, String> idToName;

        ComboMap() {
        }
    }

    static class CondAndProjPaths {
        String[] allPaths = null;
        Set<FieldPath> condPaths = null;
    }
}

