/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.Condition;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.SerializationAction;
import com.mapr.db.rowcol.SerializedFamilyInfo;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.proto.Dbfilters;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API.Internal
class ConditionLeaf
extends ConditionNode {
    static Logger logger = LoggerFactory.getLogger(ConditionLeaf.class);
    private static final String REGEX_OPTIONAL_CHARS = "?*";
    private static final String REGEX_SPECIAL_CHARS = ".+([{";
    final KeyValue value;
    final FieldPath field;
    final Value.Type type;
    final Dbfilters.ConditionOpProto op;

    ConditionLeaf(FieldPath path, Condition.Op op, KeyValue initFrom) {
        this(path, (Dbfilters.ConditionOpProto)opProtoMap.get((Object)op), initFrom);
    }

    ConditionLeaf(FieldPath field, Dbfilters.ConditionOpProto op, KeyValue value) {
        this(field, op, value, null);
    }

    ConditionLeaf(FieldPath field, Dbfilters.ConditionOpProto op, KeyValue value, Value.Type type) {
        this.op = op;
        this.field = field;
        this.value = value;
        this.type = type;
        this.checkArgs();
    }

    ConditionLeaf(String filterId, ByteString serializedState) {
        Dbfilters.FilterComparatorProto filterComparator = null;
        try {
            switch (filterId) {
                case "8cbdcd12": {
                    Dbfilters.ConditionFilterProto proto = Dbfilters.ConditionFilterProto.parseFrom((ByteString)serializedState);
                    this.field = FieldPath.parseFrom((String)proto.getFieldPath());
                    filterComparator = proto.getFilterComparator();
                    this.type = filterComparator.hasType() ? Value.Type.valueOf((int)filterComparator.getType()) : null;
                    break;
                }
                case "469dbd04": {
                    this.type = null;
                    this.field = FieldPath.parseFrom((String)"_id");
                    Dbfilters.RowFilterProto proto = Dbfilters.RowFilterProto.parseFrom((ByteString)serializedState);
                    filterComparator = proto.getFilterComparator();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid filter id: " + filterId);
                }
            }
            this.op = filterComparator.getConditionOp();
            this.value = filterComparator.hasComparator() && filterComparator.getComparator().hasSerializedComparator() ? this.toValue(filterComparator) : null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode message", e);
        }
    }

    @Override
    protected ConditionLeaf clone() {
        ConditionLeaf newLeaf = (ConditionLeaf)super.clone();
        return newLeaf;
    }

    private KeyValue toValue(Dbfilters.FilterComparatorProto filterComparator) throws InvalidProtocolBufferException {
        Dbfilters.ComparatorProto comparator = filterComparator.getComparator();
        ByteString state = comparator.getSerializedComparator();
        switch (comparator.getName()) {
            case "45a94888": {
                Dbfilters.BinaryComparatorProto binaryComparator = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state);
                ByteBuffer encoded = binaryComparator.getComparable().asReadOnlyByteBuffer();
                encoded.order(ByteOrder.LITTLE_ENDIAN);
                HashMap<Integer, ByteBuffer> bufferMap = new HashMap<Integer, ByteBuffer>();
                bufferMap.put(0, encoded);
                DBDocumentImpl doc = RowcolCodec.decode(bufferMap, Constants.DEFAULT_FAMILY_MAP, Constants.DEFAULT_NAME_MAP);
                return (KeyValue)doc.getValue("X");
            }
            case "e2d7ba40": {
                Dbfilters.RegexStringComparatorProto regexComparator = Dbfilters.RegexStringComparatorProto.parseFrom((ByteString)state);
                return KeyValueBuilder.initFrom(regexComparator.getPattern().toStringUtf8());
            }
            case "05f39865": {
                ByteString byteString = Dbfilters.BinaryComparatorProto.parseFrom((ByteString)state).getComparable();
                return filterComparator.getType() == Value.Type.BINARY.getCode() ? KeyValueBuilder.initFrom(byteString.asReadOnlyByteBuffer()) : KeyValueBuilder.initFrom(byteString.toStringUtf8());
            }
        }
        throw new IllegalArgumentException("Invalid filter id: " + comparator.getName());
    }

    Dbfilters.ConditionOpProto getOp() {
        return this.op;
    }

    FieldPath getField() {
        return this.field;
    }

    @Override
    boolean checkAndPrune() {
        return this.isOnRowKey() && this.op != Dbfilters.ConditionOpProto.CND_NE && opProtoMap.containsValue((Object)this.op) && this.value != null;
    }

    @Override
    void addProjections(Set<FieldPath> proj) {
        proj.add(this.field);
    }

    @Override
    StringBuilder expressionBuilder(StringBuilder sb) {
        return this.treeBuilder(sb, 0);
    }

    @Override
    StringBuilder treeBuilder(StringBuilder sb, int level) {
        return sb.append('(').append(this.field.asPathString()).append(' ').append((String)opSymbolMap.get(this.op)).append(' ').append(this.type != null ? this.type : (this.value != null ? this.value.toString() : null)).append(')');
    }

    @Override
    StringBuilder jsonBuilder(StringBuilder sb) {
        return sb.append('{').append('\"').append(this.field.asPathString()).append('\"').append(':').append(' ').append('{').append('\"').append(((String)opJsonOpMap.get(this.op)).toLowerCase()).append('\"').append(':').append(' ').append(this.type != null ? "\"" + this.type + "\"" : (this.value != null ? this.value.toString() : null)).append('}').append('}');
    }

    @Override
    ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        if (this.isOnRowKey()) {
            return this.toRowKeyFilter(pathIdMap);
        }
        return this.toConditionFilter(pathIdMap);
    }

    boolean isOnRowKey() {
        return this.field.getRootSegment().isLastPath() && "_id".equals(this.field.getRootSegment().getNameSegment().getName());
    }

    private void checkArgs() {
        if (this.isOnRowKey() && this.value != null && !IdCodec.isSupportedType(this.value.getType())) {
            throw new IllegalArgumentException(String.format("A %s value can not be used for '_id' field.", this.value.getType()));
        }
    }

    private ConditionDescriptor toRowKeyFilter(BiMap<FieldPath, Integer> pathIdMap) {
        Dbfilters.RowFilterProto rowFilter = Dbfilters.RowFilterProto.newBuilder().setFilterComparator(this.getComparator(true)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("469dbd04").setSerializedState(rowFilter.toByteString()).build();
        return new ConditionDescriptor(filterMsg, pathIdMap.values(), pathIdMap.keySet());
    }

    private ConditionDescriptor toConditionFilter(BiMap<FieldPath, Integer> pathIdMap) {
        FieldPath fieldPath = this.field;
        Integer familyId = (Integer)pathIdMap.get((Object)FieldPath.EMPTY);
        if (familyId == null) {
            throw new IllegalStateException("Unable to find family id for the default column family.");
        }
        for (Map.Entry kv : pathIdMap.entrySet()) {
            FieldPath progeny;
            FieldPath familyPath = (FieldPath)kv.getKey();
            if (familyPath.equals((Object)FieldPath.EMPTY) || (progeny = this.field.cloneAfterAncestor(familyPath)) == null) continue;
            fieldPath = progeny.equals((Object)FieldPath.EMPTY) ? Constants.DUMMY_FIELDPATH_V : progeny.cloneWithNewParent("v");
            familyId = (Integer)kv.getValue();
            break;
        }
        Dbfilters.ConditionFilterProto conditionFilter = Dbfilters.ConditionFilterProto.newBuilder().setFieldPath(fieldPath.asPathString(false)).setFamilyId(familyId.intValue()).setFilterComparator(this.getComparator(false)).build();
        Dbfilters.FilterMsg filterMsg = Dbfilters.FilterMsg.newBuilder().setId("8cbdcd12").setSerializedState(conditionFilter.toByteString()).build();
        return new ConditionDescriptor(filterMsg, (Set<Integer>)ImmutableSet.of((Object)familyId), (Set<FieldPath>)ImmutableSet.of((Object)fieldPath));
    }

    private Dbfilters.FilterComparatorProto getComparator(boolean onRowKey) {
        Dbfilters.FilterComparatorProto.Builder filterComparator = Dbfilters.FilterComparatorProto.newBuilder().setConditionOp(this.op);
        if (this.type != null) {
            filterComparator.setType((int)this.type.getCode());
        }
        filterComparator.setComparator(this.toComparator(filterComparator, onRowKey));
        return filterComparator.build();
    }

    private Dbfilters.ComparatorProto toComparator(Dbfilters.FilterComparatorProto.Builder filterComparator, boolean onRowKey) {
        ByteString state = null;
        String comparatorName = null;
        Dbfilters.ComparatorProto.Builder builder = Dbfilters.ComparatorProto.newBuilder();
        switch (this.op) {
            case CND_UNKNOWN: {
                String err = "Should never have unknown condition";
                logger.error("Should never have unknown condition");
                assert (false) : "Should never have unknown condition";
            }
            case CND_LIKE: 
            case CND_NOT_LIKE: {
                comparatorName = "e2d7ba40";
                ByteString pattern = onRowKey ? ByteString.copyFrom((ByteBuffer)IdCodec.encode(this.value.getString())) : ByteString.copyFrom((byte[])Bytes.toBytes((String)this.value.getString()));
                state = Dbfilters.RegexStringComparatorProto.newBuilder().setPattern(pattern).setIsUTF8(true).build().toByteString();
                builder.setSerializedComparator(state);
                break;
            }
            default: {
                comparatorName = "45a94888";
                if (onRowKey) {
                    filterComparator.setType((int)Value.Type.BINARY.getCode());
                    comparatorName = "05f39865";
                    ByteString rowkeyValue = ByteString.EMPTY;
                    if (this.value != null) {
                        rowkeyValue = ByteString.copyFrom((ByteBuffer)IdCodec.encode(this.value));
                    }
                    state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(rowkeyValue).build().toByteString();
                    builder.setSerializedComparator(state);
                    break;
                }
                if (this.value == null) break;
                DBDocumentImpl rec = new DBDocumentImpl();
                rec.set("X", this.value);
                SerializedFamilyInfo[] famInfo = RowcolCodec.encode(rec, Constants.DEFAULT_FAMILY_MAP);
                assert (famInfo.length == 1);
                assert (famInfo[0].getAction() == SerializationAction.SET);
                ByteString encodedRec = ByteString.copyFrom((ByteBuffer)famInfo[0].getByteBuffer());
                state = Dbfilters.BinaryComparatorProto.newBuilder().setComparable(encodedRec).build().toByteString();
                builder.setSerializedComparator(state);
            }
        }
        return builder.setName(comparatorName).build();
    }

    @Override
    List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        if (!this.isOnRowKey() || this.value == null) {
            return FULL_TABLE_RANGE;
        }
        byte[] fieldValue = IdCodec.encodeAsBytes(this.value);
        byte[] startRow = MapRConstants.EMPTY_BYTE_ARRAY;
        byte[] stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
        switch (this.op) {
            case CND_EQ: {
                stopRow = fieldValue;
                startRow = fieldValue;
                break;
            }
            case CND_GE: {
                startRow = fieldValue;
                break;
            }
            case CND_GT: {
                startRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case CND_LE: {
                stopRow = Arrays.copyOf(fieldValue, fieldValue.length + 1);
                break;
            }
            case CND_LT: {
                stopRow = fieldValue;
                break;
            }
            case CND_LIKE: {
                String prefix;
                boolean lastEscaped = false;
                StringBuilder prefixSB = new StringBuilder();
                String regexString = this.value.getString();
                if (regexString.charAt(0) == '^') {
                    regexString = regexString.substring(1);
                }
                for (int i = 0; i < regexString.length(); ++i) {
                    char ch = regexString.charAt(i);
                    if (lastEscaped) {
                        lastEscaped = false;
                        prefixSB.append(ch);
                        continue;
                    }
                    if (ch == '\\') {
                        lastEscaped = true;
                        continue;
                    }
                    if (REGEX_OPTIONAL_CHARS.indexOf(ch) != -1) {
                        if (prefixSB.length() <= 0) break;
                        prefixSB.setLength(prefixSB.length() - 1);
                        break;
                    }
                    if (REGEX_SPECIAL_CHARS.indexOf(ch) != -1) break;
                    prefixSB.append(ch);
                }
                if (prefixSB.length() <= 0 || (stopRow = Bytes.unsignedCopyAndIncrement((byte[])(startRow = Bytes.getBytes((ByteBuffer)IdCodec.encode(prefix = prefixSB.toString()))))).length <= startRow.length) break;
                stopRow = MapRConstants.EMPTY_BYTE_ARRAY;
            }
        }
        if (startRow != MapRConstants.EMPTY_BYTE_ARRAY || stopRow != MapRConstants.EMPTY_BYTE_ARRAY) {
            return ImmutableList.of((Object)new ConditionNode.RowkeyRange(startRow, stopRow));
        }
        return FULL_TABLE_RANGE;
    }
}

