/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.collect.BiMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.db.Condition;
import com.mapr.db.DBConstants;
import com.mapr.db.impl.ConditionBlock;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionLeaf;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.rowcol.KeyValueBuilder;
import com.mapr.fs.proto.Dbfilters;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.types.Interval;

@API.Internal
public class ConditionImpl
implements Condition {
    private static final String EMPTY = "<EMPTY>";
    private static final String EMPTY_DOC = "{}";
    private static final ConditionDescriptor EMPTY_DESC = new ConditionDescriptor(ByteBuffer.wrap(new byte[0]));
    private ConditionNode root;
    private boolean built = false;
    private Stack<ConditionBlock> groupsStack;
    private List<ConditionNode.RowkeyRange> rowkeyRanges;

    public ConditionImpl() {
    }

    ConditionImpl(String id, ByteString serializedState) {
        switch (id) {
            case "469dbd04": 
            case "8cbdcd12": {
                this.root = new ConditionLeaf(id, serializedState);
                break;
            }
            case "a42ebf64": {
                this.root = new ConditionBlock(serializedState);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown filter in the serialized message: " + id);
            }
        }
        this.build();
    }

    @Override
    public boolean isEmpty() {
        return this.root == null || this.root.isEmpty();
    }

    @Override
    public boolean isBuilt() {
        return this.built;
    }

    public String asPrefix() {
        if (this.root == null) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        this.root.treeBuilder(sb);
        if (this.built) {
            sb.append("\n]");
        }
        return sb.toString();
    }

    public String jsonString() {
        if (this.root == null || this.root.isEmpty()) {
            return EMPTY_DOC;
        }
        StringBuilder sb = new StringBuilder();
        this.root.jsonBuilder(sb);
        return sb.toString();
    }

    public Set<FieldPath> getProjections() {
        HashSet<FieldPath> proj = new HashSet<FieldPath>();
        if (!this.isEmpty()) {
            this.root.addProjections(proj);
        }
        proj.remove(DBConstants.ROWKEY_FIELD);
        return proj;
    }

    public String asInfix() {
        return this.isEmpty() ? EMPTY : this.root.expressionBuilder(new StringBuilder()).toString();
    }

    public String toString() {
        return this.asInfix();
    }

    public int hashCode() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConditionImpl other = (ConditionImpl)obj;
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP).equals(other.getDescriptor(Constants.DEFAULT_FAMILY_MAP));
    }

    @Override
    public ConditionImpl and() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.and));
    }

    @Override
    public ConditionImpl or() {
        return this.addGroup(new ConditionBlock(ConditionBlock.BlockType.or));
    }

    @Override
    public ConditionImpl close() {
        if (this.groupsStack == null || this.groupsStack.isEmpty()) {
            throw new IllegalStateException("Not in a condition block.");
        }
        this.groupsStack.pop().close();
        return this;
    }

    @Override
    public ConditionImpl build() {
        return this.build(false);
    }

    public ConditionImpl cloneOptimized() {
        ConditionImpl pruned = new ConditionImpl();
        if (this.root != null) {
            pruned.root = this.root.clone();
        }
        return pruned.build(true);
    }

    @Override
    public ConditionImpl condition(Condition conditionToAdd) {
        if (conditionToAdd == null) {
            throw new IllegalArgumentException("A null condition can not be added.");
        }
        if (conditionToAdd == this) {
            throw new IllegalArgumentException("A condition can not be added to itself");
        }
        if (!conditionToAdd.isBuilt()) {
            throw new IllegalArgumentException("The specified condition is not built\n" + conditionToAdd);
        }
        if (conditionToAdd.isEmpty()) {
            throw new IllegalArgumentException("Can not add an empty condition");
        }
        this.checkStateForModification();
        ConditionImpl other = (ConditionImpl)conditionToAdd;
        if (this.root == null) {
            this.root = other.getRoot().clone();
        } else {
            this.groupsStack.peek().add(other.getRoot().clone());
        }
        return this;
    }

    @Override
    public ConditionImpl exists(String path) {
        return this.exists(FieldPath.parseFrom((String)path));
    }

    @Override
    public ConditionImpl exists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NE, null));
    }

    @Override
    public ConditionImpl notExists(String path) {
        return this.notExists(FieldPath.parseFrom((String)path));
    }

    @Override
    public ConditionImpl in(String path, List<? extends Object> listOfValue) {
        return this.in(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    @Override
    public ConditionImpl in(FieldPath path, List<? extends Object> listOfValue) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_IN, KeyValueBuilder.initFrom(listOfValue)));
    }

    @Override
    public ConditionImpl notIn(String path, List<? extends Object> listOfValue) {
        return this.notIn(FieldPath.parseFrom((String)path), (List)listOfValue);
    }

    @Override
    public ConditionImpl notIn(FieldPath path, List<? extends Object> listOfValue) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NOT_IN, KeyValueBuilder.initFrom(listOfValue)));
    }

    @Override
    public ConditionImpl notExists(FieldPath path) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_EQ, null));
    }

    @Override
    public ConditionImpl typeOf(String path, Value.Type type) {
        return this.typeOf(FieldPath.parseFrom((String)path), type);
    }

    @Override
    public ConditionImpl typeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_TYPE_OF, null, type));
    }

    @Override
    public ConditionImpl notTypeOf(String path, Value.Type type) {
        return this.notTypeOf(FieldPath.parseFrom((String)path), type);
    }

    @Override
    public ConditionImpl notTypeOf(FieldPath path, Value.Type type) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NOT_TYPE_OF, null, type));
    }

    @Override
    public ConditionImpl matches(String path, String regex) {
        return this.matches(FieldPath.parseFrom((String)path), regex);
    }

    @Override
    public ConditionImpl matches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_LIKE, KeyValueBuilder.initFrom(regex)));
    }

    @Override
    public ConditionImpl notMatches(String path, String regex) {
        return this.notMatches(FieldPath.parseFrom((String)path), regex);
    }

    @Override
    public ConditionImpl notMatches(FieldPath path, String regex) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NOT_LIKE, KeyValueBuilder.initFrom(regex)));
    }

    @Override
    public Condition is(String path, Condition.Op op, boolean value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, boolean value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, String value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, String value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, byte value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, byte value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, short value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, short value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, int value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, int value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, long value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, long value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, float value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, float value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, double value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, double value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, BigDecimal value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, BigDecimal value) {
        throw new UnsupportedOperationException("BigDecimal type not supported");
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, Date value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, Date value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, Time value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, Time value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, Timestamp value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, Timestamp value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, Interval value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, Interval value) {
        throw new UnsupportedOperationException("Interval type not supported");
    }

    @Override
    public ConditionImpl is(String path, Condition.Op op, ByteBuffer value) {
        return this.is(FieldPath.parseFrom((String)path), op, value);
    }

    @Override
    public ConditionImpl is(FieldPath path, Condition.Op op, ByteBuffer value) {
        return this.addLeaf(new ConditionLeaf(path, op, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl equals(String path, Map<String, ? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (Map)value);
    }

    @Override
    public ConditionImpl equals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_EQ, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl equals(String path, List<? extends Object> value) {
        return this.equals(FieldPath.parseFrom((String)path), (List)value);
    }

    @Override
    public ConditionImpl equals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_EQ, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl notEquals(String path, Map<String, ? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (Map)value);
    }

    @Override
    public ConditionImpl notEquals(FieldPath path, Map<String, ? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NE, KeyValueBuilder.initFrom(value)));
    }

    @Override
    public ConditionImpl notEquals(String path, List<? extends Object> value) {
        return this.notEquals(FieldPath.parseFrom((String)path), (List)value);
    }

    @Override
    public ConditionImpl notEquals(FieldPath path, List<? extends Object> value) {
        return this.addLeaf(new ConditionLeaf(path, Dbfilters.ConditionOpProto.CND_NE, KeyValueBuilder.initFrom(value)));
    }

    @API.Internal
    public ConditionDescriptor getDescriptor() {
        return this.getDescriptor(Constants.DEFAULT_FAMILY_MAP);
    }

    @API.Internal
    public ConditionDescriptor getDescriptor(BiMap<FieldPath, Integer> pathIdMap) {
        this.checkIfBuilt();
        return this.isEmpty() ? EMPTY_DESC : this.root.getDescriptor(pathIdMap);
    }

    @API.Internal
    public List<ConditionNode.RowkeyRange> getRowkeyRanges() {
        this.checkIfBuilt();
        return this.rowkeyRanges;
    }

    @API.Internal
    public static Condition parseFrom(ByteBuffer buf) {
        try {
            if (buf.remaining() > 0) {
                Dbfilters.FilterMsg msg = Dbfilters.FilterMsg.parseFrom((ByteString)ByteString.copyFrom((ByteBuffer)buf));
                return new ConditionImpl(msg.getId(), msg.getSerializedState());
            }
            return new ConditionImpl().build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Unable to parse the provided data.", e);
        }
    }

    ConditionNode getRoot() {
        return this.root;
    }

    private ConditionImpl addLeaf(ConditionLeaf leaf) {
        this.checkStateForModification();
        if (this.root == null) {
            this.root = leaf;
        } else {
            this.groupsStack.peek().add(leaf);
        }
        return this;
    }

    private ConditionImpl addGroup(ConditionBlock newGroup) {
        this.checkStateForModification();
        if (this.groupsStack == null) {
            this.groupsStack = new Stack();
        }
        if (this.root == null) {
            this.root = newGroup;
        } else {
            this.groupsStack.peek().add(newGroup);
        }
        this.groupsStack.push(newGroup);
        return this;
    }

    private ConditionImpl build(boolean optimize) {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.groupsStack != null && !this.groupsStack.isEmpty()) {
            throw new IllegalStateException("At least one condition group is not closed." + this.asPrefix());
        }
        if (this.root != null && !this.root.isEmpty()) {
            this.rowkeyRanges = this.root.getRowkeyRanges();
            if (optimize && this.root.checkAndPrune()) {
                this.root = null;
            }
        } else {
            this.rowkeyRanges = ConditionNode.FULL_TABLE_RANGE;
        }
        this.built = true;
        return this;
    }

    private void checkIfBuilt() {
        if (!this.built) {
            throw new IllegalStateException("The condition is not built yet.\n" + this.asPrefix());
        }
    }

    private void checkStateForModification() {
        if (this.built) {
            throw new IllegalStateException("The condition is already built.");
        }
        if (this.root != null && this.groupsStack == null) {
            throw new IllegalArgumentException("A condition can only be addded as root or a child of another logical connecter.");
        }
    }
}

