/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.mapr.db.Admin;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.FamilyExistsException;
import com.mapr.db.exceptions.FamilyNotFoundException;
import com.mapr.db.exceptions.OpNotPermittedException;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.MapRDBTableImplHelper;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.fs.ErrnoException;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.annotation.API;

@API.Internal
public class AdminImpl
implements Admin {
    private final MapRFileSystem maprfs_;
    private final Configuration conf_;
    private boolean shoulCloseFS_ = false;

    public AdminImpl() throws DBException {
        this(new Configuration());
    }

    public AdminImpl(Configuration conf) throws DBException {
        this(AdminImpl.newMapRFS(conf));
        this.shoulCloseFS_ = true;
    }

    public AdminImpl(MapRFileSystem maprfs) throws DBException {
        this.maprfs_ = maprfs;
        this.conf_ = maprfs.getConf();
    }

    private static MapRFileSystem newMapRFS(Configuration conf) throws DBException {
        try {
            MapRFileSystem maprfs = new MapRFileSystem();
            maprfs.initialize(new URI("maprfs:///"), conf);
            return maprfs;
        }
        catch (Exception e) {
            throw new DBException(e);
        }
    }

    @Override
    public synchronized void close() throws DBException {
        try {
            if (this.shoulCloseFS_) {
                this.maprfs_.close();
                this.shoulCloseFS_ = false;
            }
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "close()");
        }
    }

    @Override
    public List<Path> listTables() throws DBException {
        return this.listTables((Path)null);
    }

    @Override
    public List<Path> listTables(String folderOrPattern) throws DBException {
        return this.listTables(folderOrPattern == null ? null : new Path(folderOrPattern));
    }

    @Override
    public List<Path> listTables(Path folderOrPattern) throws DBException {
        try {
            return this._listTables(folderOrPattern);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "listTables()");
        }
    }

    private List<Path> _listTables(Path folderOrPattern) throws IOException {
        FileStatus[] children;
        try {
            MapRFileStatus patternStat;
            if (folderOrPattern == null) {
                folderOrPattern = this.maprfs_.getWorkingDirectory();
            }
            children = (patternStat = this.maprfs_.getMapRFileStatus(folderOrPattern)).isDirectory() ? this.maprfs_.listMapRStatus(folderOrPattern, false, false) : new MapRFileStatus[]{patternStat};
        }
        catch (FileNotFoundException e) {
            children = this.maprfs_.globStatus(folderOrPattern);
        }
        LinkedList tables = Lists.newLinkedList();
        for (FileStatus fileStatus : children) {
            TableProperties prop;
            if (!fileStatus.isTable() || !(prop = this.maprfs_.getTableProperties(fileStatus.getPath())).getAttr().getJson()) continue;
            tables.add(new Path(fileStatus.getPath().toUri().getPath()));
        }
        return tables;
    }

    @Override
    public Table createTable(String tablePath) throws TableExistsException, DBException {
        return this._createTable(new TableDescriptorImpl(new Path(tablePath)), null, true);
    }

    @Override
    public Table createTable(Path tablePath) throws DBException {
        return this._createTable(new TableDescriptorImpl(tablePath), null, true);
    }

    @Override
    public Table createTable(TableDescriptor tableDesc) throws TableExistsException, DBException {
        return this._createTable(tableDesc, null, true);
    }

    public Table createTable(TableDescriptor tableDesc, Value[] splitPoints) throws TableExistsException, DBException {
        Object encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                Preconditions.checkArgument((boolean)IdCodec.isSupportedType(splitPoints[1].getType()), (Object)(splitPoints[1].getType() + " is not a supported type for split points."));
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this._createTable(tableDesc, (byte[][])encodedSplitKeys, true);
    }

    @Override
    public Table createTable(TableDescriptor tableDesc, String[] splitPoints) throws TableExistsException, DBException {
        Object encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this._createTable(tableDesc, (byte[][])encodedSplitKeys, true);
    }

    @Override
    public Table createTable(TableDescriptor tableDesc, ByteBuffer[] splitPoints) throws TableExistsException, DBException {
        Object encodedSplitKeys = null;
        if (splitPoints != null && splitPoints.length > 0) {
            encodedSplitKeys = new byte[splitPoints.length][];
            for (int i = 0; i < splitPoints.length; ++i) {
                encodedSplitKeys[i] = IdCodec.encodeAsBytes(splitPoints[i]);
            }
        }
        return this._createTable(tableDesc, (byte[][])encodedSplitKeys, true);
    }

    @API.Internal
    public Table createTable(String tablePath, boolean openTable) throws TableExistsException, DBException {
        return this._createTable(new TableDescriptorImpl(new Path(tablePath)), null, openTable);
    }

    @API.Internal
    public Table createTable(TableDescriptor tableDesc, boolean openTable) throws TableExistsException, DBException {
        return this._createTable(tableDesc, null, openTable);
    }

    private Table _createTable(TableDescriptor tableDesc, byte[][] splitPoints, boolean openTable) throws DBException {
        try {
            if (this.maprfs_.exists(tableDesc.getPath())) {
                throw new TableExistsException(tableDesc.getPath());
            }
            if (splitPoints != null) {
                Arrays.sort(splitPoints, Bytes.BYTES_COMPARATOR);
            }
            TableDescriptorImpl descImpl = (TableDescriptorImpl)tableDesc;
            this.maprfs_.createTable(tableDesc.getPath(), null, descImpl.getTableAttr().build(), descImpl.getTableAces().build(), splitPoints, false, -1);
            if (tableDesc.getFamilies().isEmpty()) {
                this.maprfs_.createColumnFamily(tableDesc.getPath(), "default", FamilyDescriptorImpl.DEFAULT_COLUMN_FAMILY_ATTR);
            } else {
                for (FamilyDescriptor family : tableDesc.getFamilies()) {
                    this.maprfs_.createColumnFamily(tableDesc.getPath(), family.getName(), this.getColumnFamilyAttr(false, family.getName(), family));
                }
            }
            return openTable ? new MapRDBTableImpl(tableDesc.getPath(), this.conf_) : null;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "createTable()");
        }
    }

    @Override
    public void alterTable(TableDescriptor desc) throws TableNotFoundException, DBException {
        try {
            TableDescriptor oldDesc = this.getTableDescriptor(desc.getPath());
            if (!oldDesc.isBulkLoad() && desc.isBulkLoad()) {
                throw new OpNotPermittedException("Bulk load mode can only be turned off.");
            }
            if (desc.isInsertionOrder() != oldDesc.isInsertionOrder()) {
                throw new OpNotPermittedException("Insertion order property can not be altered.");
            }
            if (!desc.getFamilies().equals(oldDesc.getFamilies())) {
                throw new OpNotPermittedException("alterTable() can not be used to modify families of the table.");
            }
            TableDescriptorImpl descImpl = (TableDescriptorImpl)desc;
            this.maprfs_.modifyTableAttr(desc.getPath(), descImpl.getTableAttr().clearJson().build(), descImpl.getTableAces().build());
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "alterTable()");
        }
    }

    public void addFamily(Path tablePath, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyExistsException, DBException {
        try {
            this.maprfs_.createColumnFamily(tablePath, familyDesc.getName(), this.getColumnFamilyAttr(false, null, familyDesc));
        }
        catch (IOException e) {
            if (e instanceof ErrnoException && ((ErrnoException)e).getErrno() == 17) {
                throw new FamilyExistsException(tablePath, familyDesc, e);
            }
            throw ExceptionHandler.handle(e, "addFamily()");
        }
    }

    @Override
    public boolean deleteFamily(Path tablePath, String familyName) throws TableNotFoundException, FamilyNotFoundException, DBException {
        try {
            this.maprfs_.deleteColumnFamily(tablePath, familyName);
            return true;
        }
        catch (IOException e) {
            if (e instanceof ErrnoException && ((ErrnoException)e).getErrno() == 2) {
                return false;
            }
            throw ExceptionHandler.handle(e, "deleteFamily()");
        }
    }

    @Override
    public void alterFamily(Path tablePath, String familyName, FamilyDescriptor familyDesc) throws TableNotFoundException, FamilyNotFoundException, DBException {
        TableDescriptor tableDesc = this.getTableDescriptor(tablePath);
        FamilyDescriptor oldFamilyDesc = tableDesc.getFamily(familyName);
        if (oldFamilyDesc == null) {
            throw new FamilyNotFoundException(tablePath, familyName);
        }
        if (!oldFamilyDesc.getJsonFieldPath().equals((Object)familyDesc.getJsonFieldPath())) {
            throw new OpNotPermittedException("A family's Json path can not be altered.");
        }
        try {
            this.maprfs_.modifyColumnFamily(tablePath, familyName, this.getColumnFamilyAttr(true, familyName, familyDesc));
        }
        catch (IOException e) {
            if (e instanceof ErrnoException) {
                switch (((ErrnoException)e).getErrno()) {
                    case 2: {
                        throw new FamilyNotFoundException(tablePath, familyName, e);
                    }
                    case 17: {
                        throw new FamilyExistsException(tablePath, familyDesc, e);
                    }
                }
            }
            throw ExceptionHandler.handle(e, "alterFamily()");
        }
    }

    @Override
    public boolean tableExists(String tablePath) throws DBException {
        return this.tableExists(new Path(tablePath));
    }

    @Override
    public boolean tableExists(Path tablePath) throws DBException {
        try {
            TableProperties tableProp = this.maprfs_.getTableProperties(tablePath);
            return tableProp.getAttr().getJson();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "tableExists()");
        }
    }

    @Override
    public TableDescriptor getTableDescriptor(String tablePath) throws DBException {
        return this.getTableDescriptor(new Path(tablePath));
    }

    @Override
    public TableDescriptor getTableDescriptor(Path tablePath) throws DBException {
        try {
            TableProperties props = this.maprfs_.getTableProperties(tablePath);
            List cfAttrs = this.maprfs_.listColumnFamily(tablePath, false);
            return new TableDescriptorImpl(tablePath, cfAttrs, props, props.getAttr().getInsertionOrder());
        }
        catch (IOException e) {
            throw new TableNotFoundException(tablePath, e);
        }
    }

    @Override
    public boolean deleteTable(String tablePath) throws DBException {
        return this.deleteTable(new Path(tablePath));
    }

    @Override
    public boolean deleteTable(Path tablePath) throws DBException {
        if (!this.tableExists(tablePath)) {
            return false;
        }
        try {
            return this.maprfs_.delete(tablePath);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "deleteTable()");
        }
    }

    @Deprecated
    public static void createTableForCopy(String replicaPath, String srcPath, List<String> cfList, boolean isBulkload) throws DBException {
        try (AdminImpl admin = new AdminImpl();){
            if (admin.tableExists(replicaPath)) {
                throw new TableExistsException(replicaPath);
            }
            if (!admin.tableExists(srcPath)) {
                throw new TableNotFoundException(srcPath);
            }
            TableDescriptor desc = MapRDB.newTableDescriptor(replicaPath).addFamily(MapRDB.newDefaultFamilyDescriptor()).setBulkLoad(isBulkload);
            MapRDBTableImpl srcTable = (MapRDBTableImpl)MapRDB.getTable(srcPath);
            List cfAttrs = srcTable.maprTable().getMapRFS().listColumnFamily(srcTable.maprTable().getTablePath(), false);
            BiMap<FieldPath, Integer> srcIdPathMap = MapRDBTableImplHelper.getCFIdPathMap(cfAttrs);
            if (srcIdPathMap.size() == 0) {
                throw new DBException("Source table has no column families.");
            }
            for (Map.Entry entry : srcIdPathMap.entrySet()) {
                String cfName = srcTable.maprTable().getFamilyName(((Integer)entry.getValue()).intValue());
                if (cfName.equals("default") || cfList.size() != 0 && !cfList.contains(cfName)) continue;
                desc.addFamily(MapRDB.newFamilyDescriptor(cfName, ((FieldPath)entry.getKey()).asPathString()));
            }
            srcTable.close();
            admin.createTable(desc, false);
        }
        catch (IOException e) {
            throw ExceptionHandler.handle(e, "createTableForCopy()");
        }
    }

    private Dbserver.ColumnFamilyAttr getColumnFamilyAttr(boolean forAlter, String familyName, FamilyDescriptor familyDesc) {
        FamilyDescriptorImpl familyDescImpl = (FamilyDescriptorImpl)familyDesc;
        Dbserver.SchemaFamily.Builder schemaFamily = familyDescImpl.getSchemaFamily();
        schemaFamily.clearId();
        if (familyName == null || familyDesc.getName().equals(familyName)) {
            schemaFamily.clearName();
        }
        Dbserver.ColumnFamilyAttr.Builder builder = Dbserver.ColumnFamilyAttr.newBuilder();
        FieldPath jsonFamilyPath = familyDescImpl.getJsonFieldPath();
        if (!forAlter && jsonFamilyPath != null && !jsonFamilyPath.equals((Object)FieldPath.EMPTY)) {
            builder.setJsonFamilyPath(jsonFamilyPath.asPathString());
        }
        return builder.setSchFamily(schemaFamily).build();
    }
}

