/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db;

import com.mapr.db.Admin;
import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.FamilyDescriptor;
import com.mapr.db.Mutation;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.FamilyDescriptorImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.ojai.DBDocumentBuilder;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.MutationImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.DocumentBuilder;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.beans.BeanCodec;
import org.ojai.exceptions.DecodingException;
import org.ojai.json.Json;

public class MapRDB {
    public static boolean tableExists(String tablePath) throws DBException {
        try (Admin admin = MapRDB.newAdmin();){
            boolean bl = admin.tableExists(tablePath);
            return bl;
        }
    }

    public static Table createTable(String tablePath) throws DBException {
        try (Admin admin = MapRDB.newAdmin();){
            Table table = admin.createTable(MapRDB.newTableDescriptor(tablePath).setInsertionOrder(true));
            return table;
        }
    }

    public static boolean deleteTable(String tablePath) throws DBException {
        try (Admin admin = MapRDB.newAdmin();){
            boolean bl = admin.deleteTable(tablePath);
            return bl;
        }
    }

    public static Table getTable(String pathName) throws DBException {
        return MapRDB.getTable(new Path(pathName));
    }

    public static Table getTable(Path path) throws DBException {
        return new MapRDBTableImpl(path, new Configuration());
    }

    public static Admin newAdmin() throws DBException {
        return new AdminImpl();
    }

    public static Admin newAdmin(Configuration c) throws DBException {
        return new AdminImpl(c);
    }

    public static TableDescriptor newTableDescriptor() {
        return new TableDescriptorImpl();
    }

    public static TableDescriptor newTableDescriptor(String tablePath) {
        return new TableDescriptorImpl(new Path(tablePath));
    }

    public static TableDescriptor newTableDescriptor(Path tablePath) {
        return new TableDescriptorImpl(tablePath);
    }

    @Deprecated
    public static TableDescriptor newTableDescriptor(boolean insertionOrder) {
        return new TableDescriptorImpl(insertionOrder);
    }

    public static FamilyDescriptor newFamilyDescriptor() {
        return new FamilyDescriptorImpl();
    }

    public static FamilyDescriptor newDefaultFamilyDescriptor() {
        return new FamilyDescriptorImpl("default", FieldPath.EMPTY);
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, String jsonPath) {
        return new FamilyDescriptorImpl(familyName, jsonPath);
    }

    public static FamilyDescriptor newFamilyDescriptor(String familyName, FieldPath jsonPath) {
        return new FamilyDescriptorImpl(familyName, jsonPath);
    }

    public static DBDocument newDocument() {
        return new DBDocumentImpl();
    }

    public static DBDocument newDocument(String jsonString) throws DecodingException {
        DocumentReader reader = Json.newDocumentReader((String)jsonString);
        DBDocumentBuilder writer = new DBDocumentBuilder();
        Json.writeReaderToBuilder((DocumentReader)reader, (DocumentBuilder)writer);
        return writer.getDocument();
    }

    public static DBDocument newDocument(Object bean) throws DecodingException {
        return (DBDocument)BeanCodec.decode((DocumentBuilder)MapRDB.newDocumentBuilder(), (Object)bean);
    }

    public static DocumentBuilder newDocumentBuilder() {
        return new DBDocumentBuilder();
    }

    public static Mutation newMutation() {
        return new MutationImpl();
    }

    public static Condition newCondition() {
        return new ConditionImpl();
    }

    private MapRDB() {
    }
}

