/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestTableOps
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestTableOps.class);
    private static final String TABLE_NAME = "testtable-TestTableOps";
    private static Table table;

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        table.setOption(Table.TableOption.BUFFERWRITE, false);
        table.insertOrReplace(Datasets.SIMPLE_KEYS[0], Datasets.SIMPLE_RECORDS[0]);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testSimpleGet() throws IOException {
        Assert.assertNotNull((Object)table.findById(Datasets.SIMPLE_KEYS[0]));
        Assert.assertNull((Object)table.findById(Datasets.SIMPLE_KEYS[1]));
    }
}

