/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Mutation;
import com.mapr.db.Table;
import com.mapr.db.tests.tableops.TestMapRDBWithCluster;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestMapRDBWithClusterConc
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestMapRDBWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestMapRDBWithClusterConc";

    @BeforeClass
    public static void startupBeforeClass() throws IOException {
        DBTests.createOrReplaceTable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupAfterClass() throws IOException, Exception {
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentWriteTest() throws Exception {
        int i;
        Table table = null;
        int nthreads = 10;
        table = DBTests.getTable(TABLE_NAME);
        DBDocument record = MapRDB.newDocument();
        for (int i2 = 0; i2 < nthreads; ++i2) {
            record.set("F" + i2, "old F" + i2);
        }
        table.insertOrReplace("record0", (Document)record);
        table.flush();
        ExecutorService executor = Executors.newFixedThreadPool(nthreads);
        Future[] futures = new Future[nthreads];
        Callable[] workers = new Callable[nthreads];
        Mutation[] mutations = new Mutation[nthreads];
        for (i = 0; i < nthreads; ++i) {
            mutations[i] = MapRDB.newMutation().setOrReplace("F" + i, "new F" + i).build();
            workers[i] = new mutationCallable(TABLE_NAME, "record0", mutations[i], i);
        }
        for (i = 0; i < nthreads; ++i) {
            futures[i] = executor.submit(workers[i]);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        for (i = 0; i < nthreads; ++i) {
            futures[i].get();
        }
    }

    public class mutationCallable
    implements Callable {
        String tableName;
        Mutation mutation;
        String record;
        int idx;

        public mutationCallable(String TABLE_NAME, String record, Mutation mutation, int idx) {
            this.tableName = TABLE_NAME;
            this.mutation = mutation;
            this.record = record;
            this.idx = idx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object call() throws Exception {
            try (Table table = null;){
                table = DBTests.getTable(TestMapRDBWithClusterConc.TABLE_NAME);
                table.update(this.record, this.mutation);
                table.flush();
                DBDocument dBDocument = table.findById("record0");
            }
            return null;
        }
    }
}

