/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.Admin;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Mutation;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TableDescriptorImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.StressTest;
import java.io.IOException;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StressTest.class})
public class TestKeepDeletes
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestKeepDeletes.class);
    private static final String TABLE_NAME = "/tmp/testtable-KeepDeletesTest";

    @Test
    public void testKeepDeletes() throws Exception {
        DBDocumentImpl r;
        int i;
        int i2;
        DBTests.admin().deleteTable(TABLE_NAME);
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl td = (TableDescriptorImpl)MapRDB.newTableDescriptor((String)TABLE_NAME);
        td.setDeleteTTL(20L);
        MapRDBTableImpl t = (MapRDBTableImpl)admin.createTable((TableDescriptor)td);
        t.setOption(Table.TableOption.EXCLUDEID, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.DECODE_TIMESTAMP, true);
        int numRows = 10;
        for (i2 = 0; i2 < numRows; ++i2) {
            DBDocument r2 = MapRDB.newDocument();
            r2.set("K1", "V1");
            r2.set("K2", "V2");
            r2.set("K3[0]", 100).set("K3[1]", "Hello").set("K3[2]", 5000);
            t.insertOrReplace("Key" + i2, (Document)r2);
        }
        t.flush();
        for (i2 = 0; i2 < numRows / 2; ++i2) {
            t.delete("Key" + i2);
        }
        for (i2 = numRows / 2; i2 < numRows; ++i2) {
            Mutation m = MapRDB.newMutation();
            m.delete("K1");
            t.update("Key" + i2, m);
        }
        t.flush();
        DocumentStream s = t.find();
        Iterator iter = s.iterator();
        for (i = 0; i < numRows / 2; ++i) {
            r = (DBDocumentImpl)iter.next();
            _logger.info("KEY '{}', value '{}]", (Object)r.getIdAsString(), (Object)r);
            _logger.info("KEY '{}' value '{}'", (Object)r.getIdAsString(), (Object)r.toStringWithTimestamp());
            Assert.assertEquals((Object)("Key" + i), (Object)r.getIdAsString());
            Iterator fIter = r.iterator();
            Assert.assertEquals((Object)false, (Object)fIter.hasNext());
        }
        for (i = numRows / 2; i < numRows; ++i) {
            r = (DBDocumentImpl)iter.next();
            _logger.info("KEY '{}', value '{}]", (Object)r.getIdAsString(), (Object)r);
            _logger.info("KEY '{}' value '{}'", (Object)r.getIdAsString(), (Object)r.toStringWithTimestamp());
            Assert.assertEquals((Object)("Key" + i), (Object)r.getIdAsString());
            Assert.assertEquals((Object)Value.Type.NULL, (Object)r.getValue("K1").getType());
            Assert.assertEquals((Object)"V2", (Object)r.getString("K2"));
        }
        Thread.sleep(25000L);
        s = t.find();
        iter = s.iterator();
        for (i = numRows / 2; i < numRows; ++i) {
            r = (DBDocumentImpl)iter.next();
            _logger.info("KEY '{}', value '{}]", (Object)r.getIdAsString(), (Object)r);
            _logger.info("KEY '{}' value '{}'", (Object)r.getIdAsString(), (Object)r.toStringWithTimestamp());
            Assert.assertEquals((Object)("Key" + i), (Object)r.getIdAsString());
            Assert.assertNull((Object)r.getValue("K1"));
            Assert.assertEquals((Object)"V2", (Object)r.getString("K2"));
        }
    }

    @Test
    public void testGetTimestamp() throws Exception {
        int i;
        DBTests.admin().deleteTable(TABLE_NAME);
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl td = (TableDescriptorImpl)MapRDB.newTableDescriptor((String)TABLE_NAME);
        MapRDBTableImpl t = (MapRDBTableImpl)admin.createTable((TableDescriptor)td);
        t.setOption(Table.TableOption.EXCLUDEID, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.DECODE_TIMESTAMP, true);
        int numRows = 10;
        for (i = 0; i < numRows; ++i) {
            DBDocument r = MapRDB.newDocument();
            r.set("K1", "V1");
            r.set("K2", "V2");
            r.set("Map1.Map2.Field1", 10);
            r.set("K3[0]", 100).set("K3[1]", "Hello").set("K3[2]", 5000).set("K3[3].field1.field2", 15000);
            t.insertOrReplace("Key" + i, (Document)r);
        }
        t.flush();
        for (i = 0; i < numRows / 2; ++i) {
            t.delete("Key" + i);
        }
        for (i = numRows / 2; i < numRows; ++i) {
            Mutation m = MapRDB.newMutation();
            m.delete("K1");
            t.update("Key" + i, m);
        }
        t.flush();
        DocumentStream s = t.find();
        for (DBDocumentImpl r : s) {
            _logger.info("KEY '{}', value '{}]", (Object)r.getIdAsString(), (Object)r);
            _logger.info("KEY '{}' value '{}'", (Object)r.getIdAsString(), (Object)r.toStringWithTimestamp());
        }
    }

    @Test
    public void testComprateKeyValueWithTimestamp() throws IOException {
        DBTests.admin().deleteTable(TABLE_NAME);
        Admin admin = MapRDB.newAdmin();
        TableDescriptorImpl td = (TableDescriptorImpl)MapRDB.newTableDescriptor((String)TABLE_NAME);
        td.setDeleteTTL(100L);
        MapRDBTableImpl t = (MapRDBTableImpl)admin.createTable((TableDescriptor)td);
        t.setOption(Table.TableOption.EXCLUDEID, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.GET_DELETES, true);
        t.setPrivateOption(MapRDBTableImpl.TablePrivateOption.DECODE_TIMESTAMP, true);
        DBDocument r = MapRDB.newDocument();
        r.set("K1", "V1");
        r.set("K2", "V2");
        r.set("Map1.Map2.Field1", 10);
        r.set("K3[0]", 100).set("K3[1]", "Hello").set("K3[2]", 5000).set("K3[3].field1.field2", 15000);
        t.insertOrReplace("Key", (Document)r);
        t.flush();
        Mutation m = MapRDB.newMutation();
        m.delete("K1");
        t.update("Key", m);
        t.flush();
        DBDocumentImpl rec1 = (DBDocumentImpl)t.findById("Key");
        DBDocumentImpl rec2 = (DBDocumentImpl)t.findById("Key");
        boolean matched = KeyValue.equals((KeyValue)rec1, (KeyValue)rec2, (boolean)true, (boolean)true, null, null);
        Assert.assertTrue((boolean)matched);
        rec1 = (DBDocumentImpl)t.findById("Key");
        m = MapRDB.newMutation();
        m.setOrReplace("K1", 500);
        m.delete("K3[2]");
        t.update("Key", m);
        t.flush();
        rec2 = (DBDocumentImpl)t.findById("Key");
        _logger.info("rec1 '{}'", (Object)rec1.toStringWithTimestamp());
        _logger.info("rec2 '{}'", (Object)rec2.toStringWithTimestamp());
        matched = KeyValue.equals((KeyValue)rec1, (KeyValue)rec2, (boolean)true, (boolean)true, null, null);
        Assert.assertFalse((boolean)matched);
        _logger.info("rec1 '{}'", (Object)rec1.toStringWithTimestamp());
        _logger.info("rec2 '{}'", (Object)rec2.toStringWithTimestamp());
    }
}

