/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.ControlInfo;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.ojai.DBDocumentReader;
import com.mapr.db.ojai.DBDocumentReaderBase;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.util.Values;

@Category(value={ClusterTest.class})
public class TestDBDocumentReader
extends BaseTest {
    private Document getRecord() {
        DBDocumentImpl r = new DBDocumentImpl();
        r.set("map.a", "eureka");
        r.set("map.b", 134566);
        HashMap<String, Cloneable> m = new HashMap<String, Cloneable>();
        HashMap<String, String> m2 = new HashMap<String, String>();
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(Values.parseDate((String)"2014-06-22"));
        l.add(127);
        m.put("x1", Values.parseTime((String)"11:20:30.450-08:00"));
        m.put("x2", Values.parseTimestamp((String)"2009-02-23T00:00:00.000-08:00"));
        m2.put("y1", "pqrs");
        m2.put("y2", null);
        l.add(m2);
        ArrayList<Comparable<Boolean>> l2 = new ArrayList<Comparable<Boolean>>();
        l2.add(Boolean.valueOf(true));
        l2.add(Double.valueOf(222.111));
        l2.add(ByteBuffer.wrap("abcd".getBytes()));
        l.add(l2);
        m.put("inner", l);
        r.set("nestedmap", m);
        r.set("doubleval", 12345.6789);
        return r;
    }

    private Document getRecordWithArray() {
        Document r = this.getRecord();
        ArrayList<Comparable<Boolean>> l = new ArrayList<Comparable<Boolean>>();
        l.add(Boolean.valueOf(true));
        l.add(new BigDecimal(11111.2222));
        r.set("map.c", l);
        return r;
    }

    private void iterateOverTokens(DocumentReader reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        while ((et = reader.next()) != null) {
            if (et == DocumentReader.EventType.STRING) {
                if (fieldName.equals("y1")) {
                    Assert.assertEquals((Object)true, (Object)reader.getString().equals("pqrs"));
                }
                if (!fieldName.equals("val1")) continue;
                Assert.assertEquals((Object)true, (Object)reader.getString().equals("abracadabra"));
                continue;
            }
            if (et == DocumentReader.EventType.INT) {
                if (!fieldName.equals("val1")) continue;
                Assert.assertEquals((long)1345L, (long)reader.getInt());
                continue;
            }
            if (et == DocumentReader.EventType.FIELD_NAME) {
                fieldName = reader.getFieldName();
                continue;
            }
            if (et == DocumentReader.EventType.DECIMAL) {
                BigDecimal bigd = reader.getDecimal();
                BigDecimal d2 = new BigDecimal("9888.11123");
                Assert.assertEquals((Object)true, (Object)bigd.equals(d2));
                continue;
            }
            if (et == DocumentReader.EventType.DATE) {
                Date d = reader.getDate();
                Assert.assertEquals((Object)true, (Object)Values.toDateStr((Date)d).equals("2014-06-22"));
                continue;
            }
            if (et == DocumentReader.EventType.TIME) {
                Time t = reader.getTime();
                Assert.assertEquals((Object)Values.parseTime((String)"11:20:30.450-08:00"), (Object)t);
                continue;
            }
            if (et == DocumentReader.EventType.TIMESTAMP) {
                Timestamp ts = reader.getTimestamp();
                Assert.assertEquals((Object)Values.parseTimestamp((String)"2009-02-23T00:00:00.000-08:00"), (Object)ts);
                continue;
            }
            if (et != DocumentReader.EventType.BOOLEAN) continue;
            Assert.assertEquals((Object)true, (Object)reader.getBoolean());
        }
    }

    @Test
    public void testMultiLevelMap() throws Exception {
        Document r = this.getRecord();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("val1", 1345);
        m.put("val2", "abracadabra");
        ArrayList<Comparable<BigDecimal>> l = new ArrayList<Comparable<BigDecimal>>();
        l.add(new BigDecimal("9888.11123"));
        l.add(Boolean.valueOf(true));
        r.set("map.array", l);
        r.set("map.secondmap", m);
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.insertOrReplace("k1", r);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        Iterator iter = rs.documentReaders().iterator();
        if (iter.hasNext()) {
            DocumentReader reader = (DocumentReader)iter.next();
            this.iterateOverTokens(reader);
        }
        myTab.close();
    }

    @Test
    public void testWithEmptyTable() throws Exception {
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        Iterator iter = rs.documentReaders().iterator();
        if (iter.hasNext()) {
            DocumentReader reader = (DocumentReader)iter.next();
            this.iterateOverTokens(reader);
        }
        myTab.close();
    }

    @Test
    public void testWithRecordReaderIterable() throws Exception {
        Document r = this.getRecord();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("val1", 1345);
        m.put("val2", "abracadabra");
        ArrayList<Comparable<BigDecimal>> l = new ArrayList<Comparable<BigDecimal>>();
        l.add(new BigDecimal(9888.11123));
        l.add(Boolean.valueOf(true));
        r.set("map.array", l);
        r.set("map.secondmap", m);
        Table myTab = DBTests.createOrReplaceTable("mytab");
        myTab.setOption(Table.TableOption.EXCLUDEID, false);
        myTab.insertOrReplace("k1", r);
        myTab.insertOrReplace("k2", r);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream stream = myTab.find();
        int recordCount = 0;
        for (DocumentReader reader : stream.documentReaders()) {
            ++recordCount;
        }
        Assert.assertEquals((long)2L, (long)recordCount);
        myTab.close();
    }

    @Test
    public void testDelayedDOMCreation() throws Exception {
        Document r = this.getRecord();
        Table myTab = DBTests.createOrReplaceTable("mytab");
        Table newTab = DBTests.createOrReplaceTable("newTab");
        myTab.insertOrReplace("k1", r);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        Iterator iter = rs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            newTab.insertOrReplace((Document)iter.next());
            ++i;
        }
        newTab.flush();
        myTab.close();
        DBDocument rec = newTab.findById("k1");
        Assert.assertEquals((Object)"eureka", (Object)rec.getString("map.a"));
        Assert.assertEquals((long)127L, (long)rec.getInt("nestedmap.inner[1]"));
        newTab.close();
    }

    @Test
    public void testTimeDescriptor() throws Exception {
        Document doc = this.getRecord();
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", doc);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.iterateOverReader(reader);
        }
    }

    private void iterateOverReader(DocumentReader r) {
        DocumentReader.EventType event = null;
        while ((event = r.next()) != null) {
            DBDocumentReader r1;
            if (r instanceof DBDocumentReader) {
                r1 = (DBDocumentReader)r;
                if (event == DocumentReader.EventType.END_MAP || event == DocumentReader.EventType.END_ARRAY) continue;
                Assert.assertEquals((Object)false, (Object)r1.getControlInfo().isDelete());
                continue;
            }
            r1 = (DBDOMDocumentReader)r;
            if (event == DocumentReader.EventType.END_MAP || event == DocumentReader.EventType.END_ARRAY) continue;
            Assert.assertEquals((Object)false, (Object)r1.getControlInfo().isDelete());
        }
    }

    private void checkIdField(DocumentReader reader, boolean checkFound) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        boolean foundId = false;
        while ((et = reader.next()) != null) {
            if (et != DocumentReader.EventType.FIELD_NAME || (fieldName = reader.getFieldName()) != "_id") continue;
            foundId = true;
            et = reader.next();
            Assert.assertNotNull((Object)et);
            Assert.assertEquals((Object)"k1", (Object)reader.getString());
        }
        Assert.assertEquals((Object)checkFound, (Object)foundId);
    }

    @Test
    public void testRowkeyParsing() throws Exception {
        DBDocument doc = MapRDB.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", (Document)doc);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.checkIdField(reader, true);
        }
        myTab.setOption(Table.TableOption.EXCLUDEID, true);
        rs = myTab.find();
        for (DocumentReader reader : rs.documentReaders()) {
            this.checkIdField(reader, false);
        }
        myTab.close();
    }

    private void iterateOverDBDocumentReaderBase(DBDocumentReaderBase reader) {
        DocumentReader.EventType et = null;
        String fieldName = null;
        ControlInfo ctlInfo = reader.getControlInfo();
        Assert.assertEquals((Object)false, (Object)ctlInfo.isDelete());
        while ((et = reader.next()) != null) {
            if (et == DocumentReader.EventType.FIELD_NAME) {
                fieldName = reader.getFieldName();
            } else if (et == DocumentReader.EventType.STRING) {
                if (fieldName.equals("a")) {
                    Assert.assertEquals((Object)"xyz", (Object)reader.getString());
                }
            } else if (et == DocumentReader.EventType.BOOLEAN && fieldName.equals("b")) {
                Assert.assertEquals((Object)false, (Object)reader.getBoolean());
            }
            if (et == DocumentReader.EventType.END_MAP || et == DocumentReader.EventType.END_ARRAY) continue;
            ctlInfo = reader.getControlInfo();
        }
    }

    @Test
    public void testBaseInterface() throws Exception {
        DBDocument doc = MapRDB.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("k1", (Document)doc);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        for (DBDocumentReaderBase reader : rs.documentReaders()) {
            this.iterateOverDBDocumentReaderBase(reader);
        }
    }

    @Test
    public void testReaderFromDocumentImpl() throws Exception {
        DBDocument doc = MapRDB.newDocument();
        doc.set("a", "xyz");
        doc.set("b", false);
        doc.set("c", 222);
        MapRDBTableImpl myTab = (MapRDBTableImpl)DBTests.createOrReplaceTable("myTab");
        myTab.insertOrReplace("key1", (Document)doc);
        myTab.flush();
        myTab.setOption(Table.TableOption.KEEPINSERTIONORDER, false);
        DocumentStream rs = myTab.find();
        for (DBDocument docFromTable : rs) {
            DBDocumentReaderBase reader = (DBDocumentReaderBase)docFromTable.asReader();
            Assert.assertEquals((Object)DocumentReader.EventType.FIELD_NAME, (Object)reader.next());
            Assert.assertEquals((Object)"_id", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"key1", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.FIELD_NAME, (Object)reader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((Object)"xyz", (Object)reader.getString());
            DBDocumentReaderBase newReader = (DBDocumentReaderBase)docFromTable.asReader();
            Assert.assertEquals((Object)DocumentReader.EventType.FIELD_NAME, (Object)newReader.next());
            Assert.assertEquals((Object)"_id", (Object)newReader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)newReader.next());
            Assert.assertEquals((Object)"key1", (Object)newReader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)newReader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.FIELD_NAME, (Object)newReader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)newReader.next());
            Assert.assertEquals((Object)"xyz", (Object)newReader.getString());
        }
        myTab.close();
    }
}

