/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.Condition;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Mutation;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DocumentExistsException;
import com.mapr.db.exceptions.DocumentNotFoundException;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestCheckAndXXX_MultiFamilies
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCheckAndXXX_MultiFamilies.class);
    private static final String TABLE_NAME = "testtable-TestCheckAndXXX_MultiFamilies";

    private Table createOrReplaceTable() throws IOException {
        return DBTests.createOrReplaceTable(TABLE_NAME, (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"a.b.c", (Object)"f2", (Object)"p.q.r", (Object)"f3", (Object)"a.b.e")).setOption(Table.TableOption.BUFFERWRITE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutateMultiFamilies() throws Exception {
        try (Table table = this.createOrReplaceTable();){
            DBDocument developer = MapRDB.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            table.insertOrReplace(Datasets.IDS[0], (Document)developer);
            developer.set("p.q.r.s", 104);
            table.insertOrReplace(Datasets.IDS[1], (Document)developer);
            Condition condition = MapRDB.newCondition().and().equals("a.b.e", Datasets.ADDRESSES[0]).is("p.q.r.s", Condition.Op.EQUAL, 105).close().build();
            Mutation rm = MapRDB.newMutation();
            rm.set("x.y.z", 42);
            rm.increment("p.q.r.s", 10);
            Assert.assertTrue((boolean)table.checkAndMutate(Datasets.IDS[0], condition, rm));
            DBDocument newRec = table.findById(Datasets.IDS[0]);
            Assert.assertNotNull((Object)newRec);
            Assert.assertEquals((long)42L, (long)newRec.getInt("x.y.z"));
            Assert.assertEquals((long)115L, (long)newRec.getInt("p.q.r.s"));
            Assert.assertFalse((boolean)table.checkAndMutate(Datasets.IDS[1], condition, rm));
            newRec = table.findById(Datasets.IDS[1]);
            Assert.assertNotNull((Object)newRec);
            try {
                newRec.getInt("x.y.z");
                Assert.fail((String)"Mutation succeeded when it shouldn't have.");
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            Assert.assertEquals((long)104L, (long)newRec.getInt("p.q.r.s"));
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertMultiFamily() throws Exception {
        try (Table table = this.createOrReplaceTable();){
            DBDocument developer = MapRDB.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            table.insert(Datasets.IDS[0], (Document)developer);
            try {
                table.insert(Datasets.IDS[0], (Document)developer);
                Assert.fail((String)"Shouldn't be able to insert same record twice");
            }
            catch (DocumentExistsException e) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceMultiFamily() throws Exception {
        try (Table table = this.createOrReplaceTable();){
            DBDocument developer = MapRDB.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            try {
                table.replace(Datasets.IDS[0], (Document)developer);
                Assert.fail((String)"Shouldn't be able to replace a non-existent record");
            }
            catch (DocumentNotFoundException e) {
                // empty catch block
            }
            table.insert(Datasets.IDS[0], (Document)developer);
            table.replace(Datasets.IDS[0], (Document)developer);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }
}

