/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.DBDocument;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.Value;

@Category(value={SimpleTest.class})
public class SetIDTest
extends BaseTest {
    @Test
    public void testSetID() throws IOException {
        DBDocument rec = new DBDocumentImpl().set("_id", "ROWKEY").set("map.string", "string").set("map.byte", (byte)100).set("map.short", (short)10000).set("map.int", 50000).set("map.long", 12345678999L).set("map.float", 10.1234f).set("map.double", 10.1234567891).set("map._id", 10).setNull("map.NULL");
        Assert.assertEquals((Object)rec.getIdString(), (Object)"ROWKEY");
        Assert.assertEquals((long)rec.getInt("map._id"), (long)10L);
        ByteBuffer buf = RowcolCodec.encode((Document)rec);
        ByteBuffer newRowKey = IdCodec.encode((String)"NEW ROW KEY");
        DBDocument rec2 = RowcolCodec.decode((ByteBuffer)buf, (ByteBuffer)newRowKey, (boolean)false, (boolean)false);
        Assert.assertEquals((Object)IdCodec.asString((Value)rec2.getId()), (Object)"NEW ROW KEY");
        boolean foundKey = false;
        for (Map.Entry e : rec2) {
            if (!((String)e.getKey()).equals("_id")) continue;
            foundKey = true;
            break;
        }
        Assert.assertEquals((Object)foundKey, (Object)true);
        rec2 = RowcolCodec.decode((ByteBuffer)buf, (ByteBuffer)newRowKey, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)IdCodec.asString((Value)rec2.getId()), (Object)"NEW ROW KEY");
        foundKey = false;
        for (Map.Entry e : rec2) {
            if (!((String)e.getKey()).equals("_id")) continue;
            foundKey = true;
            Assert.assertEquals((Object)((Value)e.getValue()).getType(), (Object)Value.Type.BINARY);
            break;
        }
        Assert.assertEquals((Object)foundKey, (Object)false);
    }
}

