/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.rowcol;

import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.rowcol.InsertContext;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.MutationImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.rowcol.TimeDescriptor;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SimpleTest.class})
public class MutationTest
extends BaseTest {
    @Test
    public void SetRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b", 10).set("a.d", "Anurag").set("Address.zip", 94086).set("Address.Street", "Washington Avenue").set("Field1", 1000.0).build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Washington Avenue");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((double)kv.getDouble(), (double)1000.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void SetOrReplaceWithoutArrayRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.setOrReplace("a.b", 10).setOrReplace("a.d", "Anurag").setOrReplace("Address.zip", 94086).setOrReplace("Address.Street", "Washington Avenue").setOrReplace("Field1", 1000.0).build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)false);
    }

    @Test
    public void SetOrReplaceRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.setOrReplace("a.b", 10).setOrReplace("a.d", "Anurag").setOrReplace("Address.zip", 94086).setOrReplace("Address.Street", "Washington Avenue").setOrReplace("Field1", 1000.0).setOrReplace("Array1[50][100]", "Hello").setOrReplace("Array1[5][10]", 1.1).setOrReplace("A1[1].A2[2].A3[3]", -500).build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[1][0]");
        Assert.assertEquals((Object)kv.getString(), (Object)"Hello");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Array1[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[0][0]");
        Assert.assertEquals((double)kv.getDouble(), (double)1.1, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("A1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0].A3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0].A3[0]");
        Assert.assertEquals((long)kv.getInt(), (long)-500L);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((Object)kv.getString(), (Object)"Washington Avenue");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET_OR_REPLACE);
        Assert.assertEquals((double)kv.getDouble(), (double)1000.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void IncrementRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.increment("a.b", 10).increment("a.d", 500.325423).increment("Address.zip", 94086).increment("Field1", new BigDecimal("100.1231213434235235234")).increment("Array1[50][100]", -500000000000L).increment("Array1[5][10]", -1.234E-7).increment("A1[1].A2[2].A3[3]", new BigDecimal("-1.11111111111111111111111111")).build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((double)kv.getDouble(), (double)500.325423, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((long)kv.getInt(), (long)94086L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)kv.getDecimal(), (Object)new BigDecimal("100.1231213434235235234"));
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[1][0]");
        Assert.assertEquals((double)kv.getLong(), (double)-5.0E11, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Array1[0][0]");
        Assert.assertEquals((double)kv.getDouble(), (double)-1.234E-7, (double)0.0);
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0].A3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("A1[0].A2[0].A3[0]");
        Assert.assertEquals((Object)kv.getDecimal(), (Object)new BigDecimal("-1.11111111111111111111111111"));
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.INCREMENT);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
    }

    @Test
    public void DeleteRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a.b").delete("a.d").delete("Address.zip").delete("Address.Street").delete("Field1").build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)false);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.d");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.zip");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void MixedOpRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a.b", 10).delete("a.c").set("b.c", 5000).delete("b").set("a.c.f", "Hello").delete("Address.Street").delete("Field1").build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a.b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a.c.f");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Address");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Address.Street");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void ArraySetRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.set("a[5]", 10).set("a[10]", "Anurag").set("b[2000]", 10.0).set("twodim[20][30]", "TWODIM20_30").set("twodim[200][300]", "TWODIM200_300").build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((long)kv.getInt(), (long)10L);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"Anurag");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((double)kv.getDouble(), (double)10.0, (double)0.0);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[0][0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"TWODIM20_30");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim[1][0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.SET);
        Assert.assertEquals((Object)kv.getString(), (Object)"TWODIM200_300");
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }

    @Test
    public void ArrayDeleteRecordMutation() throws IOException {
        MutationImpl mutation = (MutationImpl)MapRDB.newMutation();
        mutation.delete("a[5]").delete("a[10]").delete("b[2000]").delete("twodim[20][30]").delete("twodim[200][300]").delete("Field1[5].Field2[6].Field3").build();
        Assert.assertEquals((Object)mutation.needsReadOnServer(), (Object)true);
        ByteBuffer b = mutation.rowcolSerialize();
        DBDocument rec = RowcolCodec.decode((ByteBuffer)b);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)((KeyValue)rec)), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)((KeyValue)rec)), (Object)false);
        KeyValue kv = (KeyValue)rec.getValue("a");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("a[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("a[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("b[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[1]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("twodim[0][0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("twodim[1][0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
        kv = (KeyValue)rec.getValue("Field1");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[0].Field2");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[0].Field2[0]");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.NONE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)false);
        kv = (KeyValue)rec.getValue("Field1[0].Field2[0].Field3");
        Assert.assertEquals((Object)kv.getOpType(), (Object)InsertContext.OpType.DELETE);
        Assert.assertEquals((Object)TimeDescriptor.isCreateTimeValid((KeyValue)kv), (Object)false);
        Assert.assertEquals((Object)TimeDescriptor.isUpdateTimeValid((KeyValue)kv), (Object)true);
        Assert.assertEquals((Object)TimeDescriptor.isDeleteTimeValid((KeyValue)kv), (Object)true);
    }
}

