/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.Condition;
import com.mapr.db.DBConstants;
import com.mapr.db.DBDocument;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestConditionWithCluster
extends BaseTest
implements Datasets {
    private static final Logger _logger = LoggerFactory.getLogger(TestConditionWithCluster.class);
    private static final String TABLE_NAME = "testtable-TestConditionWithCluster";
    static Table table;

    @BeforeClass
    public static void setUpBeforeClass() throws IOException {
        table = DBTests.createOrReplaceTable(TABLE_NAME);
        for (int i = 0; i < ENGINEERS.length; ++i) {
            table.insertOrReplace(IDS[i], ENGINEERS[i]);
        }
        table.flush();
        _logger.info("Records inserted.");
    }

    @AfterClass
    public static void cleanupAfterClass() throws Exception {
        if (table != null) {
            table.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void testGetWithPositiveCondition() throws Exception {
        Condition condition = MapRDB.newCondition().and().equals("name", NAMES[0]).typeOf("address.phones", Value.Type.ARRAY).exists("address.phones[1]").is("address.phones[1]", Condition.Op.EQUAL, 5556667777L).close().build();
        _logger.info("Executing get() with " + condition.toString());
        DBDocument result = table.findById(IDS[0], condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned record: " + result);
    }

    @Test
    public void testGetWithConditionWhenRowExistOrNotExist() throws Exception {
        Condition condition = MapRDB.newCondition().exists(DBConstants.ROWKEY_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        DBDocument result = table.findById(IDS[8], condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using positive condition with existing row, returned record: " + result);
        condition = MapRDB.newCondition().notExists(DBConstants.ROWKEY_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[8], condition);
        Assert.assertNull((Object)result);
        _logger.info("Using negetive condition with existing row, returned record: " + result);
        condition = MapRDB.newCondition().exists(DBConstants.ROWKEY_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[9], condition);
        Assert.assertNull((Object)result);
        _logger.info("Using negetive condition with existing row, returned record: " + result);
        condition = MapRDB.newCondition().notExists(DBConstants.ROWKEY_FIELD).build();
        _logger.info("Executing get() with " + condition.toString());
        result = table.findById(IDS[9], condition);
        Assert.assertNull((Object)result);
        _logger.info("Using positive condition with existing row, returned record: " + result);
    }

    @Test
    public void testGetWithPositiveLikeCondition() throws Exception {
        Condition condition = MapRDB.newCondition().and().equals("name", NAMES[0]).matches("address.street", ".*Pennsylvania Avenue.*").close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        DBDocument result = table.findById(IDS[0], condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned record: " + result);
    }

    @Test
    public void testGetWithSumOfProductCondition() throws Exception {
        Condition condition = MapRDB.newCondition().or().and().is("name.first", Condition.Op.EQUAL, "Michael").is("name.last", Condition.Op.EQUAL, "Corleone").close().is("age", Condition.Op.GREATER, 100).close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        DBDocument result = table.findById(IDS[0], condition);
        Assert.assertNotNull((Object)result);
        _logger.info("Using matching condition, returned record: " + result);
    }

    @Test
    public void testGetWithNegativeCondition() throws Exception {
        Condition condition = MapRDB.newCondition().and().is("name.first", Condition.Op.EQUAL, "Michael").is("name.last", Condition.Op.EQUAL, "Corleone").close().build();
        _logger.info("Exeuting get() with " + condition.toString());
        DBDocument result = table.findById(IDS[0], condition);
        Assert.assertNull((Object)result);
        _logger.info("Using non-matching condition, returned record: " + result);
    }

    @Test
    public void testScanWithPositiveCondition() throws Exception {
        Condition condition = MapRDB.newCondition().and().is("_id", Condition.Op.GREATER, "dev0").is("_id", Condition.Op.LESS, "dev4").is("age", Condition.Op.LESS_OR_EQUAL, 23).close().build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int recordCount = 0;
        for (DBDocument record : stream) {
            ++recordCount;
            double age = Values.asDouble((Value)record.getValue("age"));
            Assert.assertTrue((age <= 23.0 ? 1 : 0) != 0);
            _logger.info("Returned record: id='" + IdCodec.asString((Value)record.getId()) + "', age=" + age);
        }
        Assert.assertEquals((long)2L, (long)recordCount);
    }

    @Test
    public void testScanWithRowkeyLikeCondition() throws Exception {
        String regex = "dev.*";
        Condition condition = MapRDB.newCondition().matches("_id", regex).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int recordCount = 0;
        for (DBDocument record : stream) {
            ++recordCount;
            String id = IdCodec.asString((Value)record.getId());
            Assert.assertTrue((boolean)id.matches(regex));
            _logger.info("Returned record: id='" + id + "', name='" + record.getMap("name") + "', age=" + record.getValue("age"));
        }
        Assert.assertEquals((long)5L, (long)recordCount);
    }

    @Test
    public void testScanWithInCondition() throws Exception {
        Condition condition = MapRDB.newCondition().in("age", (List)ImmutableList.of((Object)1001.82, (Object)Float.valueOf(17.5f), (Object)23, (Object)25.56, (Object)95)).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int recordCount = 0;
        for (DBDocument record : stream) {
            ++recordCount;
            _logger.info("Returned record: id='" + IdCodec.asString((Value)record.getId()) + "', name='" + record.getMap("name") + "', age=" + record.getValue("age"));
        }
        Assert.assertEquals((long)3L, (long)recordCount);
    }

    @Test
    public void testScanWithNotInCondition() throws Exception {
        Condition condition = MapRDB.newCondition().notIn("age", (List)ImmutableList.of((Object)23, (Object)71L, (Object)91, (Object)54.7)).build();
        _logger.info("Exeuting scan() with " + condition.toString());
        DocumentStream stream = table.find(condition);
        Assert.assertNotNull((Object)stream);
        int recordCount = 0;
        for (DBDocument record : stream) {
            ++recordCount;
            _logger.info("Returned record: id='" + IdCodec.asString((Value)record.getId()) + "', name='" + record.getMap("name") + "', age=" + record.getValue("age"));
        }
        Assert.assertEquals((long)5L, (long)recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilterWithMultiFamilies() throws Exception {
        String tableName = "testtable-TestConditionWithCluster-multiFamilies";
        try (Table multiCFTable = DBTests.createOrReplaceTable(tableName, (Map<String, String>)ImmutableMap.of((Object)"f1", (Object)"a.b.c", (Object)"f2", (Object)"p.q.r", (Object)"f3", (Object)"a.b.e")).setOption(Table.TableOption.BUFFERWRITE, false);){
            DBDocument developer = MapRDB.newDocument();
            developer.set("a.b.c.d", NAMES[0]);
            developer.set("a.b.e", ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            multiCFTable.insertOrReplace(IDS[0], (Document)developer);
            developer.set("p.q.r.s", 104);
            multiCFTable.insertOrReplace(IDS[1], (Document)developer);
            Condition condition = MapRDB.newCondition().and().equals("a.b.e", ADDRESSES[0]).is("p.q.r.s", Condition.Op.EQUAL, 105).close().build();
            DocumentStream stream = multiCFTable.find(condition);
            Assert.assertNotNull((Object)stream);
            int recordCount = 0;
            for (DBDocument record : stream) {
                ++recordCount;
                Assert.assertEquals((Object)IDS[0], (Object)IdCodec.asString((Value)record.getId()));
            }
            stream.close();
            Assert.assertEquals((long)1L, (long)recordCount);
            DBDocument row = multiCFTable.findById(IDS[0], condition);
            Assert.assertNotNull((Object)row);
            row = multiCFTable.findById(IDS[1], condition);
            Assert.assertNull((Object)row);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(tableName);
            throw throwable;
        }
        DBTests.deleteTables(tableName);
    }
}

