/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.condition;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.Condition;
import com.mapr.db.DBConstants;
import com.mapr.db.MapRDB;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.Constants;
import com.mapr.db.impl.IdCodec;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Value;
import org.ojai.types.Interval;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestCondition
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCondition.class);
    private static TimeZone defaultTZ;

    @BeforeClass
    public static void setTimeZone() {
        defaultTZ = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
    }

    @AfterClass
    public static void resetTimeZone() {
        defaultTZ = TimeZone.getDefault();
        TimeZone.setDefault(defaultTZ);
    }

    @Test
    public void testRowExist() {
        Condition condition = Constants.ROW_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id != null)");
    }

    @Test
    public void testRowNotExist() {
        Condition condition = Constants.ROW_NOT_EXISTS_CONDITION;
        this.serializeAndCompare(condition, "(_id = null)");
    }

    @Test
    public void testSimpleConditionsNonExistent() {
        Condition condition = MapRDB.newCondition().notExists("nonExistantElem").build();
        this.serializeAndCompare(condition, "(nonExistantElem = null)");
    }

    @Test
    public void testSimpleConditionsExistent() {
        Condition condition = MapRDB.newCondition().exists("existantElem").build();
        this.serializeAndCompare(condition, "(existantElem != null)");
    }

    @Test
    public void testSimpleConditionsNullType() {
        Condition condition = MapRDB.newCondition().typeOf("nullElem", Value.Type.NULL).build();
        this.serializeAndCompare(condition, "(nullElem TYPE_OF NULL)");
    }

    @Test
    public void testSimpleConditionsBool() {
        Condition condition = MapRDB.newCondition().is("boolElem", Condition.Op.EQUAL, false).build();
        this.serializeAndCompare(condition, "(boolElem = false)");
    }

    @Test
    public void testSimpleConditionsString() {
        Condition condition = MapRDB.newCondition().is("stringElem", Condition.Op.GREATER, "stupidity").build();
        this.serializeAndCompare(condition, "(stringElem > \"stupidity\")");
    }

    @Test
    public void testSimpleConditionsInt() {
        Condition condition = MapRDB.newCondition().is("intElem", Condition.Op.NOT_EQUAL, 5).build();
        this.serializeAndCompare(condition, "(intElem != {\"$numberLong\":5})");
    }

    @Test
    public void testSimpleConditionsLong() {
        Condition condition = MapRDB.newCondition().is("longElem", Condition.Op.LESS_OR_EQUAL, 527346237644235L).build();
        this.serializeAndCompare(condition, "(longElem <= {\"$numberLong\":527346237644235})");
    }

    @Test
    public void testSimpleConditionsFloat() {
        Condition condition = MapRDB.newCondition().is("floatElem", Condition.Op.LESS, 3.141592f).build();
        this.serializeAndCompare(condition, "(floatElem < 3.141592)");
    }

    @Test
    public void testSimpleConditionsDouble() {
        Condition condition = MapRDB.newCondition().is("doubleElem", Condition.Op.GREATER_OR_EQUAL, Math.PI).build();
        this.serializeAndCompare(condition, "(doubleElem >= 3.141592653589793)");
    }

    @Test
    @Ignore(value="BigDecimal type not supported")
    public void testSimpleConditionsDecimal() {
        Condition condition = MapRDB.newCondition().is("deceimalElem", Condition.Op.EQUAL, new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068", new MathContext(100))).build();
        this.serializeAndCompare(condition, "(deceimalElem = {\"$decimal\":\"3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068\"})");
    }

    @Test
    public void testSimpleConditionsDate() {
        Condition condition = MapRDB.newCondition().is("dateElem", Condition.Op.NOT_EQUAL, Values.parseDate((String)"1979-08-24")).build();
        this.serializeAndCompare(condition, "(dateElem != {\"$dateDay\":\"1979-08-24\"})");
    }

    @Test
    public void testSimpleConditionsTime() {
        Condition condition = MapRDB.newCondition().is("timeElem", Condition.Op.LESS_OR_EQUAL, Values.parseTime((String)"16:32:00")).build();
        this.serializeAndCompare(condition, "(timeElem <= {\"$time\":\"16:32:00\"})");
    }

    @Test
    public void testSimpleConditionsTimestamp() {
        Condition condition = MapRDB.newCondition().is("timestampElem", Condition.Op.EQUAL, Values.parseTimestamp((String)"1979-08-24T16:32:00.000+05:30")).build();
        this.serializeAndCompare(condition, "(timestampElem = {\"$date\":\"1979-08-24T11:02:00.000Z\"})");
    }

    @Test
    @Ignore(value="Interval type not supported")
    public void testSimpleConditionsInterval() {
        Condition condition = MapRDB.newCondition().is("intervalElem", Condition.Op.GREATER, new Interval(1239213L)).build();
        this.serializeAndCompare(condition, "(intervalElem > {\"$interval\":1239213})");
    }

    @Test
    public void testSimpleConditionsBinary() {
        Condition condition = MapRDB.newCondition().is("binaryElem", Condition.Op.EQUAL, ByteBuffer.wrap(new byte[]{97, 100, 105, 116, 121, 97})).build();
        this.serializeAndCompare(condition, "(binaryElem = {\"$binary\":\"YWRpdHlh\"})");
    }

    @Test
    public void testSimpleConditionsMap() {
        Condition condition = MapRDB.newCondition().equals("mapElem", (Map)ImmutableMap.of((Object)"name", (Object)"hulk", (Object)"weight", (Object)526, (Object)"id", (Object)627131273323L, (Object)"dob", (Object)Values.parseTimestamp((String)"1979-10-12T05:23:00.122+07:00"))).build();
        this.serializeAndCompare(condition, "(mapElem = {\"name\":\"hulk\",\"weight\":{\"$numberLong\":526},\"id\":{\"$numberLong\":627131273323},\"dob\":{\"$date\":\"1979-10-11T22:23:00.122Z\"}})");
    }

    @Test
    public void testSimpleConditionsEmptyMap() {
        ImmutableMap emptyMap = ImmutableMap.of();
        Condition condition = MapRDB.newCondition().equals("emptyMapElem", (Map)emptyMap).build();
        this.serializeAndCompare(condition, "(emptyMapElem = {})");
    }

    @Test
    public void testSimpleConditionsArray() {
        Condition condition = MapRDB.newCondition().equals("listElem", (List)ImmutableList.of((Object)"January", (Object)4, (Object)Values.parseTimestamp((String)"2015-03-14T20:12:21.000+00:00"), (Object)Values.parseDate((String)"1969-12-31"), (Object)Values.parseDate((String)"1970-01-01"), (Object)Values.parseDate((String)"1950-01-26"), (Object)Values.parseTime((String)"11:22:33"))).build();
        this.serializeAndCompare(condition, "(listElem = [\"January\", {\"$numberLong\":4}, {\"$date\":\"2015-03-14T20:12:21.000Z\"}, {\"$dateDay\":\"1969-12-31\"}, {\"$dateDay\":\"1970-01-01\"}, {\"$dateDay\":\"1950-01-26\"}, {\"$time\":\"11:22:33\"}])");
    }

    @Test
    public void testSimpleConditionsEmptyArray() {
        Condition condition = MapRDB.newCondition().equals("emptyListElem", (List)ImmutableList.of()).build();
        this.serializeAndCompare(condition, "(emptyListElem = [])");
    }

    @Test
    public void testSimpleConditionsRegexMatch() {
        Condition condition = MapRDB.newCondition().matches("patternElem", ".*peace$").build();
        this.serializeAndCompare(condition, "(patternElem LIKE \".*peace$\")");
    }

    @Test
    public void testSimpleConditionsRegecNonMatch() {
        Condition condition = MapRDB.newCondition().notMatches("antiPatternElem", ".*war.*").build();
        this.serializeAndCompare(condition, "(antiPatternElem NOT_LIKE \".*war.*\")");
    }

    @Test
    public void testSimpleConditionsIn() {
        Condition condition = MapRDB.newCondition().in("oneInTheListElem", (List)ImmutableList.of((Object)42, (Object)"42", (Object)new Date(42L), (Object)new Time(42L), (Object)new Timestamp(42L))).build();
        this.serializeAndCompare(condition, "(oneInTheListElem IN [{\"$numberLong\":42}, \"42\", {\"$dateDay\":\"1970-01-01\"}, {\"$time\":\"00:00:00.042\"}, {\"$date\":\"1970-01-01T00:00:00.042Z\"}])");
    }

    @Test
    public void testSimpleConditionsNotIn() {
        Condition condition = MapRDB.newCondition().notIn("noneInTheListElem", (List)ImmutableList.of((Object)"gold", (Object)"silver", (Object)"bronze")).build();
        this.serializeAndCompare(condition, "(noneInTheListElem NOT_IN [\"gold\", \"silver\", \"bronze\"])");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConditionCompoundingWihoutBlock() {
        Condition condition = MapRDB.newCondition().is("a", Condition.Op.EQUAL, 6).matches("b", "wrong_condition_grouping").build();
    }

    @Test
    public void testConditionWithId() {
        Condition condition = MapRDB.newCondition().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "pqr").build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdEqual() {
        Condition condition = MapRDB.newCondition().is(DBConstants.ROWKEY_FIELD, Condition.Op.EQUAL, "pqr").build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdNotEqual() {
        Condition condition = MapRDB.newCondition().is(DBConstants.ROWKEY_FIELD, Condition.Op.NOT_EQUAL, "pqr").build();
        Assert.assertTrue((!(condition = ((ConditionImpl)condition).cloneOptimized()).isEmpty() ? 1 : 0) != 0);
        this.checkAndGetRange(condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition, "(_id != \"pqr\")");
    }

    @Test
    public void testConditionWithIdOnLike() {
        Condition condition = MapRDB.newCondition().matches(DBConstants.ROWKEY_FIELD, "device.*").build();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("device"), this.encode("devicf"));
        this.serializeAndCompare(condition, "(_id LIKE \"device.*\")");
    }

    @Test
    public void testConditionWithIdRange() {
        Condition condition = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "pqr").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertTrue((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encode("pqr"), this.encode("uvw"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testConditionWithIdDisjointRange() {
        Condition condition = MapRDB.newCondition().or().is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "pqr").is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, MapRConstants.EMPTY_BYTE_ARRAY, MapRConstants.EMPTY_BYTE_ARRAY);
        this.serializeAndCompare(condition, "((_id < \"pqr\") or (_id > \"uvw\"))");
    }

    @Test
    public void testConditionWithIdReveseRange() {
        Condition condition = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "pqr").is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "uvw").close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encodeStringBinary("uvw\\x00"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testMultiLevelAndConditionsOnId() {
        Condition condition = MapRDB.newCondition().and().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "abc").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "pqr").close().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "rst").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS_OR_EQUAL, "xyz").close().build();
        this.serializeAndCompare(condition, "(((_id > \"abc\") and (_id < \"pqr\")) and (_id >= \"rst\") and (_id <= \"xyz\"))");
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encode("rst"), this.encode("pqr"));
        this.serializeAndCompare(condition);
    }

    @Test
    public void testOrOfAndsConditionsOnId() {
        Condition condition = MapRDB.newCondition().or().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "abc").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "pqr").close().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "efg").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS_OR_EQUAL, "xyz").close().close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        Assert.assertFalse((boolean)condition.isEmpty());
        this.checkAndGetRange(condition, this.encodeStringBinary("abc\\x00"), this.encodeStringBinary("xyz\\x00"));
        this.serializeAndCompare(condition, "(((_id > \"abc\") and (_id < \"pqr\")) or ((_id >= \"efg\") and (_id <= \"xyz\")))");
    }

    @Test
    public void testMultiLevelCondition() {
        Condition condition = this.newComplexCondition1();
        Assert.assertEquals((Object)"((c.u.r != null) and (c.u.r TYPE_OF ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))", (Object)condition.toString());
        this.serializeAndCompare(condition, "((c.u.r != null) and (c.u.r TYPE_OF ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
    }

    @Test
    public void testAddConditionToAnotherCondition() {
        Condition inner = this.newComplexCondition1();
        Condition outer0 = MapRDB.newCondition().condition(inner).build();
        this.serializeAndCompare(outer0, "((c.u.r != null) and (c.u.r TYPE_OF ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer0.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer0);
        Condition outer1 = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "pqr").is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "uvw").condition(inner).close().build();
        outer1 = ((ConditionImpl)outer1).cloneOptimized();
        this.serializeAndCompare(outer1, "((c.u.r != null) and (c.u.r TYPE_OF ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\")))");
        Assert.assertFalse((boolean)outer1.isEmpty());
        Assert.assertEquals((Object)inner, (Object)outer1);
        Condition outer2 = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER_OR_EQUAL, "pqr").is("some.other.field", Condition.Op.EQUAL, 25.69).condition(inner).close().build();
        outer2 = ((ConditionImpl)outer2).cloneOptimized();
        this.serializeAndCompare(outer2, "((some.other.field = 25.69) and ((c.u.r != null) and (c.u.r TYPE_OF ARRAY) and (c.u.r[0].d = 10.5) and ((a.b[4] = {\"$numberLong\":4}) or (b.e.t = \"35\"))))");
        Assert.assertFalse((boolean)outer2.isEmpty());
        Assert.assertNotEquals((Object)inner, (Object)outer2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddConditionToAnotherConditionFail() {
        Condition inner = this.newComplexCondition1();
        MapRDB.newCondition().is("abc", Condition.Op.EQUAL, "pqr").condition(inner).build();
    }

    @Test
    public void testComplexMixCondition() {
        Condition condition = MapRDB.newCondition().and().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "device001").is("price", Condition.Op.GREATER_OR_EQUAL, 75).is(DBConstants.ROWKEY_FIELD, Condition.Op.LESS, "user999").or().is(DBConstants.ROWKEY_FIELD, Condition.Op.GREATER, "parts550").is("price", Condition.Op.LESS_OR_EQUAL, 100).close().close().build();
        condition = ((ConditionImpl)condition).cloneOptimized();
        this.checkAndGetRange(condition, this.encodeStringBinary("device001\\x00"), this.encode("user999"));
        this.serializeAndCompare(condition, "((price >= {\"$numberLong\":75}) and ((_id > \"parts550\") or (price <= {\"$numberLong\":100})))");
    }

    private byte[] encode(String in) {
        return IdCodec.encodeAsBytes((String)in);
    }

    private byte[] encodeStringBinary(String in) {
        return IdCodec.encodeStringBinary((String)in);
    }

    private void serializeAndCompare(Condition condition) {
        this.serializeAndCompare(condition, "<EMPTY>");
    }

    private void serializeAndCompare(Condition condition, String infix) {
        _logger.info("Serializing condition\n{}", (Object)((ConditionImpl)condition).asPrefix());
        ByteBuffer serialized = ((ConditionImpl)condition).getDescriptor().getSerialized();
        Condition newCondition = ConditionImpl.parseFrom((ByteBuffer)serialized);
        Assert.assertEquals((Object)condition, (Object)newCondition);
        Assert.assertEquals((Object)infix, (Object)((ConditionImpl)condition).asInfix());
    }

    private ConditionNode.RowkeyRange checkAndGetRange(Condition condition, byte[] start, byte[] stop) {
        List rowkeyRanges = ((ConditionImpl)condition).getRowkeyRanges();
        Assert.assertEquals((long)1L, (long)rowkeyRanges.size());
        ConditionNode.RowkeyRange rowkeyRange = (ConditionNode.RowkeyRange)rowkeyRanges.get(0);
        _logger.info("{}", (Object)rowkeyRange);
        Assert.assertArrayEquals((byte[])start, (byte[])rowkeyRange.getStartRow());
        Assert.assertArrayEquals((byte[])stop, (byte[])rowkeyRange.getStopRow());
        return rowkeyRange;
    }

    private Condition newComplexCondition1() {
        return MapRDB.newCondition().and().exists("c.u.r").typeOf("c.u.r", Value.Type.ARRAY).is("c.u.r[0].d", Condition.Op.EQUAL, 10.5).or().is("a.b[4]", Condition.Op.EQUAL, 4).is("b.e.t", Condition.Op.EQUAL, "35").close().close().build();
    }
}

