/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcStruct;

public class OrcList<E extends WritableComparable>
extends ArrayList<E>
implements WritableComparable<OrcList<E>> {
    private final TypeDescription childSchema;

    public OrcList(TypeDescription schema) {
        this.childSchema = schema.getChildren().get(0);
    }

    public OrcList(TypeDescription schema, int initialCapacity) {
        super(initialCapacity);
        this.childSchema = schema.getChildren().get(0);
    }

    public void write(DataOutput output) throws IOException {
        Iterator itr = this.iterator();
        output.writeInt(this.size());
        while (itr.hasNext()) {
            WritableComparable obj = (WritableComparable)itr.next();
            output.writeBoolean(obj != null);
            if (obj == null) continue;
            obj.write(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        this.clear();
        int size = input.readInt();
        this.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            if (input.readBoolean()) {
                WritableComparable obj = OrcStruct.createValue(this.childSchema);
                obj.readFields(input);
                this.add(obj);
                continue;
            }
            this.add(null);
        }
    }

    public int compareTo(OrcList<E> other) {
        if (other == null) {
            return -1;
        }
        int result = this.childSchema.compareTo(other.childSchema);
        if (result != 0) {
            return result;
        }
        int ourSize = this.size();
        int otherSize = other.size();
        for (int e = 0; e < ourSize && e < otherSize; ++e) {
            WritableComparable ours = (WritableComparable)this.get(e);
            WritableComparable theirs = (WritableComparable)other.get(e);
            if (ours == null) {
                if (theirs == null) continue;
                return 1;
            }
            if (theirs == null) {
                return -1;
            }
            int val = ours.compareTo((Object)theirs);
            if (val == 0) continue;
            return val;
        }
        return ourSize - otherSize;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && this.compareTo((OrcList)other) == 0;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

