/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.sql.utils;

import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.exceptions.SchemaMappingException;
import com.mapr.db.spark.impl.OJAIDocument;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTimestamp;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MapRSqlUtils$ {
    public static MapRSqlUtils$ MODULE$;

    static {
        new MapRSqlUtils$();
    }

    public Row documentToRow(OJAIDocument document, StructType schema) {
        return this.convertObject(document.getDoc().asReader(), schema);
    }

    public Iterator<Row> documentsToRow(Iterator<DocumentReader> documents, StructType schema, String[] requiredColumns) {
        return documents.flatMap((Function1 & Serializable & scala.Serializable)record -> {
            Object object = MODULE$.convertRootField((DocumentReader)record, (DataType)schema);
            if (object instanceof Row) {
                Row row;
                Row row2 = row = (Row)object;
                return Nil$.MODULE$.$colon$colon((Object)row2);
            }
            if (object instanceof ArrayData) {
                ArrayData arrayData = (ArrayData)object;
                if (arrayData.numElements() == 0) {
                    return Nil$.MODULE$;
                }
                return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData.toArray((DataType)schema, ClassTag$.MODULE$.apply(Row.class))));
            }
            throw new MatchError(object);
        });
    }

    public String[] documentsToRow$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public Object convertRootField(DocumentReader docReader, DataType schema) {
        DocumentReader.EventType event = docReader.next();
        Tuple2 tuple2 = new Tuple2((Object)event, (Object)schema);
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType at = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_ARRAY.equals(eventType) && at instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)at;
                return this.convertArray(docReader, arrayType);
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_MAP.equals(eventType) && st instanceof StructType) {
                StructType structType = (StructType)st;
                return this.convertObject(docReader, structType);
            }
        }
        return this.convertField(event, docReader, schema, docReader.getFieldName());
    }

    private Row convertObject(DocumentReader documentReader, StructType schema) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).size(), (Function0 & Serializable & scala.Serializable)() -> null);
        DocumentReader.EventType event = null;
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_MAP) != 0) {
            String fieldName = documentReader.getFieldName();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)fieldName)) {
                int index = schema.fieldIndex(fieldName);
                values.update(index, this.convertField(event, documentReader, schema.apply(index).dataType(), fieldName));
            }
            event = documentReader.next();
        }
        return new GenericRowWithSchema((Object[])values.toArray(ClassTag$.MODULE$.Any()), schema);
    }

    private Object convertArray(DocumentReader documentReader, ArrayType array) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        DocumentReader.EventType event = null;
        String fieldName = documentReader.getFieldName();
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_ARRAY) != 0) {
            values.$plus$eq(this.convertField(event, documentReader, array.elementType(), fieldName));
            event = documentReader.next();
        }
        return values.toArray(ClassTag$.MODULE$.Any());
    }

    private Object convertMap(DocumentReader documentReader, MapType mapType) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        DocumentReader.EventType event = null;
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_MAP) != 0) {
            keys.$plus$eq((Object)documentReader.getFieldName());
            values.$plus$eq(this.convertField(event, documentReader, mapType.valueType(), documentReader.getFieldName()));
            event = documentReader.next();
        }
        return ArrayBasedMapData$.MODULE$.toScalaMap((Seq)Predef$.MODULE$.wrapRefArray((Object[])keys.toArray(ClassTag$.MODULE$.apply(String.class))), (Seq)Predef$.MODULE$.genericWrapArray(values.toArray(ClassTag$.MODULE$.Any())));
    }

    public Object convertField(DocumentReader.EventType event, DocumentReader documentReader, DataType schema, String fieldName) {
        DocumentReader.EventType eventType;
        Tuple2 tuple2 = new Tuple2((Object)event, (Object)schema);
        if (tuple2 != null) {
            DocumentReader.EventType eventType2 = (DocumentReader.EventType)tuple2._1();
            DataType at = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_ARRAY.equals(eventType2) && at instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)at;
                return this.convertArray(documentReader, arrayType);
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType dataType;
            DocumentReader.EventType eventType3 = (DocumentReader.EventType)tuple2._1();
            DataType mt = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_MAP.equals(eventType3) && mt instanceof MapType && StringType$.MODULE$.equals(dataType = (mapType = (MapType)mt).keyType())) {
                return this.convertMap(documentReader, mapType);
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType4 = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_MAP.equals(eventType4) && st instanceof StructType) {
                return this.convertObject(documentReader, (StructType)schema);
            }
        }
        if (tuple2 != null && (DocumentReader.EventType.NULL.equals(eventType = (DocumentReader.EventType)tuple2._1()) ? true : eventType == null)) {
            return null;
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType5 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType5) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType6 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType6) && BinaryType$.MODULE$.equals(dataType)) {
                return documentReader.getString().getBytes();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType7 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType7) && DateType$.MODULE$.equals(dataType)) {
                return new Date(ODate.parse((String)documentReader.getString()).toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType8 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType8) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(OTimestamp.parse((String)documentReader.getString()).getMillis());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType9 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType9) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType10 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType10) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType11 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType11) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType12 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType12) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType13 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType13) && ByteType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType14 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType14) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType15 = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType15) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((double)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType16 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType16) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getDate().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType17 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType17) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getDate().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType18 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType18) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getDate().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType19 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType19) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getTime().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType20 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType20) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getTime().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType21 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType21) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getTime().getMilliSecond());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType22 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType22) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getTimestampLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType23 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType23) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getTimestamp().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType24 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType24) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getTimestampLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType25 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType25) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType26 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType26) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType27 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType27) && StringType$.MODULE$.equals(dataType)) {
                return Integer.toString(documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType28 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType28) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType29 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType29) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType30 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType30) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType31 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType31) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType32 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType32) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType33 = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType33) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((double)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType34 = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType34) && st instanceof StringType) {
                return Float.toString(documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType35 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType35) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType36 = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType36) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply(documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType37 = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType37) && st instanceof StringType) {
                return Double.toString(documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType38 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType38) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType39 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType39) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType40 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType40) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType41 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType41) && StringType$.MODULE$.equals(dataType)) {
                return Long.toString(documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType42 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType42) && ByteType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToByte((byte)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType43 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType43) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType44 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType44) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType45 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType45) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType46 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType46) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType47 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType47) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType48 = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType48) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((int)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType49 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType49) && StringType$.MODULE$.equals(dataType)) {
                return Byte.toString(documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType50 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType50) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType51 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType51) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType52 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType52) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType53 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType53) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType54 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType54) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType55 = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType55) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((int)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType56 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType56) && StringType$.MODULE$.equals(dataType)) {
                return Short.toString(documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType57 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BINARY.equals(eventType57) && BinaryType$.MODULE$.equals(dataType)) {
                return documentReader.getBinary().array();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType58 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BINARY.equals(eventType58) && StringType$.MODULE$.equals(dataType)) {
                return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(documentReader.getBinary().array())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)MapRSqlUtils$.$anonfun$convertField$1(BoxesRunTime.unboxToByte((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()));
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType59 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType59) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getDecimal().floatValue());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType60 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType60) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getDecimal().doubleValue());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType61 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType61) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getDecimal().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType62 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType62) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getDecimalValueAsLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType63 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType63) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getDecimalValueAsInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType64 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BOOLEAN.equals(eventType64) && BooleanType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToBoolean((boolean)documentReader.getBoolean());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType65 = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BOOLEAN.equals(eventType65) && StringType$.MODULE$.equals(dataType)) {
                return Boolean.toString(documentReader.getBoolean());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType token = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (this.isInvalidType(dataType)) {
                throw new SchemaMappingException(new StringBuilder(43).append("Schema cannot be inferred for the column {").append(fieldName).append("}").toString());
            }
            throw new SchemaMappingException(new StringBuilder(56).append("Failed to parse a value for data type ").append(dataType).append(" (current token: ").append(token).append(")").toString());
        }
        throw new MatchError((Object)tuple2);
    }

    public boolean isInvalidType(DataType dt) {
        StructType structType;
        DataType dataType = dt;
        return dataType instanceof StructType && (structType = (StructType)dataType).size() == 1 && ((SeqLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).contains((Object)"InvalidType");
    }

    public OJAIDocument rowToDocument(Row row) {
        OJAIDocument document = MapRDBSpark$.MODULE$.newDocument(DBClient$.MODULE$.apply().newDocument());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field2 = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (!row.isNullAt(i)) {
                    return (OJAIDocument)document.set(field2.name(), MODULE$.convertToDataType(row.get(i), field2.dataType()));
                }
            }
            if (tuple2 != null) {
                StructField field3 = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (row.isNullAt(i)) {
                    return (OJAIDocument)document.setNull(field3.name());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return document;
    }

    public Value convertToDataType(Object element, DataType elementType) {
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            Document map = this.rowToDocument((Row)element).getDoc();
            return DBValueBuilderImpl.KeyValueBuilder.initFromObject((Object)map);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Seq seq = (Seq)element;
            return DBValueBuilderImpl.KeyValueBuilder.initFrom((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)seq.map((Function1 & Serializable & scala.Serializable)elem -> MODULE$.convertToDataType(elem, arrayType.elementType()), Seq$.MODULE$.canBuildFrom())).asJava());
        }
        if (dataType instanceof MapType) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)element;
            return DBValueBuilderImpl.KeyValueBuilder.initFrom((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map).asJava());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap((byte[])element));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToBoolean((Object)element));
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(new ODate((java.util.Date)((Date)element)));
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(new OTimestamp(((Timestamp)element).getTime()));
        }
        if (NullType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFromNull();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToDouble((Object)element));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(Predef$.MODULE$.Integer2int((Integer)element));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToLong((Object)element));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom((String)element);
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom((OInterval)element);
        }
        if (DecimalType$.MODULE$.unapply(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom((BigDecimal)element);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToFloat((Object)element));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToShort((Object)element));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToByte((Object)element));
        }
        throw new RuntimeException(new StringBuilder(47).append("Cannot convert ").append(elementType).append(" of a row to OjaiDocument's type").toString());
    }

    public static final /* synthetic */ char $anonfun$convertField$1(byte x$2) {
        return (char)x$2;
    }

    private MapRSqlUtils$() {
        MODULE$ = this;
    }
}

