/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.sql;

import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.spark.RDD.MapRDBTableScanRDD;
import com.mapr.db.spark.RDD.RDDTYPE$;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.spark.sql.GenerateSchema$;
import com.mapr.db.spark.sql.MapRDBRelation;
import com.mapr.db.spark.utils.DefaultClass$DefaultType$;
import com.mapr.db.spark.utils.MapRSpark;
import com.mapr.db.spark.utils.MapRSpark$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.ojai.store.QueryCondition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\u0005\u000b\u0001UAQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005BYBQA\u0011\u0001\u0005B\rCQA\u0011\u0001\u0005BICQA\u0011\u0001\u0005BuCQA\u001e\u0001\u0005\n]Dq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002<\u0001!I!!\u0010\u0003\u001b\u0011+g-Y;miN{WO]2f\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012A\u00013c\u0015\t\t\"#\u0001\u0003nCB\u0014(\"A\n\u0002\u0007\r|Wn\u0001\u0001\u0014\r\u00011B\u0004K\u0016/!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fMB\u0011QDJ\u0007\u0002=)\u0011q\u0004I\u0001\bg>,(oY3t\u0015\tY\u0011E\u0003\u0002\u000eE)\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0013\t9cD\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\bCA\u000f*\u0013\tQcD\u0001\tSK2\fG/[8o!J|g/\u001b3feB\u0011Q\u0004L\u0005\u0003[y\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u0003;=J!\u0001\r\u0010\u00033\r\u0013X-\u0019;bE2,'+\u001a7bi&|g\u000e\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0002\"\u0001\u000e\u0001\u000e\u0003)\t\u0011b\u001d5peRt\u0015-\\3\u0015\u0003]\u0002\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e\u0019\u001b\u0005Y$B\u0001\u001f\u0015\u0003\u0019a$o\\8u}%\u0011a\bG\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?1\u0005q1M]3bi\u0016\u0014V\r\\1uS>tGc\u0001#H\u001bB\u0011Q$R\u0005\u0003\rz\u0011ABQ1tKJ+G.\u0019;j_:DQ\u0001S\u0002A\u0002%\u000b!b]9m\u0007>tG/\u001a=u!\tQ5*D\u0001!\u0013\ta\u0005E\u0001\u0006T#2\u001buN\u001c;fqRDQAT\u0002A\u0002=\u000b!\u0002]1sC6,G/\u001a:t!\u0011A\u0004kN\u001c\n\u0005E\u000b%aA'baR!Ai\u0015+V\u0011\u0015AE\u00011\u0001J\u0011\u0015qE\u00011\u0001P\u0011\u00151F\u00011\u0001X\u0003\u0019\u00198\r[3nCB\u0011\u0001lW\u0007\u00023*\u0011!\fI\u0001\u0006if\u0004Xm]\u0005\u00039f\u0013!b\u0015;sk\u000e$H+\u001f9f)\u0015!el\u00183f\u0011\u0015AU\u00011\u0001J\u0011\u0015\u0001W\u00011\u0001b\u0003\u0011iw\u000eZ3\u0011\u0005)\u0013\u0017BA2!\u0005!\u0019\u0016M^3N_\u0012,\u0007\"\u0002(\u0006\u0001\u0004y\u0005\"\u00024\u0006\u0001\u00049\u0017\u0001\u00023bi\u0006\u0004\"\u0001[:\u000f\u0005%\fhB\u00016q\u001d\tYwN\u0004\u0002m]:\u0011!(\\\u0005\u0002K%\u00111\u0005J\u0005\u0003\u001b\tJ!aC\u0011\n\u0005I\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003iV\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005I\u0004\u0013\u0001F2sK\u0006$X-T1q%\u0012\u0013%+\u001a7bi&|g\u000e\u0006\u000bEqft\u00181AA\u0004\u0003\u0017\ty!!\n\u0002*\u00055\u0012\u0011\u0007\u0005\u0006\u0011\u001a\u0001\r!\u0013\u0005\u0006u\u001a\u0001\ra_\u0001\ni\u0006\u0014G.\u001a(b[\u0016\u00042a\u0006?8\u0013\ti\bD\u0001\u0004PaRLwN\u001c\u0005\u0007\u007f\u001a\u0001\r!!\u0001\u0002\u0015U\u001cXM]*dQ\u0016l\u0017\rE\u0002\u0018y^Ca!!\u0002\u0007\u0001\u0004Y\u0018AC:b[BdWmU5{K\"1\u0011\u0011\u0002\u0004A\u0002]\nABY;gM\u0016\u0014xK]5uKNDa!!\u0004\u0007\u0001\u0004Y\u0018A\u00045j]R,6/\u001b8h\u0013:$W\r\u001f\u0005\b\u0003#1\u0001\u0019AA\n\u00039\tX/\u001a:z\u0007>tG-\u001b;j_:\u0004Ba\u0006?\u0002\u0016A!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011!B:u_J,'bAA\u0010I\u0005!qN[1j\u0013\u0011\t\u0019#!\u0007\u0003\u001dE+XM]=D_:$\u0017\u000e^5p]\"1\u0011q\u0005\u0004A\u0002m\fQbY8m!J|'.Z2uS>t\u0007BBA\u0016\r\u0001\u0007q'A\u0005Pa\u0016\u0014\u0018\r^5p]\"1\u0011q\u0006\u0004A\u0002]\naBZ1jY>s7i\u001c8gY&\u001cG\u000f\u0003\u0004\u00024\u0019\u0001\raT\u0001\rcV,'/_(qi&|gn]\u0001\u0013[\u0006\\WmU2iK6\fg*\u001e7mC\ndW\rF\u0002X\u0003sAQAV\u0004A\u0002]\u000bAbZ3u)\u0006\u0014G.\u001a)bi\"$2a_A \u0011\u0015q\u0005\u00021\u0001P\u0001")
public class DefaultSource
implements DataSourceRegister,
RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    public String shortName() {
        return "maprdb";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        Option condition = parameters.get((Object)"QueryCondition").map((Function1 & Serializable & scala.Serializable)cond -> ConditionImpl.parseFrom((ByteBuffer)ByteBuffer.wrap(cond.getBytes())));
        return this.createMapRDBRelation(sqlContext, this.getTablePath(parameters), (Option<StructType>)None$.MODULE$, (Option<String>)parameters.get((Object)"sampleSize"), (String)parameters.getOrElse((Object)"bufferWrites", (Function0 & Serializable & scala.Serializable)() -> "true"), (Option<String>)parameters.get((Object)"hintUsingIndex"), (Option<QueryCondition>)condition, (Option<String>)parameters.get((Object)"ColumnProjection"), (String)parameters.getOrElse((Object)"Operation", (Function0 & Serializable & scala.Serializable)() -> "InsertOrReplace"), (String)parameters.getOrElse((Object)"FailOnConflict", (Function0 & Serializable & scala.Serializable)() -> "false"), (Map<String, String>)((Map)parameters.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$createRelation$5(k))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        Option condition = parameters.get((Object)"QueryCondition").map((Function1 & Serializable & scala.Serializable)cond -> ConditionImpl.parseFrom((ByteBuffer)ByteBuffer.wrap(cond.getBytes("ISO-8859-1"))));
        return this.createMapRDBRelation(sqlContext, this.getTablePath(parameters), (Option<StructType>)new Some((Object)schema), (Option<String>)parameters.get((Object)"sampleSize"), (String)parameters.getOrElse((Object)"bufferWrites", (Function0 & Serializable & scala.Serializable)() -> "true"), (Option<String>)parameters.get((Object)"hintUsingIndex"), (Option<QueryCondition>)condition, (Option<String>)parameters.get((Object)"ColumnProjection"), (String)parameters.getOrElse((Object)"Operation", (Function0 & Serializable & scala.Serializable)() -> "InsertOrReplace"), (String)parameters.getOrElse((Object)"FailOnConflict", (Function0 & Serializable & scala.Serializable)() -> "false"), (Map<String, String>)((Map)parameters.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$createRelation$11(k))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        LazyBoolean tableExists$lzy = new LazyBoolean();
        LazyBoolean createTheTable$lzy = new LazyBoolean();
        LazyBoolean bulkMode$lzy = new LazyBoolean();
        boolean bufferWrites = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"bufferWrites", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        String tableName = (String)this.getTablePath(parameters).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(tableName)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Table name must be defined");
        String idFieldPath = (String)parameters.getOrElse((Object)"idFieldPath", (Function0 & Serializable & scala.Serializable)() -> "_id");
        Option condition = parameters.get((Object)"QueryCondition").map((Function1 & Serializable & scala.Serializable)cond -> ConditionImpl.parseFrom((ByteBuffer)ByteBuffer.wrap(cond.getBytes())));
        String operation = (String)parameters.getOrElse((Object)"Operation", (Function0 & Serializable & scala.Serializable)() -> "ErrorIfExists");
        SaveMode saveMode = mode;
        if (!SaveMode.ErrorIfExists.equals(saveMode)) {
            throw new UnsupportedOperationException("Any mode operation is not supported for MapRDB Table.Please use Operation option instead");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string = operation;
        if ("Insert".equals(string)) {
            MapRSpark$.MODULE$.insert(data, tableName, idFieldPath, DefaultSource.createTheTable$1(createTheTable$lzy, tableExists$lzy, tableName), DefaultSource.bulkMode$1(bulkMode$lzy, parameters), bufferWrites);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if ("InsertOrReplace".equals(string)) {
            MapRSpark$.MODULE$.save(data, tableName, idFieldPath, DefaultSource.createTheTable$1(createTheTable$lzy, tableExists$lzy, tableName), DefaultSource.bulkMode$1(bulkMode$lzy, parameters), bufferWrites);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else if ("Delete".equals(string)) {
            MapRSpark$.MODULE$.delete(data, tableName, idFieldPath, bufferWrites);
            BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
        } else if ("ErrorIfExists".equals(string)) {
            if (DefaultSource.tableExists$1(tableExists$lzy, tableName)) {
                throw new TableExistsException(new StringBuilder(22).append("Table: ").append(tableName).append(" already Exists").toString());
            }
            MapRSpark$.MODULE$.save(data, tableName, idFieldPath, true, DefaultSource.bulkMode$1(bulkMode$lzy, parameters), bufferWrites);
            BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
        } else if ("Overwrite".equals(string)) {
            DBClient$.MODULE$.apply().deleteTable(tableName);
            MapRSpark$.MODULE$.save(data, tableName, idFieldPath, true, DefaultSource.bulkMode$1(bulkMode$lzy, parameters), bufferWrites);
            BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException("Not supported operation");
        }
        return this.createMapRDBRelation(sqlContext, (Option<String>)new Some((Object)tableName), (Option<StructType>)new Some((Object)data.schema()), (Option<String>)parameters.get((Object)"sampleSize"), (String)parameters.getOrElse((Object)"bufferWrites", (Function0 & Serializable & scala.Serializable)() -> "true"), (Option<String>)parameters.get((Object)"hintUsingIndex"), (Option<QueryCondition>)condition, (Option<String>)parameters.get((Object)"ColumnProjection"), (String)parameters.getOrElse((Object)"Operation", (Function0 & Serializable & scala.Serializable)() -> "InsertOrReplace"), (String)parameters.getOrElse((Object)"FailOnConflict", (Function0 & Serializable & scala.Serializable)() -> "false"), (Map<String, String>)((Map)parameters.filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$createRelation$23(k))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
    }

    private BaseRelation createMapRDBRelation(SQLContext sqlContext, Option<String> tableName, Option<StructType> userSchema, Option<String> sampleSize, String bufferWrites, Option<String> hintUsingIndex, Option<QueryCondition> queryCondition, Option<String> colProjection, String Operation, String failOnConflict, Map<String, String> queryOptions) {
        StructType structType;
        Predef$.MODULE$.require(tableName.isDefined());
        Option columns = colProjection.map((Function1 & Serializable & scala.Serializable)colList -> (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colList.split(","))).toSeq().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$createMapRDBRelation$2(x$1))));
        boolean failureOnConflict = new StringOps(Predef$.MODULE$.augmentString(failOnConflict)).toBoolean();
        MapRSpark.Builder qual$1 = MapRSpark$.MODULE$.builder().sparkSession(sqlContext.sparkSession());
        Configuration x$1 = qual$1.configuration$default$1();
        MapRDBTableScanRDD<OJAIDocument> rdd = qual$1.configuration(x$1).setTable((String)tableName.get()).setBufferWrites(new StringOps(Predef$.MODULE$.augmentString(bufferWrites)).toBoolean()).setHintUsingIndex(hintUsingIndex).setCond(queryCondition).setColumnProjection((Option<Seq<String>>)columns).setQueryOptions(queryOptions).build().toRDD(null, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass$DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Option<StructType> option = userSchema;
        if (option instanceof Some) {
            StructType s;
            Some some = (Some)option;
            structType = s = (StructType)some.value();
        } else if (None$.MODULE$.equals(option)) {
            structType = GenerateSchema$.MODULE$.apply(rdd, BoxesRunTime.unboxToDouble((Object)sampleSize.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)DefaultSource.$anonfun$createMapRDBRelation$3(x$2))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> GenerateSchema$.MODULE$.SAMPLE_SIZE())), failureOnConflict);
        } else {
            throw new MatchError(option);
        }
        StructType schema = this.makeSchemaNullable(structType);
        return new MapRDBRelation((String)tableName.get(), schema, rdd, Operation, sqlContext);
    }

    private StructType makeSchemaNullable(StructType schema) {
        return StructType$.MODULE$.apply((Seq)schema.map((Function1 & Serializable & scala.Serializable)field2 -> new StructField(field2.name(), field2.dataType(), true, field2.metadata()), Seq$.MODULE$.canBuildFrom()));
    }

    private Option<String> getTablePath(Map<String, String> parameters) {
        Option tablePath = parameters.get((Object)"tablePath");
        return tablePath.isDefined() ? tablePath : parameters.get((Object)"tableName");
    }

    public static final /* synthetic */ boolean $anonfun$createRelation$5(String k) {
        return k.startsWith("ojai.mapr.query") || k.startsWith("spark.maprdb");
    }

    public static final /* synthetic */ boolean $anonfun$createRelation$11(String k) {
        return k.startsWith("ojai.mapr.query") || k.startsWith("spark.maprdb");
    }

    private static final /* synthetic */ boolean tableExists$lzycompute$1(LazyBoolean tableExists$lzy$1, String tableName$1) {
        boolean bl;
        LazyBoolean lazyBoolean = tableExists$lzy$1;
        synchronized (lazyBoolean) {
            bl = tableExists$lzy$1.initialized() ? tableExists$lzy$1.value() : tableExists$lzy$1.initialize(DBClient$.MODULE$.apply().tableExists(tableName$1));
        }
        return bl;
    }

    private static final boolean tableExists$1(LazyBoolean tableExists$lzy$1, String tableName$1) {
        return tableExists$lzy$1.initialized() ? tableExists$lzy$1.value() : DefaultSource.tableExists$lzycompute$1(tableExists$lzy$1, tableName$1);
    }

    private static final /* synthetic */ boolean createTheTable$lzycompute$1(LazyBoolean createTheTable$lzy$1, LazyBoolean tableExists$lzy$1, String tableName$1) {
        boolean bl;
        LazyBoolean lazyBoolean = createTheTable$lzy$1;
        synchronized (lazyBoolean) {
            bl = createTheTable$lzy$1.initialized() ? createTheTable$lzy$1.value() : createTheTable$lzy$1.initialize(!DefaultSource.tableExists$1(tableExists$lzy$1, tableName$1));
        }
        return bl;
    }

    private static final boolean createTheTable$1(LazyBoolean createTheTable$lzy$1, LazyBoolean tableExists$lzy$1, String tableName$1) {
        return createTheTable$lzy$1.initialized() ? createTheTable$lzy$1.value() : DefaultSource.createTheTable$lzycompute$1(createTheTable$lzy$1, tableExists$lzy$1, tableName$1);
    }

    private static final /* synthetic */ boolean bulkMode$lzycompute$1(LazyBoolean bulkMode$lzy$1, Map parameters$1) {
        boolean bl;
        LazyBoolean lazyBoolean = bulkMode$lzy$1;
        synchronized (lazyBoolean) {
            bl = bulkMode$lzy$1.initialized() ? bulkMode$lzy$1.value() : bulkMode$lzy$1.initialize(new StringOps(Predef$.MODULE$.augmentString((String)parameters$1.getOrElse((Object)"bulkMode", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean());
        }
        return bl;
    }

    private static final boolean bulkMode$1(LazyBoolean bulkMode$lzy$1, Map parameters$1) {
        return bulkMode$lzy$1.initialized() ? bulkMode$lzy$1.value() : DefaultSource.bulkMode$lzycompute$1(bulkMode$lzy$1, parameters$1);
    }

    public static final /* synthetic */ boolean $anonfun$createRelation$23(String k) {
        return k.startsWith("ojai.mapr.query") || k.startsWith("spark.maprdb");
    }

    public static final /* synthetic */ boolean $anonfun$createMapRDBRelation$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ double $anonfun$createMapRDBRelation$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toDouble();
    }
}

