/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.sql.utils;

import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.exceptions.SchemaMappingException;
import com.mapr.db.spark.impl.OJAIDocument;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTimestamp;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class MapRSqlUtils$ {
    public static MapRSqlUtils$ MODULE$;

    static {
        new MapRSqlUtils$();
    }

    public Row documentToRow(OJAIDocument document, StructType schema) {
        return this.convertObject(document.getDoc().asReader(), schema);
    }

    public Iterator<Row> documentsToRow(Iterator<DocumentReader> documents, StructType schema, String[] requiredColumns) {
        return documents.flatMap((Function1 & Serializable & scala.Serializable)record -> {
            List list;
            Object object = MODULE$.convertRootField((DocumentReader)record, (DataType)schema);
            if (object instanceof Row) {
                Row row;
                Row row2 = row = (Row)object;
                list = Nil$.MODULE$.$colon$colon((Object)row2);
            } else if (object instanceof ArrayData) {
                ArrayData arrayData = (ArrayData)object;
                list = arrayData.numElements() == 0 ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayData.toArray((DataType)schema, ClassTag$.MODULE$.apply(Row.class))));
            } else {
                throw new MatchError(object);
            }
            return list;
        });
    }

    public String[] documentsToRow$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertRootField(DocumentReader docReader, DataType schema) {
        DocumentReader.EventType event = docReader.next();
        Tuple2 tuple2 = new Tuple2((Object)event, (Object)schema);
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType at = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_ARRAY.equals(eventType) && at instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)at;
                return this.convertArray(docReader, arrayType);
            }
        }
        if (tuple2 == null) return this.convertField(event, docReader, schema, docReader.getFieldName());
        DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
        DataType st = (DataType)tuple2._2();
        if (!DocumentReader.EventType.START_MAP.equals(eventType)) return this.convertField(event, docReader, schema, docReader.getFieldName());
        if (!(st instanceof StructType)) return this.convertField(event, docReader, schema, docReader.getFieldName());
        StructType structType = (StructType)st;
        return this.convertObject(docReader, structType);
    }

    private Row convertObject(DocumentReader documentReader, StructType schema) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).size(), (Function0 & Serializable & scala.Serializable)() -> null);
        DocumentReader.EventType event = null;
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_MAP) != 0) {
            String fieldName = documentReader.getFieldName();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)fieldName)) {
                int index = schema.fieldIndex(fieldName);
                values.update(index, this.convertField(event, documentReader, schema.apply(index).dataType(), fieldName));
            }
            event = documentReader.next();
        }
        return new GenericRowWithSchema((Object[])values.toArray(ClassTag$.MODULE$.Any()), schema);
    }

    private Object convertArray(DocumentReader documentReader, ArrayType array) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        DocumentReader.EventType event = null;
        String fieldName = documentReader.getFieldName();
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_ARRAY) != 0) {
            values.$plus$eq(this.convertField(event, documentReader, array.elementType(), fieldName));
            event = documentReader.next();
        }
        return values.toArray(ClassTag$.MODULE$.Any());
    }

    private Object convertMap(DocumentReader documentReader, MapType mapType) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        DocumentReader.EventType event = null;
        event = documentReader.next();
        while (event != null && event.compareTo((Enum)DocumentReader.EventType.END_MAP) != 0) {
            keys.$plus$eq((Object)documentReader.getFieldName());
            values.$plus$eq(this.convertField(event, documentReader, mapType.valueType(), documentReader.getFieldName()));
            event = documentReader.next();
        }
        return ArrayBasedMapData$.MODULE$.toScalaMap((Seq)Predef$.MODULE$.wrapRefArray((Object[])keys.toArray(ClassTag$.MODULE$.apply(String.class))), (Seq)Predef$.MODULE$.genericWrapArray(values.toArray(ClassTag$.MODULE$.Any())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object convertField(DocumentReader.EventType event, DocumentReader documentReader, DataType schema, String fieldName) {
        Tuple2 tuple2 = new Tuple2((Object)event, (Object)schema);
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType at = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_ARRAY.equals(eventType) && at instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)at;
                return this.convertArray(documentReader, arrayType);
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType dataType;
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType mt = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_MAP.equals(eventType) && mt instanceof MapType && StringType$.MODULE$.equals(dataType = (mapType = (MapType)mt).keyType())) {
                return this.convertMap(documentReader, mapType);
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.START_MAP.equals(eventType) && st instanceof StructType) {
                return this.convertObject(documentReader, (StructType)schema);
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            if (DocumentReader.EventType.NULL.equals(eventType)) {
                return null;
            }
            if (eventType == null) {
                return null;
            }
            boolean bl = false;
            if (bl) {
                return null;
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && BinaryType$.MODULE$.equals(dataType)) {
                return documentReader.getString().getBytes();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && DateType$.MODULE$.equals(dataType)) {
                return new Date(ODate.parse((String)documentReader.getString()).toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(OTimestamp.parse((String)documentReader.getString()).getMillis());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && ByteType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.STRING.equals(eventType) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((double)new StringOps(Predef$.MODULE$.augmentString(documentReader.getString())).toFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getDate().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getDate().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DATE.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getDate().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getTime().toDate().getTime());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getTime().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIME.equals(eventType) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getTime().getMilliSecond());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getTimestampLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getTimestamp().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.TIMESTAMP.equals(eventType) && DateType$.MODULE$.equals(dataType)) {
                return new Date(documentReader.getTimestampLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return Integer.toString(documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.INT.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((double)documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.FLOAT.equals(eventType) && st instanceof StringType) {
                return Float.toString(documentReader.getFloat());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply(documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType st = (DataType)tuple2._2();
            if (DocumentReader.EventType.DOUBLE.equals(eventType) && st instanceof StringType) {
                return Double.toString(documentReader.getDouble());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType) && TimestampType$.MODULE$.equals(dataType)) {
                return new Timestamp(documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.LONG.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return Long.toString(documentReader.getLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && ByteType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToByte((byte)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((int)documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BYTE.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return Byte.toString(documentReader.getByte());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && ShortType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToShort((short)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && dt instanceof DecimalType) {
                return Decimal$.MODULE$.apply((int)documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.SHORT.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return Short.toString(documentReader.getShort());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BINARY.equals(eventType) && BinaryType$.MODULE$.equals(dataType)) {
                return documentReader.getBinary().array();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BINARY.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(documentReader.getBinary().array())).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToCharacter((char)MapRSqlUtils$.$anonfun$convertField$1(BoxesRunTime.unboxToByte((Object)x$2))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char()));
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType) && FloatType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToFloat((float)documentReader.getDecimal().floatValue());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType) && DoubleType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToDouble((double)documentReader.getDecimal().doubleValue());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return documentReader.getDecimal().toString();
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType) && LongType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToLong((long)documentReader.getDecimalValueAsLong());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.DECIMAL.equals(eventType) && IntegerType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToInteger((int)documentReader.getDecimalValueAsInt());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BOOLEAN.equals(eventType) && BooleanType$.MODULE$.equals(dataType)) {
                return BoxesRunTime.boxToBoolean((boolean)documentReader.getBoolean());
            }
        }
        if (tuple2 != null) {
            DocumentReader.EventType eventType = (DocumentReader.EventType)tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DocumentReader.EventType.BOOLEAN.equals(eventType) && StringType$.MODULE$.equals(dataType)) {
                return Boolean.toString(documentReader.getBoolean());
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        DocumentReader.EventType token = (DocumentReader.EventType)tuple2._1();
        DataType dataType = (DataType)tuple2._2();
        if (!this.isInvalidType(dataType)) throw new SchemaMappingException(new StringBuilder(56).append("Failed to parse a value for data type ").append(dataType).append(" (current token: ").append(token).append(")").toString());
        throw new SchemaMappingException(new StringBuilder(43).append("Schema cannot be inferred for the column {").append(fieldName).append("}").toString());
    }

    public boolean isInvalidType(DataType dt) {
        StructType structType;
        DataType dataType = dt;
        boolean bl = dataType instanceof StructType && (structType = (StructType)dataType).size() == 1 && ((SeqLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).contains((Object)"InvalidType");
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public OJAIDocument rowToDocument(Row row) {
        void var2_2;
        OJAIDocument document = MapRDBSpark$.MODULE$.newDocument(DBClient$.MODULE$.apply().newDocument());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row.schema().fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field2 = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (!row.isNullAt(i)) {
                    return (OJAIDocument)document.set(field2.name(), MODULE$.convertToDataType(row.get(i), field2.dataType()));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StructField field3 = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (!row.isNullAt(i)) throw new MatchError((Object)tuple2);
            return (OJAIDocument)document.setNull(field3.name());
        });
        return var2_2;
    }

    public Value convertToDataType(Object element, DataType elementType) {
        KeyValue keyValue;
        DataType dataType = elementType;
        if (dataType instanceof StructType) {
            Document map = this.rowToDocument((Row)element).getDoc();
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFromObject((Object)map);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            Seq seq = (Seq)element;
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)seq.map((Function1 & Serializable & scala.Serializable)elem -> MODULE$.convertToDataType(elem, arrayType.elementType()), Seq$.MODULE$.canBuildFrom())).asJava());
        } else if (dataType instanceof MapType) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)element;
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map).asJava());
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap((byte[])element));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToBoolean((Object)element));
        } else if (DateType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(new ODate((java.util.Date)((Date)element)));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(new OTimestamp(((Timestamp)element).getTime()));
        } else if (NullType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFromNull();
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToDouble((Object)element));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(Predef$.MODULE$.Integer2int((Integer)element));
        } else if (LongType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToLong((Object)element));
        } else if (StringType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom((String)element);
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom((OInterval)element);
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom((BigDecimal)element);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToFloat((Object)element));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToShort((Object)element));
        } else if (ByteType$.MODULE$.equals(dataType)) {
            keyValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(BoxesRunTime.unboxToByte((Object)element));
        } else {
            throw new RuntimeException(new StringBuilder(47).append("Cannot convert ").append(elementType).append(" of a row to OjaiDocument's type").toString());
        }
        return keyValue;
    }

    public static final /* synthetic */ char $anonfun$convertField$1(byte x$2) {
        return (char)x$2;
    }

    private MapRSqlUtils$() {
        MODULE$ = this;
    }
}

