/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.sql.v2;

import com.mapr.db.MapRDB;
import com.mapr.db.spark.sql.v2.MapRDBDataPartitionReader;
import com.mapr.db.spark.sql.v2.MapRDBDataSourceReader;
import com.mapr.db.spark.sql.v2.MapRDBTabletInfo;
import com.mapr.db.spark.sql.v2.MapRDBTabletInfo$;
import com.mapr.db.spark.sql.v2.QueryConditionExtensions$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.types.StructType;
import org.ojai.Document;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.mutable.ParArray;
import scala.collection.parallel.mutable.ParArray$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001)4A\u0001C\u0005\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b1\u0003A\u0011I'\t\u000b\u0011\u0004A\u0011B3\u000375\u000b\u0007O\u0015#C\t\u0006$\u0018mU8ve\u000e,W*\u001e7uSJ+\u0017\rZ3s\u0015\tQ1\"\u0001\u0002we)\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0002eE*\u0011!cE\u0001\u0005[\u0006\u0004(OC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011\"\u0003\u0002\u001b\u0013\t1R*\u00199S\t\n#\u0015\r^1T_V\u00148-\u001a*fC\u0012,'/\u0001\u0004tG\",W.\u0019\t\u0003;\u0019j\u0011A\b\u0006\u0003?\u0001\nQ\u0001^=qKNT!\u0001D\u0011\u000b\u00059\u0011#BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001eL!a\n\u0010\u0003\u0015M#(/^2u)f\u0004X-A\u0005uC\ndW\rU1uQB\u0011!f\r\b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R!AL\u000b\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Iz\u0013!\u00045j]R,G-\u00138eKb,7\u000fE\u00029{%r!!O\u001e\u000f\u00051R\u0014\"\u0001\u0019\n\u0005qz\u0013a\u00029bG.\fw-Z\u0005\u0003}}\u0012A\u0001T5ti*\u0011AhL\u0001\u0011e\u0016\fG-\u001a:t!\u0016\u0014H+\u00192mKR\u0004\"AQ\"\u000e\u0003=J!\u0001R\u0018\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0006\u000f\"K%j\u0013\t\u00031\u0001AQaG\u0003A\u0002qAQ\u0001K\u0003A\u0002%BQAN\u0003A\u0002]BQ\u0001Q\u0003A\u0002\u0005\u000b1\u0003\u001d7b]&s\u0007/\u001e;QCJ$\u0018\u000e^5p]N$\u0012A\u0014\t\u0004\u001fR+V\"\u0001)\u000b\u0005E\u0013\u0016\u0001B;uS2T\u0011aU\u0001\u0005U\u00064\u0018-\u0003\u0002?!B\u0019a\u000b\u00180\u000e\u0003]S!\u0001W-\u0002\rI,\u0017\rZ3s\u0015\tQ!L\u0003\u0002\\A\u000591o\\;sG\u0016\u001c\u0018BA/X\u00059Ie\u000e];u!\u0006\u0014H/\u001b;j_:\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019\u0011\u0002\u0011\r\fG/\u00197zgRL!a\u00191\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000eGJ,\u0017\r^3SK\u0006$WM]:\u0016\u0003\u0019\u00042\u0001O\u001fh!\tA\u0002.\u0003\u0002j\u0013\tIR*\u00199S\t\n#\u0015\r^1QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\u0001")
public class MapRDBDataSourceMultiReader
extends MapRDBDataSourceReader {
    private final String tablePath;
    private final int readersPerTablet;

    @Override
    public java.util.List<InputPartition<InternalRow>> planInputPartitions() {
        return this.readersPerTablet == 1 ? super.planInputPartitions() : (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.createReaders()).asJava();
    }

    private List<MapRDBDataPartitionReader> createReaders() {
        Connection connection = DriverManager.getConnection((String)"ojai:mapr:");
        DocumentStore store = connection.getStore(this.tablePath);
        ParArray conditions = (ParArray)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MapRDB.getTable((String)this.tablePath).getTabletInfos())).par().flatMap((Function1 & Serializable & scala.Serializable)tablet -> {
            Query query = connection.newQuery().where(tablet.getCondition()).select(new String[]{"_id"}).build();
            QueryResult ids = store.find(query);
            List partition = ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)ids).asScala()).toList();
            int partitionSize = partition.size();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("READER SIZE == ").append(partitionSize).toString());
            return partition.grouped(partitionSize / $this.readersPerTablet + 1).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).map((Function1 & Serializable & scala.Serializable)group -> new Tuple2((Object)((Document)group.head()).getIdString(), (Object)((Document)group.last()).getIdString())).map((Function1 & Serializable & scala.Serializable)range -> {
                QueryCondition lowerBound = QueryConditionExtensions$.MODULE$.QueryConditionOps(connection.newCondition()).field("_id").$greater$eq(range._1());
                QueryCondition upperBound = QueryConditionExtensions$.MODULE$.QueryConditionOps(connection.newCondition()).field("_id").$less$eq(range._2());
                String cond = connection.newCondition().and().condition(lowerBound.build()).condition(upperBound.build()).close().build().asJsonString();
                return MapRDBTabletInfo$.MODULE$.apply(Random$.MODULE$.nextInt(), tablet.getLocations(), cond);
            });
        }, (CanBuildFrom)ParArray$.MODULE$.canBuildFrom());
        List factories = ((ParIterableLike)conditions.map((Function1 & Serializable & scala.Serializable)tabletInfo -> this.createReaderFactory((MapRDBTabletInfo)tabletInfo), (CanBuildFrom)ParArray$.MODULE$.canBuildFrom())).toList();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("CREATING ").append(factories.length()).append(" READERS").toString());
        return factories;
    }

    public MapRDBDataSourceMultiReader(StructType schema, String tablePath, List<String> hintedIndexes, int readersPerTablet) {
        this.tablePath = tablePath;
        this.readersPerTablet = readersPerTablet;
        super(schema, tablePath, hintedIndexes);
    }
}

