/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.utils;

import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.codec.BeanCodec$;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.types.DBArrayValue;
import com.mapr.db.spark.types.DBBinaryValue;
import com.mapr.db.spark.types.DBMapValue;
import com.mapr.db.spark.utils.MapRDBUtils$ClassTagOps$;
import com.mapr.db.spark.writers.OJAIKey;
import com.mapr.db.spark.writers.OJAIKey$;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.ObjectInput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.ojai.Document;
import org.ojai.Value;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;

public final class MapRDBUtils$ {
    public static MapRDBUtils$ MODULE$;

    static {
        new MapRDBUtils$();
    }

    public Tuple2<Object, Object> checkOrCreateTable(String tableName, boolean bulkMode, boolean createTable, Seq<Value> keys) {
        Tuple2.mcZZ.sp sp2;
        boolean isBulkLoad = bulkMode;
        if (!DBClient$.MODULE$.apply().tableExists(tableName)) {
            if (!createTable) {
                throw new TableNotFoundException(new StringBuilder(17).append("Table: ").append(tableName).append(" not found").toString());
            }
            TableDescriptor tabDesc = DBClient$.MODULE$.apply().newTableDescriptor();
            tabDesc.setAutoSplit(true);
            tabDesc.setPath(tableName);
            tabDesc.setBulkLoad(bulkMode);
            if (keys.isEmpty()) {
                DBClient$.MODULE$.apply().createTable(tabDesc);
            } else {
                DBClient$.MODULE$.apply().createTable(tabDesc, (Value[])keys.toArray(ClassTag$.MODULE$.apply(Value.class)));
            }
            sp2 = new Tuple2.mcZZ.sp(true, bulkMode);
        } else {
            if (createTable) {
                throw new TableExistsException(new StringBuilder(22).append("Table: ").append(tableName).append(" already Exists").toString());
            }
            if (bulkMode) {
                isBulkLoad = DBClient$.MODULE$.apply().isBulkLoad(tableName);
            }
            sp2 = new Tuple2.mcZZ.sp(false, isBulkLoad);
        }
        return sp2;
    }

    public void setBulkLoad(String tableName, boolean bulkMode) {
        TableDescriptor desc = DBClient$.MODULE$.apply().getTableDescriptor(tableName);
        desc.setBulkLoad(bulkMode);
        DBClient$.MODULE$.apply().alterTable(desc);
    }

    public boolean containsRow(byte[] row, ConditionNode.RowkeyRange rowkeyRange) {
        return Bytes.compareTo((byte[])row, (byte[])rowkeyRange.getStartRow()) >= 0 && (Bytes.compareTo((byte[])row, (byte[])rowkeyRange.getStopRow()) < 0 || Bytes.equals((byte[])rowkeyRange.getStopRow(), (byte[])MapRConstants.EMPTY_BYTE_ARRAY));
    }

    public <T> T toBeanClass(Document doc, Class<T> beanClass) {
        return (T)(beanClass.getSimpleName().equals("OJAIDocument") ? MapRDBSpark$.MODULE$.newDocument(doc) : BeanCodec$.MODULE$.encode(doc.asReader(), beanClass));
    }

    public void readBytes(ByteBuffer buff, int bufferSize, ObjectInput objectInput) {
        int read;
        byte[] byteArray = new byte[bufferSize];
        int readbytes = objectInput.read(byteArray, 0, bufferSize);
        buff.put(byteArray, 0, readbytes);
        for (int remaining = bufferSize - readbytes; remaining > 0; remaining -= read) {
            read = objectInput.read(byteArray, readbytes, remaining);
            buff.put(byteArray, readbytes, read);
            readbytes += read;
        }
        buff.flip();
    }

    public Seq<Object> convertToSeq(Seq<Object> value2) {
        Seq seq;
        Seq<Object> seq2 = value2;
        if (seq2 instanceof DBArrayValue) {
            DBArrayValue dBArrayValue = (DBArrayValue)seq2;
            seq = (Seq)dBArrayValue.arr().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)value2.map((Function1 & Serializable & scala.Serializable)value -> MODULE$.convertToScalaCollection(value), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public scala.collection.immutable.Map<String, Object> convertToMap(scala.collection.immutable.Map<String, Object> value) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map<String, Object> map2 = value;
        if (map2 instanceof DBMapValue) {
            DBMapValue dBMapValue = (DBMapValue)map2;
            map = (scala.collection.immutable.Map)dBMapValue.value().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map = (scala.collection.immutable.Map)value.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), MODULE$.convertToScalaCollection(v));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    public Object convertToScalaCollection(Object value2) {
        Object object;
        Object object2 = value2;
        if (object2 instanceof DBMapValue) {
            DBMapValue dBMapValue = (DBMapValue)object2;
            object = JavaConverters$.MODULE$.mapAsJavaMapConverter(dBMapValue.value()).asJava();
        } else if (object2 instanceof DBArrayValue) {
            DBArrayValue dBArrayValue = (DBArrayValue)object2;
            object = JavaConverters$.MODULE$.seqAsJavaListConverter(dBArrayValue.arr()).asJava();
        } else if (object2 instanceof scala.collection.immutable.Map) {
            object = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)value2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), MODULE$.convertToScalaCollection(v));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).asJava();
        } else if (object2 instanceof Seq) {
            Seq seq = (Seq)object2;
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)seq.map((Function1 & Serializable & scala.Serializable)value -> MODULE$.convertToScalaCollection(value), Seq$.MODULE$.canBuildFrom())).asJava();
        } else {
            object = value2;
        }
        return object;
    }

    public <T> OJAIKey<T> getOjaiKey(ClassTag<T> evidence$1) {
        ClassTag classTag;
        ClassTag classTag2 = classTag = package$.MODULE$.classTag(evidence$1);
        if (MapRDBUtils$ClassTagOps$.MODULE$.$less$less$colon$extension(this.ClassTagOps(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(String.class))), classTag2)) {
            return OJAIKey$.MODULE$.ojaiStringKey();
        }
        ClassTag classTag3 = classTag;
        if (MapRDBUtils$ClassTagOps$.MODULE$.$less$less$colon$extension(this.ClassTagOps(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(ByteBuffer.class))), classTag3)) {
            return OJAIKey$.MODULE$.ojaibytebufferKey();
        }
        ClassTag classTag4 = classTag;
        if (MapRDBUtils$ClassTagOps$.MODULE$.$less$less$colon$extension(this.ClassTagOps(package$.MODULE$.classTag(ClassTag$.MODULE$.apply(DBBinaryValue.class))), classTag4)) {
            return OJAIKey$.MODULE$.ojaibinaryKey();
        }
        throw new RuntimeException(new StringBuilder(31).append("Key with type:").append(package$.MODULE$.classTag(evidence$1).runtimeClass()).append(" is not supported").toString());
    }

    public <T> ClassTag<T> ClassTagOps(ClassTag<T> classTag) {
        return classTag;
    }

    private MapRDBUtils$() {
        MODULE$ = this;
    }
}

