/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests;

import com.mapr.db.MapRDB;
import com.mapr.db.spark.MapRDBSpark;
import com.mapr.db.spark.RDD.api.java.MapRDBJavaRDD;
import com.mapr.db.spark.api.java.MapRDBJavaContext;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.tests.Person;
import com.mapr.tests.annotations.ClusterTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.store.QueryCondition;
import scala.Tuple2;

@Category(value={ClusterTest.class})
public class MapRDBJavaRDDTests {
    private static final String tableName = "/tmp/UserInfo";
    private static final JavaSparkContext ctx = new JavaSparkContext("local[*]", "java maprdb rdd tests");

    private void tableInitialization(String tableName) {
        List<String> docs = Arrays.asList("{\"_id\":\"alehmann\",\"dob\":{\"$dateDay\":\"1980-10-13\"},\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}", "{\"_id\":\"dsimon\",\"dob\":{\"$dateDay\":\"1980-10-13\"},\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"jdoe\",\"dob\":{\"$dateDay\":\"1970-06-23\"},\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":{\"$dateDay\":\"1982-02-03\"},\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":{\"$dateDay\":\"1982-02-03\"},\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}");
        JavaRDD documents = ctx.parallelize(docs).map((Function)new convertToOjaiDoc());
        MapRDBJavaContext.maprDBSparkContext((JavaRDD)documents).saveToMapRDB(tableName, true, true);
    }

    @Test
    public void testLoadJavaRDD() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName);
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        List listOfDocs = docs.collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("first_name"))) continue;
            System.out.println("testLoadJavaRDD failed");
            return;
        }
        System.out.println("testLoadJavaRDD succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testLoadJavaRDDBean() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName, Person.class);
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        List listOfDocs = docs.collect();
        for (Person doc : listOfDocs) {
            if (result.contains(doc.getFirstName())) continue;
            System.out.println("testLoadJavaRDDBean failed");
            return;
        }
        System.out.println("testLoadJavaRDDBean succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testSaveMapRDBDocRDD() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        if (DBClient$.MODULE$.apply().tableExists("/tmp/UserInfoJava")) {
            DBClient$.MODULE$.apply().deleteTable("/tmp/UserInfoJava");
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName);
        MapRDBJavaContext.maprDBSparkContext((JavaRDD)docs).saveToMapRDB("/tmp/UserInfoJava", true);
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        List listOfDocs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB("/tmp/UserInfoJava").collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("first_name"))) continue;
            System.out.println("testSaveMapRDBDocRDD failed");
            return;
        }
        System.out.println("testSaveMapRDBDocRDD succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testSaveMapRDBDocBeanRDD() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        if (DBClient$.MODULE$.apply().tableExists("/tmp/UserInfoJavaBean")) {
            DBClient$.MODULE$.apply().deleteTable("/tmp/UserInfoJavaBean");
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName, Person.class);
        MapRDBJavaContext.maprDBSparkContext((JavaRDD)docs, Person.class).saveToMapRDB("/tmp/UserInfoJavaBean", true);
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        List listOfDocs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB("/tmp/UserInfoJavaBean", Person.class).collect();
        for (Person doc : listOfDocs) {
            if (result.contains(doc.getFirstName())) continue;
            System.out.println("testSaveMapRDBDocBeanRDD failed");
            return;
        }
        System.out.println("testSaveMapRDBDocBeanRDD succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testSaveMapRDBDocPairedRDDBean() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        if (DBClient$.MODULE$.apply().tableExists("/tmp/UserInfoJavaBeanPaired")) {
            DBClient$.MODULE$.apply().deleteTable("/tmp/UserInfoJavaBeanPaired");
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName, Person.class);
        JavaPairRDD rdd = docs.mapToPair((PairFunction)new keyData());
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        MapRDBJavaContext.maprDBSparkContext((JavaPairRDD)rdd, String.class, Person.class).saveToMapRDB("/tmp/UserInfoJavaBeanPaired", true);
        List listOfDocs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB("/tmp/UserInfoJavaBeanPaired", Person.class).collect();
        for (Person doc : listOfDocs) {
            if (result.contains(doc.getFirstName())) continue;
            System.out.println("testSaveMapRDBDocPairedRDDBean failed");
            return;
        }
        System.out.println("testSaveMapRDBDocPairedRDDBean succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testSaveMapRDBDocPairedRDD() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        if (DBClient$.MODULE$.apply().tableExists("/tmp/UserInfoJavaPaired")) {
            DBClient$.MODULE$.apply().deleteTable("/tmp/UserInfoJavaPaired");
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName);
        JavaPairRDD rdd = docs.mapToPair((PairFunction)new keyDataOjai());
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        MapRDBJavaContext.maprDBSparkContext((JavaPairRDD)rdd, String.class).saveToMapRDB("/tmp/UserInfoJavaPaired", true);
        List listOfDocs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB("/tmp/UserInfoJavaPaired").collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("first_name"))) continue;
            System.out.println("testSaveMapRDBDocPairedRDDBean failed");
            return;
        }
        System.out.println("testSaveMapRDBDocPairedRDDBean succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testLoadWithSelectColumns() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName).select(new String[]{"_id", "address", "first_name", "last_name"});
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        List listOfDocs = docs.collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("first_name"))) continue;
            System.out.println("testLoadWithSelectColumns failed");
            return;
        }
        System.out.println("testLoadWithSelectColumns succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testLoadWithWhereCondition() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        QueryCondition isDoe = MapRDB.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Doe").build();
        ArrayList<String> result = new ArrayList<String>();
        result.add("David");
        result.add("Andrew");
        result.add("John");
        result.add("Maxime");
        result.add("Robert");
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName).where(isDoe);
        List listOfDocs = docs.collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("first_name"))) continue;
            System.out.println("testLoadWithSelectColumns failed");
            return;
        }
        System.out.println("testLoadWithSelectColumns succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testLoadWithWhereAndSelectCondition() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        QueryCondition isDoe = MapRDB.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Doe").build();
        ArrayList<String> result = new ArrayList<String>();
        result.add("Lehmann");
        result.add("Doe");
        result.add("Simon");
        result.add("Dupont");
        result.add("Smith");
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName).where(isDoe).select(new String[]{"_id", "last_name", "address"});
        List listOfDocs = docs.collect();
        for (OJAIDocument doc : listOfDocs) {
            if (result.contains(doc.getString("last_name"))) continue;
            System.out.println("testLoadWithWhereAndSelectCondition failed");
            return;
        }
        System.out.println("testLoadWithWhereAndSelectCondition succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    @Test
    public void testLoadWithWhereAndSelectConditionWithBean() {
        if (!MapRDB.tableExists((String)tableName)) {
            this.tableInitialization(tableName);
        }
        QueryCondition isDupont = MapRDB.newCondition().is("last_name", QueryCondition.Op.EQUAL, "Dupont").build();
        ArrayList<String> result = new ArrayList<String>();
        result.add("Lehmann");
        result.add("Doe");
        result.add("Simon");
        result.add("Dupont");
        result.add("Smith");
        MapRDBJavaRDD docs = MapRDBJavaContext.maprDBSparkContext((JavaSparkContext)ctx).loadFromMapRDB(tableName, Person.class).where(isDupont).select(new String[]{"_id", "last_name", "interests"});
        List listOfDocs = docs.collect();
        for (Person doc : listOfDocs) {
            if (result.contains(doc.getLastName())) continue;
            System.out.println("testLoadWithWhereAndSelectConditionWithBean failed");
            return;
        }
        System.out.println("testLoadWithWhereAndSelectConditionWithBean succeeded");
        MapRDB.deleteTable((String)tableName);
    }

    public static class convertToOjaiDoc
    implements Function<String, OJAIDocument> {
        public OJAIDocument call(String s) throws Exception {
            return MapRDBSpark.newDocument((String)s);
        }
    }

    public static class keyDataOjai
    implements PairFunction<OJAIDocument, String, OJAIDocument> {
        public Tuple2<String, OJAIDocument> call(OJAIDocument x) {
            String personName = x.getString("first_name");
            return new Tuple2((Object)personName, (Object)x);
        }
    }

    public static class keyData
    implements PairFunction<Person, String, Person> {
        public Tuple2<String, Person> call(Person x) {
            String personName = x.getFirstName();
            return new Tuple2((Object)personName, (Object)x);
        }
    }
}

