/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.spark.utils;

import com.mapr.db.Admin;
import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.TableDescriptor;
import com.mapr.db.exceptions.TableExistsException;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.codec.BeanCodec$;
import com.mapr.db.spark.types.DBArrayValue;
import com.mapr.db.spark.types.DBMapValue;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.ObjectInput;
import java.nio.ByteBuffer;
import org.ojai.Document;
import org.ojai.Value;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class MapRDBUtils$ {
    public static final MapRDBUtils$ MODULE$;

    static {
        new MapRDBUtils$();
    }

    public Tuple2<Object, Object> checkOrCreateTable(String tableName, boolean bulkMode, boolean createTable, Seq<Value> keys) {
        boolean isBulkLoad = bulkMode;
        if (MapRDB.tableExists((String)tableName)) {
            if (createTable) {
                throw new TableExistsException(new StringBuilder().append((Object)"Table: ").append((Object)tableName).append((Object)" already Exists").toString());
            }
            if (bulkMode) {
                Admin admin = MapRDB.newAdmin();
                isBulkLoad = admin.getTableDescriptor(tableName).isBulkLoad();
            }
            return new Tuple2.mcZZ.sp(false, isBulkLoad);
        }
        if (createTable) {
            TableDescriptor tabDesc = MapRDB.newTableDescriptor();
            tabDesc.setAutoSplit(true);
            tabDesc.setPath(tableName);
            tabDesc.setBulkLoad(bulkMode);
            Table table = keys.isEmpty() ? MapRDB.newAdmin().createTable(tabDesc) : ((AdminImpl)MapRDB.newAdmin()).createTable(tabDesc, (Value[])keys.toArray(ClassTag$.MODULE$.apply(Value.class)));
            return new Tuple2.mcZZ.sp(true, bulkMode);
        }
        throw new TableNotFoundException(new StringBuilder().append((Object)"Table: ").append((Object)tableName).append((Object)" not found").toString());
    }

    public void setBulkLoad(String tableName, boolean bulkMode) {
        Admin admin = MapRDB.newAdmin();
        TableDescriptor desc = admin.getTableDescriptor(tableName);
        desc.setBulkLoad(bulkMode);
        admin.alterTable(desc);
    }

    public boolean containsRow(byte[] row, ConditionNode.RowkeyRange rowkeyRange) {
        return Bytes.compareTo((byte[])row, (byte[])rowkeyRange.getStartRow()) >= 0 && (Bytes.compareTo((byte[])row, (byte[])rowkeyRange.getStopRow()) < 0 || Bytes.equals((byte[])rowkeyRange.getStopRow(), (byte[])MapRConstants.EMPTY_BYTE_ARRAY));
    }

    public <T> T toBeanClass(Document doc, Class<T> beanClass) {
        return (T)(beanClass.getSimpleName().equals("OJAIDocument") ? MapRDBSpark$.MODULE$.newDocument(doc) : BeanCodec$.MODULE$.encode(doc.asReader(), beanClass));
    }

    public void readBytes(ByteBuffer buff, int bufferSize, ObjectInput objectInput) {
        int read;
        byte[] byteArray = new byte[bufferSize];
        int readbytes = objectInput.read(byteArray, 0, bufferSize);
        buff.put(byteArray, 0, readbytes);
        for (int remaining = bufferSize - readbytes; remaining > 0; remaining -= read) {
            read = objectInput.read(byteArray, readbytes, remaining);
            buff.put(byteArray, readbytes, read);
            readbytes += read;
        }
        buff.flip();
    }

    public Seq<Object> convertToSeq(Seq<Object> value) {
        return value instanceof DBArrayValue ? (Seq)((DBArrayValue)value).arr().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x$1) {
                return x$1;
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)value.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Object x$2) {
                return MapRDBUtils$.MODULE$.convertToScalaCollection(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public scala.collection.immutable.Map<String, Object> convertToMap(scala.collection.immutable.Map<String, Object> value) {
        return value instanceof DBMapValue ? (scala.collection.immutable.Map)((DBMapValue)value).value().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom()) : (scala.collection.immutable.Map)value.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), MapRDBUtils$.MODULE$.convertToScalaCollection(v));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Object convertToScalaCollection(Object value) {
        if (value instanceof DBMapValue) {
            return JavaConverters$.MODULE$.mapAsJavaMapConverter(((DBMapValue)value).value()).asJava();
        }
        if (value instanceof DBArrayValue) {
            return JavaConverters$.MODULE$.seqAsJavaListConverter(((DBArrayValue)value).arr()).asJava();
        }
        if (value instanceof scala.collection.immutable.Map) {
            return JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((scala.collection.immutable.Map)value).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$3) {
                    Tuple2<String, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), MapRDBUtils$.MODULE$.convertToScalaCollection(v));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom())).asJava();
        }
        if (value instanceof Seq) {
            return JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Seq)value).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object x$3) {
                    return MapRDBUtils$.MODULE$.convertToScalaCollection(x$3);
                }
            }, Seq$.MODULE$.canBuildFrom())).asJava();
        }
        return value;
    }

    private MapRDBUtils$() {
        MODULE$ = this;
    }
}

