/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.testCases;

import com.mapr.db.MapRDB;
import com.mapr.db.Table;
import com.mapr.db.spark.RDD.RDDTYPE$;
import com.mapr.db.spark.condition.Predicate;
import com.mapr.db.spark.documentTypeUtils.OJAIType$;
import com.mapr.db.spark.field;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.spark.package$;
import com.mapr.db.spark.sizeOf;
import com.mapr.db.spark.utils.DefaultClass;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.ojai.Document;
import org.ojai.exceptions.TypeException;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PredicateTests$ {
    public static final PredicateTests$ MODULE$;
    private final String tableName;
    private SparkConf conf;
    private volatile boolean bitmap$0;

    static {
        new PredicateTests$();
    }

    private SparkConf conf$lzycompute() {
        PredicateTests$ predicateTests$ = this;
        synchronized (predicateTests$) {
            if (!this.bitmap$0) {
                this.conf = new SparkConf().setAppName("simpletest").set("spark.executor.memory", "1g").set("spark.driver.memory", "1g");
                this.bitmap$0 = true;
            }
            return this.conf;
        }
    }

    public String tableName() {
        return this.tableName;
    }

    public SparkConf conf() {
        return this.bitmap$0 ? this.conf : this.conf$lzycompute();
    }

    public void main(String[] args) {
        SparkContext sc = new SparkContext(this.conf());
        this.tableInitialization(sc, this.tableName());
        this.runTests(sc);
    }

    public Table tableInitialization(SparkContext sparkSession, String tableName) {
        Object object = MapRDB.tableExists((String)tableName) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)tableName)) : BoxedUnit.UNIT;
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"table successfully create :").append((Object)tableName).toString());
        return MapRDB.createTable((String)tableName);
    }

    public void runTests(SparkContext sparkSession) {
        this.testingIdOnlyCondition(sparkSession, this.tableName());
        this.testingSimpleGTCondition(sparkSession, this.tableName());
        this.testingNotExistsCondition(sparkSession, this.tableName());
        this.testingSimpleINCondition(sparkSession, this.tableName());
        this.testingTYPEOFCondition(sparkSession, this.tableName());
        this.testingComplexAND_INcondition(sparkSession, this.tableName());
        this.testingCompositeCondition(sparkSession, this.tableName());
        this.testingMatchesCondition(sparkSession, this.tableName());
        this.testingLikeCondition(sparkSession, this.tableName());
        this.testingThreeConditions(sparkSession, this.tableName());
        this.testingORCondition(sparkSession, this.tableName());
        this.testingComplexConditonWithDate(sparkSession, this.tableName());
        this.testingBetweenCondition(sparkSession, this.tableName());
        this.testingEqualityConditionOnSeq(sparkSession, this.tableName());
        this.testingEqualtiyOnMapOfStrings(sparkSession, this.tableName());
        this.testingEqualityOnMapStringInteger(sparkSession, this.tableName());
        this.testingNotEqualityOnID(sparkSession, this.tableName());
        this.testingNotEqualityConditionOnSeq(sparkSession, this.tableName());
        this.testingNotEqualityOnMapStringInteger(sparkSession, this.tableName());
        this.testingSizeOf(sparkSession, this.tableName());
        this.testingSizeOfWithComplexCondition(sparkSession, this.tableName());
        this.testingTypeOfWithNonExistantType(sparkSession, this.tableName());
        this.testingWithQueryCondition(sparkSession, this.tableName());
        this.testWithListINCondition(sparkSession, this.tableName());
        this.testingSizeOfNotEquals(sparkSession, this.tableName());
        this.testingINConditionOnSeqwithInSeq(sparkSession, this.tableName());
    }

    public boolean testingIdOnlyCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 350).set("s", "Holger Way");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", d);
        d.set("zip-code", "95134");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", d);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("_id").$eq$eq$eq((Object)"k2", com.mapr.db.spark.condition.package$.MODULE$.quotesString())).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return (String)doc.selectDynamic("zip-code", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"95134"}))) {
            Predef$.MODULE$.println((Object)"testingIdOnlyCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingIdOnlyCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingSimpleGTCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("a.c.e", "Hello").set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 11.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        doc.set("a.c.d", 14.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k4", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.c.d").$greater((Object)BoxesRunTime.boxToInteger((int)10), com.mapr.db.spark.condition.package$.MODULE$.quotesInt())).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        MapRDB.getTable((String)tableName).delete("k4");
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(OJAIDocument doc) {
                return BoxesRunTime.unboxToDouble((Object)doc.selectDynamic("a.c.d", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiDouble()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Double.TYPE)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{11.0, 14.0})))) {
            Predef$.MODULE$.println((Object)"testingSimpleGTCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleGTCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$1) {
                    Predef$.MODULE$.println((Object)x$1);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingNotExistsCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.e", "SanJose");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.e", "Milpitas");
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).insertOrReplace("k4", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.e").notexists()).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        MapRDB.getTable((String)tableName).delete("k4");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingNotExistsCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingNotExistsCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$2) {
                    Predef$.MODULE$.println((Object)x$2);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSimpleINCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.boolean", false).set("a.c.d", ODate.parse((String)"2010-01-11")).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", ODate.parse((String)"2011-05-21"));
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", ODate.parse((String)"2005-06-21"));
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").in((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ODate[]{ODate.parse((String)"2011-05-21"), ODate.parse((String)"2013-02-22")})))).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"}))) {
            Predef$.MODULE$.println((Object)"testingSimpleINCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleINCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingOTimeINCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.boolean", false).set("a.c.d", new OTime(1000L)).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", new OTime(1001L));
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", new OTime(1002L));
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").in((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTime[]{new OTime(999L), new OTime(1000L)})))).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingOTimeINCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingOTimeINCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$3) {
                    Predef$.MODULE$.println((Object)x$3);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSimpleOTime(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.boolean", false).set("a.c.d", new OTime(1000L)).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", new OTime(1001L));
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", new OTime(1002L));
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.c.d").$eq$eq$eq((Object)new OTime(1000L), com.mapr.db.spark.condition.package$.MODULE$.quotesOTime())).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingSimpleOTime succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleOTime failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$4) {
                    Predef$.MODULE$.println((Object)x$4);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingTYPEOFCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", "SanJose");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", "Milpitas");
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").typeof("INT")).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingTYPEOFCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingTYPEOFCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$5) {
                    Predef$.MODULE$.println((Object)x$5);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingComplexAND_INcondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5).set("a.c.e", "aaa").set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        doc.set("a.c.e", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").in((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 10}))).and((Predicate)new field("a.c.e").notin((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aaa", "bbb"}))))).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"}))) {
            Predef$.MODULE$.println((Object)"testingComplexAND_INcondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingComplexAND_INcondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$6) {
                    Predef$.MODULE$.println((Object)x$6);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingCompositeCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 10.0);
        doc.set("a.c.e", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").$less((Object)BoxesRunTime.boxToInteger((int)10), com.mapr.db.spark.condition.package$.MODULE$.quotesInt()).and((Predicate)new field("a.c.e").exists())).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k3"}))) {
            Predef$.MODULE$.println((Object)"testingCompositeCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCompositeCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$7) {
                    Predef$.MODULE$.println((Object)x$7);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingLikeCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 10.0);
        doc.set("a.c.e", "xyz");
        doc.set("m", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("m").like("%s")).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingLikeCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLikeCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$8) {
                    Predef$.MODULE$.println((Object)x$8);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingMatchesCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.b[1].decimal", 123.456).set("a.c.d", 5.0).set("m", "MapR wins");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 10.0);
        doc.set("a.c.e", "xyz");
        doc.set("m", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 8.0);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("m").matches(".*s")).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k1"}))) {
            Predef$.MODULE$.println((Object)"testingMatchesCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMatchesCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$9) {
                    Predef$.MODULE$.println((Object)x$9);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingThreeConditions(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b", 5.1).set("a.c.e", "mapR").set("m", "MapR wins").set("a.k", 25.1);
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.k", 10.11);
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.e").exists().and((Predicate)new field("a.b").$greater$eq((Object)BoxesRunTime.boxToInteger((int)5), com.mapr.db.spark.condition.package$.MODULE$.quotesInt()).and(new field("a.k").$less((Object)BoxesRunTime.boxToInteger((int)20), com.mapr.db.spark.condition.package$.MODULE$.quotesInt())))).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k2"}))) {
            Predef$.MODULE$.println((Object)"testingThreeConditions succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingThreeConditions failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$10) {
                    Predef$.MODULE$.println((Object)x$10);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingORCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b", 5.1).set("a.c.d", "mapR").set("m", "MapR wins").set("a.k", 25.1);
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 101);
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 100);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        doc.set("a.c.d", 99);
        MapRDB.getTable((String)tableName).insertOrReplace("k4", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").$greater((Object)BoxesRunTime.boxToLong((long)100L), com.mapr.db.spark.condition.package$.MODULE$.quotesLong()).or((Predicate)new field("a.c.d").typeof("STRING"))).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        MapRDB.getTable((String)tableName).delete("k4");
        if (BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(OJAIDocument doc) {
                return 1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$11, int x$12) {
                return this.apply$mcIII$sp(x$11, x$12);
            }

            public int apply$mcIII$sp(int x$11, int x$12) {
                return x$11 + x$12;
            }
        })) == 2) {
            Predef$.MODULE$.println((Object)"testingORCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingORCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$13) {
                    Predef$.MODULE$.println((Object)x$13);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingTypeOfWithNonExistantType(SparkContext sparkSession, String tableName) {
        boolean bl;
        boolean succeeded = false;
        Document doc = MapRDB.newDocument().set("a.b", 5.1).set("a.c.d", "mapR").set("m", "MapR wins").set("a.k", 25.1);
        MapRDB.getTable((String)tableName).insertOrReplace("k1", doc);
        doc.set("a.c.d", 101);
        MapRDB.getTable((String)tableName).insertOrReplace("k2", doc);
        doc.set("a.c.d", 100);
        MapRDB.getTable((String)tableName).insertOrReplace("k3", doc);
        doc.set("a.c.d", 99);
        MapRDB.getTable((String)tableName).insertOrReplace("k4", doc);
        MapRDB.getTable((String)tableName).flush();
        try {
            OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.c.d").$greater((Object)BoxesRunTime.boxToLong((long)100L), com.mapr.db.spark.condition.package$.MODULE$.quotesLong()).or((Predicate)new field("a.c.d").typeof("STR"))).collect();
        }
        catch (TypeException typeException) {
            Predef$.MODULE$.println((Object)typeException.getMessage());
            Predef$.MODULE$.println((Object)"testingTypeOfWithNonExistantType succeeded");
            succeeded = true;
        }
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        MapRDB.getTable((String)tableName).delete("k3");
        MapRDB.getTable((String)tableName).delete("k4");
        if (succeeded) {
            Predef$.MODULE$.println((Object)"testingTypeOfWithNonExistantType succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingTypeOfWithNonExistantType failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingComplexConditonWithDate(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.c.d", 22).set("m", "MapR wins").set("p.q", ODate.parse((String)"2016-04-05"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        doc.set("a.b", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("id2", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("a.b").notexists().and((Predicate)new field("p.q").typeof("DATE")).and(new field("a.c.d").$greater((Object)BoxesRunTime.boxToLong((long)20L), com.mapr.db.spark.condition.package$.MODULE$.quotesLong()))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1"}))) {
            Predef$.MODULE$.println((Object)"testingComplexConditionWithDate succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingComplexConditionWithDate failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$14) {
                    Predef$.MODULE$.println((Object)x$14);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingBetweenCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document doc = MapRDB.newDocument().set("a.b[0].boolean", false).set("a.c.d", ODate.parse((String)"2015-01-16")).set("a.c.e", "Hello").set("m", "MapR");
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-01-14"));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-06-14"));
        MapRDB.getTable((String)tableName).insertOrReplace("id3", doc);
        doc.set("a.c.d", ODate.parse((String)"2015-02-26"));
        MapRDB.getTable((String)tableName).insertOrReplace("id4", doc);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.c.d").between((Object)ODate.parse((String)"2015-01-15"), (Object)ODate.parse((String)"2015-05-15"), com.mapr.db.spark.condition.package$.MODULE$.quotesODate())).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        MapRDB.getTable((String)tableName).delete("id3");
        MapRDB.getTable((String)tableName).delete("id4");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1", "id4"})))) {
            Predef$.MODULE$.println((Object)"testingBetweenCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBetweenCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.getIdString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$15) {
                    Predef$.MODULE$.println((Object)x$15);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingEqualityConditionOnSeq(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 111.222).set("a.x", true);
        MapRDB.getTable((String)tableName).insertOrReplace("id1", d);
        Document d2 = d.set("a.b[0]", 12345).set("a.b[1]", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.b").$eq$eq$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)12345L), "xyz"})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<String, Object, Object> apply(OJAIDocument doc) {
                return new Tuple3((Object)doc.getIdString(), ((SeqLike)doc.selectDynamic("a.b", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiarrayanyref())).apply(0), ((SeqLike)doc.selectDynamic("a.b", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiarrayanyref())).apply(1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"id2", (Object)BoxesRunTime.boxToLong((long)12345L), (Object)"xyz")})))) {
            Predef$.MODULE$.println((Object)"testingEqualityConditionOnSeq succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingEqualityConditionSeq failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, Object> apply(OJAIDocument doc) {
                    return new Tuple3((Object)doc.getIdString(), doc.getList("a.b").apply(0), doc.getList("a.b").apply(1));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple3<String, Object, Object> x$16) {
                    Predef$.MODULE$.println(x$16);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingINConditionOnSeqwithInSeq(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 111.222).set("a.x", true);
        MapRDB.getTable((String)tableName).insertOrReplace("id1", d);
        Document d2 = d.set("a.b1[0]", 12345).set("a.b1[1]", "xyz");
        d2.set("a.c[0]", d.getList("a.b1"));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        WrappedArray list = Predef$.MODULE$.wrapRefArray((Object[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument doc) {
                return doc.selectDynamic("a.b1", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect());
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.c").$eq$eq$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{list.apply(1)})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        String[] values = (String[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (Predef$.MODULE$.refArrayOps((Object[])values).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id2"})))) {
            Predef$.MODULE$.println((Object)"testingINConditionOnSeqwithInSeq succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingINConditionOnSeqwithInSeq failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, Object> apply(OJAIDocument doc) {
                    return new Tuple3((Object)doc.getIdString(), doc.getList("a.b").apply(0), doc.getList("a.b").apply(1));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple3<String, Object, Object> x$17) {
                    Predef$.MODULE$.println(x$17);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingNotEqualityConditionOnSeq(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 111.222).set("a.x", true);
        MapRDB.getTable((String)tableName).insertOrReplace("id1", d);
        Document d2 = d.set("a.b[0]", 12345).set("a.b[1]", "xyz");
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a.b").$bang$eq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)12345L), "xyz"})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(OJAIDocument doc) {
                return new Tuple2((Object)doc.getIdString(), doc.selectDynamic("a.b", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiDouble()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"id1", (Object)BoxesRunTime.boxToDouble((double)111.222))})))) {
            Predef$.MODULE$.println((Object)"testingNotEqualityConditionOnSeq succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingNotEqualityConditionSeq failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, Object, Object> apply(OJAIDocument doc) {
                    return new Tuple3((Object)doc.getIdString(), doc.getList("a.b").apply(0), doc.getList("a.b").apply(1));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple3<String, Object, Object> x$18) {
                    Predef$.MODULE$.println(x$18);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingNotEqualityOnID(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 350).set("s", "Holger Way");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", d);
        d.set("zip-code", "95134");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", d);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("_id").$bang$eq((Object)"k1", com.mapr.db.spark.condition.package$.MODULE$.quotesString())).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return (String)doc.selectDynamic("zip-code", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"95134"}))) {
            Predef$.MODULE$.println((Object)"testingIdOnlyCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingIdOnlyCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingEqualtiyOnMapOfStrings(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("k", "kite");
        m.put("m", "map");
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a").$eq$eq$eq((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"kite"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m"), (Object)"map")})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1"}))) {
            Predef$.MODULE$.println((Object)"testingEqualityOnMapOfString succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingEqualityOnMapOfStrings failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$19) {
                    Predef$.MODULE$.println((Object)x$19);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingEqualityOnMapStringInteger(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("k", Predef$.MODULE$.int2Integer(100));
        m.put("m", Predef$.MODULE$.int2Integer(120));
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a").$eq$eq$eq((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m"), (Object)BoxesRunTime.boxToInteger((int)120))})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id1"}))) {
            Predef$.MODULE$.println((Object)"testingEqualityOnMapStringInteger succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingEqualityOnMapStringInteger failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$20) {
                    Predef$.MODULE$.println((Object)x$20);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingNotEqualityOnMapStringInteger(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("k", Predef$.MODULE$.int2Integer(100));
        m.put("m", Predef$.MODULE$.int2Integer(120));
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("a").$bang$eq((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m"), (Object)BoxesRunTime.boxToInteger((int)120))})))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id2"}))) {
            Predef$.MODULE$.println((Object)"testingNotEqualityOnMapStringInteger succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingNotEqualityOnMapStringInteger failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$21) {
                    Predef$.MODULE$.println((Object)x$21);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSizeOf(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("k", Predef$.MODULE$.int2Integer(100));
        m.put("m", Predef$.MODULE$.int2Integer(120));
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new sizeOf(new field("a.m")).$greater(4L)).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id2"}))) {
            Predef$.MODULE$.println((Object)"testingSizeOf succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSizeOf failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$22) {
                    Predef$.MODULE$.println((Object)x$22);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSizeOfWithComplexCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("k", Predef$.MODULE$.int2Integer(100));
        m.put("m", Predef$.MODULE$.int2Integer(120));
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new sizeOf(new field("a")).$greater(1L).and(new field("a").$bang$eq((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)BoxesRunTime.boxToInteger((int)100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"m"), (Object)BoxesRunTime.boxToInteger((int)120))}))))).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id2"}))) {
            Predef$.MODULE$.println((Object)"testingSizeOfWithComplexCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSizeOfWithComplexCondition failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$23) {
                    Predef$.MODULE$.println((Object)x$23);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingWithQueryCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        Document d = MapRDB.newDocument().set("a.b", 350).set("s", "Holger Way");
        MapRDB.getTable((String)tableName).insertOrReplace("k1", d);
        d.set("zip-code", "95134");
        MapRDB.getTable((String)tableName).insertOrReplace("k2", d);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(MapRDB.newCondition().is("_id", QueryCondition.Op.EQUAL, "k2").build()).collect();
        MapRDB.getTable((String)tableName).delete("k1");
        MapRDB.getTable((String)tableName).delete("k2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return (String)doc.selectDynamic("zip-code", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"95134"}))) {
            Predef$.MODULE$.println((Object)"testingWithQueryCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingWithQueryCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testWithListINCondition(SparkContext sparkSession, String tableName) {
        boolean bl;
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB("/tmp/bug26114", ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("level0_a0_bool").in((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)-4998511681057838802L), BoxesRunTime.boxToDouble((double)0.22987476349110803), BoxesRunTime.boxToInteger((int)-1722097687), BoxesRunTime.boxToDouble((double)0.6030484), BoxesRunTime.boxToBoolean((boolean)false)})))).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])maprd).size() == 0) {
            Predef$.MODULE$.println((Object)"testWithListINCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testWithListINCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingSizeOfNotEquals(SparkContext sparkSession, String tableName) {
        boolean bl;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("k", Predef$.MODULE$.int2Integer(100));
        m.put("m", Predef$.MODULE$.int2Integer(120));
        Document doc = MapRDB.newDocument().set("a", m).set("b.c.d", ODate.parse((String)"2013-03-22"));
        MapRDB.getTable((String)tableName).insertOrReplace("id1", doc);
        Document d2 = doc.set("a.m", "not map").setArray("x.y", (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 44}), ClassTag$.MODULE$.Int()));
        MapRDB.getTable((String)tableName).insertOrReplace("id2", d2);
        MapRDB.getTable((String)tableName).flush();
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new sizeOf(new field("a.m")).$bang$eq(4L)).collect();
        MapRDB.getTable((String)tableName).delete("id1");
        MapRDB.getTable((String)tableName).delete("id2");
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument doc) {
                return doc.getIdString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id2"}))) {
            Predef$.MODULE$.println((Object)"testingSizeOfNotEquals succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSizeOfNotEquals failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument doc) {
                    return doc.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$24) {
                    Predef$.MODULE$.println((Object)x$24);
                }
            });
            bl = false;
        }
        return bl;
    }

    private PredicateTests$() {
        MODULE$ = this;
        this.tableName = "/tmp/user_profiles_predicates";
    }
}

