/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.testCases;

import com.mapr.db.MapRDB;
import com.mapr.db.TableDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.spark.RDD.MapRDBTableScanRDD;
import com.mapr.db.spark.RDD.RDDTYPE$;
import com.mapr.db.spark.condition.Predicate;
import com.mapr.db.spark.dbclient.DBClient$;
import com.mapr.db.spark.exceptions.SchemaMappingException;
import com.mapr.db.spark.field;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.spark.package$;
import com.mapr.db.spark.utils.DefaultClass;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.ojai.Document;
import org.ojai.store.DocumentStore;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class SparkSqlAccessTests$ {
    public static final SparkSqlAccessTests$ MODULE$;
    private SparkConf conf;
    private SparkSession spark;
    private final String tableName;
    private volatile byte bitmap$0;

    static {
        new SparkSqlAccessTests$();
    }

    private SparkConf conf$lzycompute() {
        SparkSqlAccessTests$ sparkSqlAccessTests$ = this;
        synchronized (sparkSqlAccessTests$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.conf = new SparkConf().setAppName("simpletest").set("spark.executor.memory", "1g").set("spark.driver.memory", "1g");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.conf;
        }
    }

    private SparkSession spark$lzycompute() {
        SparkSqlAccessTests$ sparkSqlAccessTests$ = this;
        synchronized (sparkSqlAccessTests$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.spark = SparkSession$.MODULE$.builder().appName("SparkSqlTest").config(this.conf()).getOrCreate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.spark;
        }
    }

    public SparkConf conf() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.conf$lzycompute() : this.conf;
    }

    public SparkSession spark() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.spark$lzycompute() : this.spark;
    }

    public String tableName() {
        return this.tableName;
    }

    public void main(String[] args) {
        this.tableInitialization(this.tableName());
        this.runTests(this.spark());
    }

    public void tableInitialization(String tableName) {
        Object object = MapRDB.tableExists((String)tableName) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)tableName)) : BoxedUnit.UNIT;
        TableDescriptor tabDesc = DBClient$.MODULE$.apply().newTableDescriptor();
        tabDesc.setAutoSplit(true);
        tabDesc.setPath(tableName);
        tabDesc.setInsertionOrder(false);
        DBClient$.MODULE$.apply().createTable(tabDesc);
        DocumentStore table = DBClient$.MODULE$.apply().getTable(tableName);
        table.insertOrReplace(this.getNullRecord());
        table.insertOrReplace(this.getBooleanRecord());
        table.insertOrReplace(this.getStringRecord());
        table.insertOrReplace(this.getByteRecord());
        table.insertOrReplace(this.getShortRecord());
        table.insertOrReplace(this.getIntRecord());
        table.insertOrReplace(this.getLongRecord());
        table.insertOrReplace(this.getFloatRecord());
        table.insertOrReplace(this.getDoubleRecord());
        table.insertOrReplace(this.getDateRecord());
        table.insertOrReplace(this.getTimeRecord());
        table.insertOrReplace(this.getTimeStampRecord());
        table.insertOrReplace(this.getBinaryRecord());
        table.insertOrReplace(this.getMapRecord());
        table.insertOrReplace(this.getArrayRecord());
        table.flush();
        table.close();
    }

    private Document getBooleanRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("boolean");
        rec.set("null", true);
        rec.set("boolean", true);
        rec.set("string", true);
        rec.set("byte", true);
        rec.set("short", true);
        rec.set("int", true);
        rec.set("long", true);
        rec.set("float", true);
        rec.set("double", true);
        rec.set("decimal", true);
        rec.set("date", true);
        rec.set("time", true);
        rec.set("timestamp", true);
        rec.set("binary", true);
        rec.set("map", true);
        rec.set("array", true);
        return rec;
    }

    private Document getNullRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("null");
        rec.setNull("null");
        rec.setNull("boolean");
        rec.setNull("string");
        rec.setNull("byte");
        rec.setNull("short");
        rec.setNull("int");
        rec.setNull("long");
        rec.setNull("float");
        rec.setNull("double");
        rec.setNull("decimal");
        rec.setNull("date");
        rec.setNull("time");
        rec.setNull("timestamp");
        rec.setNull("binary");
        rec.setNull("map");
        rec.setNull("array");
        return rec;
    }

    private Document getStringRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("string");
        rec.set("null", "hello");
        rec.set("boolean", "hello");
        rec.set("string", "hello");
        rec.set("byte", "hello");
        rec.set("short", "hello");
        rec.set("int", "hello");
        rec.set("long", "hello");
        rec.set("float", "hello");
        rec.set("double", "hello");
        rec.set("decimal", "hello");
        rec.set("date", "hello");
        rec.set("time", "hello");
        rec.set("timestamp", "hello");
        rec.set("binary", "hello");
        rec.set("map", "hello");
        rec.set("array", "hello");
        return rec;
    }

    private Document getByteRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("byte");
        rec.set("null", (byte)100);
        rec.set("boolean", (byte)100);
        rec.set("string", (byte)100);
        rec.set("byte", (byte)100);
        rec.set("short", (byte)100);
        rec.set("int", (byte)100);
        rec.set("long", (byte)100);
        rec.set("float", (byte)100);
        rec.set("double", (byte)100);
        rec.set("decimal", (byte)100);
        rec.set("date", (byte)100);
        rec.set("time", (byte)100);
        rec.set("timestamp", (byte)100);
        rec.set("binary", (byte)100);
        rec.set("map", (byte)100);
        rec.set("array", (byte)100);
        return rec;
    }

    private Document getShortRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("short");
        rec.set("null", (short)10000);
        rec.set("boolean", (short)10000);
        rec.set("string", (short)10000);
        rec.set("byte", (short)10000);
        rec.set("short", (short)10000);
        rec.set("int", (short)10000);
        rec.set("long", (short)10000);
        rec.set("float", (short)10000);
        rec.set("double", (short)10000);
        rec.set("decimal", (short)10000);
        rec.set("date", (short)10000);
        rec.set("time", (short)10000);
        rec.set("timestamp", (short)10000);
        rec.set("binary", (short)10000);
        rec.set("map", (short)10000);
        rec.set("array", (short)10000);
        return rec;
    }

    private Document getIntRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("int");
        rec.set("null", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("boolean", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("string", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("byte", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("short", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("int", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("long", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("float", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("double", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("decimal", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("date", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("time", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("timestamp", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("binary", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("map", Predef$.MODULE$.Integer2int(new Integer(5000)));
        rec.set("array", Predef$.MODULE$.Integer2int(new Integer(5000)));
        return rec;
    }

    private Document getLongRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("long");
        rec.set("null", 12345678999L);
        rec.set("boolean", 12345678999L);
        rec.set("string", 12345678999L);
        rec.set("byte", 12345678999L);
        rec.set("short", 12345678999L);
        rec.set("int", 12345678999L);
        rec.set("long", 12345678999L);
        rec.set("float", 12345678999L);
        rec.set("double", 12345678999L);
        rec.set("decimal", 12345678999L);
        rec.set("date", 12345678999L);
        rec.set("time", 12345678999L);
        rec.set("timestamp", 12345678999L);
        rec.set("binary", 12345678999L);
        rec.set("map", 12345678999L);
        rec.set("array", 12345678999L);
        return rec;
    }

    private Document getFloatRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("float");
        rec.set("null", 10.1234f);
        rec.set("boolean", 10.1234f);
        rec.set("string", 10.1234f);
        rec.set("byte", 10.1234f);
        rec.set("short", 10.1234f);
        rec.set("int", 10.1234f);
        rec.set("long", 10.1234f);
        rec.set("float", 10.1234f);
        rec.set("double", 10.1234f);
        rec.set("decimal", 10.1234f);
        rec.set("date", 10.1234f);
        rec.set("time", 10.1234f);
        rec.set("timestamp", 10.1234f);
        rec.set("binary", 10.1234f);
        rec.set("map", 10.1234f);
        rec.set("array", 10.1234f);
        return rec;
    }

    private Document getDoubleRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("double");
        rec.set("null", 10.1234567891);
        rec.set("boolean", 10.1234567891);
        rec.set("string", 10.1234567891);
        rec.set("byte", 10.1234567891);
        rec.set("short", 10.1234567891);
        rec.set("int", 10.1234567891);
        rec.set("long", 10.1234567891);
        rec.set("float", 10.1234567891);
        rec.set("double", 10.1234567891);
        rec.set("decimal", 10.1234567891);
        rec.set("date", 10.1234567891);
        rec.set("time", 10.1234567891);
        rec.set("timestamp", 10.1234567891);
        rec.set("binary", 10.1234567891);
        rec.set("map", 10.1234567891);
        rec.set("array", 10.1234567891);
        return rec;
    }

    private Document getDecimalRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("decimal");
        rec.set("null", new BigDecimal(1.5));
        rec.set("boolean", new BigDecimal(1.5));
        rec.set("string", new BigDecimal(1.5));
        rec.set("byte", new BigDecimal(1.5));
        rec.set("short", new BigDecimal(1.5));
        rec.set("int", new BigDecimal(1.5));
        rec.set("long", new BigDecimal(1.5));
        rec.set("float", new BigDecimal(1.5));
        rec.set("double", new BigDecimal(1.5));
        rec.set("decimal", new BigDecimal(1.5));
        rec.set("date", new BigDecimal(1.5));
        rec.set("time", new BigDecimal(1.5));
        rec.set("timestamp", new BigDecimal(1.5));
        rec.set("binary", new BigDecimal(1.5));
        rec.set("map", new BigDecimal(1.5));
        rec.set("array", new BigDecimal(1.5));
        return rec;
    }

    private Document getDateRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("date");
        rec.set("null", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("boolean", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("string", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("byte", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("short", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("int", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("long", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("float", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("double", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("decimal", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("date", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("time", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("timestamp", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("binary", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("map", ODate.fromDaysSinceEpoch((int)1000));
        rec.set("array", ODate.fromDaysSinceEpoch((int)1000));
        return rec;
    }

    private Document getTimeRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("time");
        rec.set("null", OTime.fromMillisOfDay((int)1000));
        rec.set("boolean", OTime.fromMillisOfDay((int)1000));
        rec.set("string", OTime.fromMillisOfDay((int)1000));
        rec.set("byte", OTime.fromMillisOfDay((int)1000));
        rec.set("short", OTime.fromMillisOfDay((int)1000));
        rec.set("int", OTime.fromMillisOfDay((int)1000));
        rec.set("long", OTime.fromMillisOfDay((int)1000));
        rec.set("float", OTime.fromMillisOfDay((int)1000));
        rec.set("double", OTime.fromMillisOfDay((int)1000));
        rec.set("decimal", OTime.fromMillisOfDay((int)1000));
        rec.set("date", OTime.fromMillisOfDay((int)1000));
        rec.set("time", OTime.fromMillisOfDay((int)1000));
        rec.set("timestamp", OTime.fromMillisOfDay((int)1000));
        rec.set("binary", OTime.fromMillisOfDay((int)1000));
        rec.set("map", OTime.fromMillisOfDay((int)1000));
        rec.set("array", OTime.fromMillisOfDay((int)1000));
        return rec;
    }

    private Document getTimeStampRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.setId("timestamp");
        rec.set("null", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("boolean", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("string", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("byte", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("short", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("int", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("long", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("float", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("double", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("decimal", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("date", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("time", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("timestamp", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("binary", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("map", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        rec.set("array", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()));
        return rec;
    }

    private Document getBinaryRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        byte[] bytes = (byte[])Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(1, 10)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$1) {
                return (byte)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        rec.setId("binary");
        rec.set("null", bytes);
        rec.set("boolean", bytes);
        rec.set("string", bytes);
        rec.set("byte", bytes);
        rec.set("short", bytes);
        rec.set("int", bytes);
        rec.set("long", bytes);
        rec.set("float", bytes);
        rec.set("double", bytes);
        rec.set("decimal", bytes);
        rec.set("date", bytes);
        rec.set("time", bytes);
        rec.set("timestamp", bytes);
        rec.set("binary", bytes);
        rec.set("map", bytes);
        rec.set("array", bytes);
        return rec;
    }

    private Document getMapRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "AAA");
        map.put("Age", new Integer(20));
        rec.setId("map");
        rec.set("null", map);
        rec.set("boolean", map);
        rec.set("string", map);
        rec.set("byte", map);
        rec.set("short", map);
        rec.set("int", map);
        rec.set("long", map);
        rec.set("float", map);
        rec.set("double", map);
        rec.set("decimal", map);
        rec.set("date", map);
        rec.set("time", map);
        rec.set("timestamp", map);
        rec.set("binary", map);
        rec.set("map", map);
        rec.set("array", map);
        return rec;
    }

    private Document getArrayRecord() {
        DBDocumentImpl rec = new DBDocumentImpl();
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        Integer intvalue = Predef$.MODULE$.int2Integer(500);
        values.add(intvalue);
        values.add(new Double(5555.5555));
        rec.setId("array");
        rec.set("null", values);
        rec.set("boolean", values);
        rec.set("string", values);
        rec.set("byte", values);
        rec.set("short", values);
        rec.set("int", values);
        rec.set("long", values);
        rec.set("float", values);
        rec.set("double", values);
        rec.set("decimal", values);
        rec.set("date", values);
        rec.set("time", values);
        rec.set("timestamp", values);
        rec.set("binary", values);
        rec.set("map", values);
        rec.set("array", values);
        return rec;
    }

    public boolean testingBooleanVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Boolean bl2;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("boolean"));
                            if (!bl) break block2;
                            bl2 = null;
                            break block3;
                        }
                        if (bl) break block4;
                        bl2 = BoxesRunTime.boxToBoolean((boolean)row.getBoolean(row.fieldIndex("boolean")));
                    }
                    return bl2;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), null})))) {
            Predef$.MODULE$.println((Object)"testingBooleanVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingBooleanVsNull Failed");
        return false;
    }

    public boolean testingStringVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", null})))) {
            Predef$.MODULE$.println((Object)"testingStringVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsNull Failed");
        return false;
    }

    public boolean testingByteVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Byte by;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("byte"));
                            if (!bl) break block2;
                            by = null;
                            break block3;
                        }
                        if (bl) break block4;
                        by = BoxesRunTime.boxToByte((byte)row.getByte(row.fieldIndex("byte")));
                    }
                    return by;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)100)), null})))) {
            Predef$.MODULE$.println((Object)"testingByteVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingByteVsNull Failed");
        return false;
    }

    public boolean testingShortVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Short s;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("short"));
                            if (!bl) break block2;
                            s = null;
                            break block3;
                        }
                        if (bl) break block4;
                        s = BoxesRunTime.boxToShort((short)row.getShort(row.fieldIndex("short")));
                    }
                    return s;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)((short)10000)), null})))) {
            Predef$.MODULE$.println((Object)"testingShortVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingShortVsNull Failed");
        return false;
    }

    public boolean testingIntVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Integer n;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("int"));
                            if (!bl) break block2;
                            n = null;
                            break block3;
                        }
                        if (bl) break block4;
                        n = BoxesRunTime.boxToInteger((int)row.getInt(row.fieldIndex("int")));
                    }
                    return n;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5000), null})))) {
            Predef$.MODULE$.println((Object)"testingIntVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingIntVsNull Failed");
        return false;
    }

    public boolean testingLongVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Long l;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("long"));
                            if (!bl) break block2;
                            l = null;
                            break block3;
                        }
                        if (bl) break block4;
                        l = BoxesRunTime.boxToLong((long)row.getLong(row.fieldIndex("long")));
                    }
                    return l;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)12345678999L), null})))) {
            Predef$.MODULE$.println((Object)"testingLongVsNull succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingLongVsNull Failed");
        return false;
    }

    public boolean testingFloatVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Float f;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("float"));
                            if (!bl) break block2;
                            f = null;
                            break block3;
                        }
                        if (bl) break block4;
                        f = BoxesRunTime.boxToFloat((float)row.getFloat(row.fieldIndex("float")));
                    }
                    return f;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)10.1234f), null})))) {
            Predef$.MODULE$.println((Object)"testingFloatVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingFloatVsNull Failed");
        return false;
    }

    public boolean testingDoubleVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row row) {
                boolean bl;
                block4: {
                    Double d;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("double"));
                            if (!bl) break block2;
                            d = null;
                            break block3;
                        }
                        if (bl) break block4;
                        d = BoxesRunTime.boxToDouble((double)row.getDouble(row.fieldIndex("double")));
                    }
                    return d;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)10.1234567891), null})))) {
            Predef$.MODULE$.println((Object)"testingDoubleVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingDoubleVsNull Failed");
        return false;
    }

    public boolean testingDateVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Date apply(Row row) {
                return row.getDate(row.fieldIndex("date"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Date.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Date[]{new Date(ODate.fromDaysSinceEpoch((int)1000).toDate().getTime()), null})))) {
            Predef$.MODULE$.println((Object)"testingDateVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingDateVsNull Failed");
        return false;
    }

    public boolean testingTimeVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Timestamp apply(Row row) {
                return row.getTimestamp(row.fieldIndex("time"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{new Timestamp(OTime.fromMillisOfDay((int)1000).toDate().getTime()), null})))) {
            Predef$.MODULE$.println((Object)"testingTimeVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingTimeVsNull Failed");
        return false;
    }

    public boolean testingTimeStampVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Timestamp apply(Row row) {
                return row.getTimestamp(row.fieldIndex("timestamp"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{new Timestamp(OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()).getMillis()), null})))) {
            Predef$.MODULE$.println((Object)"testingTimeStampVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingTimeSTampVsNull Failed");
        return false;
    }

    public boolean testingBinaryVsNull(SparkSession spark, String tableName) {
        byte[] bytes = (byte[])Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(1, 10)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte apply(int x$2) {
                return (byte)x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (new Bytes.ByteArrayComparator().compare((byte[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Row row) {
                return (byte[])row.get(row.fieldIndex("binary"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(byte[] x$3) {
                return x$3 != null;
            }
        })).toSeq().apply(0), bytes) == 0) {
            Predef$.MODULE$.println((Object)"testingBinaryVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingBinaryVsNull Failed");
        return false;
    }

    public boolean testingMapVsNull(SparkSession spark, String tableName) {
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Name"), (Object)"AAA"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Age"), (Object)BoxesRunTime.boxToInteger((int)20))}));
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (((MapLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(Row row) {
                return row.getStruct(row.fieldIndex("map"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Row x$4) {
                return x$4 != null;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Object> apply(Row row) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames()).zip((GenIterable)row.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class)))).toSeq().apply(0)).toSeq().toSet().equals((Object)map.toSeq().toSet())) {
            Predef$.MODULE$.println((Object)"testingMapVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)((scala.collection.immutable.Map)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Nothing$, Nothing$> apply(Row row) {
                return row.getMap(row.fieldIndex("map"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Map<Nothing$, Nothing$> x$5) {
                return x$5 != null;
            }
        })).toSeq().apply(0)));
        Predef$.MODULE$.println((Object)"testingMapVsNull Failed");
        return false;
    }

    public boolean testingArrayVsNull(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"null", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply(Row row) {
                return row.getSeq(row.fieldIndex("array"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Nothing$> x$6) {
                return x$6 != null;
            }
        })).toSeq().apply(0)).sameElements((GenIterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field1", "500", "5555.5555"})))) {
            Predef$.MODULE$.println((Object)"testingArrayVsNull Succeeded");
            return true;
        }
        Predef$.MODULE$.println(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply(Row row) {
                return row.getSeq(row.fieldIndex("array"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Nothing$> x$7) {
                return x$7 != null;
            }
        })).toSeq().apply(0));
        Predef$.MODULE$.println((Object)"testingArrayVsNull Failed");
        return false;
    }

    public boolean testingBooleanVsString(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                boolean bl;
                block4: {
                    String string;
                    block3: {
                        block2: {
                            bl = row.isNullAt(row.fieldIndex("boolean"));
                            if (!bl) break block2;
                            string = null;
                            break block3;
                        }
                        if (bl) break block4;
                        string = row.getString(row.fieldIndex("boolean"));
                    }
                    return string;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"true", "hello"})))) {
            Predef$.MODULE$.println((Object)"testingBooleanVsString Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingBooleanVsString Failed");
        return false;
    }

    public boolean testingBooleanVsByte(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsByte Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsByte Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsByte Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsByte Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsShort(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsShort Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsShort Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsShort Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsShort Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsInt(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsInt Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsInt Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsInt Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsInt Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsLong(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsLong Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsLong Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsLong Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsLong Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsFloat(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsFloat Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsFloat Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsFloat Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsFloat Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsDouble(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsDouble Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsDouble Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsDouble Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsDouble Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsTimeStamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsTimeStamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBooleanVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"boolean", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBooleanVsArray Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBooleanVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBooleanVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBooleanVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingStringVsByte(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "100"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsByte Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsByte Failed");
        return false;
    }

    public boolean testingStringVsShort(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "10000"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsShort Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsShort Failed");
        return false;
    }

    public boolean testingStringVsInt(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "5000"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsInt Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsInt Failed");
        return false;
    }

    public boolean testingStringVsLong(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "12345678999"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsLong Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsLong Failed");
        return false;
    }

    public boolean testingStringVsFloat(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "10.1234"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsFloat Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsFloat Failed");
        return false;
    }

    public boolean testingStringVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "10.1234567891"})))) {
            Predef$.MODULE$.println((Object)"testingStringVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingStringVsDouble Failed");
        return false;
    }

    public boolean testingStringVsDate(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", ODate.fromDaysSinceEpoch((int)1000).toDateStr()})))) {
            Predef$.MODULE$.println((Object)"testingStringVsDate Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsDate Failed");
        return false;
    }

    public boolean testingStringVsTime(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", OTime.fromMillisOfDay((int)1000).toString()})))) {
            Predef$.MODULE$.println((Object)"testingStringVsTime Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsTime Failed");
        return false;
    }

    public boolean testingStringVsTimeStamp(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("string"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()).toString()})))) {
            Predef$.MODULE$.println((Object)"testingStringVsTimeStamp Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingStringVsTimeStamp Failed");
        return false;
    }

    public boolean testingStringVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingStringVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingStringVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingStringVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingStringVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingStringVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingStringVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingStringVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingStringVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingStringVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingStringVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"string", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingStringVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingStringVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingStringVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingStringVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsShort(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.shortArrayOps((short[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final short apply(Row row) {
                return row.getShort(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 10000})))) {
            Predef$.MODULE$.println((Object)"testingByteVsShort Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingByteVsShort Failed");
        return false;
    }

    public boolean testingByteVsInt(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Row row) {
                return row.getInt(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 5000})))) {
            Predef$.MODULE$.println((Object)"testingByteVsInt Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingByteVsInt Failed");
        return false;
    }

    public boolean testingByteVsLong(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row row) {
                return row.getLong(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{100L, 12345678999L})))) {
            Predef$.MODULE$.println((Object)"testingByteVsLong Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingByteVsLong Failed");
        return false;
    }

    public boolean testingByteVsFloat(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{100.0f, 10.1234f})))) {
            Predef$.MODULE$.println((Object)"testingByteVsFloat Succeeded");
            return true;
        }
        Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingByteVsFloat Failed");
        return false;
    }

    public boolean testingByteVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{100.0, 10.1234567891})))) {
            Predef$.MODULE$.println((Object)"testingByteVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingByteVsDouble Failed");
        return false;
    }

    public boolean testingByteVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingByteVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"byte", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingByteVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingByteVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingByteVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingByteVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsInt(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Row row) {
                return row.getInt(row.fieldIndex("byte"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10000, 5000})))) {
            Predef$.MODULE$.println((Object)"testingShortVsInt Succeeded");
            return true;
        }
        Predef$.MODULE$.println((Object)"testingShortVsInt Failed");
        return false;
    }

    public boolean testingShortVsLong(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row row) {
                return row.getLong(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10000L, 12345678999L})))) {
            Predef$.MODULE$.println((Object)"testingShortVsLong Succeeded");
            return true;
        }
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row row) {
                return row.getLong(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingShortVsLong Failed");
        return false;
    }

    public boolean testingShortVsFloat(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{10000.0f, 10.1234f})))) {
            Predef$.MODULE$.println((Object)"testingShortVsFloat Succeeded");
            return true;
        }
        Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingShortVsFloat Failed");
        return false;
    }

    public boolean testingShortVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10000.0, 10.1234567891})))) {
            Predef$.MODULE$.println((Object)"testingShortVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("short"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingShortVsDouble Failed");
        return false;
    }

    public boolean testingShortVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingShortVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"short", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingShortVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingShortVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingShortVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsLong(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row row) {
                return row.getLong(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5000L, 12345678999L})))) {
            Predef$.MODULE$.println((Object)"testingIntVsLong Succeeded");
            return true;
        }
        Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Row row) {
                return row.getLong(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingIntVsLong Failed");
        return false;
    }

    public boolean testingIntVsFloat(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapFloatArray(new float[]{5000.0f, 10.1234f})))) {
            Predef$.MODULE$.println((Object)"testingIntVsFloat Succeeded");
            return true;
        }
        Predef$.MODULE$.floatArrayOps((float[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(Row row) {
                return row.getFloat(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingIntVsFloat Failed");
        return false;
    }

    public boolean testingIntVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5000.0, 10.1234567891})))) {
            Predef$.MODULE$.println((Object)"testingSIntVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("int"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingIntVsDouble Failed");
        return false;
    }

    public boolean testingIntVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingIntVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingIntVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingIntVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingIntVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingShortVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingIntVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"int", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingIntVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingIntVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingIntVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingIntVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsFloat(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsFloat Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsFloat Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsFloat Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsFloat Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("long"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.2345678999E10, 10.1234567891})))) {
            Predef$.MODULE$.println((Object)"testingLongVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row row) {
                return row.getString(row.fieldIndex("long"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingLongVsDouble Failed");
        return false;
    }

    public boolean testingLongVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingLongVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"long", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingLongVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingLongVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingLongVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingLongVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsDouble(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("float"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{10.1234f, 10.1234567891})))) {
            Predef$.MODULE$.println((Object)"testingFloatVsDouble Succeeded");
            return true;
        }
        Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Row row) {
                return row.getDouble(row.fieldIndex("float"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingFloatVsDouble Failed");
        return false;
    }

    public boolean testingFloatVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatsBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingFloatVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"float", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingFloatVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingFloatVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingFloatVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingFloatVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsDate(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsDate Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleVsDate Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsDate Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsDate Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsTime(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsTime Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleVsTime Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsTime Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsTime Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsTimeStamp(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsTimeStamp Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleVsTimeStamp Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsTimestamp Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsTimestamp Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDoubleVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"double", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDoubleVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDoubleVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDoubleVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDoubleVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDateVsTime(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp(row.getTimestamp(row.fieldIndex("time")).getTime());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTimestamp[]{OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()), new OTimestamp(OTime.fromMillisOfDay((int)1000).toDate().getTime())})))) {
            Predef$.MODULE$.println((Object)"testingDateVsTime Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp((java.util.Date)row.getTimestamp(row.fieldIndex("time")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTimestamp[]{OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()), new OTimestamp(OTime.fromMillisOfDay((int)1000).toDate().getTime())}))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingDateVsTime Failed");
        return false;
    }

    public boolean testingDateVsTimeStamp(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp((java.util.Date)row.getTimestamp(row.fieldIndex("timestamp")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTimestamp[]{OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()), OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr())})))) {
            Predef$.MODULE$.println((Object)"testingDateVsTimeStamp Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp((java.util.Date)row.getTimestamp(row.fieldIndex("timestamp")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        ((IterableLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTimestamp[]{OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()), OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr())}))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingDateVsTimeStamp Failed");
        return false;
    }

    public boolean testingDateVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDateVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDateBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDateVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDateVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDateVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDateVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDateVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDateVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDateVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingDateVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"date", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingDateVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingDateVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingDateVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingDateVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeVsTimeStamp(SparkSession spark, String tableName) {
        Dataset booleanAndNullDF = ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp((java.util.Date)row.getTimestamp(row.fieldIndex("time")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OTimestamp[]{OTimestamp.parse((String)ODate.fromDaysSinceEpoch((int)1000).toDateStr()), new OTimestamp(OTime.fromMillisOfDay((int)1000).toDate().getTime())})))) {
            Predef$.MODULE$.println((Object)"testingTimeVsTimeStamp Succeeded");
            return true;
        }
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])booleanAndNullDF.collect()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OTimestamp apply(Row row) {
                return new OTimestamp((java.util.Date)row.getTimestamp(row.fieldIndex("time")));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OTimestamp.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"testingTimeVsTimeStamp Failed");
        return false;
    }

    public boolean testingTimeVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"time", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeStampVsBinary(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeStampVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeStampBinary Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsBinary Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsBinary Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeStampVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeStampVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeStampVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingTimeStampVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"timestamp", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingTimeStampVsBinary Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingTimeStampVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingTimeStampVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBinaryVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBinaryVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBinaryVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBinaryVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBinaryVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingBinaryVsArray(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"binary", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingBinaryVsArray Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingBinaryVsArray Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingBinaryVsArray Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingBinaryVsArray Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingArrayVsMap(SparkSession spark, String tableName) {
        try {
            ((MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(spark.sparkContext()).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where((Predicate)new field("_id").$eq$eq$eq((Object)"array", com.mapr.db.spark.condition.package$.MODULE$.quotesString()).or(new field("_id").$eq$eq$eq((Object)"map", com.mapr.db.spark.condition.package$.MODULE$.quotesString())))).toDF(((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing()).collect();
            Predef$.MODULE$.println((Object)"testingArrayVsMap Failed");
            return false;
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"testingArrayVsMap Failed");
            return false;
        }
        catch (SparkException sparkException) {
            Throwable throwable = sparkException.getCause();
            if (throwable instanceof SchemaMappingException) {
                Predef$.MODULE$.println((Object)"testingArrayVsMap Succeeded");
                return true;
            }
            if (throwable != null) {
                Predef$.MODULE$.println((Object)"testingArrayVsMap Failed");
                return false;
            }
            throw new MatchError((Object)throwable);
        }
    }

    public boolean testingCustomer(SparkSession spark, String tableName) {
        spark.sqlContext().read().format("com.mapr.db.spark.sql.DefaultSource").option("tableName", "/tmp/customer").load().select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).show(10);
        Predef$.MODULE$.println((Object)"testingCustomer Failed");
        return true;
    }

    public void runTests(SparkSession sparkSession) {
        this.testingBooleanVsNull(sparkSession, this.tableName());
        this.testingStringVsNull(sparkSession, this.tableName());
        this.testingByteVsNull(sparkSession, this.tableName());
        this.testingShortVsNull(sparkSession, this.tableName());
        this.testingIntVsNull(sparkSession, this.tableName());
        this.testingLongVsNull(sparkSession, this.tableName());
        this.testingFloatVsNull(sparkSession, this.tableName());
        this.testingDoubleVsNull(sparkSession, this.tableName());
        this.testingDateVsNull(sparkSession, this.tableName());
        this.testingTimeVsNull(sparkSession, this.tableName());
        this.testingTimeStampVsNull(sparkSession, this.tableName());
        this.testingBinaryVsNull(sparkSession, this.tableName());
        this.testingMapVsNull(sparkSession, this.tableName());
        this.testingArrayVsNull(sparkSession, this.tableName());
        this.testingBooleanVsString(sparkSession, this.tableName());
        this.testingBooleanVsByte(sparkSession, this.tableName());
        this.testingBooleanVsShort(sparkSession, this.tableName());
        this.testingBooleanVsInt(sparkSession, this.tableName());
        this.testingBooleanVsLong(sparkSession, this.tableName());
        this.testingBooleanVsFloat(sparkSession, this.tableName());
        this.testingBooleanVsDouble(sparkSession, this.tableName());
        this.testingBooleanVsDate(sparkSession, this.tableName());
        this.testingBooleanVsTime(sparkSession, this.tableName());
        this.testingBooleanVsTimeStamp(sparkSession, this.tableName());
        this.testingBooleanVsBinary(sparkSession, this.tableName());
        this.testingBooleanVsMap(sparkSession, this.tableName());
        this.testingBooleanVsArray(sparkSession, this.tableName());
        this.testingStringVsByte(sparkSession, this.tableName());
        this.testingStringVsShort(sparkSession, this.tableName());
        this.testingStringVsInt(sparkSession, this.tableName());
        this.testingStringVsLong(sparkSession, this.tableName());
        this.testingStringVsFloat(sparkSession, this.tableName());
        this.testingStringVsDouble(sparkSession, this.tableName());
        this.testingStringVsDate(sparkSession, this.tableName());
        this.testingStringVsTime(sparkSession, this.tableName());
        this.testingStringVsTimeStamp(sparkSession, this.tableName());
        this.testingStringVsBinary(sparkSession, this.tableName());
        this.testingStringVsMap(sparkSession, this.tableName());
        this.testingStringVsArray(sparkSession, this.tableName());
        this.testingByteVsShort(sparkSession, this.tableName());
        this.testingByteVsInt(sparkSession, this.tableName());
        this.testingByteVsLong(sparkSession, this.tableName());
        this.testingByteVsFloat(sparkSession, this.tableName());
        this.testingByteVsLong(sparkSession, this.tableName());
        this.testingByteVsFloat(sparkSession, this.tableName());
        this.testingByteVsDouble(sparkSession, this.tableName());
        this.testingByteVsDate(sparkSession, this.tableName());
        this.testingByteVsTime(sparkSession, this.tableName());
        this.testingByteVsTimeStamp(sparkSession, this.tableName());
        this.testingByteVsBinary(sparkSession, this.tableName());
        this.testingByteVsMap(sparkSession, this.tableName());
        this.testingByteVsArray(sparkSession, this.tableName());
        this.testingShortVsInt(sparkSession, this.tableName());
        this.testingShortVsLong(sparkSession, this.tableName());
        this.testingShortVsFloat(sparkSession, this.tableName());
        this.testingShortVsLong(sparkSession, this.tableName());
        this.testingShortVsFloat(sparkSession, this.tableName());
        this.testingShortVsDouble(sparkSession, this.tableName());
        this.testingShortVsDate(sparkSession, this.tableName());
        this.testingShortVsTime(sparkSession, this.tableName());
        this.testingShortVsTimeStamp(sparkSession, this.tableName());
        this.testingShortVsBinary(sparkSession, this.tableName());
        this.testingShortVsMap(sparkSession, this.tableName());
        this.testingShortVsArray(sparkSession, this.tableName());
        this.testingIntVsLong(sparkSession, this.tableName());
        this.testingIntVsFloat(sparkSession, this.tableName());
        this.testingIntVsDouble(sparkSession, this.tableName());
        this.testingIntVsDate(sparkSession, this.tableName());
        this.testingIntVsTime(sparkSession, this.tableName());
        this.testingIntVsTimeStamp(sparkSession, this.tableName());
        this.testingIntVsBinary(sparkSession, this.tableName());
        this.testingIntVsMap(sparkSession, this.tableName());
        this.testingIntVsArray(sparkSession, this.tableName());
        this.testingLongVsFloat(sparkSession, this.tableName());
        this.testingLongVsDouble(sparkSession, this.tableName());
        this.testingLongVsDate(sparkSession, this.tableName());
        this.testingLongVsTime(sparkSession, this.tableName());
        this.testingLongVsTimeStamp(sparkSession, this.tableName());
        this.testingLongVsBinary(sparkSession, this.tableName());
        this.testingLongVsMap(sparkSession, this.tableName());
        this.testingLongVsArray(sparkSession, this.tableName());
        this.testingFloatVsDouble(sparkSession, this.tableName());
        this.testingFloatVsDate(sparkSession, this.tableName());
        this.testingFloatVsTime(sparkSession, this.tableName());
        this.testingFloatVsTimeStamp(sparkSession, this.tableName());
        this.testingFloatVsBinary(sparkSession, this.tableName());
        this.testingFloatVsMap(sparkSession, this.tableName());
        this.testingFloatVsArray(sparkSession, this.tableName());
        this.testingDoubleVsDate(sparkSession, this.tableName());
        this.testingDoubleVsTime(sparkSession, this.tableName());
        this.testingDoubleVsTimeStamp(sparkSession, this.tableName());
        this.testingDoubleVsBinary(sparkSession, this.tableName());
        this.testingDoubleVsMap(sparkSession, this.tableName());
        this.testingDoubleVsArray(sparkSession, this.tableName());
        this.testingDateVsTime(sparkSession, this.tableName());
        this.testingDateVsTimeStamp(sparkSession, this.tableName());
        this.testingDateVsBinary(sparkSession, this.tableName());
        this.testingDateVsArray(sparkSession, this.tableName());
        this.testingDateVsMap(sparkSession, this.tableName());
        this.testingTimeVsTimeStamp(sparkSession, this.tableName());
        this.testingTimeVsBinary(sparkSession, this.tableName());
        this.testingTimeVsMap(sparkSession, this.tableName());
        this.testingTimeVsArray(sparkSession, this.tableName());
        this.testingTimeStampVsBinary(sparkSession, this.tableName());
        this.testingTimeStampVsMap(sparkSession, this.tableName());
        this.testingTimeStampVsArray(sparkSession, this.tableName());
        this.testingBinaryVsArray(sparkSession, this.tableName());
        this.testingBinaryVsMap(sparkSession, this.tableName());
        this.testingArrayVsMap(sparkSession, this.tableName());
    }

    private SparkSqlAccessTests$() {
        MODULE$ = this;
        this.tableName = "/tmp/SparkSqlOjaiConnectorAccessTesting";
    }
}

