/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.testCases;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.mapr.db.MapRDB;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.RDD.FIELD$;
import com.mapr.db.spark.RDD.MapRDBTableScanRDD;
import com.mapr.db.spark.RDD.OJAIDocumentRDDFunctions;
import com.mapr.db.spark.RDD.RDDTYPE$;
import com.mapr.db.spark.RDD.partitioner.OJAIKEY$;
import com.mapr.db.spark.documentTypeUtils.OJAIType$;
import com.mapr.db.spark.field;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.spark.package$;
import com.mapr.db.spark.types.DBBinaryValue;
import com.mapr.db.spark.types.DBMapValue;
import com.mapr.db.spark.utils.DefaultClass;
import com.mapr.db.spark.writers.OJAIKey$;
import com.mapr.db.spark.writers.OJAIValue$;
import com.mapr.db.testCases.BeanTest;
import com.mapr.db.testCases.WordCount;
import com.mapr.db.testCases.WordCount$;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.scala.Document;
import org.ojai.store.DocumentMutation;
import org.ojai.types.ODate;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

public final class MapRDBSparkTests$ {
    public static final MapRDBSparkTests$ MODULE$;
    private final String tableName;
    private final String saveToTable;
    private SparkConf conf;
    private volatile boolean bitmap$0;

    static {
        new MapRDBSparkTests$();
    }

    private SparkConf conf$lzycompute() {
        MapRDBSparkTests$ mapRDBSparkTests$ = this;
        synchronized (mapRDBSparkTests$) {
            if (!this.bitmap$0) {
                this.conf = new SparkConf().setAppName("simpletest").set("spark.executor.memory", "1g").set("spark.driver.memory", "1g").setMaster("local[*]");
                this.bitmap$0 = true;
            }
            return this.conf;
        }
    }

    public String tableName() {
        return this.tableName;
    }

    public String saveToTable() {
        return this.saveToTable;
    }

    public SparkConf conf() {
        return this.bitmap$0 ? this.conf : this.conf$lzycompute();
    }

    public void main(String[] args) {
        SparkContext sc = new SparkContext(this.conf());
        this.tableInitialization(sc, this.tableName());
        this.runTests(sc);
    }

    public void tableInitialization(SparkContext sparkSession, String tableName) {
        Object object = MapRDB.tableExists((String)tableName) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)tableName)) : BoxedUnit.UNIT;
        List docs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"}));
        RDD docsrdd = sparkSession.parallelize((Seq)docs, sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        RDD ojairdd = docsrdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(String doc) {
                return MapRDBSpark$.MODULE$.newDocument(doc);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument doc) {
                Option option;
                block4: {
                    ODate oDate;
                    block3: {
                        block2: {
                            option = Option$.MODULE$.apply(doc.selectDynamic("dob", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
                            if (!(option instanceof Some)) break block2;
                            oDate = ODate.parse((String)((String)doc.selectDynamic("dob", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString())));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        oDate = null;
                    }
                    doc.updateDynamic("dob", oDate);
                    return doc;
                }
                throw new MatchError((Object)option);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class));
        OJAIDocumentRDDFunctions qual$1 = package$.MODULE$.toDocumentRDDFunctions(ojairdd, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$15 = tableName;
        boolean x$16 = true;
        boolean x$17 = qual$1.saveToMapRDB$default$3();
        String x$18 = qual$1.saveToMapRDB$default$4();
        qual$1.saveToMapRDB(x$15, x$16, x$17, x$18);
    }

    public void runTests(SparkContext sparkSession) {
        this.testEmptySet(sparkSession, this.tableName());
        this.testShakespearesFamousQuote(sparkSession, this.tableName());
        this.testBeanClassParsing(sparkSession, this.tableName());
        this.testIntegerZipCodes(sparkSession, this.tableName());
        this.testingMapRDBBeanClass(sparkSession, this.tableName());
        this.testMaprDBBeanClassWithCollect(sparkSession, this.tableName());
        this.testGroupByOnODate(sparkSession, this.tableName());
        this.testingLoadingOfOJAIDocuments(sparkSession, this.tableName());
        this.testingCoGroupWithOJAIDOCUMENT(sparkSession, this.tableName());
        this.testingArrayValueWithOJAIDocument(sparkSession, this.tableName());
        this.testingCoGroupArrayKey(sparkSession, this.tableName());
        this.testingCoGroupOnMapValue(sparkSession, this.tableName());
        this.testingCoGroupOnMapKey(sparkSession, this.tableName());
        this.testingCoGroupWithMapKeyWithFilter(sparkSession, this.tableName());
        this.testingAssignmentOfZipCodeToOJAIDocument(sparkSession, this.tableName());
        this.testingAccessOfFieldsOfOJAIDocumentWithParametricTypes(sparkSession, this.tableName());
        this.testingAccessOfFieldsOfOJAIDocumentWithParametricTypes2(sparkSession, this.tableName());
        this.testingAccessOfProjectedFields(sparkSession, this.tableName());
        this.testingAccessOfProjectedFieldPaths(sparkSession, this.tableName());
        this.testingOfSavingTheProcessedOJAIDocuments(sparkSession, this.tableName());
        this.testingMapAsaValue(sparkSession, this.tableName());
        this.testingMapAsaKey(sparkSession, this.tableName());
        this.testingArrayAsaValue(sparkSession, this.tableName());
        this.testingArrayAsaKey(sparkSession, this.tableName());
        this.testingOJAIDocumentParsingFunctionality(sparkSession, this.tableName());
        this.testingMultipleDataTypesInOJAIDocument(sparkSession, this.tableName());
        this.testingSingleDataTypeDoubleInOJAIAndTypeCasting(sparkSession, this.tableName());
        this.testingTupleOutputOfAnRDD(sparkSession, this.tableName());
        this.testingAddingCountryInAddressField(sparkSession, this.tableName());
        this.testingBinaryDataTypeInOJAIDocument(sparkSession, this.tableName());
        this.testingMapTypeInOJAIDocument(sparkSession, this.tableName());
        this.testingDateTypeInOJAIDocument(sparkSession, this.tableName());
        this.testingSaveWithAnyObject(sparkSession, this.tableName());
        this.testingFilterFunctionOnMapObject(sparkSession, this.tableName());
        this.testingFilterFunctionOnArrayObject(sparkSession, this.tableName());
        this.testingFilterFunctionOnArrayObjectFunctionalway(sparkSession, this.tableName());
        this.testingWhereClauseOnloadFromMapRDB(sparkSession, this.tableName());
        this.testingPartitionOnloadFromMapRDB(sparkSession, this.tableName());
        this.testingAssignmentOfDocument(sparkSession, this.tableName());
        this.testCaseWithFlatMap(sparkSession, this.tableName());
        this.testingBulkJoinWithRDD(sparkSession, this.tableName());
        this.testingJoinWithRDDBean(sparkSession, this.tableName());
        this.testingJoinWithRDD(sparkSession, this.tableName());
        this.testingJoinWithOjaiRDDBean(sparkSession, this.tableName());
        this.testingUpdateMapRDBTable(sparkSession, this.tableName());
    }

    public boolean testEmptySet(SparkContext sparkSession, String tableName) {
        boolean bl;
        String[] lines = (String[])((Object[])new String[]{""});
        WrappedArray wordCounts = Predef$.MODULE$.wrapRefArray((Object[])WordCount$.MODULE$.count(sparkSession, (RDD<String>)sparkSession.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])lines), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class))).collect());
        if (wordCounts.equals((Object)Seq$.MODULE$.empty())) {
            Predef$.MODULE$.println((Object)"testEmptySet succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testEmptySet failed");
            bl = false;
        }
        return bl;
    }

    public boolean testShakespearesFamousQuote(SparkContext sparkSession, String tableName) {
        boolean bl;
        Seq lines = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"To be or not to be.", "That is the question."}));
        Set stopWords = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the"}));
        WordCount[] wordCounts = (WordCount[])WordCount$.MODULE$.count(sparkSession, (RDD<String>)sparkSession.parallelize(lines, sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)), (Set<String>)stopWords).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])wordCounts).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new WordCount[]{new WordCount("be", 2), new WordCount("is", 1), new WordCount("not", 1), new WordCount("or", 1), new WordCount("question", 1), new WordCount("that", 1), new WordCount("to", 2)}))) {
            Predef$.MODULE$.println((Object)"testShakespearesFamousQuote succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testShakespearesFamousQuote failed");
            bl = false;
        }
        return bl;
    }

    public boolean testBeanClassParsing(SparkContext sparkSession, String tableName) {
        boolean bl;
        BeanTest.person person2 = new BeanTest.person("fred", Predef$.MODULE$.int2Integer(25));
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        StringWriter out = new StringWriter();
        mapper.writeValue((Writer)out, (Object)person2);
        String json = out.toString();
        BeanTest.person person22 = (BeanTest.person)mapper.readValue(json, BeanTest.person.class);
        if (((Object)person2).equals(person22)) {
            Predef$.MODULE$.println((Object)"testBeanClassParsing succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testBeanClassParsing failed");
            bl = false;
        }
        return bl;
    }

    public boolean testIntegerZipCodes(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Integer[] collection = (Integer[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(OJAIDocument a) {
                return (Integer)a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger());
            }
        }, ClassTag$.MODULE$.apply(Integer.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)94105), BoxesRunTime.boxToInteger((int)95109), null, null, null})))) {
            Predef$.MODULE$.println((Object)"testIntegerZipCodes succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testIntegerZipCodes failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingMapRDBBeanClass(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype());
        BeanTest.User[] collection = (BeanTest.User[])maprd.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BeanTest.User a) {
                return ((Object)a).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User(rsmith,Robert,Smith,1982-02-03,List(electronics, music, sports))", "User(mdupont,Maxime,Dupont,1982-02-03,List(sports, movies, electronics))", "User(jdoe,John,Doe,1970-06-23,null)", "User(dsimon,David,Simon,1980-10-13,null)", "User(alehmann,Andrew,Lehmann,1980-10-13,List(html, css, js))"})))) {
            Predef$.MODULE$.println((Object)"testingMapRDBBeanClass succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMapRDBBeanClass failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(BeanTest.User a) {
                    return ((Object)a).toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$1) {
                    Predef$.MODULE$.print((Object)x$1);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testMaprDBBeanClassWithCollect(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype());
        String[] collection = (String[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BeanTest.User a) {
                return ((Object)a).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User(rsmith,Robert,Smith,1982-02-03,List(electronics, music, sports))", "User(mdupont,Maxime,Dupont,1982-02-03,List(sports, movies, electronics))", "User(jdoe,John,Doe,1970-06-23,null)", "User(dsimon,David,Simon,1980-10-13,null)", "User(alehmann,Andrew,Lehmann,1980-10-13,List(html, css, js))"})))) {
            Predef$.MODULE$.println((Object)"testMaprDBBeanClassWithCollect succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testMaprDBBeanClassWithCollect failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String a) {
                    return a.toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$2) {
                    Predef$.MODULE$.print((Object)x$2);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testGroupByOnODate(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        RDD aggregatedondate = RDD$.MODULE$.rddToPairRDDFunctions(maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ODate, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("dob", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaidate()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ODate.class), ClassTag$.MODULE$.apply(OJAIDocument.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).groupByKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ODate, Object> apply(Tuple2<ODate, Iterable<OJAIDocument>> a) {
                return new Tuple2(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)a._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2[] collection = (Tuple2[])aggregatedondate.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)ODate.parse((String)"1982-02-03"), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)ODate.parse((String)"1980-10-13"), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)ODate.parse((String)"1970-06-23"), (Object)BoxesRunTime.boxToInteger((int)1))})))) {
            Predef$.MODULE$.println((Object)"testGroupByOnODate succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testGroupByOnODate failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingLoadingOfOJAIDocuments(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        OJAIDocument[] collection = (OJAIDocument[])maprd.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingLoadingOfOJAIDocuments succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLoadingOfOJAIDocuments failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingCoGroupWithOJAIDOCUMENT(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Integer.class), ClassTag$.MODULE$.apply(OJAIDocument.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Integer, Object, Object> apply(Tuple2<Integer, Tuple2<Iterable<OJAIDocument>, Iterable<OJAIDocument>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)94105), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)95109), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1))})))) {
            Predef$.MODULE$.println((Object)"testingCoGroupWithOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCoGroupWithOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingArrayValueWithOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Integer.class), ClassTag$.MODULE$.apply(OJAIDocument.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Integer, Object, Object> apply(Tuple2<Integer, Tuple2<Iterable<OJAIDocument>, Iterable<Object>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)94105), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)95109), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1))})))) {
            Predef$.MODULE$.println((Object)"testingArrayValueWithOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingArrayValueWithOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingCoGroupArrayKey(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        RDD x$19 = maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$20 = ClassTag$.MODULE$.apply(Object.class);
        ClassTag x$21 = ClassTag$.MODULE$.apply(OJAIDocument.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$19);
        Object x$22 = null;
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(x$19, x$20, x$21, null).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Tuple2<Iterable<OJAIDocument>, Iterable<Object>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple3((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"html", "css", "js"})), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sports", "movies", "electronics"})), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"electronics", "music", "sports"})), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1))})))) {
            Predef$.MODULE$.println((Object)"testingCoGroupArrayKey succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCoGroupArrayKey failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingCoGroupOnMapValue(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Integer.class), ClassTag$.MODULE$.apply(OJAIDocument.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Integer, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger()), a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Integer, Object, Object> apply(Tuple2<Integer, Tuple2<Iterable<OJAIDocument>, Iterable<Object>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3(null, (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)94105), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)95109), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)1))})))) {
            Predef$.MODULE$.println((Object)"testingCoGroupOnMapValue succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCoGroupOnMapValue failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingCoGroupOnMapKey(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        RDD x$23 = maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$24 = ClassTag$.MODULE$.apply(Object.class);
        ClassTag x$25 = ClassTag$.MODULE$.apply(OJAIDocument.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$23);
        Object x$26 = null;
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(x$23, x$24, x$25, null).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Tuple2<Iterable<OJAIDocument>, Iterable<Object>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<Object, Object, Object> a) {
                return a.toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(null,3,3)", "(Map(city -> San Francisco, line -> 100 Main Street, zip -> 94105.0),1,1)", "(Map(city -> San Jose, line -> 1223 Broadway, zip -> 95109.0),1,1)"})))) {
            Predef$.MODULE$.println((Object)"testingCoGroupOnMapKey succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCoGroupOnMapKey failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingCoGroupWithMapKeyWithFilter(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd1 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        MapRDBTableScanRDD maprd2 = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        RDD x$27 = maprd1.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag x$28 = ClassTag$.MODULE$.apply(Object.class);
        ClassTag x$29 = ClassTag$.MODULE$.apply(OJAIDocument.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$27);
        Object x$30 = null;
        Tuple3[] collection = (Tuple3[])RDD$.MODULE$.rddToPairRDDFunctions(x$27, x$28, x$29, null).cogroup(maprd2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple2<Object, Tuple2<Iterable<OJAIDocument>, Iterable<Object>>> a) {
                return new Tuple3(a._1(), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._1()).size()), (Object)BoxesRunTime.boxToInteger((int)((TraversableOnce)((Tuple2)a._2())._2()).size()));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple3<Object, Object, Object> a) {
                return a._1() != null;
            }
        }).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<Object, Object, Object> a) {
                return a.toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Map(city -> San Francisco, line -> 100 Main Street, zip -> 94105.0),1,1)", "(Map(city -> San Jose, line -> 1223 Broadway, zip -> 95109.0),1,1)"})))) {
            Predef$.MODULE$.println((Object)"testingCoGroupWithMapKeyWithFilter succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCoGroupWithMapKeyWithFilter failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAssignmentOfZipCodeToOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        OJAIDocument[] collection = (OJAIDocument[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                a.updateDynamic("address.zip", (Object)BoxesRunTime.boxToInteger((int)95035));
                return a;
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Object.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{95035, 95035, 95035, 95035, 95035})))) {
            Predef$.MODULE$.println((Object)"testingAssignmentOfZipCodeToOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAssignmentOfZipCodeToOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAccessOfFieldsOfOJAIDocumentWithParametricTypes(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Object[] collection = (Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps(collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)94105), BoxesRunTime.boxToInteger((int)95109), null, null, null})))) {
            Predef$.MODULE$.println((Object)"testingAccessOfFieldsOfOJAIDocumentWithParametricTypes succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAccessOfFieldsOfOJAIDocumentWithParametricTypes failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAccessOfFieldsOfOJAIDocumentWithParametricTypes2(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Integer[] collection = (Integer[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(OJAIDocument a) {
                return (Integer)a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger());
            }
        }, ClassTag$.MODULE$.apply(Integer.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)94105), BoxesRunTime.boxToInteger((int)95109), null, null, null})))) {
            Predef$.MODULE$.println((Object)"testingAccessOfFieldsOfOJAIDocumentWithParametricTypes2 succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAccessOfFieldsOfOJAIDocumentWithParametricTypes2 failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAccessOfProjectedFields(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = (MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address", "_id", "first_name"}), FIELD$.MODULE$.fieldStrings(), FIELD$.MODULE$.fieldStrings());
        OJAIDocument[] collection = (OJAIDocument[])maprd.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"first_name\":\"Robert\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"first_name\":\"Maxime\"}", "{\"_id\":\"jdoe\",\"first_name\":\"John\"}", "{\"_id\":\"dsimon\",\"first_name\":\"David\"}", "{\"_id\":\"alehmann\",\"first_name\":\"Andrew\"}"})))) {
            Predef$.MODULE$.println((Object)"testingAccessOfProjectedFields succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAccessOfProjectedFields failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAccessOfProjectedFieldPaths(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = (MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldPath[]{FieldPath.parseFrom((String)"address"), FieldPath.parseFrom((String)"_id"), FieldPath.parseFrom((String)"first_name")}), FIELD$.MODULE$.fieldPaths(), FIELD$.MODULE$.fieldPaths());
        OJAIDocument[] collection = (OJAIDocument[])maprd.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"first_name\":\"Robert\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"first_name\":\"Maxime\"}", "{\"_id\":\"jdoe\",\"first_name\":\"John\"}", "{\"_id\":\"dsimon\",\"first_name\":\"David\"}", "{\"_id\":\"alehmann\",\"first_name\":\"Andrew\"}"})))) {
            Predef$.MODULE$.println((Object)"testingAccessOfProjectedFieldPaths succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAccessOfProjectedFieldPaths failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingOfSavingTheProcessedOJAIDocuments(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)"/tmp/temp_user_profiles") ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)"/tmp/temp_user_profiles")) : BoxedUnit.UNIT;
        MapRDBTableScanRDD maprd = (MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address", "id", "first_name"}), FIELD$.MODULE$.fieldStrings(), FIELD$.MODULE$.fieldStrings());
        OJAIDocumentRDDFunctions qual$2 = package$.MODULE$.toDocumentRDDFunctions((RDD)maprd, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$31 = "/tmp/temp_user_profiles";
        boolean x$32 = true;
        boolean x$33 = qual$2.saveToMapRDB$default$3();
        String x$34 = qual$2.saveToMapRDB$default$4();
        qual$2.saveToMapRDB(x$31, x$32, x$33, x$34);
        MapRDBTableScanRDD savedDocumentsRDD = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB("/tmp/temp_user_profiles", ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        OJAIDocument[] collection = (OJAIDocument[])savedDocumentsRDD.collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"first_name\":\"Robert\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"first_name\":\"Maxime\"}", "{\"_id\":\"jdoe\",\"first_name\":\"John\"}", "{\"_id\":\"dsimon\",\"first_name\":\"David\"}", "{\"_id\":\"alehmann\",\"first_name\":\"Andrew\"}"})))) {
            Predef$.MODULE$.println((Object)"testingOfSavingTheProcessedOJAIDocuments succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingOfSavingTheProcessedOJAIDocuments failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingMapAsaValue(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Object[] collection = (Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Object a) {
                return (Map)Option$.MODULE$.apply(a).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(Object a) {
                        return (Map)a;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Francisco"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"100 Main Street"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)94105))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Jose"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"1223 Broadway"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)95109))})), null, null, null})))) {
            Predef$.MODULE$.println((Object)"testingMapAsaValue succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMapAsaValue failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingMapAsaKey(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple2[] collection = (Tuple2[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        Set newcollection = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Tuple2<Object, Object> a) {
                return (Map)Option$.MODULE$.apply(a._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, Object> apply(Object a) {
                        return (Map)a;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Null$ apply() {
                        return null;
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)))).toSet();
        if (newcollection.equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{null, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Jose"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"1223 Broadway"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)95109))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Francisco"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"100 Main Street"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)94105))})), null, null})))) {
            Predef$.MODULE$.println((Object)"testingMapAsaKey succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMapAsaKey failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingArrayAsaValue(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        WrappedArray collection = Predef$.MODULE$.wrapRefArray((Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect());
        if (((TraversableOnce)collection.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Object a) {
                return a == null ? null : (Seq)a;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"electronics", "music", "sports"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sports", "movies", "electronics"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"html", "css", "js"})), null, null})))) {
            Predef$.MODULE$.println((Object)"testingArrayAsaValue succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingArrayAsaValue failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingArrayAsaKey(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple2[] collection = (Tuple2[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, OJAIDocument> apply(OJAIDocument a) {
                return new Tuple2(a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), (Object)a);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Tuple2<Object, OJAIDocument> a) {
                return a._1() == null ? null : (Seq)a._1();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"electronics", "music", "sports"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sports", "movies", "electronics"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"html", "css", "js"})), null, null})))) {
            Predef$.MODULE$.println((Object)"testingArrayAsaKey succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingArrayAsaKey failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingOJAIDocumentParsingFunctionality(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)"/tmp/testingOJAIDocumentParsingFunctionality") ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)"/tmp/testingOJAIDocumentParsingFunctionality")) : BoxedUnit.UNIT;
        RDD documents = sparkSession.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\\42_id\\42 : \\42", "\\42, \\42test\\42: ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        RDD maprd = documents.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(String a) {
                return MapRDBSpark$.MODULE$.newDocument(a);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class));
        OJAIDocumentRDDFunctions qual$3 = package$.MODULE$.toDocumentRDDFunctions(maprd, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$35 = "/tmp/testingOJAIDocumentParsingFunctionality";
        boolean x$36 = true;
        boolean x$37 = qual$3.saveToMapRDB$default$3();
        String x$38 = qual$3.saveToMapRDB$default$4();
        qual$3.saveToMapRDB(x$35, x$36, x$37, x$38);
        MapRDBTableScanRDD saveddocs = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB("/tmp/testingOJAIDocumentParsingFunctionality", ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Object[] collection = (Object[])saveddocs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("test", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps(collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0})))) {
            Predef$.MODULE$.println((Object)"testingOJAIDocumentParsingFunctionality succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingOJAIDocumentParsingFunctionality failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingMultipleDataTypesInOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD documents = sparkSession.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return i < 5 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\\42test\\42: ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\\42test\\42: \\42", "\\42}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        RDD maprd = documents.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(String a) {
                return MapRDBSpark$.MODULE$.newDocument(a);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class));
        Object[] collection = (Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("test", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps(collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"8", "9", BoxesRunTime.boxToDouble((double)1.0), "5", "10", BoxesRunTime.boxToDouble((double)2.0), "6", BoxesRunTime.boxToDouble((double)3.0), "7", BoxesRunTime.boxToDouble((double)4.0)})))) {
            Predef$.MODULE$.println((Object)"testingMultipleDataTypesInOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMultipleDataTypesInOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingSingleDataTypeDoubleInOJAIAndTypeCasting(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD documents = sparkSession.parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int i) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\\42test\\42: ", ".", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)i)}));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        RDD maprd = documents.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(String a) {
                return MapRDBSpark$.MODULE$.newDocument(a);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class));
        Integer[] collection = (Integer[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(OJAIDocument a) {
                return (Integer)a.selectDynamic("test", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger());
            }
        }, ClassTag$.MODULE$.apply(Integer.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{8, 9, 1, 5, 10, 2, 6, 3, 7, 4})))) {
            Predef$.MODULE$.println((Object)"testingSingleDataTypeDoubleInOJAIAndTypeCasting succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSingleDataTypeDoubleInOJAIAndTypeCasting failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingTupleOutputOfAnRDD(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD documents = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Tuple4[] collection = (Tuple4[])documents.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple4<Object, Object, Object, Object> apply(OJAIDocument a) {
                return new Tuple4(a.selectDynamic("address.city", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("address.zip", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()), a.selectDynamic("last_name", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
            }
        }, ClassTag$.MODULE$.apply(Tuple4.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])collection).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"San Francisco", (Object)BoxesRunTime.boxToInteger((int)94105), (Object)"Robert", (Object)"Smith"), new Tuple4((Object)"San Jose", (Object)BoxesRunTime.boxToInteger((int)95109), (Object)"Maxime", (Object)"Dupont"), new Tuple4(null, null, (Object)"John", (Object)"Doe"), new Tuple4(null, null, (Object)"David", (Object)"Simon"), new Tuple4(null, null, (Object)"Andrew", (Object)"Lehmann")})))) {
            Predef$.MODULE$.println((Object)"testingTupleOutputOfAnRDD succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingTupleOutputOfAnRDD failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAddingCountryInAddressField(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Integer[] documents = (Integer[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                a.updateDynamic("address.country", (Object)"USA");
                a.updateDynamic("address.street", (Object)BoxesRunTime.boxToInteger((int)10));
                return a;
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(OJAIDocument a) {
                return (Integer)a.selectDynamic("address.street", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiinteger());
            }
        }, ClassTag$.MODULE$.apply(Integer.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])documents).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 10, 10, 10, 10})))) {
            Predef$.MODULE$.println((Object)"testingAddingCountryInAddressField succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAddingCountryInAddressField failed");
            bl = false;
        }
        return bl;
    }

    public boolean testCaseWithFlatMap(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Object[] documents = (Object[])maprd.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Object> apply(OJAIDocument a) {
                return Predef$.MODULE$.refArrayOps(new Object[]{a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref())});
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps(documents).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Francisco"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"100 Main Street"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)94105))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Jose"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"1223 Broadway"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)95109))})), null, null, null})))) {
            Predef$.MODULE$.println((Object)"testingAddingCountryInAddressField succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAddingCountryInAddressField failed");
            Predef$.MODULE$.refArrayOps(documents).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Object x$3) {
                    Predef$.MODULE$.println(x$3);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingBinaryDataTypeInOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        ByteBuffer buff = ByteBuffer.wrap("Non-Immigrant".getBytes(Charset.forName("UTF-8")));
        String str = new String(buff.array(), Charset.forName("UTF-8"));
        DBBinaryValue dBBinaryValue = MapRDBSpark$.MODULE$.serializableBinaryValue(buff);
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bolo"), (Object)"b")}));
        DBBinaryValue[] documents = (DBBinaryValue[])maprd.map((Function1)new Serializable(dBBinaryValue){
            public static final long serialVersionUID = 0L;
            private final DBBinaryValue dBBinaryValue$1;

            public final OJAIDocument apply(OJAIDocument a) {
                a.updateDynamic("address.country", (Object)"USA");
                a.updateDynamic("user_profile", (Object)this.dBBinaryValue$1);
                return a;
            }
            {
                this.dBBinaryValue$1 = dBBinaryValue$1;
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DBBinaryValue apply(OJAIDocument a) {
                return a.getBinarySerializable("user_profile");
            }
        }, ClassTag$.MODULE$.apply(DBBinaryValue.class)).collect();
        Seq chars = (Seq)Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(DBBinaryValue a) {
                return new String(a.array(), Charset.forName("UTF-8"));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        if (chars.sameElements((GenIterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non-Immigrant", "Non-Immigrant", "Non-Immigrant", "Non-Immigrant", "Non-Immigrant"})))) {
            Predef$.MODULE$.println((Object)"testingBinaryDataTypeInOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBinaryDataTypeInOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingMapTypeInOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        ByteBuffer buff = ByteBuffer.wrap("Non-Immigrant".getBytes(Charset.forName("UTF-8")));
        String str = new String(buff.array(), Charset.forName("UTF-8"));
        DBBinaryValue dBBinaryValue = MapRDBSpark$.MODULE$.serializableBinaryValue(buff);
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hello"), (Object)"h"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bolo"), (Object)"b")}));
        Object[] documents = (Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                a.updateDynamic("user_profile", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})));
                return a;
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("user_profile", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).take(5);
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Object a) {
                return (Seq)a;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "b"}))}))) {
            Predef$.MODULE$.println((Object)"testingMapTypeInOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingMapTypeInOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingDateTypeInOJAIDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        ByteBuffer buff = ByteBuffer.wrap("Non-Immigrant".getBytes(Charset.forName("UTF-8")));
        String str = new String(buff.array(), Charset.forName("UTF-8"));
        DBBinaryValue dBBinaryValue = MapRDBSpark$.MODULE$.serializableBinaryValue(buff);
        Object[] documents = (Object[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                a.updateDynamic("address.country", (Object)"USA");
                a.updateDynamic("user_profile", (Object)ODate.parse((String)"2011-10-10"));
                return a;
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument a) {
                return a.selectDynamic("user_profile", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, ClassTag$.MODULE$.apply(Object.class)).collect();
        if (Predef$.MODULE$.refArrayOps(documents).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ODate[]{ODate.parse((String)"2011-10-10"), ODate.parse((String)"2011-10-10"), ODate.parse((String)"2011-10-10"), ODate.parse((String)"2011-10-10"), ODate.parse((String)"2011-10-10")})))) {
            Predef$.MODULE$.println((Object)"testingDateTypeInOJAIDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingDateTypeInOJAIDocument failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingSaveWithAnyObject(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)"/tmp/testingSaveWithAnyObject") ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)"/tmp/testingSaveWithAnyObject")) : BoxedUnit.UNIT;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype());
        OJAIDocumentRDDFunctions qual$4 = package$.MODULE$.toDocumentRDDFunctions((RDD)maprd, OJAIValue$.MODULE$.overrideDefault());
        String x$39 = "/tmp/testingSaveWithAnyObject";
        boolean x$40 = true;
        boolean x$41 = true;
        String x$42 = qual$4.saveToMapRDB$default$4();
        qual$4.saveToMapRDB(x$39, x$41, x$40, x$42);
        OJAIDocument[] savedocuments = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB("/tmp/testingSaveWithAnyObject", ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])savedocuments).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"interests\":null,\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"interests\":null,\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingSaveWithAnyObject succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSaveWithAnyObject failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingFilterFunctionOnMapObject(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        DBMapValue[] useraddress = (DBMapValue[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DBMapValue apply(OJAIDocument a) {
                return (DBMapValue)a.selectDynamic("address", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaimapstringvalue());
            }
        }, ClassTag$.MODULE$.apply(DBMapValue.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DBMapValue a) {
                return a != null && a.get("city").get().equals("San Jose");
            }
        }).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])useraddress).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<Tuple2<String, Object>> apply(DBMapValue a) {
                return a.toSet();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Set[]{(Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"city"), (Object)"San Jose"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"line"), (Object)"1223 Broadway"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zip"), (Object)BoxesRunTime.boxToInteger((int)95109))}))})))) {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnMapObject succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnMapObject failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingFilterFunctionOnArrayObject(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Seq[] useraddress = (Seq[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(OJAIDocument a) {
                return (Seq)a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiarrayanyref());
            }
        }, ClassTag$.MODULE$.apply(Seq.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Seq<Object> a) {
                if (a == null) return false;
                Object object = a.apply(0);
                String string = "sports";
                if (object != null) {
                    if (!object.equals(string)) return false;
                    return true;
                }
                if (string == null) return true;
                return false;
            }
        }).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])useraddress).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<Object> a) {
                return a;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sports", "movies", "electronics"}))})))) {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnArrayObject succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnArrayObject failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingFilterFunctionOnArrayObjectFunctionalway(SparkContext sparkSession, String tableName) {
        boolean bl;
        MapRDBTableScanRDD maprd = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        Seq[] useraddress = (Seq[])maprd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(OJAIDocument a) {
                return (Seq)a.selectDynamic("interests", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiarrayanyref());
            }
        }, ClassTag$.MODULE$.apply(Seq.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<Object> a) {
                return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply(a).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Seq<Object> b) {
                        Object object = b.apply(0);
                        String string = "sports";
                        return !(object != null ? !object.equals(string) : string != null);
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
        }).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])useraddress).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<Object> a) {
                return a;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sports", "movies", "electronics"}))})))) {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnArrayObjectFunctionalWay succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingFilterFunctionOnArrayObjectFunctionalWay failed");
            Predef$.MODULE$.refArrayOps((Object[])useraddress).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Seq<Object> x$4) {
                    Predef$.MODULE$.println(x$4);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingWhereClauseOnloadFromMapRDB(SparkContext sparkSession, String tableName) {
        boolean bl;
        OJAIDocument[] maprd = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("address.city").$eq$eq$eq((Object)"San Jose", com.mapr.db.spark.condition.package$.MODULE$.quotesString())).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])maprd).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"})))) {
            Predef$.MODULE$.println((Object)"testingWhereClauseOnloadFromMapRDB succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingWhereClauseOnloadFromMapRDB failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingPartitionOnloadFromMapRDB(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)this.saveToTable()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)this.saveToTable())) : BoxedUnit.UNIT;
        OJAIDocumentRDDFunctions qual$5 = package$.MODULE$.toDocumentRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey())), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class), package$.MODULE$.ojaiStringKeyOrdering()).values(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$43 = this.saveToTable();
        boolean x$44 = true;
        boolean x$45 = qual$5.saveToMapRDB$default$3();
        String x$46 = qual$5.saveToMapRDB$default$4();
        qual$5.saveToMapRDB(x$43, x$44, x$45, x$46);
        BoxedUnit maprd = BoxedUnit.UNIT;
        OJAIDocument[] collection = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(this.saveToTable(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingPartitionOnloadFromMapRDB succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingPartitionOnloadFromMapRDB failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingAssignmentOfDocument(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)this.saveToTable()).append((Object)"assigningdoc").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)this.saveToTable()).append((Object)"assigningdoc").toString())) : BoxedUnit.UNIT;
        OJAIDocumentRDDFunctions qual$6 = package$.MODULE$.toDocumentRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class), package$.MODULE$.ojaiStringKeyOrdering()).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                return (OJAIDocument)a.set("recursivedoc", (Document)MapRDBSpark$.MODULE$.newDocument(a.asJsonString()));
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey())), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class), package$.MODULE$.ojaiStringKeyOrdering()).values(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$47 = new StringBuilder().append((Object)this.saveToTable()).append((Object)"assigningdoc").toString();
        boolean x$48 = true;
        boolean x$49 = qual$6.saveToMapRDB$default$3();
        String x$50 = qual$6.saveToMapRDB$default$4();
        qual$6.saveToMapRDB(x$47, x$48, x$49, x$50);
        BoxedUnit maprd = BoxedUnit.UNIT;
        OJAIDocument[] collection = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)this.saveToTable()).append((Object)"assigningdoc").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                return (OJAIDocument)a.delete("recursivedoc");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OJAIDocument.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingAssignmentOfDocument succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingAssignmentOfDocument failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$5) {
                    Predef$.MODULE$.println((Object)x$5);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingJoinWithRDD(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD valuesRDD = sparkSession.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "Hon", "rsmith"})), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        OJAIDocument[] documents = (OJAIDocument[])package$.MODULE$.toFilterRDDFunctions(valuesRDD, OJAIKey$.MODULE$.ojaiStringKey(), com.mapr.db.spark.condition.package$.MODULE$.quotesString()).joinWithMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument doc) {
                return doc.selectDynamic("_id", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Object.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "rsmith"})))) {
            Predef$.MODULE$.println((Object)"testingJoinWithRDD succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingJoinWithRDD failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$6) {
                    Predef$.MODULE$.println((Object)x$6);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingBulkJoinWithRDD(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD valuesRDD = sparkSession.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "Hon", "rsmith"})), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        OJAIDocument[] documents = (OJAIDocument[])package$.MODULE$.toFilterRDDFunctions(valuesRDD, OJAIKey$.MODULE$.ojaiStringKey(), com.mapr.db.spark.condition.package$.MODULE$.quotesString()).bulkJoinWithMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(OJAIDocument doc) {
                return doc.selectDynamic("_id", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Object.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "rsmith"})))) {
            Predef$.MODULE$.println((Object)"testingBulkJoinWithRDD succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBulkJoinWithRDD failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$7) {
                    Predef$.MODULE$.println((Object)x$7);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingJoinWithRDDBean(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD valuesRDD = sparkSession.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "Hon", "rsmith"})), sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        BeanTest.User[] documents = (BeanTest.User[])package$.MODULE$.toFilterRDDFunctions(valuesRDD, OJAIKey$.MODULE$.ojaiStringKey(), com.mapr.db.spark.condition.package$.MODULE$.quotesString()).joinWithMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BeanTest.User doc) {
                return doc.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "rsmith"})))) {
            Predef$.MODULE$.println((Object)"testingJoinWithRDDBean succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingJoinWithRDDBean failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(BeanTest.User a) {
                    return ((Object)a).toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$8) {
                    Predef$.MODULE$.println((Object)x$8);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingJoinWithOjaiRDDBean(SparkContext sparkSession, String tableName) {
        boolean bl;
        RDD valuesRDD = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument x$9) {
                return x$9.getString("_id");
            }
        }, ClassTag$.MODULE$.apply(String.class));
        BeanTest.User[] documents = (BeanTest.User[])package$.MODULE$.toFilterRDDFunctions(valuesRDD, OJAIKey$.MODULE$.ojaiStringKey(), com.mapr.db.spark.condition.package$.MODULE$.quotesString()).joinWithMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BeanTest.User doc) {
                return doc.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdoe", "rsmith", "alehmann", "mdupont", "dsimon"})))) {
            Predef$.MODULE$.println((Object)"testingJoinWithOjaiRDDBean succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingJoinWithOjaiRDDBean failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])documents).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(BeanTest.User a) {
                    return ((Object)a).toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$10) {
                    Predef$.MODULE$.println((Object)x$10);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingUpdateMapRDBTable(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString())) : BoxedUnit.UNIT;
        OJAIDocumentRDDFunctions qual$7 = package$.MODULE$.toDocumentRDDFunctions((RDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$51 = new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString();
        boolean x$52 = true;
        boolean x$53 = qual$7.saveToMapRDB$default$3();
        String x$54 = qual$7.saveToMapRDB$default$4();
        qual$7.saveToMapRDB(x$51, x$52, x$53, x$54);
        MapRDBTableScanRDD valuesRDD = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        package$.MODULE$.toDocumentRDDFunctions((RDD)valuesRDD, OJAIValue$.MODULE$.defaultOJAIDocument()).updateToMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final DocumentMutation apply(OJAIDocument doc) {
                void var2_2;
                DocumentMutation mutation = MapRDB.newMutation();
                mutation.setOrReplace("key", doc.getIdString());
                return var2_2;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Value apply(OJAIDocument doc) {
                return doc.getId();
            }
        });
        OJAIDocument[] collection = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"key\":\"rsmith\",\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"key\":\"mdupont\",\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"key\":\"jdoe\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"key\":\"dsimon\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"key\":\"alehmann\",\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingUpdateMapRDBTable succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingUpdateMapRDBTable failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$11) {
                    Predef$.MODULE$.println((Object)x$11);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingCheckAndUpdateMapRDBTable(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString())) : BoxedUnit.UNIT;
        OJAIDocumentRDDFunctions qual$8 = package$.MODULE$.toDocumentRDDFunctions((RDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$55 = new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString();
        boolean x$56 = true;
        boolean x$57 = qual$8.saveToMapRDB$default$3();
        String x$58 = qual$8.saveToMapRDB$default$4();
        qual$8.saveToMapRDB(x$55, x$56, x$57, x$58);
        MapRDBTableScanRDD valuesRDD = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        package$.MODULE$.toDocumentRDDFunctions((RDD)valuesRDD, OJAIValue$.MODULE$.defaultOJAIDocument()).updateToMapRDB(new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final DocumentMutation apply(OJAIDocument doc) {
                void var2_2;
                DocumentMutation mutation = MapRDB.newMutation();
                mutation.setOrReplace("key", doc.getIdString());
                return var2_2;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Value apply(OJAIDocument doc) {
                return doc.getId();
            }
        }, new field("_id").$eq$eq$eq((Object)"rsmith", com.mapr.db.spark.condition.package$.MODULE$.quotesString()));
        OJAIDocument[] collection = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"checkAndUpdateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"key\":\"rsmith\",\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingCheckAndUpdateMapRDBTable succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingCheckAndUpdateMapRDBTable failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$12) {
                    Predef$.MODULE$.println((Object)x$12);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingUpdateMapRDBTablePairedRDD(SparkContext sparkSession, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString())) : BoxedUnit.UNIT;
        OJAIDocumentRDDFunctions qual$9 = package$.MODULE$.toDocumentRDDFunctions((RDD)package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$59 = new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString();
        boolean x$60 = true;
        boolean x$61 = qual$9.saveToMapRDB$default$3();
        String x$62 = qual$9.saveToMapRDB$default$4();
        qual$9.saveToMapRDB(x$59, x$60, x$61, x$62);
        RDD valuesRDD = package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument x$13) {
                return x$13.getIdString();
            }
        });
        package$.MODULE$.toPairedRDDFunctions(valuesRDD, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.defaultOJAIDocument()).updateToMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final DocumentMutation apply(OJAIDocument doc) {
                void var2_2;
                DocumentMutation mutation = MapRDB.newMutation();
                mutation.setOrReplace("key", doc.getIdString());
                return var2_2;
            }
        });
        OJAIDocument[] collection = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sparkSession).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"updateMapRDB").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"key\":\"rsmith\",\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"key\":\"mdupont\",\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"key\":\"jdoe\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"key\":\"dsimon\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"key\":\"alehmann\",\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingUpdateMapRDBTablePairedRDD succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingUpdateMapRDBTablePairedRDD failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])collection).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(OJAIDocument a) {
                    return a.asJsonString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$14) {
                    Predef$.MODULE$.println((Object)x$14);
                }
            });
            bl = false;
        }
        return bl;
    }

    private MapRDBSparkTests$() {
        MODULE$ = this;
        this.tableName = "/tmp/user_profiles_temp";
        this.saveToTable = "/tmp/user_profiles_temp_save";
    }
}

