/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.testCases;

import com.mapr.db.MapRDB;
import com.mapr.db.TableDescriptor;
import com.mapr.db.spark.MapRDBSpark$;
import com.mapr.db.spark.RDD.FIELD$;
import com.mapr.db.spark.RDD.MapRDBTableScanRDD;
import com.mapr.db.spark.RDD.OJAIDocumentRDDFunctions;
import com.mapr.db.spark.RDD.PairedDocumentRDDFunctions;
import com.mapr.db.spark.RDD.RDDTYPE$;
import com.mapr.db.spark.RDD.partitioner.OJAIKEY$;
import com.mapr.db.spark.documentTypeUtils.OJAIType$;
import com.mapr.db.spark.field;
import com.mapr.db.spark.impl.OJAIDocument;
import com.mapr.db.spark.package$;
import com.mapr.db.spark.types.DBBinaryValue;
import com.mapr.db.spark.utils.DefaultClass;
import com.mapr.db.spark.writers.OJAIKey$;
import com.mapr.db.spark.writers.OJAIValue$;
import com.mapr.db.testCases.BeanTest;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.ojai.types.ODate;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LoadAndSaveTests$ {
    public static final LoadAndSaveTests$ MODULE$;
    private final String tableName;
    private final String saveToTable;
    private SparkConf conf;
    private volatile boolean bitmap$0;

    static {
        new LoadAndSaveTests$();
    }

    private SparkConf conf$lzycompute() {
        LoadAndSaveTests$ loadAndSaveTests$ = this;
        synchronized (loadAndSaveTests$) {
            if (!this.bitmap$0) {
                this.conf = new SparkConf().setMaster("local[*]").setAppName("simpletest").set("spark.executor.memory", "1g").set("spark.driver.memory", "1g");
                this.bitmap$0 = true;
            }
            return this.conf;
        }
    }

    public String tableName() {
        return this.tableName;
    }

    public String saveToTable() {
        return this.saveToTable;
    }

    public SparkConf conf() {
        return this.bitmap$0 ? this.conf : this.conf$lzycompute();
    }

    public void main(String[] args) {
        SparkContext sc = new SparkContext(this.conf());
        this.tableInitialization(sc, this.tableName());
        this.runTests(sc, false);
    }

    public void tableInitialization(SparkContext sparkSession, String tableName) {
        Object object = MapRDB.tableExists((String)tableName) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)tableName)) : BoxedUnit.UNIT;
        List docs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"}));
        RDD docsrdd = sparkSession.parallelize((Seq)docs, sparkSession.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        RDD ojairdd = docsrdd.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(String doc) {
                return MapRDBSpark$.MODULE$.newDocument(doc);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument doc) {
                Option option;
                block4: {
                    ODate oDate;
                    block3: {
                        block2: {
                            option = Option$.MODULE$.apply(doc.selectDynamic("dob", DefaultClass.DefaultType$.MODULE$.default(), OJAIType$.MODULE$.ojaianyref()));
                            if (!(option instanceof Some)) break block2;
                            oDate = ODate.parse((String)((String)doc.selectDynamic("dob", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString())));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        oDate = null;
                    }
                    doc.updateDynamic("dob", oDate);
                    return doc;
                }
                throw new MatchError((Object)option);
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class));
        OJAIDocumentRDDFunctions qual$1 = package$.MODULE$.toDocumentRDDFunctions(ojairdd, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$9 = tableName;
        boolean x$10 = true;
        boolean x$11 = qual$1.saveToMapRDB$default$3();
        String x$12 = qual$1.saveToMapRDB$default$4();
        qual$1.saveToMapRDB(x$9, x$10, x$11, x$12);
    }

    public void runTests(SparkContext sparkSession, boolean kryoOn) {
        this.testingSimpleLoadTable(sparkSession, this.tableName());
        this.testingLoadTableWithSpecificColumns(sparkSession, this.tableName());
        this.testingLoadTableWithWhereEQCondition(sparkSession, this.tableName());
        this.testingLoadTableWithWhereEQAndSelectClause(sparkSession, this.tableName());
        this.testingLoadTableWithWhereEQConditionAndSave(sparkSession, this.tableName());
        this.testingSimpleSaveTable(sparkSession, this.tableName(), this.saveToTable());
        this.testingIDwithSaveToMapRDB(sparkSession, this.tableName(), new StringBuilder().append((Object)this.saveToTable()).append((Object)"id").toString());
        this.testingBulkSaveMode(sparkSession, this.tableName(), this.saveToTable());
        this.testingBulkSaveWithoutBulkModeSetInTable(sparkSession, this.tableName(), this.saveToTable());
        this.testingBulkSaveModeBeanClass(sparkSession, this.tableName(), this.saveToTable());
        this.testingSplitPartitioner(sparkSession, this.tableName(), this.saveToTable());
        this.testingSplitPartitionerWithBinaryData(sparkSession, this.tableName(), this.saveToTable());
        if (kryoOn) {
            this.testingSplitPartitionerWithByteBufferData(sparkSession, this.tableName(), this.saveToTable());
        }
    }

    public boolean testingSimpleLoadTable(SparkContext sc, String tableName) {
        boolean bl;
        OJAIDocument[] cust_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cust_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingSimpleLoadTable succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleLoadTable failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingLoadTableWithSpecificColumns(SparkContext sc, String tableName) {
        boolean bl;
        OJAIDocument[] cust_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first_name", "address", "interests"}), FIELD$.MODULE$.fieldStrings(), FIELD$.MODULE$.fieldStrings()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cust_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"rsmith\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"]}", "{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"]}", "{\"_id\":\"jdoe\",\"first_name\":\"John\"}", "{\"_id\":\"dsimon\",\"first_name\":\"David\"}", "{\"_id\":\"alehmann\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"]}"})))) {
            Predef$.MODULE$.println((Object)"testingLoadTableWithSpecificColumns succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLoadTableWithSpecificColumns failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingLoadTableWithWhereEQCondition(SparkContext sc, String tableName) {
        boolean bl;
        OJAIDocument[] cust_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("address.city").$eq$eq$eq((Object)"San Jose", com.mapr.db.spark.condition.package$.MODULE$.quotesString())).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cust_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"})))) {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQCondition succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQCondition failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingLoadTableWithWhereEQConditionAndSave(SparkContext sc, String tableName) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)tableName).append((Object)"save").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)tableName).append((Object)"save").toString())) : BoxedUnit.UNIT;
        MapRDBTableScanRDD cust_profiles = (MapRDBTableScanRDD)package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("address.city").$eq$eq$eq((Object)"San Jose", com.mapr.db.spark.condition.package$.MODULE$.quotesString()));
        OJAIDocumentRDDFunctions qual$2 = package$.MODULE$.toDocumentRDDFunctions((RDD)cust_profiles, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$13 = new StringBuilder().append((Object)tableName).append((Object)"save").toString();
        boolean x$14 = true;
        boolean x$15 = qual$2.saveToMapRDB$default$3();
        String x$16 = qual$2.saveToMapRDB$default$4();
        qual$2.saveToMapRDB(x$13, x$14, x$15, x$16);
        OJAIDocument[] cust_profiles1 = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)tableName).append((Object)"save").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cust_profiles1).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"})))) {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQConditionAndSave succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQConditionAndSave failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingLoadTableWithWhereEQAndSelectClause(SparkContext sc, String tableName) {
        boolean bl;
        OJAIDocument[] cust_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).where(new field("address.city").$eq$eq$eq((Object)"San Jose", com.mapr.db.spark.condition.package$.MODULE$.quotesString())).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"address", "first_name", "interests"}), FIELD$.MODULE$.fieldStrings(), FIELD$.MODULE$.fieldStrings()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cust_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"_id\":\"mdupont\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"]}"})))) {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQAndSelectClause succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingLoadTableWithWhereEQAndSelectClause failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingSimpleSaveTable(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)saveToTable) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)saveToTable)) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToPairRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                return (OJAIDocument)a.setId((String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString()));
            }
        }, ClassTag$.MODULE$.apply(OJAIDocument.class)).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class), package$.MODULE$.ojaiStringKeyOrdering()).partitionBy(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey()));
        PairedDocumentRDDFunctions qual$3 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$17 = saveToTable;
        boolean x$18 = true;
        boolean x$19 = qual$3.saveToMapRDB$default$3();
        qual$3.saveToMapRDB(x$17, x$18, x$19);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(saveToTable, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingSimpleSaveTable succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleSaveTable failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$1) {
                    Predef$.MODULE$.println(x$1);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingIDwithSaveToMapRDB(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)saveToTable) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)saveToTable)) : BoxedUnit.UNIT;
        MapRDBTableScanRDD cust_profiles = package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType());
        OJAIDocumentRDDFunctions qual$4 = package$.MODULE$.toDocumentRDDFunctions((RDD)cust_profiles, OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$20 = saveToTable;
        String x$21 = "first_name";
        boolean x$22 = true;
        boolean x$23 = qual$4.saveToMapRDB$default$3();
        qual$4.saveToMapRDB(x$20, x$22, x$23, x$21);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(saveToTable, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingIDwithSaveToMapRDB succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingIDwithSaveToMapRDB failed");
            bl = false;
        }
        return bl;
    }

    public boolean testingBulkSaveMode(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulk").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulk").toString())) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey()));
        PairedDocumentRDDFunctions qual$5 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$24 = new StringBuilder().append((Object)saveToTable).append((Object)"bulk").toString();
        boolean x$25 = true;
        boolean x$26 = true;
        qual$5.saveToMapRDB(x$24, x$26, x$25);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"bulk").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingBulkSaveMode succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBulkSaveMode failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$2) {
                    Predef$.MODULE$.println(x$2);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingBulkSaveWithoutBulkModeSetInTable(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulkmodeswitch").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulkmodeswitch").toString())) : BoxedUnit.UNIT;
        TableDescriptor tabDesc = MapRDB.newTableDescriptor();
        tabDesc.setAutoSplit(true);
        tabDesc.setPath(new StringBuilder().append((Object)saveToTable).append((Object)"bulkmodeswitch").toString());
        tabDesc.setBulkLoad(false);
        MapRDB.newAdmin().createTable(tabDesc);
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey()));
        PairedDocumentRDDFunctions qual$6 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$27 = new StringBuilder().append((Object)saveToTable).append((Object)"bulkmodeswitch").toString();
        boolean x$28 = true;
        boolean x$29 = false;
        qual$6.saveToMapRDB(x$27, x$29, x$28);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"bulkmodeswitch").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingBulkSaveMode succeeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBulkSaveMode failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$3) {
                    Predef$.MODULE$.println(x$3);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSimpleSaveModeBeanClass(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"simplebean").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"simplebean").toString())) : BoxedUnit.UNIT;
        MapRDBTableScanRDD cust_profiles = package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User1.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype());
        OJAIDocumentRDDFunctions qual$11 = package$.MODULE$.toDocumentRDDFunctions((RDD)cust_profiles, OJAIValue$.MODULE$.overrideDefault());
        String x$42 = new StringBuilder().append((Object)saveToTable).append((Object)"simplebean").toString();
        boolean x$43 = true;
        boolean x$44 = qual$11.saveToMapRDB$default$3();
        String x$45 = qual$11.saveToMapRDB$default$4();
        qual$11.saveToMapRDB(x$42, x$43, x$44, x$45);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"simplebean").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"rsmith", (Object)"{\"_id\":\"rsmith\",\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"mdupont", (Object)"{\"_id\":\"mdupont\",\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"jdoe", (Object)"{\"_id\":\"jdoe\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"interests\":null,\"last_name\":\"Doe\"}"), new Tuple2((Object)"dsimon", (Object)"{\"_id\":\"dsimon\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"interests\":null,\"last_name\":\"Simon\"}"), new Tuple2((Object)"alehmann", (Object)"{\"_id\":\"alehmann\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingSimpleSaveModeBeanClass succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSimpleSaveModeBeanClass failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$4) {
                    Predef$.MODULE$.println(x$4);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingBulkSaveModeBeanClass(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulkbean").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"bulkbean").toString())) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(BeanTest.User.class), DefaultClass.DefaultType$.MODULE$.overrideDefault(), RDDTYPE$.MODULE$.overridedefaulttype()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BeanTest.User a) {
                return a.firstName();
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(BeanTest.User.class)).repartitionAndSortWithinPartitions(MapRDBSpark$.MODULE$.newPartitioner(tableName, OJAIKEY$.MODULE$.strkey()));
        PairedDocumentRDDFunctions qual$7 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.overrideDefault());
        String x$30 = new StringBuilder().append((Object)saveToTable).append((Object)"bulkbean").toString();
        boolean x$31 = true;
        boolean x$32 = true;
        qual$7.saveToMapRDB(x$30, x$32, x$31);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"bulkbean").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().sameElements((GenIterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"interests\":null,\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"interests\":null,\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingBulkSaveModeBeanClass succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingBulkSaveModeBeanClass failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$5) {
                    Predef$.MODULE$.println(x$5);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSplitPartitioner(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"splitpartitioner").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"splitpartitioner").toString())) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return (String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString());
            }
        }), package$.MODULE$.ojaiStringKeyOrdering(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions((Partitioner)MapRDBSpark$.MODULE$.newPartitioner((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bolo", "chalo", "hello", "zebra"})), OJAIKEY$.MODULE$.strkey()));
        PairedDocumentRDDFunctions qual$8 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaiStringKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$33 = new StringBuilder().append((Object)saveToTable).append((Object)"splitpartitioner").toString();
        boolean x$34 = true;
        boolean x$35 = true;
        qual$8.saveToMapRDB(x$33, x$35, x$34);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"splitpartitioner").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(OJAIDocument a) {
                return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Robert", (Object)"{\"_id\":\"Robert\",\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}"), new Tuple2((Object)"Maxime", (Object)"{\"_id\":\"Maxime\",\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}"), new Tuple2((Object)"John", (Object)"{\"_id\":\"John\",\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}"), new Tuple2((Object)"David", (Object)"{\"_id\":\"David\",\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}"), new Tuple2((Object)"Andrew", (Object)"{\"_id\":\"Andrew\",\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}")})))) {
            Predef$.MODULE$.println((Object)"testingSplitPartitioner succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSplitPartitioner failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdString(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, String> x$6) {
                    Predef$.MODULE$.println(x$6);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSplitPartitionerWithBinaryData(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithBinary").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithBinary").toString())) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DBBinaryValue apply(OJAIDocument a) {
                return MapRDBSpark$.MODULE$.serializableBinaryValue(ByteBuffer.wrap(((String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString())).getBytes(Charset.forName("UTF-8"))));
            }
        }), package$.MODULE$.ojaiDBBinaryKeyOrdering(), ClassTag$.MODULE$.apply(DBBinaryValue.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions((Partitioner)MapRDBSpark$.MODULE$.newPartitioner((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBBinaryValue[]{MapRDBSpark$.MODULE$.serializableBinaryValue(ByteBuffer.wrap("Bolo".getBytes(Charset.forName("UTF-8")))), MapRDBSpark$.MODULE$.serializableBinaryValue(ByteBuffer.wrap("zebra".getBytes(Charset.forName("UTF-8"))))})), OJAIKEY$.MODULE$.idkey()));
        PairedDocumentRDDFunctions qual$9 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaibinaryKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$36 = new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithBinary").toString();
        boolean x$37 = true;
        boolean x$38 = true;
        qual$9.saveToMapRDB(x$36, x$38, x$37);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithBinary").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                return (OJAIDocument)a.delete("_id");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OJAIDocument.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingSplitPartitionerWithBinaryData succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSplitPartitionerWithBinaryData failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<ByteBuffer, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdBinary(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<ByteBuffer, String> x$7) {
                    Predef$.MODULE$.println(x$7);
                }
            });
            bl = false;
        }
        return bl;
    }

    public boolean testingSplitPartitionerWithByteBufferData(SparkContext sc, String tableName, String saveToTable) {
        boolean bl;
        Object object = MapRDB.tableExists((String)new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithByteBuffer").toString()) ? BoxesRunTime.boxToBoolean((boolean)MapRDB.deleteTable((String)new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithByteBuffer").toString())) : BoxedUnit.UNIT;
        RDD cust_profiles = RDD$.MODULE$.rddToOrderedRDDFunctions(package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(tableName, ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).keyBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ByteBuffer apply(OJAIDocument a) {
                return ByteBuffer.wrap(((String)a.selectDynamic("first_name", DefaultClass.DefaultType$.MODULE$.overrideDefault(), OJAIType$.MODULE$.ojaiString())).getBytes(Charset.forName("UTF-8")));
            }
        }), package$.MODULE$.ojaiByteBufferOrdering(), ClassTag$.MODULE$.apply(ByteBuffer.class), ClassTag$.MODULE$.apply(OJAIDocument.class)).repartitionAndSortWithinPartitions((Partitioner)MapRDBSpark$.MODULE$.newPartitioner((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ByteBuffer[]{MapRDBSpark$.MODULE$.serializableBinaryValue(ByteBuffer.wrap("Bolo".getBytes(Charset.forName("UTF-8")))).getByteBuffer(), MapRDBSpark$.MODULE$.serializableBinaryValue(ByteBuffer.wrap("zebra".getBytes(Charset.forName("UTF-8")))).getByteBuffer()})), OJAIKEY$.MODULE$.idbytebuff()));
        PairedDocumentRDDFunctions qual$10 = package$.MODULE$.toPairedRDDFunctions(cust_profiles, OJAIKey$.MODULE$.ojaibytebufferKey(), OJAIValue$.MODULE$.defaultOJAIDocument());
        String x$39 = new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithByteBuffer").toString();
        boolean x$40 = true;
        boolean x$41 = true;
        qual$10.saveToMapRDB(x$39, x$41, x$40);
        OJAIDocument[] saved_profiles = (OJAIDocument[])package$.MODULE$.toSparkContextFunctions(sc).loadFromMapRDB(new StringBuilder().append((Object)saveToTable).append((Object)"SplitpartitionerWithByteBuffer").toString(), ClassTag$.MODULE$.apply(OJAIDocument.class), DefaultClass.DefaultType$.MODULE$.default(), RDDTYPE$.MODULE$.defaultType()).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OJAIDocument apply(OJAIDocument a) {
                return (OJAIDocument)a.delete("_id");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OJAIDocument.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(OJAIDocument a) {
                return a.asJsonString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet().equals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"address\":{\"city\":\"San Francisco\",\"line\":\"100 Main Street\",\"zip\":94105},\"dob\":\"1982-02-03\",\"first_name\":\"Robert\",\"interests\":[\"electronics\",\"music\",\"sports\"],\"last_name\":\"Smith\"}", "{\"address\":{\"city\":\"San Jose\",\"line\":\"1223 Broadway\",\"zip\":95109},\"dob\":\"1982-02-03\",\"first_name\":\"Maxime\",\"interests\":[\"sports\",\"movies\",\"electronics\"],\"last_name\":\"Dupont\"}", "{\"dob\":\"1970-06-23\",\"first_name\":\"John\",\"last_name\":\"Doe\"}", "{\"dob\":\"1980-10-13\",\"first_name\":\"David\",\"last_name\":\"Simon\"}", "{\"dob\":\"1980-10-13\",\"first_name\":\"Andrew\",\"interests\":[\"html\",\"css\",\"js\"],\"last_name\":\"Lehmann\"}"})))) {
            Predef$.MODULE$.println((Object)"testingSplitPartitionerWithByteBufferData succeded");
            bl = true;
        } else {
            Predef$.MODULE$.println((Object)"testingSplitPartitionerWithByteBufferData failed");
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])saved_profiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<ByteBuffer, String> apply(OJAIDocument a) {
                    return new Tuple2((Object)a.getIdBinary(), (Object)a.asJsonString());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<ByteBuffer, String> x$8) {
                    Predef$.MODULE$.println(x$8);
                }
            });
            bl = false;
        }
        return bl;
    }

    private LoadAndSaveTests$() {
        MODULE$ = this;
        this.tableName = "/tmp/user_profiles_load_and_save_read";
        this.saveToTable = "/tmp/user_profiles_load_and_save_write";
    }
}

