/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.tests;

import com.mapr.db.JsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.CommandResult;
import org.springframework.shell.core.JLineShellComponent;

@Category(value={ClusterTest.class})
public class TestDeleteCommand
extends BaseTest {
    private static final String TABLE_NAME = "testtable-DeleteCommand";
    private static JLineShellComponent shell;
    private static final String deleteCondition = "{\"$and\":[{\"$typeof\":{\"a.c.e\":\"STRING\"}},{\"$exists\":\"a.c.d\"}]}";
    private static final String deleteWithIDRepeated = "{\"$and\":[{\"$eq\":{\"_id\":\"id2\"}},{\"$eq\":{\"m.x\":false}}]}";

    @BeforeClass
    public static void setUp() throws Exception {
        Bootstrap bootstrap = new Bootstrap();
        shell = bootstrap.getJLineShellComponent();
    }

    @AfterClass
    public static void cleanUp() {
    }

    @Test
    public void simpleDeleteCommand() throws Exception {
        String tableName = "testtable-DeleteCommand-simpleDelete";
        JsonTable table = DBTests.createOrReplaceTable((String)"testtable-DeleteCommand-simpleDelete");
        Document doc = MapRDBImpl.newDocument().set("a.b", false).set("x", "Holger way");
        table.insertOrReplace("id1", doc);
        doc.set("a.c.e", "MapR").set("a.c.d", 111);
        table.insertOrReplace("id2", doc);
        String deleteCmd = "delete " + DBTests.getTablePath((String)tableName).toString() + " --id id1 ";
        CommandResult result = shell.executeCommand(deleteCmd);
        Assert.assertTrue((boolean)result.isSuccess());
        int count = 0;
        Iterator iter = table.find().iterator();
        Document returnedDoc = null;
        while (iter.hasNext()) {
            ++count;
            returnedDoc = (Document)iter.next();
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertNotNull((Object)returnedDoc);
        Assert.assertEquals((Object)"id2", (Object)returnedDoc.getId().getString());
        Assert.assertEquals((long)111L, (long)returnedDoc.getInt("a.c.d"));
        table.close();
    }

    @Test
    public void deleteWithCondition() throws Exception {
        String tableName = "testtable-DeleteCommand-delWithCondition";
        JsonTable table = DBTests.createOrReplaceTable((String)tableName);
        Document doc = MapRDBImpl.newDocument().set("a.b", false).set("x", "Holger way");
        table.insertOrReplace("id1", doc);
        doc.set("a.c.e", "MapR").set("a.c.d", 111).set("a.b", true);
        table.insertOrReplace("id2", doc);
        String deleteCmd = "delete " + DBTests.getTablePath((String)tableName).toString() + " --id id2  --c {\"$and\":[{\"$typeof\":{\"a.c.e\":\"STRING\"}},{\"$exists\":\"a.c.d\"}]}";
        CommandResult result = shell.executeCommand(deleteCmd);
        Assert.assertTrue((boolean)result.isSuccess());
        int count = 0;
        Iterator iter = table.find().iterator();
        Document returnedDoc = null;
        while (iter.hasNext()) {
            ++count;
            returnedDoc = (Document)iter.next();
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertNotNull((Object)returnedDoc);
        Assert.assertEquals((Object)"id1", (Object)returnedDoc.getId().getString());
        Assert.assertFalse((boolean)returnedDoc.getBoolean("a.b"));
        table.close();
    }
}

