/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.tests;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.shell.Bootstrap;
import org.springframework.shell.core.CommandResult;
import org.springframework.shell.core.JLineShellComponent;

@Category(value={ClusterTest.class})
public class TestInsertCommand
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestInsertCommand.class);
    private static final String TABLE_NAME = "testtable-InsertCommand";
    private static Table table;
    private static JLineShellComponent shell;
    private static final String docString = "{\"a\":{\"b\":[{\"boolean\":false},{\"decimal\":123.456}],\"c.d\":10,\"c.e\":\"Hello\"},\"m\":\"mapr\"}";
    private static final String replaceDocString = "{\"a\":{\"b\":[{\"boolean\":false},{\"decimal\":123.456}],\"c\":{\"d\":10,\"e\":\"Hello\"}},\"m\":\"mapr\"}";
    private static final String conditionString = "{\"$eq\":{\"a.c\":\"replace\"}}";

    @BeforeClass
    public static void setUp() throws IOException {
        table = DBTests.createOrReplaceTable((String)TABLE_NAME);
        table.setOption(Table.TableOption.EXCLUDEID, true);
        Bootstrap bootstrap = new Bootstrap();
        shell = bootstrap.getJLineShellComponent();
    }

    @AfterClass
    public static void cleanUp() {
        table.close();
    }

    @Test
    public void testInsert() throws Exception {
        String tablePath = DBTests.getTablePath((String)TABLE_NAME).toString();
        String insertCommand = "insert " + tablePath + " --id id1 --value " + docString;
        CommandResult result = shell.executeCommand(insertCommand);
        Assert.assertEquals((Object)true, (Object)result.isSuccess());
        Document insertedDoc = MapRDBImpl.newDocument((String)docString);
        Document returnedDoc = table.findById("id1");
        Assert.assertEquals((Object)true, (Object)insertedDoc.equals(returnedDoc));
        table.delete("id1");
    }

    @Test
    public void testInsertWithCondition() throws Exception {
        Document doc = MapRDBImpl.newDocument().set("a.b", 22).set("a.c", "replace");
        table.insertOrReplace("id1", doc);
        String tablePath = DBTests.getTablePath((String)TABLE_NAME).toString();
        String insertWithConditionCommand = "insert " + tablePath + " --id id1 --value " + replaceDocString + " --c " + conditionString;
        CommandResult result = shell.executeCommand(insertWithConditionCommand);
        Assert.assertEquals((Object)true, (Object)result.isSuccess());
        Document insertedDoc = MapRDBImpl.newDocument((String)replaceDocString);
        Document returnedDoc = table.findById("id1");
        Assert.assertTrue((boolean)insertedDoc.equals(returnedDoc));
        table.delete("id1");
    }

    @Test
    public void testInsertBinaryId() throws Exception {
        String cmd = "{\"_id\":{\"$binary\":\"YWJjZA==\"},\"a\":123,\"b\":\"mapr\"}";
        String tablePath = DBTests.getTablePath((String)TABLE_NAME).toString();
        String insertCommand = "insert " + tablePath + " --value " + cmd;
        CommandResult result = shell.executeCommand(insertCommand);
        Assert.assertEquals((Object)true, (Object)result.isSuccess());
        Iterator iter = table.find().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document d = (Document)iter.next();
        ByteBuffer bb = Values.parseBinary((String)"YWJjZA==");
        Assert.assertEquals((Object)bb, (Object)d.getId().getBinary());
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete(bb);
    }

    @Test
    public void testInsertStringId() throws Exception {
        String cmd = "{\"a\":123,\"b\":\"mapr\",\"_id\":\"kk1\"}";
        String tablePath = DBTests.getTablePath((String)TABLE_NAME).toString();
        String insertCommand = "insert " + tablePath + " --value " + cmd;
        CommandResult result = shell.executeCommand(insertCommand);
        Assert.assertEquals((Object)true, (Object)result.isSuccess());
        Iterator iter = table.find().iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        Document d = (Document)iter.next();
        Assert.assertEquals((Object)"kk1", (Object)d.getId().getString());
        Assert.assertFalse((boolean)iter.hasNext());
        table.delete("kk1");
    }
}

