/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.ops;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.mapr.db.Table;
import com.mapr.db.exceptions.DBException;
import com.mapr.db.exceptions.ExceptionHandler;
import com.mapr.db.exceptions.IndexNotFoundException;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.shell.ShellSession;
import com.mapr.db.shell.ops.TableLookupKey;
import com.mapr.db.util.ConditionParser;
import com.mapr.db.util.MutationParser;
import com.mapr.fs.MapRFileSystem;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.QueryParser;
import com.mapr.streams.Streams;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.json.JsonOptions;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.DocumentStore;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;

public class TableOps {
    private static final String DOC_ID_NOT_FOUND = "A document id was neither provided nor found in the document.";
    private final AdminImpl admin_;
    private final MapRFileSystem fs_;
    private final ShellSession session_;
    private final LoadingCache<TableLookupKey, Table> tableCache;
    private final LoadingCache<String, DocumentStore> streamCache;
    private Connection con = DriverManager.getConnection((String)"ojai:mapr:");

    public TableOps(ShellSession session_) throws IOException {
        this.fs_ = session_.getFS();
        this.admin_ = new AdminImpl(this.fs_);
        this.session_ = session_;
        this.tableCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener((RemovalListener)new RemovalListener<TableLookupKey, Table>(){

            public void onRemoval(RemovalNotification<TableLookupKey, Table> notification) {
                try {
                    ((Table)notification.getValue()).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).build((CacheLoader)new CacheLoader<TableLookupKey, Table>(){

            public Table load(TableLookupKey key) throws Exception {
                if (key.getIndexName() == null) {
                    return MapRDBImpl.getTable((Path)key.getPath());
                }
                return MapRDBImpl.getIndexTable((IndexDesc)TableOps.this.findIndexDesc(key));
            }
        });
        this.streamCache = CacheBuilder.newBuilder().maximumSize(50L).removalListener((RemovalListener)new RemovalListener<String, DocumentStore>(){

            public void onRemoval(RemovalNotification<String, DocumentStore> notification) {
                try {
                    ((DocumentStore)notification.getValue()).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).build((CacheLoader)new CacheLoader<String, DocumentStore>(){

            public DocumentStore load(String tablePath) throws Exception {
                return Streams.getMessageStore((String)tablePath);
            }
        });
    }

    private IndexDesc findIndexDesc(TableLookupKey key) throws IOException {
        Collection indexes = this.admin_.getTableIndexes(key.getPath(), true);
        for (IndexDesc indexDesc : indexes) {
            if (!indexDesc.getIndexName().equals(key.getIndexName())) continue;
            return indexDesc;
        }
        throw new IndexNotFoundException(key.getPath(), key.getIndexName());
    }

    public void create(String tablePath) throws IOException {
        this.putTable(tablePath, this.admin_.createTable(tablePath));
        this.session_.printf("Table %s created.\n", tablePath);
    }

    public void deleteTable(String tablePath) throws IOException {
        Collection indexes = this.admin_.getTableIndexes(this.fs_.makeAbsolute(new Path(tablePath)), true);
        if (!this.admin_.deleteTable(tablePath)) {
            this.session_.printf("Unable to delete table: '%s'. Check if the path exists and is a table.\n", tablePath);
        } else {
            for (IndexDesc indexDesc : indexes) {
                this.removeIndex(tablePath, indexDesc.getIndexName());
            }
            this.removeTable(tablePath);
            this.session_.printf("Table %s deleted.\n", tablePath);
        }
    }

    public void findById(JsonOptions jsonOptions, String tablePath, String id, String conditionString, String projectionString) throws IOException {
        Table store = this.getTable(tablePath);
        if (!this.session_.isRawStreamScan() && this.isStream((DocumentStore)store)) {
            throw new IllegalArgumentException("'findbyid' is currently not supported with Streams");
        }
        String[] projections = null;
        QueryCondition condition = null;
        if (projectionString != null) {
            projections = projectionString.split(",");
        }
        if (conditionString != null) {
            condition = this.getConditionFromJSONString(conditionString, id);
        }
        Document readDocument = null;
        readDocument = projections == null && condition == null ? store.findById(id) : (projections != null ? (condition == null ? store.findById(id, projections) : store.findById(id, condition, projections)) : store.findById(id, condition));
        int count = 0;
        if (readDocument != null) {
            String json = readDocument.asJsonString(jsonOptions);
            this.session_.println(json);
            ++count;
        }
        this.session_.printf("%d document(s) found.\n", count);
    }

    private QueryCondition getConditionFromJSONString(String conditionString, String docId) {
        ConditionParser queryParser = new ConditionParser();
        if (docId != null) {
            queryParser.setIdInCmdLine(true);
        }
        return queryParser.parseCondition(conditionString);
    }

    public void find(JsonOptions jsonOptions, String tablePath, String fromId, String toId, String limitStr, String conditionString, String projectionString, String offsetStr, String orderByStr, String queryStr) throws IOException {
        DocumentStore store = this.con.getStore(tablePath);
        DocumentStream stream = null;
        if (queryStr != null) {
            QueryParser qParser = new QueryParser();
            Query query = qParser.parseQuery(queryStr);
            if (!this.session_.isRawStreamScan() && this.isStream(store)) {
                if (!((OjaiQuery)query).hasCondition() || ((OjaiQuery)query).getSelectListAsArray() != null) {
                    // empty if block
                }
                stream = this.getStream(tablePath).find();
            } else {
                stream = store.findQuery(query);
            }
            this.printDocumentStream(stream, jsonOptions);
            stream.close();
            return;
        }
        QueryCondition c = this.buildQueryCondition(fromId, toId, conditionString);
        String[] projections = null;
        projections = projectionString != null ? projectionString.split(",") : new String[]{};
        long limit = Long.MAX_VALUE;
        if (limitStr != null) {
            limit = Long.parseLong(limitStr);
        }
        long offset = 0L;
        if (offsetStr != null) {
            offset = Long.parseLong(offsetStr);
        }
        String[] orders = null;
        if (orderByStr != null) {
            orders = orderByStr.split(",");
        }
        if (!this.session_.isRawStreamScan() && this.isStream(store)) {
            if (c != null || projections != null) {
                // empty if block
            }
            stream = this.getStream(tablePath).find();
        } else {
            Query query = this.con.newQuery().select(projections);
            if (c != null) {
                query.where(c);
            }
            if (limitStr != null) {
                query.limit(limit);
            }
            if (offsetStr != null) {
                query.offset(offset);
            }
            if (orders != null) {
                for (String ele : orders) {
                    query = ele.toLowerCase().endsWith(":asc") && ele.charAt(ele.lastIndexOf(":") - 1) != '\\' ? query.orderBy(ele.substring(0, ele.lastIndexOf(":")), SortOrder.ASC) : (ele.toLowerCase().endsWith(":desc") && ele.charAt(ele.lastIndexOf(":") - 1) != '\\' ? query.orderBy(ele.substring(0, ele.lastIndexOf(":")), SortOrder.DESC) : query.orderBy(ele, SortOrder.ASC));
                }
            }
            stream = store.findQuery(query.build());
        }
        this.printDocumentStream(stream, jsonOptions);
    }

    public void listIndex(String tablePath) {
        for (IndexDesc indexDesc : this.admin_.getTableIndexes(tablePath)) {
            this.session_.println(indexDesc.asJsonString(this.session_.getJsonOptions()));
        }
    }

    public void scanIndex(JsonOptions jsonOptions, String tablePath, String indexName, String fromId, String toId, String limitStr, String conditionString, String projectionString, String mode, String decodeIndexedFields) throws IOException {
        long limit = Long.MAX_VALUE;
        if (limitStr != null) {
            limit = Long.parseLong(limitStr);
        }
        if (mode != null) {
            if (mode.equals("err")) {
                try {
                    Table store = this.getTable(tablePath, indexName);
                    DocumentStream stream = ((MapRDBIndexImpl)store)._doErrorScan();
                    this.printDocumentStream(stream, jsonOptions, limit);
                    stream.close();
                }
                catch (Exception e) {
                    this.session_.err_println("Failed to open  index " + indexName + " for table " + tablePath + ":" + e.getMessage());
                    this.session_.err_println(e.getStackTrace());
                    throw e;
                }
            } else {
                this.session_.err_println("mode \"" + mode + "\" not recognizable.");
            }
            return;
        }
        QueryCondition c = this.buildQueryCondition(fromId, toId, conditionString);
        String[] projections = null;
        if (projectionString != null) {
            projections = projectionString.split(",");
        }
        try {
            Table store = this.getTable(tablePath, indexName);
            boolean decodeIdxFields = false;
            if (decodeIndexedFields != null && decodeIndexedFields.equals("true")) {
                ((MapRDBIndexImpl)store).setDecodeIndexValues(true);
                decodeIdxFields = true;
            }
            DocumentStream stream = store.find(c, projections);
            this.printDocumentStream(stream, jsonOptions, limit);
            if (decodeIdxFields) {
                ((MapRDBIndexImpl)store).setDecodeIndexValues(false);
            }
        }
        catch (Exception e) {
            this.session_.err_println("Failed to open  index " + indexName + " for table " + tablePath + ":" + e.getMessage());
            this.session_.err_println(e.getStackTrace());
            throw e;
        }
    }

    private QueryCondition buildQueryCondition(String fromId, String toId, String conditionString) {
        ConditionImpl c = null;
        if (fromId != null || toId != null) {
            c = MapRDBImpl.newCondition();
            if (fromId != null && toId != null) {
                c.and();
            }
            if (fromId != null) {
                c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, fromId);
            }
            if (toId != null) {
                c.is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS, toId);
            }
            if (fromId != null && toId != null) {
                c.close();
            }
            c.build();
        }
        if (conditionString != null) {
            if (c == null) {
                c = this.getConditionFromJSONString(conditionString, null);
            } else {
                c.condition(this.getConditionFromJSONString(conditionString, null));
            }
        }
        return c;
    }

    private void printDocumentStream(DocumentStream stream, JsonOptions jsonOptions) {
        this.printDocumentStream(stream, jsonOptions, Long.MAX_VALUE);
    }

    private void printDocumentStream(DocumentStream stream, JsonOptions jsonOptions, long limit) {
        long count = 0L;
        for (Document document : stream) {
            this.session_.println(document.asJsonString(jsonOptions));
            if (++count < limit) continue;
            break;
        }
        this.session_.printf("%d document(s) found.\n", count);
    }

    private boolean insertDocument(String docId, Document document, String conditionString, Table t, boolean replace) throws IOException {
        boolean success = true;
        if (docId == null) {
            if (replace) {
                t.replace(document);
            } else {
                t.insertOrReplace(document);
            }
            return success;
        }
        QueryCondition condition = null;
        if (conditionString != null) {
            condition = this.getConditionFromJSONString(conditionString, docId);
        }
        if (condition != null) {
            success = t.checkAndReplace(docId, condition, document);
        } else {
            t.insertOrReplace(docId, document);
        }
        return success;
    }

    public void insert(String tablePath, String docId, String jsonStr, String conditionString, boolean replace) throws IOException {
        Document document = MapRDBImpl.newDocument((String)jsonStr);
        String inDocId = null;
        Value inDocIdValue = null;
        boolean inDoc = false;
        if (docId == null) {
            inDocIdValue = document.getValue(DocumentConstants.ID_FIELD);
            inDoc = true;
        } else {
            inDocId = document.getString(DocumentConstants.ID_FIELD);
            if (inDocId != null && !inDocId.equals(docId)) {
                throw new UnsupportedOperationException("ERROR: '_id' field in the json string '" + inDocId + "' should  match input parameter '" + docId + "' or only one of them can be provided.");
            }
            inDocId = docId;
        }
        if (inDocId == null && inDocIdValue == null) {
            throw new UnsupportedOperationException("ERROR: Expected an '_id' field either in the json string or as an input '--id' parameter.");
        }
        Table t = this.noStream(this.getTable(tablePath), "insert");
        boolean isSuccess = true;
        if (inDoc) {
            isSuccess = this.insertDocument(null, document, conditionString, t, replace);
            inDocId = inDocIdValue.toString();
        } else {
            isSuccess = this.insertDocument(inDocId, document, conditionString, t, replace);
        }
        if (isSuccess) {
            if (inDoc) {
                this.session_.printf("Document with id: %s inserted.\n", inDocId);
            } else {
                this.session_.printf("Document with id: \"%s\" inserted.\n", inDocId);
            }
        }
    }

    public void deleteRow(String tablePath, String docId, String conditionString) throws IOException {
        Table t = this.noStream(this.getTable(tablePath), "delete");
        if (conditionString != null) {
            boolean status = t.checkAndDelete(docId, this.getConditionFromJSONString(conditionString, docId));
            if (status) {
                this.session_.printf("Document with id: \"%s\" deleted.\n", docId);
            }
        } else {
            t.delete(docId);
            this.session_.printf("Document with id: \"%s\" deleted.\n", docId);
        }
    }

    public void update(String tablePath, String docId, String jsonMutation, String conditionString) throws IOException {
        MutationParser mParser = new MutationParser();
        DocumentMutation mutation = mParser.parseMutation(jsonMutation);
        QueryCondition condition = null;
        if (conditionString != null) {
            condition = this.getConditionFromJSONString(conditionString, docId);
        }
        boolean opSuccess = true;
        Table tab = this.noStream(this.getTable(tablePath), "update");
        if (condition == null) {
            try {
                tab.update(docId, mutation);
            }
            catch (DBException e) {
                if (jsonMutation.contains("$set") && e.getMessage().equals("update() failed with err code = 22,")) {
                    this.session_.err_println("Failed to update the field. This could be caused by a datatype mismatch between the existing data and the update. If an overwrite is intended, please use \"$put\" operator.");
                }
                throw e;
            }
        } else {
            opSuccess = tab.checkAndMutate(docId, condition, mutation);
        }
        if (opSuccess) {
            this.session_.printf("Document with id: \"%s\" updated.\n", docId);
        }
    }

    public void exists(String tablePath) throws IOException {
        this.session_.println(this.admin_.tableExists(tablePath));
    }

    public void list(String parent) throws IOException {
        List tables = this.admin_.listTables(parent);
        if (tables == null) {
            this.session_.printf("No tables found.\n", new Object[0]);
            return;
        }
        for (Path path : tables) {
            this.session_.println(path);
        }
        this.session_.printf("%d table(s) found.\n", tables.size());
    }

    public void desc(String tablePath) throws IOException {
        this.session_.println(this.admin_.getTableDescriptor(tablePath));
    }

    private void removeIndex(String tablePath, String indexName) throws IOException {
        TableLookupKey key = new TableLookupKey.KeyBuilder().setPath(this.fs_.makeAbsolute(new Path(tablePath))).setIndexName(indexName).build();
        this.tableCache.invalidate((Object)key);
    }

    private void removeTable(String tablePath) throws IOException {
        this.removeIndex(tablePath, null);
    }

    private void putTable(String tablePath, Table table) throws IOException {
        TableLookupKey key = new TableLookupKey.KeyBuilder().setPath(this.fs_.makeAbsolute(new Path(tablePath))).build();
        this.tableCache.put((Object)key, (Object)table);
    }

    private Table noStream(Table table, String op) {
        if (this.isStream((DocumentStore)table)) {
            throw new UnsupportedOperationException("'" + op + "' is not supported with a MapR Stream.");
        }
        return table;
    }

    private boolean isStream(DocumentStore store) {
        return store instanceof BaseJsonTable && ((BaseJsonTable)store).isStream();
    }

    private Table getTable(String tablePath, String indexName) throws IOException {
        TableLookupKey key = new TableLookupKey.KeyBuilder().setPath(this.fs_.makeAbsolute(new Path(tablePath))).setIndexName(indexName).build();
        return this.getTable(key);
    }

    private Table getTable(String tablePath) throws IOException {
        return this.getTable(tablePath, null);
    }

    private Table getTable(TableLookupKey key) throws IOException {
        try {
            this.tableCache.invalidate((Object)key);
            Table table = ((Table)this.tableCache.get((Object)key)).setOption(Table.TableOption.BUFFERWRITE, this.session_.getTableOptions().isBufferWrite());
            return table;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DBException) {
                throw (DBException)cause;
            }
            throw ExceptionHandler.handle((IOException)(cause instanceof IOException ? (IOException)cause : new IOException(cause)), (String)"getTable()");
        }
    }

    private DocumentStore getStream(String streamPath) throws IOException {
        try {
            this.streamCache.invalidate((Object)streamPath);
            return (DocumentStore)this.streamCache.get((Object)streamPath);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DBException) {
                throw (DBException)cause;
            }
            throw ExceptionHandler.handle((IOException)(cause instanceof IOException ? (IOException)cause : new IOException(cause)), (String)"getStream()");
        }
    }
}

