/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import com.mapr.db.shell.ops.TableOps;
import com.mapr.ojai.store.impl.DrillNotInClasspathException;
import java.io.IOException;
import javax.naming.OperationNotSupportedException;
import org.ojai.json.JsonOptions;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class TableCommands
extends ShellCommands {
    private static final String HELP_PARAM_ID = "Document Id.";
    private static final String HELP_PARAM_FROM_ID = "Document Id to start from (inclusive)";
    private static final String HELP_PARAM_TO_ID = "Document Id to stop at (exclusive)";
    private static final String HELP_PARAM_1 = "A path and/or a file pattern.";
    private static final String HELP_PARAM_2 = "Json document to insert or replace.";
    private static final String HELP_PARAM_3 = "Json document containing field and their values.";
    private static final String HELP_PARAM_4 = "Maximum number of documents to return.";
    private static final String HELP_PARAM_5 = "Enables/disables printing with extended Type Tags.";
    private static final String HELP_PARAM_6 = "Enables/disables pretty printing of the document.";
    private static final String HELP_PARAM_7 = "Skip first n number of rows in the result.";
    private static final String HELP_PARAM_8 = "Sort result by the given fields.";
    private static final String HELP_PARAM_CONDITION = "Condition in JSON format";
    private static final String HELP_PARAM_PROJECTION = "Projections in JSON documents";
    private static final String HELP_PARAM_QUERY = "Query in JSON documents";
    private static final String HELP_SCAN_MODE = "Scan mode, currently support error scan with --mode err";
    private static final String TABLE_PATH = "Table path.";
    private static final String INDEX_NAME_HELP = "Name of the index.";
    private static final String UPDATE_HELP = "Update field in a single document.";
    private static final String DELETE_HELP = "Delete a document from the table.";
    private static final String FINDBYID_HELP = "Retrieves a single document from the table.";
    private static final String FIND_HELP = "Retrieves one or more documents from the table.";
    private static final String INDEX_LIST_HELP = "Retrieves the list of indexes for the specified table.";
    private static final String INDEX_SCAN_HELP = "Scan the index and return the document in their natural order.";
    private static final String INSERT_HELP = "Inserts or replaces a document into the table.";
    private static final String REPLACE_HELP = "Replace a document based on condition.";
    private static final String DROP_HELP = "Deletes a MapR-DB json table.";
    private static final String EXISTS_HELP = "Returns true if the table exists.";
    private static final String CREATE_HELP = "Create a json table at the given path.";
    private static final String DESC_HELP = "Describes the properties of a table.";
    private static final String LIST_HELP = "Lists all tables in a folder or matching the specified pattern.";
    private TableOps tableOps_;

    public TableCommands() throws IOException {
        this.tableOps_ = new TableOps(this.session_);
    }

    @CliAvailabilityIndicator(value={"find", "insert", "delete", "exists", "create", "drop", "list", "desc"})
    public boolean isDMLAvailable() {
        return this.session_.inTableMode();
    }

    @CliCommand(value={"exists"}, help="Returns true if the table exists.")
    public void exists(@CliOption(key={"", "path", "p"}, mandatory=true, help="Table path.") String path) throws IOException {
        this.tableOps_.exists(path);
    }

    @CliCommand(value={"list"}, help="Lists all tables in a folder or matching the specified pattern.")
    public void list(@CliOption(key={"", "p", "patternOrPath"}, help="A path and/or a file pattern.") String patternOrPath) throws IOException {
        this.tableOps_.list(patternOrPath);
    }

    @CliCommand(value={"desc"}, help="Describes the properties of a table.")
    public void desc(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath) throws IOException {
        this.tableOps_.desc(tablePath);
    }

    @CliCommand(value={"create"}, help="Create a json table at the given path.")
    public void create(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath) throws IOException {
        this.tableOps_.create(tablePath);
    }

    @CliCommand(value={"drop"}, help="Deletes a MapR-DB json table.")
    public void drop(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath) throws IOException {
        this.tableOps_.deleteTable(tablePath);
    }

    @CliCommand(value={"insert"}, help="Inserts or replaces a document into the table.", examples={"insert /tables/users --value '{\"_id\":\"user001\" , \"first_name\":\"John\", \"last_name\":\"Doe\"}'", "insert /tables/users --id user002 --value '{\"first_name\":\"Jane\", \"last_name\":\"Dane\"}'"})
    public void insert(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"id"}, help="Document Id.") String _id, @CliOption(key={"v", "value"}, mandatory=true, help="Json document to insert or replace.") String jsonStr, @CliOption(key={"c", "where"}, mandatory=false, help="Condition in JSON format") String conditionString) throws IOException {
        this.tableOps_.insert(tablePath, _id, jsonStr, conditionString, false);
    }

    @CliCommand(value={"replace"}, help="Replace a document based on condition.", examples={"replace /tables/users --id user002 --value '{\"first_name\":\"Jane\", \"last_name\":\"Doe\"}'"})
    public void replace(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"id"}, help="Document Id.") String _id, @CliOption(key={"v", "value"}, mandatory=true, help="Json document to insert or replace.") String jsonStr, @CliOption(key={"c", "where"}, mandatory=false, help="Condition in JSON format") String conditionString) throws IOException {
        this.tableOps_.insert(tablePath, _id, jsonStr, conditionString, true);
    }

    @CliCommand(value={"findbyid"}, help="Retrieves a single document from the table.", examples={"findbyid /tables/users --id user001"})
    public void get(@CliOption(key={"", "table", "t"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String _id, @CliOption(key={"c", "where"}, help="Condition in JSON format") String conditionString, @CliOption(key={"f", "fields"}, help="Projections in JSON documents") String projectionString, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.", specifiedDefaultValue="true") String withTags, @CliOption(key={"pretty"}, help="Enables/disables pretty printing of the document.", specifiedDefaultValue="true") String pretty) throws IOException {
        JsonOptions jsonOptions = this.getCmdJsonOptions(withTags, pretty);
        this.tableOps_.findById(jsonOptions, tablePath, _id, conditionString, projectionString);
    }

    @CliCommand(value={"find"}, help="Retrieves one or more documents from the table.", examples={"find /tables/users", "find /tables/users --fromid user001 --toid user00a --limit 32"})
    public void find(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"indexName", "indexname"}, hidden=true) String indexName, @CliOption(key={"id"}, help="Document Id.") String _id, @CliOption(key={"fromid"}, help="Document Id to start from (inclusive)") String fromId, @CliOption(key={"toid"}, help="Document Id to stop at (exclusive)") String toId, @CliOption(key={"limit"}, help="Maximum number of documents to return.") String limit, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.", specifiedDefaultValue="true") String withTags, @CliOption(key={"pretty"}, help="Enables/disables pretty printing of the document.", specifiedDefaultValue="true") String pretty, @CliOption(key={"offset"}, help="Skip first n number of rows in the result.") String offset, @CliOption(key={"orderby"}, help="Sort result by the given fields.") String orderby, @CliOption(key={"c", "where"}, help="Condition in JSON format") String conditionString, @CliOption(key={"f", "fields"}, help="Projections in JSON documents") String projectionString, @CliOption(key={"q", "query"}, mandatory=false, help="Query in JSON documents") String queryString) throws IOException, OperationNotSupportedException {
        JsonOptions jsonOptions = this.getCmdJsonOptions(withTags, pretty);
        try {
            if (_id == null) {
                this.tableOps_.find(jsonOptions, tablePath, fromId, toId, limit, conditionString, projectionString, offset, orderby, queryString);
            } else {
                this.tableOps_.findById(jsonOptions, tablePath, _id, conditionString, projectionString);
            }
        }
        catch (DrillNotInClasspathException e) {
            throw (OperationNotSupportedException)new OperationNotSupportedException("Apache Drill jars are not found in the classpath!\nPlease ensure `mapr-drill-internal` package is installed.").initCause(e);
        }
    }

    @CliCommand(value={"indexlist"}, help="Retrieves the list of indexes for the specified table.", hidden=true, examples={"indexlist /tables/users"})
    public void indexlist(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath) {
        this.tableOps_.listIndex(tablePath);
    }

    @CliCommand(value={"indexscan"}, help="Scan the index and return the document in their natural order.", hidden=false, examples={"indexscan /table --indexname idx --limit 7", "indexscan /table --indexname idx --mode err"})
    public void indexscan(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"indexname", "indexName"}, mandatory=true, help="Name of the index.") String indexName, @CliOption(key={"limit"}, help="Maximum number of documents to return.") String limit, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.", specifiedDefaultValue="true") String withTags, @CliOption(key={"pretty"}, help="Enables/disables pretty printing of the document.", specifiedDefaultValue="true") String pretty, @CliOption(key={"mode"}, help="Scan mode, currently support error scan with --mode err") String mode, @CliOption(key={"c", "where"}, help="Condition in JSON format") String queryString, @CliOption(key={"f", "fields"}, help="Projections in JSON documents") String projectionString) throws IOException {
        JsonOptions jsonOptions = this.getCmdJsonOptions(withTags, pretty);
        this.tableOps_.scanIndex(jsonOptions, tablePath, indexName, null, null, limit, queryString, projectionString, mode);
    }

    @CliCommand(value={"delete"}, help="Delete a document from the table.")
    public void delete(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String id, @CliOption(key={"c", "where"}, mandatory=false, help="Condition in JSON format") String conditionString) throws IOException {
        this.tableOps_.deleteRow(tablePath, id, conditionString);
    }

    @CliCommand(value={"update"}, help="Update field in a single document.")
    public void update(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String _id, @CliOption(key={"m", "mutation"}, mandatory=true, help="Json document containing field and their values.") String kvs, @CliOption(key={"c", "where"}, mandatory=false, help="Condition in JSON format") String conditionString) throws IOException {
        this.tableOps_.update(tablePath, _id, kvs, conditionString);
    }
}

