/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import com.mapr.db.shell.ops.TableOps;
import java.io.IOException;
import org.ojai.json.JsonOptions;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class TableCommands
extends ShellCommands {
    private static final String HELP_PARAM_ID = "Document Id.";
    private static final String HELP_PARAM_FROM_ID = "Document Id to start from (inclusive)";
    private static final String HELP_PARAM_TO_ID = "Document Id to stop at (exclusive)";
    private static final String HELP_PARAM_1 = "A path and/or a file pattern.";
    private static final String HELP_PARAM_2 = "Json document to insert or replace.";
    private static final String HELP_PARAM_3 = "Json document containing field and their values.";
    private static final String HELP_PARAM_4 = "Maximum number of documents to return.";
    private static final String HELP_PARAM_5 = "Enables/disables printing with extended Type Tags.";
    private static final String HELP_PARAM_6 = "Enables/disables pretty printing of the document.";
    private static final String TABLE_PATH = "Table Path.";
    private static final String UPDATE_HELP = "Update field in a single document.";
    private static final String DELETE_HELP = "Delete a document from the table.";
    private static final String FINDBYID_HELP = "Retrieves a single document from the table.\nExample: findbyid /idsTable --id 001";
    private static final String FIND_HELP = "Retrieves one or more documents from the table.\nExample: find /idsTable\n         find /idsTable --fromid 001 --toid 00a --limit 32";
    private static final String INSERT_HELP = "Inserts or replaces a document into the table.\nExample: insert /idsTable --value '{\"_id\":\"001\" , \"first_name\":\"John\", \"last_name\":\"Doe\"}'\n         insert /idsTable --id 002 --value '{\"first_name\":\"Jane\", \"last_name\":\"Dane\"}'\n";
    private static final String DROP_HELP = "Deletes a json table.";
    private static final String EXISTS_HELP = "Returns true if the table exists.";
    private static final String CREATE_HELP = "Create a json table at the given path.";
    private static final String DESC_HELP = "Describes the properties of a table.";
    private static final String LIST_HELP = "Lists all tables in a folder or matching the specified pattern.";
    private TableOps tableOps_;

    public TableCommands() throws IOException {
        this.tableOps_ = new TableOps(this.session_);
    }

    @CliAvailabilityIndicator(value={"find", "insert", "delete", "exists", "create", "drop", "list", "desc"})
    public boolean isDMLAvailable() {
        return this.session_.inTableMode();
    }

    @CliCommand(value={"exists"}, help="Returns true if the table exists.")
    public String exists(@CliOption(key={"", "path", "p"}, mandatory=true, help="Table Path.") String path) throws IOException {
        this.tableOps_.exists(path);
        return null;
    }

    @CliCommand(value={"list"}, help="Lists all tables in a folder or matching the specified pattern.")
    public String list(@CliOption(key={"", "p", "patternOrPath"}, help="A path and/or a file pattern.") String patternOrPath) throws IOException {
        this.tableOps_.list(patternOrPath);
        return null;
    }

    @CliCommand(value={"desc"}, help="Describes the properties of a table.")
    public String desc(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath) throws IOException {
        this.tableOps_.desc(tablePath);
        return null;
    }

    @CliCommand(value={"create"}, help="Create a json table at the given path.")
    public String create(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath) throws IOException {
        this.tableOps_.create(tablePath);
        return null;
    }

    @CliCommand(value={"drop"}, help="Deletes a json table.")
    public String drop(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath) throws IOException {
        this.tableOps_.deleteTable(tablePath);
        return null;
    }

    @CliCommand(value={"insert"}, help="Inserts or replaces a document into the table.\nExample: insert /idsTable --value '{\"_id\":\"001\" , \"first_name\":\"John\", \"last_name\":\"Doe\"}'\n         insert /idsTable --id 002 --value '{\"first_name\":\"Jane\", \"last_name\":\"Dane\"}'\n")
    public String insert(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath, @CliOption(key={"id"}, help="Document Id.") String _id, @CliOption(key={"v", "value"}, mandatory=true, help="Json document to insert or replace.") String jsonStr) throws IOException {
        this.tableOps_.insert(tablePath, _id, jsonStr);
        return null;
    }

    @CliCommand(value={"findbyid"}, help="Retrieves a single document from the table.\nExample: findbyid /idsTable --id 001")
    public String get(@CliOption(key={"", "table", "t"}, mandatory=true, help="Table Path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String _id, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.") String withTags, @CliOption(key={"pretty"}, help="Enables/disables pretty printing of the document.") String pretty) throws IOException {
        JsonOptions jsonOptions = this.getCmdJsonOptions(withTags, pretty);
        this.tableOps_.findById(jsonOptions, tablePath, _id);
        return null;
    }

    @CliCommand(value={"find"}, help="Retrieves one or more documents from the table.\nExample: find /idsTable\n         find /idsTable --fromid 001 --toid 00a --limit 32")
    public String find(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath, @CliOption(key={"id"}, help="Document Id.") String _id, @CliOption(key={"fromid"}, help="Document Id to start from (inclusive)") String fromId, @CliOption(key={"toid"}, help="Document Id to stop at (exclusive)") String toId, @CliOption(key={"limit"}, help="Maximum number of documents to return.") String limit, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.") String withTags, @CliOption(key={"pretty"}, help="Enables/disables pretty printing of the document.") String pretty) throws IOException {
        JsonOptions jsonOptions = this.getCmdJsonOptions(withTags, pretty);
        if (_id == null) {
            this.tableOps_.find(jsonOptions, tablePath, fromId, toId, limit);
        } else {
            this.tableOps_.findById(jsonOptions, tablePath, _id);
        }
        return null;
    }

    @CliCommand(value={"delete"}, help="Delete a document from the table.")
    public String delete(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String id) throws IOException {
        this.tableOps_.deleteRow(tablePath, id);
        return null;
    }

    public String update(@CliOption(key={"", "t", "table"}, mandatory=true, help="Table Path.") String tablePath, @CliOption(key={"id"}, mandatory=true, help="Document Id.") String _id, @CliOption(key={"v", "value"}, mandatory=true, help="Json document containing field and their values.") String kvs) throws IOException {
        this.tableOps_.update(tablePath, _id, kvs);
        return null;
    }
}

