/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell;

import com.mapr.db.MapRDB;
import com.mapr.db.shell.SessionMode;
import com.mapr.db.shell.TableOptions;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.ojai.Document;
import org.ojai.json.JsonOptions;
import org.springframework.shell.ShellException;

public class ShellSession {
    private static final String DEBUG_ENABLED = "enabled";
    private static final String STREAM_RAW_SCAN = "STREAM_RAW_SCAN";
    private final MapRFileSystem fs_;
    private final Path homeDir;
    private final JsonOptions jsonOptions_;
    private final TableOptions tableOptions_;
    private SessionMode mode_ = SessionMode.TABLES;
    private Document debugOptions = MapRDB.newDocument().set("enabled", false).set("STREAM_RAW_SCAN", false);
    private static volatile ShellSession INSTACE;

    private ShellSession() throws IOException {
        try {
            this.fs_ = new MapRFileSystem();
            this.fs_.initialize(new URI("maprfs:///"), new Configuration());
            this.homeDir = this.fs_.getHomeDirectory();
            this.jsonOptions_ = new JsonOptions().withTags();
            this.tableOptions_ = new TableOptions();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Path getHomeDir() {
        return this.homeDir;
    }

    public MapRFileSystem getFS() {
        return this.fs_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShellSession getSession() {
        if (INSTACE != null) return INSTACE;
        Class<ShellSession> clazz = ShellSession.class;
        synchronized (ShellSession.class) {
            if (INSTACE != null) return INSTACE;
            try {
                INSTACE = new ShellSession();
            }
            catch (IOException e) {
                throw new ShellException((Throwable)e);
            }
            return INSTACE;
        }
    }

    public Document getDebugOptions() {
        return this.debugOptions;
    }

    public boolean isDebug() {
        return this.debugOptions.getBoolean(DEBUG_ENABLED);
    }

    public ShellSession setDebug(boolean isDebug) {
        this.debugOptions.set(DEBUG_ENABLED, isDebug);
        return this;
    }

    public boolean isRawStreamScan() {
        return this.debugOptions.getBoolean(STREAM_RAW_SCAN);
    }

    public ShellSession setRawStreamScan(boolean value) {
        this.debugOptions.set(STREAM_RAW_SCAN, value);
        return this;
    }

    public ShellSession setMode(String mode) {
        this.mode_ = SessionMode.valueOf(mode.toUpperCase());
        return this;
    }

    public ShellSession setMode(SessionMode mode) {
        this.mode_ = mode;
        return this;
    }

    public SessionMode getMode() {
        return this.mode_;
    }

    public boolean inGlobalMode() {
        return this.mode_ == SessionMode.GLOBAL;
    }

    public boolean inTableMode() {
        return this.mode_ == SessionMode.TABLES;
    }

    public Path getCWD() {
        return this.fs_.getWorkingDirectory();
    }

    public JsonOptions getJsonOptions() {
        return this.jsonOptions_;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions_;
    }
}

