/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.shell.spring;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultPromptProvider;
import org.springframework.stereotype.Component;

import com.mapr.db.shell.ShellSession;

/**
 * Prompt for the shell
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class PromptProvider extends DefaultPromptProvider {

  @Override
  public String getPrompt() {
    return String.format("maprdb %s:> ", ShellSession.getSession().getCWD().getName());
  }

  @Override
  public String getProviderName() {
    return "MapR-DB prompt provider";
  }

}
