/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.db.shell.spring;

import java.io.File;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultHistoryFileNameProvider;
import org.springframework.stereotype.Component;

/**
 * Shell command history stored this file location.
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class HistoryFileNameProvide extends DefaultHistoryFileNameProvider {
  private final static String USER_HOME;
  private final static String HISTORY_FILE;

  static {
    boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    String home_dir = isWindows ? System.getenv("USERPROFILE") : System.getProperty("user.home");
    USER_HOME = home_dir == null ? System.getProperty("user.home") : home_dir;
    HISTORY_FILE = USER_HOME + File.separator + ".maprdb_history";
  }

  public String getHistoryFileName() {
    return HISTORY_FILE;
  }

  @Override
  public String getProviderName() {
    return "MapR-DB Shell command history file name provider.";
  }

}
